/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tile;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.GalacticraftPlanets;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.BlockTelepadFake;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.ShortRangeTelepadHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.network.PacketSimpleAsteroids;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityShortRangeTelepad
extends TileBaseElectricBlock
implements IMultiBlock,
IInventory,
ISidedInventory {
    public static final int MAX_TELEPORT_TIME = 150;
    public static final int TELEPORTER_RANGE = 256;
    public static final int ENERGY_USE_ON_TELEPORT = 2500;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int address = -1;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean addressValid = false;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int targetAddress = -1;
    public EnumTelepadSearchResult targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int teleportTime = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public String owner = "";
    private ItemStack[] containingItems = new ItemStack[1];
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public boolean teleporting;

    public TileEntityShortRangeTelepad() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 115.0f : 50.0f);
    }

    public int canTeleportHere() {
        if (this.field_145850_b.field_72995_K) {
            return -1;
        }
        this.setAddress(this.address);
        this.setTargetAddress(this.targetAddress);
        if (!this.addressValid) {
            return 1;
        }
        if (this.getEnergyStoredGC() < 2500.0f) {
            return 2;
        }
        return 0;
    }

    @Override
    public void func_145845_h() {
        if (this.ticks % 40 == 0 && !this.field_145850_b.field_72995_K) {
            this.setAddress(this.address);
            this.setTargetAddress(this.targetAddress);
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.targetAddressResult == EnumTelepadSearchResult.VALID && (this.ticks % 5 == 0 || this.teleporting)) {
                List containedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
                if (containedEntities.size() > 0 && this.getEnergyStoredGC() >= 2500.0f) {
                    ShortRangeTelepadHandler.TelepadEntry entry = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
                    if (entry != null) {
                        this.teleporting = true;
                    }
                } else {
                    this.teleporting = false;
                }
            }
            if (this.teleporting) {
                ++this.teleportTime;
                if (this.teleportTime >= 150) {
                    BlockVec3 finalPos;
                    ShortRangeTelepadHandler.TelepadEntry entry = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
                    BlockVec3 blockVec3 = finalPos = entry == null ? null : entry.position;
                    if (finalPos != null) {
                        TileEntity tileAt = finalPos.getTileEntityForce(this.field_145850_b);
                        List containedEntities = this.field_145850_b.func_72872_a(EntityLivingBase.class, AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 2), (double)(this.field_145849_e + 1)));
                        if (tileAt != null && tileAt instanceof TileEntityShortRangeTelepad) {
                            TileEntityShortRangeTelepad destTelepad = (TileEntityShortRangeTelepad)tileAt;
                            int teleportResult = destTelepad.canTeleportHere();
                            if (teleportResult == 0) {
                                for (EntityLivingBase e : containedEntities) {
                                    e.func_70107_b((double)((float)finalPos.x + 0.5f), (double)((float)finalPos.y + 1.0f), (double)((float)finalPos.z + 0.5f));
                                    this.field_145850_b.func_72866_a((Entity)e, true);
                                    if (e instanceof EntityPlayerMP) {
                                        ((EntityPlayerMP)e).field_71135_a.func_147364_a((double)finalPos.x, (double)finalPos.y, (double)finalPos.z, e.field_70177_z, e.field_70125_A);
                                    }
                                    GalacticraftCore.packetPipeline.sendToDimension(new PacketSimpleAsteroids(PacketSimpleAsteroids.EnumSimplePacketAsteroids.C_TELEPAD_SEND, new Object[]{finalPos, e.func_145782_y()}), this.field_145850_b.field_73011_w.field_76574_g);
                                }
                                if (containedEntities.size() > 0) {
                                    this.storage.setEnergyStored(this.storage.getEnergyStoredGC() - 2500.0f);
                                    destTelepad.storage.setEnergyStored(this.storage.getEnergyStoredGC() - 2500.0f);
                                }
                            } else {
                                switch (teleportResult) {
                                    case -1: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            ((EntityPlayer)e).func_146105_b((IChatComponent)new ChatComponentText("Cannot Send client-side"));
                                        }
                                        break;
                                    }
                                    case 1: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            ((EntityPlayer)e).func_146105_b((IChatComponent)new ChatComponentText("Target address invalid"));
                                        }
                                        break;
                                    }
                                    case 2: {
                                        for (EntityLivingBase e : containedEntities) {
                                            if (!(e instanceof EntityPlayer)) continue;
                                            ((EntityPlayer)e).func_146105_b((IChatComponent)new ChatComponentText(GCCoreUtil.translate("gui.message.targetNoEnergy.name")));
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                    }
                    this.teleportTime = 0;
                    this.teleporting = false;
                }
            } else {
                this.teleportTime = Math.max(--this.teleportTime, 0);
            }
        }
        super.func_145845_h();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
        this.setAddress(nbt.func_74762_e("Address"));
        this.targetAddress = nbt.func_74762_e("TargetAddress");
        this.owner = nbt.func_74779_i("Owner");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        nbt.func_74768_a("TargetAddress", this.targetAddress);
        nbt.func_74768_a("Address", this.address);
        nbt.func_74778_a("Owner", this.owner);
    }

    @Override
    public void addExtraNetworkedData(List<Object> networkedList) {
        super.addExtraNetworkedData(networkedList);
        networkedList.add(this.targetAddressResult.ordinal());
    }

    @Override
    public void readExtraNetworkedData(ByteBuf dataStream) {
        super.readExtraNetworkedData(dataStream);
        this.targetAddressResult = EnumTelepadSearchResult.values()[dataStream.readInt()];
    }

    @Override
    public double getPacketRange() {
        return 24.0;
    }

    @Override
    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)GalacticraftPlanets.instance, 3, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        return true;
    }

    @Override
    public void onCreate(BlockVec3 placedPosition) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        for (int y = 0; y < 3; y += 2) {
            if (placedPosition.y + y > buildHeight) {
                return;
            }
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockVec3 vecToAdd = new BlockVec3(placedPosition.x + x, placedPosition.y + y, placedPosition.z + z);
                    if (vecToAdd.equals(placedPosition)) continue;
                    ((BlockTelepadFake)AsteroidBlocks.fakeTelepad).makeFakeBlock(this.field_145850_b, vecToAdd, placedPosition, y == 0 ? 1 : 0);
                }
            }
        }
    }

    @Override
    public void onDestroy(TileEntity callingBlock) {
        for (int y = 0; y < 3; y += 2) {
            for (int x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    this.field_145850_b.func_147480_a(this.field_145851_c + x, this.field_145848_d + y, this.field_145849_e + z, y == 0 && x == 0 && z == 0);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 2));
    }

    public String func_145825_b() {
        return GCCoreUtil.translate("container.shortRangeTelepad.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return slotID == 0 && ItemElectricBase.isElectricItem(itemStack.func_77973_b());
    }

    public int[] func_94128_d(int side) {
        return new int[]{0};
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 0;
    }

    @Override
    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    @Override
    public boolean shouldUseEnergy() {
        return !this.getDisabled(0);
    }

    @Override
    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2));
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    @Override
    public void setDisabled(int index, boolean disabled) {
        if (this.disableCooldown == 0) {
            switch (index) {
                case 0: {
                    this.disabled = disabled;
                    this.disableCooldown = 10;
                    break;
                }
            }
        }
    }

    @Override
    public boolean getDisabled(int index) {
        switch (index) {
            case 0: {
                return this.disabled;
            }
        }
        return true;
    }

    public void setAddress(int address) {
        ShortRangeTelepadHandler.TelepadEntry entry;
        if (this.field_145850_b != null && address != this.address) {
            ShortRangeTelepadHandler.removeShortRangeTeleporter(this);
        }
        this.address = address;
        this.addressValid = this.address >= 0 ? (entry = ShortRangeTelepadHandler.getLocationFromAddress(this.address)) == null || this.field_145850_b != null && entry.dimensionID == this.field_145850_b.field_73011_w.field_76574_g && entry.position.x == this.field_145851_c && entry.position.y == this.field_145848_d && entry.position.z == this.field_145849_e : false;
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            ShortRangeTelepadHandler.addShortRangeTelepad(this);
        }
    }

    public boolean updateTarget() {
        if (this.targetAddress < 0 || this.field_145850_b.field_72995_K) {
            this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
            return false;
        }
        this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
        ShortRangeTelepadHandler.TelepadEntry addressResult = ShortRangeTelepadHandler.getLocationFromAddress(this.targetAddress);
        if (addressResult == null) {
            this.targetAddressResult = EnumTelepadSearchResult.NOT_FOUND;
            return false;
        }
        if (this.field_145850_b.field_73011_w.field_76574_g == addressResult.dimensionID) {
            double distance = this.func_145835_a((float)addressResult.position.x + 0.5f, (float)addressResult.position.y + 0.5f, (float)addressResult.position.z + 0.5f);
            if (distance < 65536.0) {
                this.targetAddressResult = EnumTelepadSearchResult.VALID;
                return true;
            }
            this.targetAddressResult = EnumTelepadSearchResult.TOO_FAR;
            return false;
        }
        this.targetAddressResult = EnumTelepadSearchResult.WRONG_DIM;
        return false;
    }

    public void setTargetAddress(int address) {
        this.targetAddress = address;
        this.updateTarget();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        ItemStack var3;
        if (this.containingItems[par1] == null) {
            return null;
        }
        if (this.containingItems[par1].field_77994_a <= par2) {
            var3 = this.containingItems[par1];
            this.containingItems[par1] = null;
        } else {
            var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
        }
        return var3;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    @SideOnly(value=Side.CLIENT)
    public String getReceivingStatus() {
        if (!this.addressValid) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.invalidAddress.name");
        }
        if (this.getEnergyStoredGC() <= 0.0f) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.noEnergy.name");
        }
        if (this.getEnergyStoredGC() <= 2500.0f) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.notEnoughEnergy.name");
        }
        if (this.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.disabled.name");
        }
        return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.message.receivingActive.name");
    }

    @SideOnly(value=Side.CLIENT)
    public String getSendingStatus() {
        if (!this.addressValid) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.invalidTargetAddress.name");
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.TOO_FAR) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translateWithFormat("gui.message.telepadTooFar.name", 256);
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.WRONG_DIM) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.telepadWrongDim.name");
        }
        if (this.targetAddressResult == EnumTelepadSearchResult.NOT_FOUND) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.telepadNotFound.name");
        }
        if (this.getEnergyStoredGC() <= 0.0f) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.noEnergy.name");
        }
        if (this.getEnergyStoredGC() <= 2500.0f) {
            return (Object)((Object)EnumColor.RED) + GCCoreUtil.translate("gui.message.notEnoughEnergy.name");
        }
        if (this.getDisabled(0)) {
            return (Object)((Object)EnumColor.ORANGE) + GCCoreUtil.translate("gui.status.disabled.name");
        }
        return (Object)((Object)EnumColor.BRIGHT_GREEN) + GCCoreUtil.translate("gui.message.sendingActive.name");
    }

    @SideOnly(value=Side.CLIENT)
    public Vector3 getParticleColor(Random rand, boolean sending) {
        float teleportTimeScaled = Math.min(1.0f, (float)this.teleportTime / 150.0f);
        float f = rand.nextFloat() * 0.6f + 0.4f;
        if (sending ? this.targetAddressResult != EnumTelepadSearchResult.VALID : !this.addressValid) {
            return new Vector3(f, f * 0.3f, f * 0.3f);
        }
        if (this.getEnergyStoredGC() < 2500.0f) {
            return new Vector3(f, f * 0.6f, f * 0.3f);
        }
        float r = f * 0.3f;
        float g = f * (0.3f + teleportTimeScaled * 0.7f);
        float b = f * (1.0f - teleportTimeScaled * 0.7f);
        return new Vector3(r, g, b);
    }

    public static enum EnumTelepadSearchResult {
        VALID,
        NOT_FOUND,
        TOO_FAR,
        WRONG_DIM;

    }
}

