/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.lang.ref.WeakReference;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ReportedException;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class TileEntityArclamp
extends TileEntity {
    private int ticks = 0;
    private int sideRear = 0;
    public int facing = 0;
    private final LongSet airToRestore = new LongOpenHashSet();
    private boolean isActive = false;
    private AxisAlignedBB thisAABB;
    private Vec3 thisPos;
    private int facingSide = 0;
    public boolean updateClientFlag;
    private static WeakReference<Chunk> chunkCached = new WeakReference<Object>(null);
    private static int chunkCacheDim = Integer.MAX_VALUE;
    private static int chunkCacheX = 1876000;
    private static int chunkCacheZ = 1876000;

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean initialLight = false;
        if (this.updateClientFlag) {
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing}), this.field_145850_b.field_73011_w.field_76574_g);
            this.updateClientFlag = false;
        }
        if (RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.isActive) {
                this.isActive = false;
                this.revertAir();
                this.func_70296_d();
            }
        } else if (!this.isActive) {
            this.isActive = true;
            initialLight = true;
        }
        if (this.isActive) {
            List moblist;
            if (this.thisAABB == null) {
                initialLight = true;
                int side = this.func_145832_p();
                switch (side) {
                    case 0: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 8), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 1: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 8), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 2: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide = 7 - this.facing;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 8), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 3: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide += 2;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 8));
                        break;
                    }
                    case 4: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 8), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 20), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    case 5: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing > 1) {
                            this.facingSide = 5 - this.facing;
                        }
                        this.thisAABB = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 20), (double)(this.field_145848_d - 20), (double)(this.field_145849_e - 20), (double)(this.field_145851_c + 8), (double)(this.field_145848_d + 20), (double)(this.field_145849_e + 20));
                        break;
                    }
                    default: {
                        return;
                    }
                }
            }
            if (initialLight || this.ticks % 100 == 0) {
                this.lightArea();
            }
            if (this.field_145850_b.field_73012_v.nextInt(20) == 0 && !(moblist = this.field_145850_b.func_94576_a(null, this.thisAABB, IMob.field_82192_a)).isEmpty()) {
                for (Entity entry : moblist) {
                    double distanceNew;
                    PathNavigate nav;
                    EntityCreature e;
                    Vec3 vecNewTarget;
                    if (!(entry instanceof EntityCreature) || (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)(e = (EntityCreature)entry), (int)16, (int)7, (Vec3)this.thisPos)) == null || (nav = e.func_70661_as()) == null) continue;
                    Vec3 vecOldTarget = null;
                    if (nav.func_75505_d() != null && !nav.func_75505_d().func_75879_b()) {
                        vecOldTarget = nav.func_75505_d().func_75878_a((Entity)e);
                    }
                    if (!((distanceNew = vecNewTarget.func_72445_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) > e.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) || vecOldTarget != null && !(distanceNew > vecOldTarget.func_72445_d((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e))) continue;
                    e.func_70661_as().func_75492_a(vecNewTarget.field_72450_a, vecNewTarget.field_72448_b, vecNewTarget.field_72449_c, 0.3);
                }
            }
        }
        ++this.ticks;
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.thisPos = Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5));
        this.ticks = 0;
        this.thisAABB = null;
        if (this.field_145850_b.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketSimple(PacketSimple.EnumSimplePacket.S_REQUEST_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e}));
        } else {
            this.isActive = true;
        }
    }

    public void func_145843_s() {
        if (!this.field_145850_b.field_72995_K) {
            this.revertAir();
        }
        this.isActive = false;
        super.func_145843_s();
    }

    public void lightArea() {
        Block b;
        Block breatheableAirID = GCBlocks.breatheableAir;
        Block brightAir = GCBlocks.brightAir;
        Block brightBreatheableAir = GCBlocks.brightBreatheableAir;
        LongOpenHashSet checked = new LongOpenHashSet();
        LongArrayList currentLayer = new LongArrayList();
        LongArrayList nextLayer = new LongArrayList();
        long thisPackedCoord = CoordinatePacker.pack((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        currentLayer.add(thisPackedCoord);
        World world = this.field_145850_b;
        int sideskip1 = this.sideRear;
        int sideskip2 = this.facingSide ^ 1;
        for (int i = 0; i < 6; ++i) {
            long neighborPackedCoord;
            if (i == sideskip1 || i == sideskip2 || i == (sideskip1 ^ 1) || i == (sideskip2 ^ 1) || (b = this.getBlockAtPackedCoord(world, neighborPackedCoord = this.getAdjacentPacked(thisPackedCoord, i))) == null || b.func_149717_k() >= 15) continue;
            currentLayer.add(neighborPackedCoord);
        }
        long inFrontPacked = thisPackedCoord;
        for (int i = 0; i < 5; ++i) {
            b = this.getBlockAtPackedCoord(world, inFrontPacked = this.getDoubleSidedPacked(inFrontPacked, this.facingSide, sideskip1 ^ 1));
            if (b == null || b.func_149717_k() >= 15) continue;
            currentLayer.add(inFrontPacked);
        }
        for (int count = 0; count < 14; ++count) {
            LongIterator iter = currentLayer.longIterator();
            while (iter.hasNext()) {
                long packedCoord = iter.nextLong();
                int side = 0;
                long sideBits = packedCoord >> 60 & 0xFL;
                boolean allAir = true;
                do {
                    long sidePackedCoord;
                    if ((sideBits & (long)(1 << side)) != 0L || checked.contains(sidePackedCoord = this.getAdjacentPacked(packedCoord, side))) continue;
                    checked.add(sidePackedCoord);
                    int sideX = CoordinatePacker.unpackX((long)sidePackedCoord);
                    int sideY = CoordinatePacker.unpackY((long)sidePackedCoord);
                    int sideZ = CoordinatePacker.unpackZ((long)sidePackedCoord);
                    Block b2 = this.getBlockAtPackedCoord(world, sidePackedCoord);
                    if (b2 instanceof BlockAir) {
                        if (side == sideskip1 || side == sideskip2) continue;
                        nextLayer.add(sidePackedCoord);
                        continue;
                    }
                    allAir = false;
                    if (b2 == null || b2.getLightOpacity((IBlockAccess)world, sideX, sideY, sideZ) != 0 || side == sideskip1 || side == sideskip2) continue;
                    nextLayer.add(sidePackedCoord);
                } while (++side < 6);
                if (allAir) continue;
                int x = CoordinatePacker.unpackX((long)packedCoord);
                int y = CoordinatePacker.unpackY((long)packedCoord);
                int z = CoordinatePacker.unpackZ((long)packedCoord);
                Block id = this.getBlockAtPackedCoord(world, packedCoord);
                if (Blocks.field_150350_a == id) {
                    world.func_147465_d(x, y, z, brightAir, 0, 2);
                    this.airToRestore.add(packedCoord);
                    this.func_70296_d();
                    continue;
                }
                if (id != breatheableAirID) continue;
                world.func_147465_d(x, y, z, brightBreatheableAir, 0, 2);
                this.airToRestore.add(packedCoord);
                this.func_70296_d();
            }
            currentLayer = nextLayer;
            nextLayer = new LongArrayList();
            if (currentLayer.isEmpty()) break;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = nbt.func_74762_e("Facing");
        this.updateClientFlag = true;
        this.airToRestore.clear();
        NBTTagList airBlocks = nbt.func_150295_c("AirBlocks", 10);
        if (airBlocks.func_74745_c() > 0) {
            for (int j = airBlocks.func_74745_c() - 1; j >= 0; --j) {
                NBTTagCompound tag = airBlocks.func_150305_b(j);
                if (tag == null) continue;
                long packedCoord = CoordinatePacker.pack((int)tag.func_74762_e("x"), (int)tag.func_74762_e("y"), (int)tag.func_74762_e("z"));
                this.airToRestore.add(packedCoord);
            }
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("Facing", this.facing);
        NBTTagList airBlocks = new NBTTagList();
        LongIterator iterator = this.airToRestore.longIterator();
        while (iterator.hasNext()) {
            long packedCoord = iterator.nextLong();
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", CoordinatePacker.unpackX((long)packedCoord));
            tag.func_74768_a("y", CoordinatePacker.unpackY((long)packedCoord));
            tag.func_74768_a("z", CoordinatePacker.unpackZ((long)packedCoord));
            airBlocks.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("AirBlocks", (NBTBase)airBlocks);
    }

    public void facingChanged() {
        this.facing -= 2;
        if (this.facing < 0) {
            this.facing = 1 - this.facing;
        }
        GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_ARCLAMP_FACING, new Object[]{this.field_145851_c, this.field_145848_d, this.field_145849_e, this.facing}), this.field_145850_b.field_73011_w.field_76574_g);
        this.thisAABB = null;
        this.revertAir();
        this.func_70296_d();
    }

    private void revertAir() {
        Block brightAir = GCBlocks.brightAir;
        Block brightBreatheableAir = GCBlocks.brightBreatheableAir;
        LongIterator iterator = this.airToRestore.longIterator();
        while (iterator.hasNext()) {
            int z;
            int y;
            long packedCoord = iterator.nextLong();
            int x = CoordinatePacker.unpackX((long)packedCoord);
            Block b = this.field_145850_b.func_147439_a(x, y = CoordinatePacker.unpackY((long)packedCoord), z = CoordinatePacker.unpackZ((long)packedCoord));
            if (b == brightAir) {
                this.field_145850_b.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                continue;
            }
            if (b != brightBreatheableAir) continue;
            this.field_145850_b.func_147465_d(x, y, z, GCBlocks.breatheableAir, 0, 2);
        }
        this.airToRestore.clear();
    }

    public boolean getEnabled() {
        return !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private long getAdjacentPacked(long packedCoord, int side) {
        int x = CoordinatePacker.unpackX((long)packedCoord);
        int y = CoordinatePacker.unpackY((long)packedCoord);
        int z = CoordinatePacker.unpackZ((long)packedCoord);
        long existingSideBits = packedCoord & 0xF000000000000000L;
        long newSideBits = (long)(1 << (side ^ 1)) + ((long)side << 6) << 60;
        long sideBits = existingSideBits | newSideBits;
        switch (side) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        return CoordinatePacker.pack((int)x, (int)y, (int)z) | sideBits;
    }

    private Block getBlockAtPackedCoord(World world, long packedCoord) {
        long coordBits = packedCoord & 0xFFFFFFFFFFFFFFFL;
        int x = CoordinatePacker.unpackX((long)coordBits);
        int y = CoordinatePacker.unpackY((long)coordBits);
        int z = CoordinatePacker.unpackZ((long)coordBits);
        if (y < 0 || y >= 256) {
            return null;
        }
        int chunkx = x >> 4;
        int chunkz = z >> 4;
        try {
            if (world.func_72863_F().func_73149_a(chunkx, chunkz)) {
                Chunk cached = (Chunk)chunkCached.get();
                if (chunkCacheX == chunkx && chunkCacheZ == chunkz && chunkCacheDim == world.field_73011_w.field_76574_g && cached != null && cached.field_76636_d) {
                    return cached.func_150810_a(x & 0xF, y, z & 0xF);
                }
                Chunk chunk = world.func_72964_e(chunkx, chunkz);
                chunkCached = new WeakReference<Chunk>(chunk);
                chunkCacheDim = world.field_73011_w.field_76574_g;
                chunkCacheX = chunkx;
                chunkCacheZ = chunkz;
                return chunk.func_150810_a(x & 0xF, y, z & 0xF);
            }
            return Blocks.field_150357_h;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Arclamp thread: Exception getting block type in world");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Requested block coordinates");
            crashreportcategory.func_71507_a("Location", (Object)CrashReportCategory.func_85071_a((int)x, (int)y, (int)z));
            throw new ReportedException(crashreport);
        }
    }

    private long getDoubleSidedPacked(long packedCoord, int firstSide, int secondSide) {
        int x = CoordinatePacker.unpackX((long)packedCoord);
        int y = CoordinatePacker.unpackY((long)packedCoord);
        int z = CoordinatePacker.unpackZ((long)packedCoord);
        switch (firstSide) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        switch (secondSide) {
            case 0: {
                --y;
                break;
            }
            case 1: {
                ++y;
                break;
            }
            case 2: {
                --z;
                break;
            }
            case 3: {
                ++z;
                break;
            }
            case 4: {
                --x;
                break;
            }
            case 5: {
                ++x;
            }
        }
        long existingSideBits = packedCoord & 0xF000000000000000L;
        long newSideBits = (long)(1 << (firstSide ^ 1)) + ((long)firstSide << 6) << 60;
        long sideBits = existingSideBits | newSideBits;
        return CoordinatePacker.pack((int)x, (int)y, (int)z) | sideBits;
    }
}

