/*
 * Decompiled with CFR 0.152.
 */
package makeo.gadomancy.common.blocks.tiles;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import makeo.gadomancy.common.utils.NBTHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import thaumcraft.common.tiles.TileJarFillable;

public class TileRemoteJar
extends TileJarFillable {
    public UUID networkId;
    private int count;
    private boolean registered_to_network;
    private static final Map<UUID, JarNetwork> networks = new HashMap<UUID, JarNetwork>();

    public void func_145845_h() {
        super.func_145845_h();
        if (!(this.count % 3 != 0 || this.func_145831_w().field_72995_K || this.networkId == null || this.registered_to_network && this.amount >= this.maxAmount)) {
            this.count = 0;
            JarNetwork network = TileRemoteJar.getNetwork(this.networkId);
            this.registered_to_network = true;
            if (!network.jars.contains((Object)this)) {
                network.jars.add((TileJarFillable)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            }
            network.update();
        }
        ++this.count;
    }

    public void readCustomNBT(NBTTagCompound compound) {
        super.readCustomNBT(compound);
        this.networkId = NBTHelper.getUUID(compound, "networkId");
    }

    public void writeCustomNBT(NBTTagCompound compound) {
        super.writeCustomNBT(compound);
        if (this.networkId != null) {
            NBTHelper.setUUID(compound, "networkId", this.networkId);
        }
    }

    private static JarNetwork getNetwork(UUID id) {
        JarNetwork network = networks.get(id);
        if (network == null) {
            network = new JarNetwork();
            networks.put(id, network);
        }
        return network;
    }

    public void markForUpdate() {
        this.func_70296_d();
        this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private static class JarNetwork {
        private long lastTime;
        private final List<TileJarFillable> jars = new ArrayList<TileJarFillable>();

        private JarNetwork() {
        }

        private void update() {
            long time = MinecraftServer.func_71276_C().func_130014_f_().func_82737_E();
            if (time > this.lastTime) {
                if (this.jars.size() > 1) {
                    this.jars.removeIf(JarNetwork::isInvalid);
                    TileJarFillable high = null;
                    TileJarFillable low = null;
                    for (TileJarFillable jar : this.jars) {
                        if (low == null || low.amount > jar.amount) {
                            low = jar;
                        }
                        if (high != null && high.amount > jar.amount) continue;
                        high = jar;
                    }
                    if (low != high && low.amount + 1 < high.amount && low.addToContainer(high.aspect, 1) == 0) {
                        high.takeFromContainer(high.aspect, 1);
                    }
                }
                this.lastTime = time + 3L;
            }
        }

        private static boolean isInvalid(TileJarFillable jar) {
            return jar == null || jar.func_145831_w() == null || jar.func_145837_r() || !jar.func_145831_w().func_72899_e(jar.field_145851_c, jar.field_145848_d, jar.field_145849_e);
        }
    }
}

