/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.debug;

import java.awt.Color;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class DebugWindow
extends JFrame {
    private static final long serialVersionUID = -6071825908782027957L;
    private final JTextPane textArea;
    private final JScrollPane pane;

    public DebugWindow(String title, int width, int height) {
        super(title);
        this.setSize(width, height);
        this.textArea = new JTextPane();
        this.pane = new JScrollPane(this.textArea);
        this.getContentPane().add(this.pane);
        this.setVisible(true);
    }

    public void showInfo(String data, Color color) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attr, "SansSerif");
        StyleConstants.setFontSize(attr, 12);
        StyleConstants.setForeground(attr, color);
        Document document = this.textArea.getDocument();
        if (document != null) {
            try {
                document.insertString(document.getLength(), data, attr);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.getContentPane().validate();
    }

    public void clear() {
        this.textArea.setText("");
        this.getContentPane().validate();
    }
}

