/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.signs;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.BitSet;
import java.util.List;
import java.util.Map;
import logisticspipes.network.NewGuiHandler;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.network.guis.item.ItemAmountSignGui;
import logisticspipes.network.packets.pipe.ItemAmountSignUpdatePacket;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.signs.IPipeSign;
import logisticspipes.pipes.signs.IPipeSignData;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.renderer.LogisticsRenderPipe;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierInventory;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.StringUtils;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class ItemAmountPipeSign
implements IPipeSign,
ISimpleInventoryEventHandler {
    public ItemIdentifierInventory itemTypeInv = new ItemIdentifierInventory(1, "", 1);
    public int amount = 100;
    public CoreRoutedPipe pipe;
    public ForgeDirection dir;
    private boolean hasUpdated = false;

    public ItemAmountPipeSign() {
        this.itemTypeInv.addListener(this);
    }

    @Override
    public boolean isAllowedFor(CoreRoutedPipe pipe) {
        return true;
    }

    @Override
    public void addSignTo(CoreRoutedPipe pipe, ForgeDirection dir, EntityPlayer player) {
        pipe.addPipeSign(dir, new ItemAmountPipeSign(), player);
        this.openGUI(pipe, dir, player);
    }

    private void openGUI(CoreRoutedPipe pipe, ForgeDirection dir, EntityPlayer player) {
        NewGuiHandler.getGui(ItemAmountSignGui.class).setDir(dir).setTilePos(pipe.container).open(player);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.itemTypeInv.readFromNBT(tag);
    }

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.itemTypeInv.writeToNBT(tag);
    }

    @Override
    public ModernPacket getPacket() {
        return PacketHandler.getPacket(ItemAmountSignUpdatePacket.class).setStack(this.itemTypeInv.getIDStackInSlot(0)).setInteger2(this.amount).setInteger(this.dir.ordinal()).setTilePos(this.pipe.container);
    }

    @Override
    public void updateServerSide() {
        Map<ItemIdentifier, Integer> availableItems;
        if (!this.pipe.isNthTick(20)) {
            return;
        }
        if (this.hasUpdated) {
            this.hasUpdated = false;
            return;
        }
        int newAmount = 0;
        if (this.itemTypeInv.getIDStackInSlot(0) != null && (availableItems = SimpleServiceLocator.logisticsManager.getAvailableItems(this.pipe.getRouter().getIRoutersByCost())) != null) {
            BitSet set = new BitSet(ServerRouter.getBiggestSimpleID());
            this.spread(availableItems, set);
            if (availableItems.containsKey(this.itemTypeInv.getIDStackInSlot(0).getItem())) {
                newAmount = availableItems.get(this.itemTypeInv.getIDStackInSlot(0).getItem());
            }
        }
        if (newAmount != this.amount) {
            this.amount = newAmount;
            this.sendUpdatePacket();
        }
    }

    private void spread(Map<ItemIdentifier, Integer> availableItems, BitSet set) {
        IRouter router = this.pipe.getRouter();
        if (set.get(router.getSimpleID())) {
            return;
        }
        set.set(router.getSimpleID());
        for (ExitRoute exit : router.getIRoutersByCost()) {
            CoreRoutedPipe cachedPipe;
            if (exit.distanceToDestination > 2.0) break;
            if (!exit.filters.isEmpty() || set.get(exit.destination.getSimpleID()) || !exit.connectionDetails.contains((Object)PipeRoutingConnectionType.canRequestFrom) || !exit.connectionDetails.contains((Object)PipeRoutingConnectionType.canRouteTo) || (cachedPipe = exit.destination.getCachedPipe()) == null) continue;
            List<Pair<ForgeDirection, IPipeSign>> pipeSigns = cachedPipe.getPipeSigns();
            for (Pair<ForgeDirection, IPipeSign> signPair : pipeSigns) {
                if (signPair == null || !(signPair.getValue2() instanceof ItemAmountPipeSign)) continue;
                ((ItemAmountPipeSign)signPair.getValue2()).updateStats(availableItems, set);
            }
        }
    }

    private void updateStats(Map<ItemIdentifier, Integer> availableItems, BitSet set) {
        this.hasUpdated = true;
        int newAmount = 0;
        if (this.itemTypeInv.getIDStackInSlot(0) != null && availableItems.containsKey(this.itemTypeInv.getIDStackInSlot(0).getItem())) {
            newAmount = availableItems.get(this.itemTypeInv.getIDStackInSlot(0).getItem());
        }
        if (newAmount != this.amount) {
            this.amount = newAmount;
            this.sendUpdatePacket();
        }
        this.spread(availableItems, set);
    }

    @Override
    public void activate(EntityPlayer player) {
        this.openGUI(this.pipe, this.dir, player);
    }

    @Override
    public void init(CoreRoutedPipe pipe, ForgeDirection dir) {
        this.pipe = pipe;
        this.dir = dir;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void render(CoreRoutedPipe pipe, LogisticsRenderPipe renderer) {
        FontRenderer var17 = renderer.func_147498_b();
        if (pipe != null) {
            String name = "";
            if (this.itemTypeInv != null && this.itemTypeInv.getIDStackInSlot(0) != null) {
                ItemStack itemstack = this.itemTypeInv.getIDStackInSlot(0).unsafeMakeNormalStack();
                renderer.renderItemStackOnSign(itemstack);
                Item item = itemstack.func_77973_b();
                GL11.glDepthMask((boolean)false);
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                try {
                    name = item.func_77653_i(itemstack);
                }
                catch (Exception e) {
                    try {
                        name = item.func_77658_a();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                var17.func_78276_b("ID: " + Item.func_150891_b((Item)item), -var17.func_78256_a("ID: " + Item.func_150891_b((Item)item)) / 2, -20, 0);
                String displayAmount = StringUtils.getFormatedStackSize(this.amount, false);
                var17.func_78276_b("Amount:", -var17.func_78256_a("Amount:") / 2, -10, 0);
                var17.func_78276_b(displayAmount, -var17.func_78256_a(displayAmount) / 2, 0, 0);
            } else {
                GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glTranslatef((float)0.5f, (float)0.08f, (float)0.0f);
                GL11.glScalef((float)0.011111111f, (float)0.011111111f, (float)0.011111111f);
                name = "Empty";
            }
            name = renderer.cut(name, var17);
            var17.func_78276_b(name, -var17.func_78256_a(name) / 2 - 15, 10, 0);
            GL11.glDepthMask((boolean)true);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public IPipeSignData getRenderData(CoreRoutedPipe pipe) {
        if (pipe != null) {
            ItemIdentifierStack idStackInSlot = this.itemTypeInv.getIDStackInSlot(0);
            if (this.itemTypeInv != null && idStackInSlot != null) {
                return new ItemAmountPipeSignData(idStackInSlot, this.amount);
            }
            return new ItemAmountPipeSignData(null, -1);
        }
        return null;
    }

    @Override
    public void InventoryChanged(IInventory inventory) {
        if (inventory == this.itemTypeInv) {
            this.sendUpdatePacket();
        }
    }

    private void sendUpdatePacket() {
        if (MainProxy.isServer(this.pipe.getWorld())) {
            MainProxy.sendPacketToAllWatchingChunk(this.pipe.getX(), this.pipe.getZ(), MainProxy.getDimensionForWorld(this.pipe.getWorld()), this.getPacket());
        }
    }

    private static class ItemAmountPipeSignData
    implements IPipeSignData {
        private final ItemIdentifierStack item;
        private final int amount;

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean isListCompatible(LogisticsRenderPipe render) {
            return this.item == null || this.item.getItem().isRenderListCompatible(render);
        }

        public ItemAmountPipeSignData(ItemIdentifierStack item, int amount) {
            this.item = item;
            this.amount = amount;
        }

        public ItemIdentifierStack getItem() {
            return this.item;
        }

        public int getAmount() {
            return this.amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ItemAmountPipeSignData)) {
                return false;
            }
            ItemAmountPipeSignData other = (ItemAmountPipeSignData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAmount() != other.getAmount()) {
                return false;
            }
            ItemIdentifierStack this$item = this.getItem();
            ItemIdentifierStack other$item = other.getItem();
            return !(this$item == null ? other$item != null : !((Object)this$item).equals(other$item));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ItemAmountPipeSignData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAmount();
            ItemIdentifierStack $item = this.getItem();
            result = result * 59 + ($item == null ? 43 : ((Object)$item).hashCode());
            return result;
        }

        public String toString() {
            return "ItemAmountPipeSign.ItemAmountPipeSignData(item=" + this.getItem() + ", amount=" + this.getAmount() + ")";
        }
    }
}

