/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import logisticspipes.LPConstants;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.interfaces.IRotationProvider;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.CoreUnroutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.subproxies.IBCClickResult;
import logisticspipes.proxy.buildcraft.subproxies.IBCPipePluggable;
import logisticspipes.renderer.LogisticsPipeWorldRenderer;
import logisticspipes.renderer.newpipe.LogisticsNewRenderPipe;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.QueuedTasks;
import logisticspipes.utils.MatrixTranformations;
import logisticspipes.utils.tuples.LPPosition;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.Nullable;

public class LogisticsBlockGenericPipe
extends BlockContainer {
    public static Map<Item, Class<? extends CoreUnroutedPipe>> pipes = new HashMap<Item, Class<? extends CoreUnroutedPipe>>();
    public static Map<LPPosition, CoreUnroutedPipe> pipeRemoved = new HashMap<LPPosition, CoreUnroutedPipe>();
    private static long lastRemovedDate = -1L;
    private static final ForgeDirection[] DIR_VALUES = ForgeDirection.values();
    private boolean skippedFirstIconRegister;
    private int renderMask = 0;
    protected final Random rand = new Random();

    public LogisticsBlockGenericPipe() {
        super(Material.field_151592_s);
        this.setRenderAllSides();
        this.func_149647_a(null);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (world.field_72995_K) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
            if (pipe == null) {
                pipe = pipeRemoved.get(new LPPosition(x, y, z));
            }
            if (pipe == null) continue;
            if (pipe.item != null && (pipe.canBeDestroyed() || pipe.destroyByPlayer())) {
                list.addAll(pipe.dropContents());
                list.add(new ItemStack(pipe.item, 1, this.func_149692_a(metadata)));
                continue;
            }
            if (pipe.item == null) continue;
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
        return list;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess iblockaccess, int i, int j, int k, int l) {
        TileEntity tile = iblockaccess.func_147438_o(i, j, k);
        if (!(tile instanceof LogisticsTileGenericPipe)) {
            return null;
        }
        if (((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            PipeBlockRequestTable table = (PipeBlockRequestTable)((LogisticsTileGenericPipe)tile).pipe;
            return table.getTextureFor(l);
        }
        if (((LogisticsTileGenericPipe)tile).renderState.textureArray != null) {
            return ((LogisticsTileGenericPipe)tile).renderState.textureArray[l];
        }
        return ((LogisticsTileGenericPipe)tile).renderState.currentTexture;
    }

    public void func_149743_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List<AxisAlignedBB> arraylist, Entity par7Entity) {
        TileEntity tile = world.func_147438_o(i, j, k);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            return;
        }
        this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
        super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        if (tile instanceof LogisticsTileGenericPipe) {
            LogisticsTileGenericPipe tileG = (LogisticsTileGenericPipe)tile;
            if (tileG.isPipeConnected(ForgeDirection.WEST)) {
                this.func_149676_a(0.0f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.EAST)) {
                this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 1.0f, 0.8125f, 0.8125f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.DOWN)) {
                this.func_149676_a(0.1875f, 0.0f, 0.1875f, 0.8125f, 0.8125f, 0.8125f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.UP)) {
                this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 0.8125f, 1.0f, 0.8125f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.NORTH)) {
                this.func_149676_a(0.1875f, 0.1875f, 0.0f, 0.8125f, 0.8125f, 0.8125f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.SOUTH)) {
                this.func_149676_a(0.1875f, 0.1875f, 0.1875f, 0.8125f, 0.8125f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            float facadeThickness = 0.125f;
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.EAST)) {
                this.func_149676_a(1.0f - facadeThickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.WEST)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, facadeThickness, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.UP)) {
                this.func_149676_a(0.0f, 1.0f - facadeThickness, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.DOWN)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, facadeThickness, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.SOUTH)) {
                this.func_149676_a(0.0f, 0.0f, 1.0f - facadeThickness, 1.0f, 1.0f, 1.0f);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.tilePart.hasEnabledFacade(ForgeDirection.NORTH)) {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facadeThickness);
                super.func_149743_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            return AxisAlignedBB.func_72330_a((double)((double)x + 0.0), (double)((double)y + 0.0), (double)((double)z + 0.0), (double)((double)x + 1.0), (double)((double)y + 1.0), (double)((double)z + 1.0));
        }
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            AxisAlignedBB box = rayTraceResult.boundingBox;
            switch (rayTraceResult.hitPart) {
                case Pluggable: 
                case Pipe: {
                    float scale = 0.001f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
            }
            return box.func_72325_c((double)x, (double)y, (double)z);
        }
        return super.func_149633_g(world, x, y, z).func_72314_b((double)-0.85f, (double)-0.85f, (double)-0.85f);
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
            this.func_149719_a((IBlockAccess)world, x, y, z);
            origin = origin.func_72441_c((double)(-x), (double)(-y), (double)(-z));
            direction = direction.func_72441_c((double)(-x), (double)(-y), (double)(-z));
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            Vec3 vec32 = origin.func_72429_b(direction, this.field_149759_B);
            Vec3 vec33 = origin.func_72429_b(direction, this.field_149755_E);
            Vec3 vec34 = origin.func_72435_c(direction, this.field_149760_C);
            Vec3 vec35 = origin.func_72435_c(direction, this.field_149756_F);
            Vec3 vec36 = origin.func_72434_d(direction, this.field_149754_D);
            Vec3 vec37 = origin.func_72434_d(direction, this.field_149757_G);
            if (!this.isVecInsideYZBounds(vec32)) {
                vec32 = null;
            }
            if (!this.isVecInsideYZBounds(vec33)) {
                vec33 = null;
            }
            if (!this.isVecInsideXZBounds(vec34)) {
                vec34 = null;
            }
            if (!this.isVecInsideXZBounds(vec35)) {
                vec35 = null;
            }
            if (!this.isVecInsideXYBounds(vec36)) {
                vec36 = null;
            }
            if (!this.isVecInsideXYBounds(vec37)) {
                vec37 = null;
            }
            Vec3 vec38 = null;
            if (vec32 != null && (vec38 == null || origin.func_72436_e(vec32) < origin.func_72436_e(vec38))) {
                vec38 = vec32;
            }
            if (vec33 != null && (vec38 == null || origin.func_72436_e(vec33) < origin.func_72436_e(vec38))) {
                vec38 = vec33;
            }
            if (vec34 != null && (vec38 == null || origin.func_72436_e(vec34) < origin.func_72436_e(vec38))) {
                vec38 = vec34;
            }
            if (vec35 != null && (vec38 == null || origin.func_72436_e(vec35) < origin.func_72436_e(vec38))) {
                vec38 = vec35;
            }
            if (vec36 != null && (vec38 == null || origin.func_72436_e(vec36) < origin.func_72436_e(vec38))) {
                vec38 = vec36;
            }
            if (vec37 != null && (vec38 == null || origin.func_72436_e(vec37) < origin.func_72436_e(vec38))) {
                vec38 = vec37;
            }
            if (vec38 == null) {
                return null;
            }
            int b0 = -1;
            if (vec38 == vec32) {
                b0 = 4;
            }
            if (vec38 == vec33) {
                b0 = 5;
            }
            if (vec38 == vec34) {
                b0 = 0;
            }
            if (vec38 == vec35) {
                b0 = 1;
            }
            if (vec38 == vec36) {
                b0 = 2;
            }
            if (vec38 == vec37) {
                b0 = 3;
            }
            return new MovingObjectPosition(x, y, z, b0, vec38.func_72441_c((double)x, (double)y, (double)z));
        }
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.movingObjectPosition;
    }

    public RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer player) {
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        double eyeHeight = world.field_72995_K ? (double)(player.func_70047_e() - player.getDefaultEyeHeight()) : (double)player.func_70047_e();
        Vec3 lookVec = player.func_70040_Z();
        Vec3 origin = Vec3.func_72443_a((double)player.field_70165_t, (double)(player.field_70163_u + eyeHeight), (double)player.field_70161_v);
        Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, x, y, z, origin, direction);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        AxisAlignedBB bb;
        TileEntity pipeTileEntity = world.func_147438_o(x, y, z);
        LogisticsTileGenericPipe tileG = null;
        if (pipeTileEntity instanceof LogisticsTileGenericPipe) {
            tileG = (LogisticsTileGenericPipe)pipeTileEntity;
        }
        if (tileG == null) {
            return null;
        }
        CoreUnroutedPipe pipe = tileG.pipe;
        if (!LogisticsBlockGenericPipe.isValid(pipe)) {
            return null;
        }
        MovingObjectPosition[] hits = new MovingObjectPosition[31];
        AxisAlignedBB[] boxes = new AxisAlignedBB[31];
        Object[] sideHit = new ForgeDirection[31];
        Arrays.fill(sideHit, ForgeDirection.UNKNOWN);
        for (ForgeDirection side : DIR_VALUES) {
            if (side != ForgeDirection.UNKNOWN && !tileG.isPipeConnected(side)) continue;
            bb = this.getPipeBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[side.ordinal()] = bb;
            hits[side.ordinal()] = super.func_149731_a(world, x, y, z, origin, direction);
            sideHit[side.ordinal()] = side;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (tileG.getPipePluggable(side) == null) continue;
            bb = tileG.getPipePluggable(side).getBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[7 + side.ordinal()] = bb;
            hits[7 + side.ordinal()] = super.func_149731_a(world, x, y, z, origin, direction);
            sideHit[7 + side.ordinal()] = side;
        }
        double minLengthSquared = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double lengthSquared;
            MovingObjectPosition hit = hits[i];
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            minIndex = i;
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (minIndex == -1) {
            return null;
        }
        Part hitPart = minIndex < 7 ? Part.Pipe : Part.Pluggable;
        return new RaytraceResult(hitPart, hits[minIndex], boxes[minIndex], (ForgeDirection)sideHit[minIndex]);
    }

    private void setBlockBounds(AxisAlignedBB bb) {
        this.func_149676_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
    }

    private AxisAlignedBB getPipeBoundingBox(ForgeDirection side) {
        float min = 0.1875f;
        float max = 0.8125f;
        if (side == ForgeDirection.UNKNOWN) {
            return AxisAlignedBB.func_72330_a((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.0f;
        bounds[1][1] = min;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72330_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private boolean isVecInsideYZBounds(Vec3 par1Vec3) {
        return par1Vec3 != null && par1Vec3.field_72448_b >= this.field_149760_C && par1Vec3.field_72448_b <= this.field_149756_F && par1Vec3.field_72449_c >= this.field_149754_D && par1Vec3.field_72449_c <= this.field_149757_G;
    }

    private boolean isVecInsideXZBounds(Vec3 par1Vec3) {
        return par1Vec3 != null && par1Vec3.field_72450_a >= this.field_149759_B && par1Vec3.field_72450_a <= this.field_149755_E && par1Vec3.field_72449_c >= this.field_149754_D && par1Vec3.field_72449_c <= this.field_149757_G;
    }

    private boolean isVecInsideXYBounds(Vec3 par1Vec3) {
        return par1Vec3 != null && par1Vec3.field_72450_a >= this.field_149759_B && par1Vec3.field_72450_a <= this.field_149755_E && par1Vec3.field_72448_b >= this.field_149760_C && par1Vec3.field_72448_b <= this.field_149756_F;
    }

    public static IIcon getRequestTableTextureFromSide(int l) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)l);
        switch (dir) {
            case UP: {
                return Textures.LOGISTICS_REQUEST_TABLE[0];
            }
            case DOWN: {
                return Textures.LOGISTICS_REQUEST_TABLE[1];
            }
        }
        return Textures.LOGISTICS_REQUEST_TABLE[4];
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new LogisticsTileGenericPipe();
    }

    public float func_149712_f(World par1World, int par2, int par3, int par4) {
        return Configs.pipeDurability;
    }

    public int func_149645_b() {
        return LPConstants.pipeModel;
    }

    public boolean canRenderInPass(int pass) {
        LogisticsPipeWorldRenderer.renderPass = pass;
        return true;
    }

    public int func_149701_w() {
        return 1;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void setRenderMask(int mask) {
        this.renderMask = mask;
    }

    public final void setRenderAllSides() {
        this.renderMask = 63;
    }

    public void setRenderSide(ForgeDirection side, boolean render) {
        this.renderMask = render ? (this.renderMask |= 1 << side.ordinal()) : (this.renderMask &= ~(1 << side.ordinal()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return (this.renderMask & 1 << side) != 0;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof LogisticsTileGenericPipe) {
            if (((LogisticsTileGenericPipe)tile).pipe instanceof PipeBlockRequestTable) {
                return true;
            }
            return ((LogisticsTileGenericPipe)tile).isSolidOnSide(side);
        }
        return false;
    }

    public boolean func_149721_r() {
        return false;
    }

    public static void removePipe(CoreUnroutedPipe pipe) {
        if (!LogisticsBlockGenericPipe.isValid(pipe)) {
            return;
        }
        if (pipe.canBeDestroyed() || pipe.destroyByPlayer()) {
            pipe.onBlockRemoval();
        } else if (pipe.preventRemove()) {
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
        World world = pipe.container.func_145831_w();
        if (world == null) {
            return;
        }
        int x = pipe.container.field_145851_c;
        int y = pipe.container.field_145848_d;
        int z = pipe.container.field_145849_e;
        if (lastRemovedDate != world.func_82737_E()) {
            lastRemovedDate = world.func_82737_E();
            pipeRemoved.clear();
        }
        pipeRemoved.put(new LPPosition(x, y, z), pipe);
        world.func_147475_p(x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        LogisticsBlockGenericPipe.removePipe(LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z));
        super.func_149749_a(world, x, y, z, block, par6);
        SimpleServiceLocator.buildCraftProxy.callBCRemovePipe(world, x, y, z);
    }

    public void func_149690_a(World world, int i, int j, int k, int l, float f, int dmg) {
        if (world.field_72995_K) {
            return;
        }
        int i1 = this.func_149745_a(world.field_73012_v);
        for (int j1 = 0; j1 < i1; ++j1) {
            if (world.field_73012_v.nextFloat() > f) continue;
            CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
            if (pipe == null) {
                pipe = pipeRemoved.get(new LPPosition(i, j, k));
            }
            if (pipe.item != null && (pipe.canBeDestroyed() || pipe.destroyByPlayer())) {
                for (ItemStack stack : pipe.dropContents()) {
                    this.func_149642_a(world, i, j, k, stack);
                }
                this.func_149642_a(world, i, j, k, new ItemStack(pipe.item, 1, this.func_149692_a(l)));
                continue;
            }
            if (pipe.item == null) continue;
            LogisticsBlockGenericPipe.cacheTileToPreventRemoval(pipe);
        }
    }

    public Item func_149650_a(int meta, Random rand, int dmg) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            switch (rayTraceResult.hitPart) {
                case Pluggable: {
                    CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
                    IBCPipePluggable pluggable = pipe.container.tilePart.getBCPipePluggable(rayTraceResult.sideHit);
                    ItemStack[] drops = pluggable.getDropItems(pipe.container);
                    if (drops != null && drops.length > 0) {
                        return drops[0];
                    }
                }
                case Pipe: {
                    return new ItemStack(LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, (int)x, (int)y, (int)z).item);
                }
            }
        }
        return null;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        super.func_149695_a(world, x, y, z, block);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
        }
        SimpleServiceLocator.buildCraftProxy.callBCNeighborBlockChange(world, x, y, z, block);
    }

    public int func_149660_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        super.func_149660_a(world, x, y, z, side, par6, par7, par8, meta);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
        }
        return meta;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        super.func_149689_a(world, x, y, z, placer, stack);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlacedBy(placer);
            if (pipe instanceof IRotationProvider) {
                double xPos = (double)pipe.getX() + 0.5 - placer.field_70165_t;
                double zPos = (double)pipe.getZ() + 0.5 - placer.field_70161_v;
                double w = Math.atan2(xPos, zPos);
                double halfPI = 1.5707963267948966;
                double halfhalfPI = halfPI / 2.0;
                if ((w -= halfhalfPI) < 0.0) {
                    w += Math.PI * 2;
                }
                if (0.0 < w && w <= halfPI) {
                    ((IRotationProvider)((Object)pipe)).setRotation(1);
                } else if (halfPI < w && w <= 2.0 * halfPI) {
                    ((IRotationProvider)((Object)pipe)).setRotation(2);
                } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
                    ((IRotationProvider)((Object)pipe)).setRotation(0);
                } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
                    ((IRotationProvider)((Object)pipe)).setRotation(3);
                }
            }
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        super.func_149727_a(world, x, y, z, player, side, xOffset, yOffset, zOffset);
        world.func_147459_d(x, y, z, (Block)LogisticsPipes.LogisticsPipeBlock);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            ItemStack currentItem = player.func_71045_bC();
            if (currentItem != null) {
                if (currentItem.func_77973_b() == Items.field_151155_ap) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemLogisticsPipe) {
                    return false;
                }
                if (SimpleServiceLocator.toolWrenchHandler.isWrench(currentItem.func_77973_b())) {
                    return pipe.blockActivated(player);
                }
            }
            if (pipe.canHoldBCParts()) {
                IBCClickResult result = SimpleServiceLocator.buildCraftProxy.handleBCClickOnPipe(world, x, y, z, player, side, xOffset, yOffset, zOffset, pipe);
                if (result.handled()) {
                    return true;
                }
                if (result.blocked()) {
                    return false;
                }
            }
            return pipe.blockActivated(player);
        }
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        super.func_149670_a(world, i, j, k, entity);
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(world, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            return pipe.bcPipePart.canConnectRedstone();
        }
        return false;
    }

    public int func_149748_c(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(iblockaccess, x, y, z);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            return pipe.bcPipePart.isPoweringTo(l);
        }
        return 0;
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess world, int i, int j, int k, int l) {
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe(world, i, j, k);
        if (LogisticsBlockGenericPipe.isValid(pipe)) {
            return pipe.bcPipePart.isIndirectlyPoweringTo(l);
        }
        return 0;
    }

    public static ItemLogisticsPipe registerPipe(Class<? extends CoreUnroutedPipe> clas) {
        ItemLogisticsPipe item = new ItemLogisticsPipe();
        item.func_77655_b(clas.getSimpleName());
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        pipes.put(item, clas);
        CoreUnroutedPipe dummyPipe = LogisticsBlockGenericPipe.createPipe(item);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem(), dummyPipe.getTextureIndex());
            MainProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
        }
        return item;
    }

    @Nullable
    public static Class<? extends CoreUnroutedPipe> getPipeClassByItem(Item key) {
        return pipes.get(key);
    }

    public static CoreUnroutedPipe createPipe(Item key) {
        Class<? extends CoreUnroutedPipe> pipe = LogisticsBlockGenericPipe.getPipeClassByItem(key);
        if (pipe != null) {
            try {
                return pipe.getConstructor(Item.class).newInstance(key);
            }
            catch (ReflectiveOperationException e) {
                LogisticsPipes.log.error("Could not construct class " + pipe.getSimpleName() + " for key " + key, (Throwable)e);
            }
        } else {
            LogisticsPipes.log.warn("Detected pipe with unknown key (" + key + "). Did you remove a buildcraft addon?");
        }
        return null;
    }

    public static boolean placePipe(CoreUnroutedPipe pipe, World world, int i, int j, int k, Block block, int meta) {
        if (world.field_72995_K) {
            return true;
        }
        boolean placed = world.func_147465_d(i, j, k, block, meta, 2);
        if (placed) {
            TileEntity tile = world.func_147438_o(i, j, k);
            if (tile instanceof LogisticsTileGenericPipe) {
                LogisticsTileGenericPipe tilePipe = (LogisticsTileGenericPipe)tile;
                tilePipe.initialize(pipe);
                tilePipe.sendUpdateToClient();
            }
            world.func_147444_c(i, j, k, block);
        }
        return placed;
    }

    public static CoreUnroutedPipe getPipe(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_147438_o(i, j, k);
        if (!(tile instanceof LogisticsTileGenericPipe) || tile.func_145837_r()) {
            return null;
        }
        return ((LogisticsTileGenericPipe)tile).pipe;
    }

    public static boolean isFullyDefined(CoreUnroutedPipe pipe) {
        return pipe != null && pipe.transport != null && pipe.container != null;
    }

    public static boolean isValid(CoreUnroutedPipe pipe) {
        return LogisticsBlockGenericPipe.isFullyDefined(pipe);
    }

    public String func_149739_a() {
        return "LogisticsPipes Pipe Block";
    }

    public String func_149732_F() {
        return this.func_149739_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        LogisticsNewRenderPipe.registerTextures(iconRegister);
        SimpleServiceLocator.thermalDynamicsProxy.registerTextures(iconRegister);
        if (!this.skippedFirstIconRegister) {
            this.skippedFirstIconRegister = true;
            return;
        }
        for (Item i : pipes.keySet()) {
            CoreUnroutedPipe dummyPipe = LogisticsBlockGenericPipe.createPipe(i);
            if (dummyPipe == null) continue;
            dummyPipe.getIconProvider().registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        IIcon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int sideHit = target.field_72310_e;
        LogisticsBlockGenericPipe block = LogisticsPipes.LogisticsPipeBlock;
        float b = 0.1f;
        double px = (double)x + this.rand.nextDouble() * (block.func_149753_y() - block.func_149704_x() - (double)(b * 2.0f)) + (double)b + block.func_149704_x();
        double py = (double)y + this.rand.nextDouble() * (block.func_149669_A() - block.func_149665_z() - (double)(b * 2.0f)) + (double)b + block.func_149665_z();
        double pz = (double)z + this.rand.nextDouble() * (block.func_149693_C() - block.func_149706_B() - (double)(b * 2.0f)) + (double)b + block.func_149706_B();
        if (sideHit == 0) {
            py = (double)y + block.func_149665_z() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.func_149669_A() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.func_149706_B() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.func_149693_C() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.func_149704_x() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.func_149753_y() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, 0.0, 0.0, 0.0, (Block)block, sideHit, worldObj.func_72805_g(x, y, z));
        fx.func_110125_a(icon);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        CoreUnroutedPipe pipe = LogisticsBlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        IIcon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, (Block)LogisticsPipes.LogisticsPipeBlock, random, meta);
                    fx.func_110125_a(icon);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    private static void cacheTileToPreventRemoval(CoreUnroutedPipe pipe) {
        World worldCache = pipe.getWorld();
        int xCache = pipe.getX();
        int yCache = pipe.getY();
        int zCache = pipe.getZ();
        LogisticsTileGenericPipe tileCache = pipe.container;
        CoreUnroutedPipe fPipe = pipe;
        fPipe.setPreventRemove(true);
        QueuedTasks.queueTask(() -> {
            if (!fPipe.preventRemove()) {
                return null;
            }
            boolean changed = false;
            if (worldCache.func_147439_a(xCache, yCache, zCache) != LogisticsPipes.LogisticsPipeBlock) {
                worldCache.func_147449_b(xCache, yCache, zCache, (Block)LogisticsPipes.LogisticsPipeBlock);
                changed = true;
            }
            if (worldCache.func_147438_o(xCache, yCache, zCache) != tileCache) {
                worldCache.func_147455_a(xCache, yCache, zCache, tileCache);
                changed = true;
            }
            if (changed) {
                worldCache.func_147444_c(xCache, yCache, zCache, (Block)LogisticsPipes.LogisticsPipeBlock);
            }
            fPipe.setPreventRemove(false);
            return null;
        });
    }

    public static class RaytraceResult {
        public final Part hitPart;
        public final MovingObjectPosition movingObjectPosition;
        public final AxisAlignedBB boundingBox;
        public final ForgeDirection sideHit;

        RaytraceResult(Part hitPart, MovingObjectPosition movingObjectPosition, AxisAlignedBB boundingBox, ForgeDirection side) {
            this.hitPart = hitPart;
            this.movingObjectPosition = movingObjectPosition;
            this.boundingBox = boundingBox;
            this.sideHit = side;
        }

        public String toString() {
            return String.format("RayTraceResult: %s, %s", this.hitPart == null ? "null" : this.hitPart.name(), this.boundingBox == null ? "null" : this.boundingBox.toString());
        }
    }

    public static enum Part {
        Pipe,
        Pluggable;

    }
}

