/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockConfiguration;
import com.jaquadro.minecraft.storagedrawers.api.pack.BlockType;
import com.jaquadro.minecraft.storagedrawers.api.security.ISecurityProvider;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.api.storage.INetworked;
import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.LockAttribute;
import com.jaquadro.minecraft.storagedrawers.block.IExtendedBlockClickHandler;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.core.ModCreativeTabs;
import com.jaquadro.minecraft.storagedrawers.core.ModItems;
import com.jaquadro.minecraft.storagedrawers.core.handlers.GuiHandler;
import com.jaquadro.minecraft.storagedrawers.item.ItemPersonalKey;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgrade;
import com.jaquadro.minecraft.storagedrawers.item.ItemUpgradeCreative;
import com.jaquadro.minecraft.storagedrawers.network.BlockClickMessage;
import com.jaquadro.minecraft.storagedrawers.security.SecurityManager;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fox.spiteful.avaritia.items.ItemMatterCluster;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockEnderChest;
import net.minecraft.block.BlockWood;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.client.resources.IResource;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.logging.log4j.Level;

public class BlockDrawers
extends BlockContainer
implements IExtendedBlockClickHandler,
INetworked {
    private static final ResourceLocation blockConfig = new ResourceLocation("StorageDrawers:textures/blocks/block_config.mcmeta");
    public final boolean halfDepth;
    public final int drawerCount;
    private float trimWidth = 0.0625f;
    private float trimDepth = 0.0625f;
    private float indStart = 0.0f;
    private float indEnd = 0.0f;
    private int indSteps = 0;
    private String blockConfigName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSide;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideV;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconSideH;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront1;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront2;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconFront4;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] iconTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlay;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayV;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayH;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconOverlayTrim;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator1;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator2;
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconIndicator4;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconLock;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconClaim;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconClaimLock;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconVoid;
    @SideOnly(value=Side.CLIENT)
    private IIcon iconTaped;
    private long ignoreEventTime;

    public BlockDrawers(String blockName, int drawerCount, boolean halfDepth) {
        this(Material.field_151575_d, blockName, drawerCount, halfDepth);
    }

    protected BlockDrawers(Material material, String blockName, int drawerCount, boolean halfDepth) {
        super(material);
        this.drawerCount = drawerCount;
        this.halfDepth = halfDepth;
        this.field_149783_u = true;
        this.func_149647_a(ModCreativeTabs.tabStorageDrawers);
        this.func_149711_c(5.0f);
        this.func_149672_a(Block.field_149766_f);
        this.func_149663_c(blockName);
        this.setConfigName(blockName);
        this.func_149713_g(255);
    }

    public boolean retrimBlock(World world, int x, int y, int z, ItemStack prototype) {
        if (this.retrimType() == null) {
            return false;
        }
        Block protoBlock = Block.func_149634_a((Item)prototype.func_77973_b());
        int protoMeta = prototype.func_77960_j();
        BlockConfiguration config = BlockConfiguration.by(this.retrimType(), this.drawerCount, this.halfDepth);
        Block plankBlock = StorageDrawers.blockRegistry.getPlankBlock(BlockConfiguration.Trim, protoBlock, protoMeta);
        int plankMeta = StorageDrawers.blockRegistry.getPlankMeta(BlockConfiguration.Trim, protoBlock, protoMeta);
        Block newBlock = StorageDrawers.blockRegistry.getBlock(config, plankBlock, plankMeta);
        int newMeta = StorageDrawers.blockRegistry.getMeta(config, plankBlock, plankMeta);
        if (newBlock == null) {
            return false;
        }
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (newBlock == this && newMeta == world.func_72805_g(x, y, z) && !tile.shouldHideUpgrades()) {
            tile.setShouldHideUpgrades(true);
            return true;
        }
        if (newBlock == this) {
            world.func_72921_c(x, y, z, newMeta, 3);
        } else {
            TileEntityDrawers newDrawer = this.createNewTileEntity(world, newMeta);
            NBTTagCompound tag = new NBTTagCompound();
            tile.func_145841_b(tag);
            newDrawer.func_145839_a(tag);
            world.func_147475_p(x, y, z);
            world.func_147468_f(x, y, z);
            world.func_147465_d(x, y, z, newBlock, newMeta, 3);
            world.func_147455_a(x, y, z, (TileEntity)newDrawer);
        }
        return true;
    }

    public BlockType retrimType() {
        return BlockType.Drawers;
    }

    public float getTrimWidth() {
        return this.trimWidth;
    }

    public float getTrimDepth() {
        return this.trimDepth;
    }

    public float getIndStart() {
        return this.indStart;
    }

    public float getIndEnd() {
        return this.indEnd;
    }

    public int getIndSteps() {
        return this.indSteps;
    }

    public BlockDrawers setConfigName(String name) {
        this.blockConfigName = name;
        return this;
    }

    public String getConfigName() {
        return this.blockConfigName;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return StorageDrawers.proxy.drawersRenderID;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
            return;
        }
        float depth = this.halfDepth ? 0.5f : 1.0f;
        switch (tile.getDirection()) {
            case 2: {
                this.func_149676_a(0.0f, 0.0f, 1.0f - depth, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 3: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, depth);
                break;
            }
            case 4: {
                this.func_149676_a(1.0f - depth, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.func_149676_a(0.0f, 0.0f, 0.0f, depth, 1.0f, 1.0f);
            }
        }
    }

    public void func_149683_g() {
        if (this.halfDepth) {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
        } else {
            this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        this.func_149719_a((IBlockAccess)world, x, y, z);
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack itemStack) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.getDirection() > 1) {
            return;
        }
        int quadrant = MathHelper.func_76128_c((double)((double)(entity.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        switch (quadrant) {
            case 0: {
                tile.setDirection(2);
                break;
            }
            case 1: {
                tile.setDirection(5);
                break;
            }
            case 2: {
                tile.setDirection(3);
                break;
            }
            case 3: {
                tile.setDirection(4);
            }
        }
        if (itemStack.func_82837_s()) {
            tile.setInventoryName(itemStack.func_82833_r());
        }
        if (world.field_72995_K) {
            tile.func_145843_s();
            world.func_147471_g(x, y, z);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K && Minecraft.func_71386_F() == this.ignoreEventTime) {
            this.ignoreEventTime = 0L;
            return false;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        ItemStack item = player.field_71071_by.func_70448_g();
        if (!SecurityManager.hasAccess(player.func_146103_bH(), tileDrawers)) {
            return false;
        }
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"BlockDrawers.onBlockActivated", (Object[])new Object[0]);
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item), (Object[])new Object[0]);
        }
        if (item != null && item.func_77973_b() != null) {
            if (item.func_77973_b() instanceof ItemTrim && player.func_70093_af()) {
                if (!this.retrimBlock(world, x, y, z, item)) {
                    return false;
                }
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.upgrade || item.func_77973_b() == ModItems.upgradeStatus || item.func_77973_b() == ModItems.upgradeVoid || item.func_77973_b() == ModItems.upgradeCreative || item.func_77973_b() == ModItems.upgradeRedstone || item.func_77973_b() == ModItems.upgradeDowngrade) {
                if (!tileDrawers.addUpgrade(item)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("storagedrawers.msg.maxUpgrades", new Object[0]));
                    return false;
                }
                world.func_147471_g(x, y, z);
                if (!player.field_71075_bZ.field_75098_d && --item.field_77994_a <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.upgradeLock) {
                int slot;
                IDrawer drawer;
                boolean locked = tileDrawers.isLocked(LockAttribute.LOCK_POPULATED);
                if (locked && (drawer = tileDrawers.getDrawer(slot = this.getDrawerSlot(side, hitX, hitY, hitZ))) != null) {
                    ItemStack stack = drawer.getStoredItemPrototype();
                    int count = drawer.getStoredItemCount();
                    if (stack != null && count == 0) {
                        drawer.setStoredItemRedir(null, 0);
                        return true;
                    }
                }
                tileDrawers.setLocked(LockAttribute.LOCK_POPULATED, !locked);
                tileDrawers.setLocked(LockAttribute.LOCK_EMPTY, !locked);
                return true;
            }
            if (item.func_77973_b() == ModItems.shroudKey) {
                tileDrawers.setIsShrouded(!tileDrawers.isShrouded());
                return true;
            }
            if (item.func_77973_b() == ModItems.quantifyKey) {
                tileDrawers.setIsQuantified(!tileDrawers.isQuantified());
                return true;
            }
            if (item.func_77973_b() instanceof ItemPersonalKey) {
                String securityKey = ((ItemPersonalKey)item.func_77973_b()).getSecurityProviderKey(item.func_77960_j());
                ISecurityProvider provider = StorageDrawers.securityRegistry.getProvider(securityKey);
                if (tileDrawers.getOwner() == null) {
                    tileDrawers.setOwner(player.getPersistentID());
                    tileDrawers.setSecurityProvider(provider);
                } else if (SecurityManager.hasOwnership(player.func_146103_bH(), tileDrawers)) {
                    tileDrawers.setOwner(null);
                    tileDrawers.setSecurityProvider(null);
                } else {
                    return false;
                }
                return true;
            }
            if (item.func_77973_b() == ModItems.tape) {
                return false;
            }
        } else if (item == null && player.func_70093_af()) {
            if (tileDrawers.isSealed()) {
                tileDrawers.setIsSealed(false);
                return true;
            }
            if (StorageDrawers.config.cache.enableDrawerUI) {
                player.openGui((Object)StorageDrawers.instance, GuiHandler.drawersGuiID, world, x, y, z);
                return true;
            }
        }
        if (tileDrawers.getDirection() != side) {
            return false;
        }
        if (tileDrawers.isSealed()) {
            return false;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        if (drawer != null) {
            ItemStack currentStack = drawer.getStoredItemPrototype();
            int countAdded = tileDrawers.interactPutItemsIntoSlot(slot, player);
            if (countAdded > 0 && currentStack != null) {
                world.func_147471_g(x, y, z);
            }
        }
        return true;
    }

    protected int getDrawerSlot(int side, float hitX, float hitY, float hitZ) {
        if (this.drawerCount == 1) {
            return 0;
        }
        if (this.drawerCount == 2) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        if (this.hitLeft(side, hitX, hitZ)) {
            return this.hitTop(hitY) ? 0 : 1;
        }
        return this.hitTop(hitY) ? 2 : 3;
    }

    protected boolean hitTop(float hitY) {
        return (double)hitY > 0.5;
    }

    protected boolean hitLeft(int side, float hitX, float hitZ) {
        switch (side) {
            case 2: {
                return (double)hitX > 0.5;
            }
            case 3: {
                return (double)hitX < 0.5;
            }
            case 4: {
                return (double)hitZ < 0.5;
            }
            case 5: {
                return (double)hitZ > 0.5;
            }
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        if (world.field_72995_K) {
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            float hitX = (float)(posn.field_72307_f.field_72450_a - (double)posn.field_72311_b);
            float hitY = (float)(posn.field_72307_f.field_72448_b - (double)posn.field_72312_c);
            float hitZ = (float)(posn.field_72307_f.field_72449_c - (double)posn.field_72309_d);
            StorageDrawers.network.sendToServer((IMessage)new BlockClickMessage(x, y, z, posn.field_72310_e, hitX, hitY, hitZ, StorageDrawers.config.cache.invertShift));
            if (StorageDrawers.config.cache.debugTrace) {
                FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)("BlockDrawers.onBlockClicked with " + posn), (Object[])new Object[0]);
            }
        }
    }

    @Override
    public void onBlockClicked(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ, boolean invertShift) {
        PlayerInteractEvent event;
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)"IExtendedBlockClickHandler.onBlockClicked", (Object[])new Object[0]);
        }
        if (!player.field_71075_bZ.field_75098_d && (event = ForgeEventFactory.onPlayerInteract((EntityPlayer)player, (PlayerInteractEvent.Action)PlayerInteractEvent.Action.LEFT_CLICK_BLOCK, (int)x, (int)y, (int)z, (int)side, (World)world)).isCanceled()) {
            return;
        }
        TileEntityDrawers tileDrawers = this.getTileEntitySafe(world, x, y, z);
        if (tileDrawers.getDirection() != side) {
            return;
        }
        if (tileDrawers.isSealed()) {
            return;
        }
        if (!SecurityManager.hasAccess(player.func_146103_bH(), tileDrawers)) {
            return;
        }
        int slot = this.getDrawerSlot(side, hitX, hitY, hitZ);
        IDrawer drawer = tileDrawers.getDrawer(slot);
        if (drawer == null) {
            return;
        }
        ItemStack item = player.func_70093_af() != invertShift ? tileDrawers.takeItemsFromSlot(slot, drawer.getStoredItemStackSize()) : tileDrawers.takeItemsFromSlot(slot, 1);
        if (StorageDrawers.config.cache.debugTrace) {
            FMLLog.log((String)"StorageDrawers", (Level)Level.INFO, (String)(item == null ? "  null item" : "  " + item), (Object[])new Object[0]);
        }
        if (item != null && item.field_77994_a > 0) {
            if (!player.field_71071_by.func_70441_a(item)) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)side);
                this.dropItemStack(world, x + dir.offsetX, y, z + dir.offsetZ, item);
                world.func_147471_g(x, y, z);
            } else {
                world.func_72908_a((double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), "random.pop", 0.2f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            }
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntityDrawers tile = this.getTileEntitySafe(world, x, y, z);
        if (tile.isSealed()) {
            this.func_149697_b(world, x, y, z, world.func_72805_g(x, y, z), 0);
            world.func_147468_f(x, y, z);
            return true;
        }
        if (tile.getDirection() == axis.ordinal()) {
            return false;
        }
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        tile.setDirection(axis.ordinal());
        world.func_147471_g(x, y, z);
        if (world.field_72995_K) {
            this.ignoreEventTime = Minecraft.func_71386_F();
        }
        return true;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        Block blockUnder;
        if (this.halfDepth) {
            return false;
        }
        if (side == ForgeDirection.DOWN && ((blockUnder = world.func_147439_a(x, y - 1, z)) instanceof BlockChest || blockUnder instanceof BlockEnderChest)) {
            return false;
        }
        if (BlockDrawers.getTileEntity(world, x, y, z) == null) {
            return true;
        }
        return side.ordinal() != BlockDrawers.getTileEntity(world, x, y, z).getDirection();
    }

    private void dropItemStack(World world, int x, int y, int z, ItemStack stack) {
        EntityItem entity = new EntityItem(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), stack);
        entity.func_70024_g(-entity.field_70159_w, -entity.field_70181_x, -entity.field_70179_y);
        world.func_72838_d((Entity)entity);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z) {
        if (world.field_72995_K && player.field_71075_bZ.field_75098_d) {
            TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
            MovingObjectPosition posn = Minecraft.func_71410_x().field_71476_x;
            if (tile.getDirection() == posn.field_72310_e) {
                this.func_149699_a(world, x, y, z, player);
                return false;
            }
        }
        return super.removedByPlayer(world, player, x, y, z);
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null && !tile.isSealed()) {
            for (int i = 0; i < tile.getUpgradeSlotCount(); ++i) {
                ItemStack stack = tile.getUpgrade(i);
                if (stack == null || stack.func_77973_b() instanceof ItemUpgradeCreative) continue;
                this.func_149642_a(world, x, y, z, stack);
            }
            if (!tile.isVending()) {
                switch (StorageDrawers.config.cache.breakDrawerDropMode) {
                    case "merge": {
                        BlockDrawers.dropMergedStacks(tile, world, x, y, z);
                        break;
                    }
                    case "destroy": {
                        BlockDrawers.dropStacksAndDestroyExcess(tile, world, x, y, z);
                        break;
                    }
                    case "mixed": {
                        BlockDrawers.dropStacksMixedBehavior(tile, world, x, y, z);
                        break;
                    }
                    case "cluster": {
                        if (Loader.isModLoaded((String)"Avaritia")) {
                            BlockDrawers.dropAvaritiaClusters(tile, world, x, y, z);
                        }
                    }
                    default: {
                        BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
                    }
                }
            }
            world.func_147453_f(x, y, z, block);
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    private static void forEachSplitStackOfSubDrawer(TileEntityDrawers drawer, int drawerIndex, Consumer<ItemStack> action) {
        ItemStack stack;
        if (!drawer.isDrawerEnabled(drawerIndex)) {
            return;
        }
        IDrawer subDrawer = drawer.getDrawer(drawerIndex);
        while (subDrawer.getStoredItemCount() > 0 && (stack = drawer.takeItemsFromSlot(drawerIndex, subDrawer.getStoredItemStackSize())) != null && stack.field_77994_a != 0) {
            action.accept(stack);
        }
    }

    private static void spawnStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        Random rand = world.field_73012_v;
        while (stack.field_77994_a > 0) {
            int stackSize = Math.min(stack.field_77994_a, stack.func_77976_d());
            stack.field_77994_a -= stackSize;
            ItemStack newStack = new ItemStack(stack.func_77973_b(), stackSize, stack.func_77960_j());
            if (stack.func_77942_o()) {
                newStack.func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)x + rand.nextFloat() * 0.8f + 0.1f), (double)((float)y + rand.nextFloat() * 0.8f + 0.1f), (double)((float)z + rand.nextFloat() * 0.8f + 0.1f), newStack);
            entityItem.field_70159_w = rand.nextGaussian() * (double)0.05f;
            entityItem.field_70181_x = rand.nextGaussian() * (double)0.05f + (double)0.2f;
            entityItem.field_70179_y = rand.nextGaussian() * (double)0.05f;
            world.func_72838_d((Entity)entityItem);
        }
    }

    private static void dropMergedStacks(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            if (!tile.isDrawerEnabled(i)) continue;
            IDrawer drawer = tile.getDrawer(i);
            ItemStack rawStoredItem = drawer.getStoredItemPrototype();
            if (rawStoredItem != null && rawStoredItem.func_77985_e()) {
                BlockDrawers.dropBigStackInWorld(world, x, y, z, drawer.getStoredItemCopy());
                drawer.setStoredItemCount(0);
                continue;
            }
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stack -> BlockDrawers.spawnStackInWorld(world, x, y, z, stack));
        }
    }

    private static void dropBigStackInWorld(World world, int x, int y, int z, ItemStack stack) {
        if (stack == null || stack.field_77994_a <= 0) {
            return;
        }
        Random rand = world.field_73012_v;
        float ex = rand.nextFloat() * 0.8f + 0.1f;
        float ey = rand.nextFloat() * 0.8f + 0.1f;
        float ez = rand.nextFloat() * 0.8f + 0.1f;
        EntityItem entity = new EntityItem(world, (double)((float)x + ex), (double)((float)y + ey), (double)((float)z + ez), stack);
        if (stack.func_77942_o()) {
            entity.func_92059_d().func_77982_d((NBTTagCompound)stack.func_77978_p().func_74737_b());
        }
        world.func_72838_d((Entity)entity);
    }

    private static void dropStacksAndDestroyExcess(TileEntityDrawers tile, World world, int x, int y, int z) {
        int maxDropNum = 4096 / tile.getDrawerCount();
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            if (!tile.isDrawerEnabled(i) || (drawer = tile.getDrawer(i)).getStoredItemCount() <= maxDropNum) continue;
            drawer.setStoredItemCount(maxDropNum);
        }
        BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
    }

    private static void dropStacksMixedBehavior(TileEntityDrawers tile, World world, int x, int y, int z) {
        int stacksToSpawn = BlockDrawers.countAmountOfStacksToSpawn(tile);
        if (stacksToSpawn <= 64) {
            BlockDrawers.dropAllStacksOfDrawer(tile, world, x, y, z);
        } else if (Loader.isModLoaded((String)"Avaritia")) {
            BlockDrawers.dropAvaritiaClusters(tile, world, x, y, z);
        } else {
            BlockDrawers.dropMergedStacks(tile, world, x, y, z);
        }
    }

    private static int countAmountOfStacksToSpawn(TileEntityDrawers tile) {
        int stackCount = 0;
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            IDrawer drawer;
            ItemStack storedItem;
            if (!tile.isDrawerEnabled(i) || (storedItem = (drawer = tile.getDrawer(i)).getStoredItemPrototype()) == null) continue;
            int maxStackSize = storedItem.func_77976_d();
            int storedItemCount = drawer.getStoredItemCount();
            stackCount += storedItemCount / maxStackSize;
            if (storedItemCount % maxStackSize == 0) continue;
            ++stackCount;
        }
        return stackCount;
    }

    @Optional.Method(modid="Avaritia")
    private static void dropAvaritiaClusters(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            ArrayList stacks = new ArrayList();
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stacks::add);
            List clusters = ItemMatterCluster.makeClusters(stacks);
            for (ItemStack stack : clusters) {
                BlockDrawers.spawnStackInWorld(world, x, y, z, stack);
            }
        }
    }

    private static void dropAllStacksOfDrawer(TileEntityDrawers tile, World world, int x, int y, int z) {
        for (int i = 0; i < tile.getDrawerCount(); ++i) {
            BlockDrawers.forEachSplitStackOfSubDrawer(tile, i, stack -> BlockDrawers.spawnStackInWorld(world, x, y, z, stack));
        }
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, false);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ItemStack dropStack = this.getMainDrop(world, x, y, z, metadata);
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(dropStack);
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null || !tile.isSealed()) {
            return drops;
        }
        NBTTagCompound tiledata = new NBTTagCompound();
        tile.func_145841_b(tiledata);
        NBTTagCompound data = dropStack.func_77978_p();
        if (data == null) {
            data = new NBTTagCompound();
        }
        data.func_74782_a("tile", (NBTBase)tiledata);
        dropStack.func_77982_d(data);
        return drops;
    }

    protected ItemStack getMainDrop(World world, int x, int y, int z, int metadata) {
        return new ItemStack(Item.func_150898_a((Block)this), 1, metadata);
    }

    public float getExplosionResistance(Entity par1Entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile != null) {
            for (int slot = 0; slot < 5; ++slot) {
                ItemStack stack = tile.getUpgrade(slot);
                if (stack == null || !(stack.func_77973_b() instanceof ItemUpgrade) || stack.func_77960_j() != 4) continue;
                return 1000.0f;
            }
        }
        return super.getExplosionResistance(par1Entity, world, x, y, z, explosionX, explosionY, explosionZ);
    }

    public TileEntityDrawers createNewTileEntity(World world, int meta) {
        return new TileEntityDrawersStandard();
    }

    public static TileEntityDrawers getTileEntity(IBlockAccess blockAccess, int x, int y, int z) {
        TileEntity tile = blockAccess.func_147438_o(x, y, z);
        return tile instanceof TileEntityDrawers ? (TileEntityDrawers)tile : null;
    }

    public TileEntityDrawers getTileEntitySafe(World world, int x, int y, int z) {
        TileEntityDrawers tile = BlockDrawers.getTileEntity((IBlockAccess)world, x, y, z);
        if (tile == null) {
            tile = this.createNewTileEntity(world, world.func_72805_g(x, y, z));
            world.func_147455_a(x, y, z, (TileEntity)tile);
        }
        return tile;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        TileEntity tile = worldObj.func_147438_o(target.field_72311_b, target.field_72312_c, target.field_72309_d);
        if (tile instanceof TileEntityDrawers && ((TileEntityDrawers)tile).getDirection() == target.field_72310_e) {
            return true;
        }
        return super.addHitEffects(worldObj, target, effectRenderer);
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        list.add(new ItemStack(item, 1, 0));
        if (StorageDrawers.config.cache.creativeTabVanillaWoods) {
            for (int i = 1; i < BlockWood.field_150096_a.length; ++i) {
                list.add(new ItemStack(item, 1, i));
            }
        }
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blockAccess, int x, int y, int z, int dir) {
        if (!this.func_149744_f()) {
            return 0;
        }
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null || !tile.isRedstone()) {
            return 0;
        }
        return tile.getRedstoneLevel();
    }

    public int func_149748_c(IBlockAccess blockAccess, int x, int y, int z, int dir) {
        return dir == 1 ? this.func_149709_b(blockAccess, x, y, z, dir) : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconTrim(int meta) {
        meta = meta < 0 || meta >= this.iconTrim.length ? 0 : meta;
        return this.iconTrim[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        switch (side) {
            case 0: 
            case 1: {
                return this.halfDepth ? this.iconSideH[meta] : this.iconSide[meta];
            }
            case 2: 
            case 3: {
                return this.halfDepth ? this.iconSideV[meta] : this.iconSide[meta];
            }
            case 4: {
                switch (this.drawerCount) {
                    case 1: {
                        return this.iconFront1[meta];
                    }
                    case 2: {
                        return this.iconFront2[meta];
                    }
                    case 4: {
                        return this.iconFront4[meta];
                    }
                }
                return null;
            }
            case 5: {
                return this.iconSide[meta];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return this.getIcon(blockAccess, x, y, z, side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        if (level == 0) {
            return null;
        }
        return this.getIcon(blockAccess, x, y, z, side, level);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getOverlayIconTrim(int level) {
        if (level == 0) {
            return null;
        }
        level = level < 0 || level >= this.iconOverlayTrim.length ? 0 : level;
        return this.iconOverlayTrim[level];
    }

    @SideOnly(value=Side.CLIENT)
    protected IIcon getIcon(IBlockAccess blockAccess, int x, int y, int z, int side, int level) {
        int meta = blockAccess.func_72805_g(x, y, z);
        meta = meta < 0 || meta >= this.iconSide.length ? 0 : meta;
        level = level < 0 || level >= this.iconOverlay.length ? 0 : level;
        TileEntityDrawers tile = BlockDrawers.getTileEntity(blockAccess, x, y, z);
        if (tile == null || side == tile.getDirection()) {
            if (this.drawerCount == 1) {
                return this.iconFront1[meta];
            }
            if (this.drawerCount == 2) {
                return this.iconFront2[meta];
            }
            return this.iconFront4[meta];
        }
        switch (side) {
            case 0: 
            case 1: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayH[level] : this.iconSideH[meta];
                    }
                }
                break;
            }
            case 2: 
            case 3: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                }
                break;
            }
            case 4: 
            case 5: {
                if (!this.halfDepth) break;
                switch (tile.getDirection()) {
                    case 2: 
                    case 3: {
                        return level > 0 ? this.iconOverlayV[level] : this.iconSideV[meta];
                    }
                    case 4: 
                    case 5: {
                        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
                    }
                }
            }
        }
        return level > 0 ? this.iconOverlay[level] : this.iconSide[meta];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIndicatorIcon(int drawerCount, boolean on) {
        int onIndex = on ? 1 : 0;
        switch (drawerCount) {
            case 1: {
                return this.iconIndicator1[onIndex];
            }
            case 2: {
                return this.iconIndicator2[onIndex];
            }
            case 4: {
                return this.iconIndicator4[onIndex];
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getLockIcon(boolean locked, boolean claimed) {
        if (locked && claimed) {
            return this.iconClaimLock;
        }
        if (locked) {
            return this.iconLock;
        }
        if (claimed) {
            return this.iconClaim;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getVoidIcon() {
        return this.iconVoid;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getTapeIcon() {
        return this.iconTaped;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        String[] subtex = BlockWood.field_150096_a;
        this.iconSide = new IIcon[subtex.length];
        this.iconSideH = new IIcon[subtex.length];
        this.iconSideV = new IIcon[subtex.length];
        this.iconFront1 = new IIcon[subtex.length];
        this.iconFront2 = new IIcon[subtex.length];
        this.iconFront4 = new IIcon[subtex.length];
        this.iconTrim = new IIcon[subtex.length];
        for (int i = 0; i < subtex.length; ++i) {
            this.iconFront1[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_1");
            this.iconFront2[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_2");
            this.iconFront4[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_front_4");
            this.iconSide[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side");
            this.iconSideV[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_v");
            this.iconSideH[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_side_h");
            this.iconTrim[i] = register.func_94245_a("StorageDrawers:drawers_" + subtex[i] + "_trim");
        }
        this.iconTaped = register.func_94245_a("StorageDrawers:tape");
        String[] overlays = new String[]{null, null, "iron", "gold", "obsidian", "diamond", "emerald", "ruby", "tanzanite"};
        this.iconOverlay = new IIcon[overlays.length];
        this.iconOverlayH = new IIcon[overlays.length];
        this.iconOverlayV = new IIcon[overlays.length];
        this.iconOverlayTrim = new IIcon[overlays.length];
        for (int i = 2; i < overlays.length; ++i) {
            this.iconOverlay[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i]);
            this.iconOverlayV[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_v");
            this.iconOverlayH[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_h");
            this.iconOverlayTrim[i] = register.func_94245_a("StorageDrawers:overlay_" + overlays[i] + "_trim");
        }
        this.iconIndicator1 = new IIcon[2];
        this.iconIndicator2 = new IIcon[2];
        this.iconIndicator4 = new IIcon[2];
        this.iconIndicator1[0] = register.func_94245_a("StorageDrawers:indicator/indicator_1_off");
        this.iconIndicator1[1] = register.func_94245_a("StorageDrawers:indicator/indicator_1_on");
        this.iconIndicator2[0] = register.func_94245_a("StorageDrawers:indicator/indicator_2_off");
        this.iconIndicator2[1] = register.func_94245_a("StorageDrawers:indicator/indicator_2_on");
        this.iconIndicator4[0] = register.func_94245_a("StorageDrawers:indicator/indicator_4_off");
        this.iconIndicator4[1] = register.func_94245_a("StorageDrawers:indicator/indicator_4_on");
        this.iconLock = register.func_94245_a("StorageDrawers:indicator/lock_icon");
        this.iconClaim = register.func_94245_a("StorageDrawers:indicator/claim_icon");
        this.iconClaimLock = register.func_94245_a("StorageDrawers:indicator/claim_lock_icon");
        this.iconVoid = register.func_94245_a("StorageDrawers:indicator/void_icon");
        this.loadBlockConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    protected void loadBlockConfig() {
        try {
            BufferedReader reader;
            block8: {
                IResource configResource = Minecraft.func_71410_x().func_110442_L().func_110536_a(blockConfig);
                reader = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(configResource.func_110527_b()));
                    JsonObject root = new JsonParser().parse((Reader)reader).getAsJsonObject();
                    JsonObject entry = root.getAsJsonObject(this.getConfigName());
                    if (entry == null) break block8;
                    if (entry.has("trimWidth")) {
                        this.trimWidth = entry.get("trimWidth").getAsFloat();
                    }
                    if (entry.has("trimDepth")) {
                        this.trimDepth = entry.get("trimDepth").getAsFloat();
                    }
                    if (entry.has("indStart")) {
                        this.indStart = entry.get("indStart").getAsFloat();
                    }
                    if (entry.has("indEnd")) {
                        this.indEnd = entry.get("indEnd").getAsFloat();
                    }
                    if (!entry.has("indSteps")) break block8;
                    this.indSteps = entry.get("indSteps").getAsInt();
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((Closeable)reader);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

