/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.world;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public abstract class MapGenCavesMeta
extends MapGenBaseMeta {
    protected void recursiveGenerate(World world, int xChunkCoord, int zChunkCoord, int origXChunkCoord, int origZChunkCoord, Block[] blocks, byte[] metadata) {
        int attemptsLarge = this.rand.nextInt(this.rand.nextInt(this.rand.nextInt(40) + 1) + 1);
        if (this.rand.nextInt(15) != 0) {
            attemptsLarge = 0;
        }
        for (int i = 0; i < attemptsLarge; ++i) {
            double x = xChunkCoord * 16 + this.rand.nextInt(16);
            double y = this.rand.nextInt(this.rand.nextInt(120) + 8);
            double z = zChunkCoord * 16 + this.rand.nextInt(16);
            int attemptsNormal = 1;
            if (this.rand.nextInt(4) == 0) {
                this.generateLargeCaveNode(this.rand.nextLong(), origXChunkCoord, origZChunkCoord, blocks, metadata, x, y, z);
                attemptsNormal += this.rand.nextInt(4);
            }
            for (int j = 0; j < attemptsNormal; ++j) {
                float var14 = this.rand.nextFloat() * ((float)Math.PI * 2);
                float var15 = (this.rand.nextFloat() - 0.5f) * 0.25f;
                float var16 = this.rand.nextFloat() * 2.0f + this.rand.nextFloat();
                if (this.rand.nextInt(10) == 0) {
                    var16 *= this.rand.nextFloat() * this.rand.nextFloat() * 3.0f + 1.0f;
                }
                this.generateCaveNode(this.rand.nextLong(), origXChunkCoord, origZChunkCoord, blocks, metadata, x, y, z, var16, var14, var15, 0, 0, 1.0);
            }
        }
    }

    protected void generateLargeCaveNode(long seed, int origXChunkCoord, int origZChunkCoord, Block[] blocks, byte[] metadata, double x, double y, double z) {
        this.generateCaveNode(seed, origXChunkCoord, origZChunkCoord, blocks, metadata, x, y, z, 1.0f + this.rand.nextFloat() * 6.0f, 0.0f, 0.0f, -1, -1, 0.5);
    }

    protected void generateCaveNode(long seed, int origXChunkCoord, int origZChunkCoord, Block[] blocks, byte[] metadata, double x, double y, double z, float par12, float par13, float par14, int par15, int par16, double par17) {
        boolean flag2;
        double d4 = origXChunkCoord * 16 + 8;
        double d5 = origZChunkCoord * 16 + 8;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Random random = new Random(seed);
        if (par16 <= 0) {
            int j1 = this.range * 16 - 16;
            par16 = j1 - random.nextInt(j1 / 4);
        }
        boolean flag = false;
        if (par15 == -1) {
            par15 = par16 / 2;
            flag = true;
        }
        int k1 = random.nextInt(par16 / 2) + par16 / 4;
        boolean bl = flag2 = random.nextInt(6) == 0;
        while (par15 < par16) {
            double d6 = 1.5 + (double)(MathHelper.func_76126_a((float)((float)par15 * (float)Math.PI / (float)par16)) * par12);
            double d7 = d6 * par17;
            float f5 = MathHelper.func_76134_b((float)par14);
            float f6 = MathHelper.func_76126_a((float)par14);
            x += (double)(MathHelper.func_76134_b((float)par13) * f5);
            y += (double)f6;
            z += (double)(MathHelper.func_76126_a((float)par13) * f5);
            par14 = flag2 ? (par14 *= 0.92f) : (par14 *= 0.7f);
            par14 += f4 * 0.1f;
            par13 += f3 * 0.1f;
            f4 *= 0.9f;
            f3 *= 0.75f;
            f4 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 2.0f;
            f3 += (random.nextFloat() - random.nextFloat()) * random.nextFloat() * 4.0f;
            if (!flag && par15 == k1 && par12 > 1.0f && par16 > 0) {
                this.generateCaveNode(random.nextLong(), origXChunkCoord, origZChunkCoord, blocks, metadata, x, y, z, random.nextFloat() * 0.5f + 0.5f, par13 - 1.5707964f, par14 / 3.0f, par15, par16, 1.0);
                this.generateCaveNode(random.nextLong(), origXChunkCoord, origZChunkCoord, blocks, metadata, x, y, z, random.nextFloat() * 0.5f + 0.5f, par13 + 1.5707964f, par14 / 3.0f, par15, par16, 1.0);
                return;
            }
            if (flag || random.nextInt(4) != 0) {
                double d8 = x - d4;
                double d9 = z - d5;
                double d10 = par16 - par15;
                double d11 = (double)par12 + 18.0;
                if (d8 * d8 + d9 * d9 - d10 * d10 > d11 * d11) {
                    return;
                }
                if (x >= d4 - 16.0 - d6 * 2.0 && z >= d5 - 16.0 - d6 * 2.0 && x <= d4 + 16.0 + d6 * 2.0 && z <= d5 + 16.0 + d6 * 2.0) {
                    int l1 = MathHelper.func_76128_c((double)(x - d6)) - origXChunkCoord * 16 - 1;
                    int i2 = MathHelper.func_76128_c((double)(x + d6)) - origXChunkCoord * 16 + 1;
                    int j2 = MathHelper.func_76128_c((double)(y - d7)) - 1;
                    int k2 = MathHelper.func_76128_c((double)(y + d7)) + 1;
                    int l2 = MathHelper.func_76128_c((double)(z - d6)) - origZChunkCoord * 16 - 1;
                    int i3 = MathHelper.func_76128_c((double)(z + d6)) - origZChunkCoord * 16 + 1;
                    if (l1 < 0) {
                        l1 = 0;
                    }
                    if (i2 > 16) {
                        i2 = 16;
                    }
                    if (j2 < 1) {
                        j2 = 1;
                    }
                    if (k2 > 120) {
                        k2 = 120;
                    }
                    if (l2 < 0) {
                        l2 = 0;
                    }
                    if (i3 > 16) {
                        i3 = 16;
                    }
                    for (int j3 = l1; j3 < i2; ++j3) {
                        for (int l3 = l2; l3 < i3; ++l3) {
                            for (int i4 = k2 + 1; i4 >= j2 - 1; --i4) {
                                if (i4 < 0 || i4 >= 128 || i4 == j2 - 1 || j3 == l1 || j3 == i2 - 1 || l3 == l2 || l3 == i3 - 1) continue;
                                i4 = j2;
                            }
                        }
                    }
                    for (int localY = j2; localY < k2; ++localY) {
                        double yfactor = ((double)localY + 0.5 - y) / d7;
                        double yfactorSq = yfactor * yfactor;
                        for (int localX = l1; localX < i2; ++localX) {
                            double zfactor = ((double)(localX + origXChunkCoord * 16) + 0.5 - x) / d6;
                            double zfactorSq = zfactor * zfactor;
                            for (int localZ = l2; localZ < i3; ++localZ) {
                                double xfactor = ((double)(localZ + origZChunkCoord * 16) + 0.5 - z) / d6;
                                double xfactorSq = xfactor * xfactor;
                                boolean foundTop = false;
                                if (!(xfactorSq + zfactorSq < 1.0)) continue;
                                int coords = (localX * 16 + localZ) * 256 + localY;
                                if (!(yfactor > -0.7) || !(xfactorSq + yfactorSq + zfactorSq < 1.0)) continue;
                                if (this.handleSurface(blocks, metadata, coords, localX, localY, localZ, origXChunkCoord, origZChunkCoord, random)) {
                                    foundTop = true;
                                    continue;
                                }
                                this.handleUnderground(blocks, metadata, coords, localX, localY, localZ, origXChunkCoord, origZChunkCoord, foundTop);
                            }
                        }
                    }
                    if (flag) break;
                }
            }
            ++par15;
        }
    }

    protected abstract boolean handleSurface(Block[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8, Random var9);

    protected abstract void handleUnderground(Block[] var1, byte[] var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);
}

