/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.api.transmission.tile.IConnector;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseUniversalElectricalSource;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityStorageModule
extends TileBaseUniversalElectricalSource
implements ISidedInventory,
IConnector {
    private ItemStack[] containingItems = new ItemStack[2];
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public int scaledEnergyLevel;
    private int lastScaledEnergyLevel;
    private float lastEnergy = 0.0f;

    public TileEntityStorageModule() {
        this.storage.setCapacity(5000000.0f);
        this.storage.setMaxExtract(2200.0f);
    }

    public void func_145845_h() {
        float energy = this.storage.getEnergyStoredGC();
        if (!this.field_145850_b.field_72995_K && this.lastEnergy - energy > this.storage.getMaxExtract() - 1.0f) {
            this.storage.extractEnergyGC(25.0f, false);
        }
        this.lastEnergy = energy;
        super.func_145845_h();
        this.scaledEnergyLevel = (int)Math.floor((this.getEnergyStoredGC() + 49.0f) * 16.0f / this.getMaxEnergyStoredGC());
        if (this.scaledEnergyLevel != this.lastScaledEnergyLevel) {
            this.field_145850_b.func_147479_m(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.recharge(this.containingItems[0]);
            this.discharge(this.containingItems[1]);
        }
        if (!this.field_145850_b.field_72995_K) {
            this.produce();
        }
        this.lastScaledEnergyLevel = this.scaledEnergyLevel;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList items = nbt.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int index = item.func_74771_c("Slot") & 0xFF;
            if (index >= this.containingItems.length) continue;
            this.containingItems[index] = ItemStack.func_77949_a((NBTTagCompound)item);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        if (this.storage.getEnergyStoredGC() > 5000000.0f) {
            this.storage.setEnergyStored(5000000.0f);
        }
        super.func_145841_b(nbt);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.containingItems.length; ++i) {
            if (this.containingItems[i] == null) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            this.containingItems[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        nbt.func_74782_a("Items", (NBTBase)items);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int slotIn) {
        return this.containingItems[slotIn];
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.containingItems[index] == null) {
            return null;
        }
        if (this.containingItems[index].field_77994_a <= count) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        ItemStack stack = this.containingItems[index].func_77979_a(count);
        if (this.containingItems[index].field_77994_a == 0) {
            this.containingItems[index] = null;
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        if (this.containingItems[index] != null) {
            ItemStack stack = this.containingItems[index];
            this.containingItems[index] = null;
            return stack;
        }
        return null;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.containingItems[index] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.StorageModuleT3.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return ItemElectricBase.isElectricItem((Item)stack.func_77973_b());
    }

    public int[] func_94128_d(int slotID) {
        return new int[]{0, 1};
    }

    public boolean func_102007_a(int slotID, ItemStack item, int side) {
        if (item.func_77973_b() instanceof ItemElectricBase) {
            if (slotID == 0) {
                return ((ItemElectricBase)item.func_77973_b()).getTransfer(item) > 0.0f;
            }
            if (slotID == 1) {
                return ((ItemElectricBase)item.func_77973_b()).getElectricityStored(item) > 0.0f;
            }
        }
        return false;
    }

    public boolean func_102008_b(int slotID, ItemStack item, int side) {
        if (item.func_77973_b() instanceof ItemElectricBase) {
            if (slotID == 0) {
                return ((ItemElectricBase)item.func_77973_b()).getTransfer(item) <= 0.0f;
            }
            if (slotID == 1) {
                return ((ItemElectricBase)item.func_77973_b()).getElectricityStored(item) <= 0.0f || this.getEnergyStoredGC() >= this.getMaxEnergyStoredGC();
            }
        }
        return false;
    }

    public EnumSet<ForgeDirection> getElectricalInputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2)).getOpposite(), ForgeDirection.UNKNOWN);
    }

    public EnumSet<ForgeDirection> getElectricalOutputDirections() {
        return EnumSet.of(ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2)), ForgeDirection.UNKNOWN);
    }

    public ForgeDirection getElectricalOutputDirectionMain() {
        return ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2));
    }

    public boolean canConnect(ForgeDirection direction, NetworkType type) {
        if (direction == null || ForgeDirection.UNKNOWN.equals((Object)direction) || type != NetworkType.POWER) {
            return false;
        }
        int metadata = this.func_145832_p() & 3;
        return direction == ForgeDirection.getOrientation((int)(metadata + 2)) || direction == ForgeDirection.getOrientation((int)(metadata + 2 ^ 1));
    }
}

