/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.item;

import cpw.mods.fml.client.FMLClientHandler;
import micdoodle8.mods.galacticraft.api.entity.IRocketType;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import org.lwjgl.Sys;
import org.lwjgl.opengl.GL11;

public class ItemRendererRocket
implements IItemRenderer {
    private static final ResourceLocation chestTexture = new ResourceLocation("textures/entity/chest/normal.png");
    private static final ModelChest chestModel = new ModelChest();
    private final Class<? extends Entity> rocketClass;
    private final ResourceLocation texture;
    private final IModelCustom model;
    private final float offsetEquippedX;
    private final float offsetEquippedY;
    private final float offsetEquipped1stPersonX;
    private final float offsetEquipped1stPersonY;
    private final float scaleInventory;
    private final float scaleEntity;

    public ItemRendererRocket(int tier, Class<? extends Entity> rocketClass, float offsetEquippedX, float offsetEquippedY, float offsetEquipped1stPersonX, float offsetEquipped1stPersonY, float scaleInventory, float scaleEntity) {
        this.rocketClass = rocketClass;
        this.texture = new ResourceLocation("galaxyspace", "textures/model/tier" + tier + "rocket.png");
        this.model = AdvancedModelLoader.loadModel((ResourceLocation)new ResourceLocation("galaxyspace", "models/tier" + tier + "rocket.obj"));
        this.offsetEquippedX = offsetEquippedX;
        this.offsetEquippedY = offsetEquippedY;
        this.offsetEquipped1stPersonX = offsetEquipped1stPersonX;
        this.offsetEquipped1stPersonY = offsetEquipped1stPersonY;
        this.scaleInventory = scaleInventory;
        this.scaleEntity = scaleEntity;
    }

    protected void renderRocket(IItemRenderer.ItemRenderType type, RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        GL11.glPushMatrix();
        this.transform(item, type);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(this.texture);
        this.model.renderAll();
        GL11.glPopMatrix();
    }

    protected void renderRocketInventory(IItemRenderer.ItemRenderType type, RenderBlocks render, ItemStack item, float translateX, float translateY, float translateZ) {
        this.renderRocket(type, render, item, translateX, translateY, translateZ);
        int index = MathHelper.func_76125_a((int)item.func_77960_j(), (int)0, (int)(IRocketType.EnumRocketType.values().length - 1));
        if (IRocketType.EnumRocketType.values()[index].getInventorySpace() <= 3) {
            return;
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(chestTexture);
        GL11.glPushMatrix();
        GL11.glDisable((int)2929);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glScalef((float)0.5f, (float)-0.5f, (float)-0.5f);
        GL11.glTranslatef((float)1.5f, (float)1.95f, (float)1.7f);
        GL11.glRotatef((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-1.5f, (float)-1.5f, (float)-1.5f);
        ItemRendererRocket.chestModel.field_78234_a.field_78795_f = 0.0f;
        ItemRendererRocket.chestModel.field_78232_b.func_78785_a(0.0625f);
        ItemRendererRocket.chestModel.field_78234_a.func_78785_a(0.0625f);
        ItemRendererRocket.chestModel.field_78233_c.func_78785_a(0.0625f);
        GL11.glEnable((int)2929);
        GL11.glPopMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void transform(ItemStack itemstack, IItemRenderer.ItemRenderType type) {
        EntityClientPlayerMP player = FMLClientHandler.instance().getClient().field_71439_g;
        if (type == IItemRenderer.ItemRenderType.EQUIPPED) {
            GL11.glRotatef((float)70.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-10.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)50.0f, (float)0.0f, (float)1.0f, (float)1.0f);
            GL11.glTranslatef((float)this.offsetEquippedX, (float)this.offsetEquippedY, (float)0.0f);
            if (player != null && player.field_70154_o != null && this.rocketClass.isAssignableFrom(player.field_70154_o.getClass())) {
                GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glScalef((float)5.2f, (float)5.2f, (float)5.2f);
            }
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            GL11.glTranslatef((float)this.offsetEquipped1stPersonX, (float)this.offsetEquipped1stPersonY, (float)1.0f);
            GL11.glRotatef((float)28.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glRotatef((float)230.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)73.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            if (player != null && player.field_70154_o != null && this.rocketClass.isAssignableFrom(player.field_70154_o.getClass())) {
                GL11.glScalef((float)0.0f, (float)0.0f, (float)0.0f);
            } else {
                GL11.glScalef((float)5.2f, (float)5.2f, (float)5.2f);
            }
        }
        GL11.glTranslatef((float)0.0f, (float)0.1f, (float)0.0f);
        GL11.glScalef((float)-0.4f, (float)-0.4f, (float)0.4f);
        if (type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.ENTITY) {
            if (type == IItemRenderer.ItemRenderType.INVENTORY) {
                GL11.glRotatef((float)85.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glScalef((float)this.scaleInventory, (float)this.scaleInventory, (float)this.scaleInventory);
                GL11.glTranslatef((float)0.8f, (float)5.4f, (float)-0.4f);
            } else {
                GL11.glTranslatef((float)0.0f, (float)-0.9f, (float)0.0f);
                GL11.glScalef((float)this.scaleEntity, (float)this.scaleEntity, (float)this.scaleEntity);
            }
            GL11.glScalef((float)1.3f, (float)1.3f, (float)1.3f);
            GL11.glTranslatef((float)0.0f, (float)-0.6f, (float)0.0f);
            GL11.glRotatef((float)((float)Sys.getTime() / 30.0f % 360.0f + 45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        boolean bl;
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: 
            case INVENTORY: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        switch (type) {
            case ENTITY: 
            case EQUIPPED: 
            case EQUIPPED_FIRST_PERSON: {
                this.renderRocket(type, (RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
            case INVENTORY: {
                this.renderRocketInventory(type, (RenderBlocks)data[0], item, -0.5f, -0.5f, -0.5f);
                break;
            }
        }
    }
}

