/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.render.entity.mob;

import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.model.entity.ModelEvolvedEnderman;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class RenderEvolvedEnderman
extends RenderLiving {
    private static final ResourceLocation TEXTURE_EYES = new ResourceLocation("galaxyspace", "textures/model/enderman_gs_eyes.png");
    private static final ResourceLocation TEXTURE_BODY = new ResourceLocation("galaxyspace", "textures/model/enderman_gs.png");
    private ModelEvolvedEnderman endermanModel;
    private Random rnd = new Random();

    public RenderEvolvedEnderman() {
        super((ModelBase)new ModelEvolvedEnderman(), 0.5f);
        this.endermanModel = (ModelEvolvedEnderman)this.field_77045_g;
        this.func_77042_a((ModelBase)this.endermanModel);
    }

    public void doRender(EntityEvolvedEnderman entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.endermanModel.isCarrying = entity.getCarried().func_149688_o() != Material.field_151579_a;
        this.endermanModel.isAttacking = entity.isScreaming();
        if (entity.isScreaming()) {
            x += this.rnd.nextGaussian() * 0.02;
            z += this.rnd.nextGaussian() * 0.02;
        }
        super.func_76986_a((EntityLiving)entity, x, y, z, yaw, partialTickTime);
    }

    protected int shouldRenderPass(EntityEvolvedEnderman entity, int pass, float partialTickTime) {
        if (pass != 0) {
            return -1;
        }
        this.func_110776_a(TEXTURE_EYES);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        GL11.glBlendFunc((int)1, (int)1);
        GL11.glDisable((int)2896);
        if (entity.func_82150_aj()) {
            GL11.glDepthMask((boolean)false);
        } else {
            GL11.glDepthMask((boolean)true);
        }
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        return 1;
    }

    public void func_76986_a(EntityLiving entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.doRender((EntityEvolvedEnderman)entity, x, y, z, yaw, partialTickTime);
    }

    protected int func_77032_a(EntityLivingBase entity, int pass, float partialTickTime) {
        return this.shouldRenderPass((EntityEvolvedEnderman)entity, pass, partialTickTime);
    }

    protected void func_77029_c(EntityLivingBase entity, float partialTickTime) {
        super.func_77029_c(entity, partialTickTime);
        if (((EntityEvolvedEnderman)entity).getCarried().func_149688_o() != Material.field_151579_a) {
            GL11.glEnable((int)32826);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.0f, (float)0.6875f, (float)-0.75f);
            GL11.glRotatef((float)20.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)-0.5f, (float)-0.5f, (float)0.5f);
            int brightness = entity.func_70070_b(partialTickTime);
            int x = brightness % 65536;
            int y = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)x, (float)y);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_110776_a(TextureMap.field_110575_b);
            this.field_147909_c.func_147800_a(((EntityEvolvedEnderman)entity).getCarried(), ((EntityEvolvedEnderman)entity).getCarryingData(), 1.0f);
            GL11.glPopMatrix();
            GL11.glDisable((int)32826);
        }
    }

    public void func_76986_a(EntityLivingBase entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.doRender((EntityEvolvedEnderman)entity, x, y, z, yaw, partialTickTime);
    }

    protected ResourceLocation func_110775_a(Entity entity) {
        return TEXTURE_BODY;
    }

    public void func_76986_a(Entity entity, double x, double y, double z, float yaw, float partialTickTime) {
        this.doRender((EntityEvolvedEnderman)entity, x, y, z, yaw, partialTickTime);
    }
}

