/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.titan.dimension;

import galaxyspace.SolarSystem.moons.titan.world.BiomeGenTitan;
import galaxyspace.core.dimension.ChunkProviderSpaceLakes;
import galaxyspace.core.entity.mob.EntityEvolvedEnderman;
import galaxyspace.core.register.GSBlocks;
import galaxyspace.core.register.GSFluids;
import galaxyspace.core.world.BiomeDecoratorSpaceGS;
import galaxyspace.core.world.MapGenCavesMeta3;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import micdoodle8.mods.galacticraft.api.prefab.core.BlockMetaPair;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.BiomeDecoratorSpace;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.MapGenBaseMeta;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedCreeper;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSkeleton;
import micdoodle8.mods.galacticraft.core.entities.EntityEvolvedSpider;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class ChunkProviderTitan
extends ChunkProviderSpaceLakes {
    private List<MapGenBaseMeta> worldGenerators;
    private final MapGenBaseMeta caveGenerator;

    @Override
    protected List<MapGenBaseMeta> getWorldGenerators() {
        return Collections.singletonList(this.caveGenerator);
    }

    public ChunkProviderTitan(World world, long seed, boolean mapFeaturesEnabled) {
        super(world, seed, mapFeaturesEnabled);
        this.field_73231_z = this.getBiomesForGeneration();
        this.caveGenerator = new MapGenCavesMeta3(GSBlocks.TitanBlocks);
    }

    @Override
    protected BiomeDecoratorSpace getBiomeGenerator() {
        return new BiomeDecoratorSpaceGS();
    }

    @Override
    protected BiomeGenBase[] getBiomesForGeneration() {
        return new BiomeGenBase[]{BiomeGenTitan.INSTANCE};
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public double getHeightModifier() {
        return 15.0;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getMonsters() {
        BiomeGenBase.SpawnListEntry skele = new BiomeGenBase.SpawnListEntry(EntityEvolvedSkeleton.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry creeper = new BiomeGenBase.SpawnListEntry(EntityEvolvedCreeper.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry spider = new BiomeGenBase.SpawnListEntry(EntityEvolvedSpider.class, 100, 4, 4);
        BiomeGenBase.SpawnListEntry enderman = new BiomeGenBase.SpawnListEntry(EntityEvolvedEnderman.class, 100, 4, 4);
        return new BiomeGenBase.SpawnListEntry[]{skele, creeper, spider, enderman};
    }

    @Override
    public void onChunkProvider(int cX, int cZ, Block[] blocks, byte[] metadata) {
        Arrays.fill(blocks, Blocks.field_150350_a);
        this.generateTerrain(cX, cZ, blocks, metadata);
        this.field_73231_z = this.field_73230_p.func_72959_q().func_76933_b(this.field_73231_z, cX * 16, cZ * 16, 16, 16);
        this.func_147422_a(cX, cZ, blocks, metadata, this.field_73231_z);
        if (this.worldGenerators == null) {
            this.worldGenerators = this.getWorldGenerators();
        }
        for (MapGenBaseMeta generator : this.worldGenerators) {
            generator.generate((IChunkProvider)this, this.field_73230_p, cX, cZ, blocks, metadata);
        }
    }

    @Override
    public void onPopulate(IChunkProvider chunkProvider, int chunkX, int chunkZ) {
    }

    public boolean func_73149_a(int x, int y) {
        return false;
    }

    @Override
    protected BiomeGenBase.SpawnListEntry[] getWaterCreatures() {
        return new BiomeGenBase.SpawnListEntry[0];
    }

    @Override
    public boolean canGenerateWaterBlock() {
        return true;
    }

    @Override
    protected BlockMetaPair getWaterBlock() {
        return new BlockMetaPair(GSFluids.BlockLiquidMethane, 0);
    }

    @Override
    public int getWaterLevel() {
        return 63;
    }

    @Override
    protected BlockMetaPair getGrassBlock() {
        return new BlockMetaPair(Blocks.field_150357_h, 0);
    }

    @Override
    protected BlockMetaPair getDirtBlock() {
        return new BlockMetaPair(Blocks.field_150357_h, 0);
    }

    @Override
    protected BlockMetaPair getStoneBlock() {
        return new BlockMetaPair(GSBlocks.TitanBlocks, 0);
    }

    @Override
    protected boolean enableBiomeGenBaseBlock() {
        return true;
    }

    @Override
    public boolean canGenerateIceBlock() {
        return true;
    }

    @Override
    public String func_73148_d() {
        return "TitanLevelSource";
    }
}

