/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.IBox;
import buildcraft.api.core.IPathProvider;
import buildcraft.api.core.IZone;
import buildcraft.api.items.IMapLocation;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.Box;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.StringUtils;
import buildcraft.robotics.ZonePlan;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemMapLocation
extends ItemBuildCraft
implements IMapLocation {
    public ItemMapLocation() {
        super(BCCreativeTab.get("main"));
    }

    public int getItemStackLimit(ItemStack stack) {
        return NBTUtils.getItemData(stack).func_74764_b("kind") ? 1 : 16;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        String name;
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (cpt.func_74764_b("name") && (name = cpt.func_74779_i("name")).length() > 0) {
            list.add(name);
        }
        if (cpt.func_74764_b("kind")) {
            switch (cpt.func_74771_c("kind")) {
                case 0: {
                    int x = cpt.func_74762_e("x");
                    int y = cpt.func_74762_e("y");
                    int z = cpt.func_74762_e("z");
                    ForgeDirection side = ForgeDirection.values()[cpt.func_74771_c("side")];
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + ", " + side + "}"));
                    break;
                }
                case 1: {
                    int x = cpt.func_74762_e("xMin");
                    int y = cpt.func_74762_e("yMin");
                    int z = cpt.func_74762_e("zMin");
                    int xLength = cpt.func_74762_e("xMax") - x + 1;
                    int yLength = cpt.func_74762_e("yMax") - y + 1;
                    int zLength = cpt.func_74762_e("zMax") - z + 1;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + {" + xLength + " x " + yLength + " x " + zLength + "}"));
                    break;
                }
                case 2: {
                    NBTTagList pathNBT = cpt.func_150295_c("path", 10);
                    BlockIndex first = new BlockIndex(pathNBT.func_150305_b(0));
                    int x = first.x;
                    int y = first.y;
                    int z = first.z;
                    list.add(StringUtils.localize("{" + x + ", " + y + ", " + z + "} + " + pathNBT.func_74745_c() + " elements"));
                    break;
                }
            }
        }
    }

    public IIcon func_77650_f(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (!cpt.func_74764_b("kind")) {
            return this.icons[0];
        }
        return this.func_77617_a(cpt.func_74771_c("kind") + 1);
    }

    @Override
    public String[] getIconNames() {
        return new String[]{"mapLocation/clean", "mapLocation/spot", "mapLocation/area", "mapLocation/path", "mapLocation/zone"};
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        super.func_94581_a(par1IconRegister);
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer par2EntityPlayer, World world, int x, int y, int z, int side, float par8, float par9, float par10) {
        TileEntity tile = world.func_147438_o(x, y, z);
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        if (tile instanceof IPathProvider) {
            cpt.func_74774_a("kind", (byte)2);
            NBTTagList pathNBT = new NBTTagList();
            for (BlockIndex index : ((IPathProvider)tile).getPath()) {
                NBTTagCompound nbt = new NBTTagCompound();
                index.writeTo(nbt);
                pathNBT.func_74742_a((NBTBase)nbt);
            }
            cpt.func_74782_a("path", (NBTBase)pathNBT);
        } else if (tile instanceof IAreaProvider) {
            cpt.func_74774_a("kind", (byte)1);
            IAreaProvider areaTile = (IAreaProvider)tile;
            cpt.func_74768_a("xMin", areaTile.xMin());
            cpt.func_74768_a("yMin", areaTile.yMin());
            cpt.func_74768_a("zMin", areaTile.zMin());
            cpt.func_74768_a("xMax", areaTile.xMax());
            cpt.func_74768_a("yMax", areaTile.yMax());
            cpt.func_74768_a("zMax", areaTile.zMax());
        } else {
            cpt.func_74774_a("kind", (byte)0);
            cpt.func_74774_a("side", (byte)side);
            cpt.func_74768_a("x", x);
            cpt.func_74768_a("y", y);
            cpt.func_74768_a("z", z);
        }
        return true;
    }

    @Override
    public IBox getBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 1) {
            int xMin = cpt.func_74762_e("xMin");
            int yMin = cpt.func_74762_e("yMin");
            int zMin = cpt.func_74762_e("zMin");
            int xMax = cpt.func_74762_e("xMax");
            int yMax = cpt.func_74762_e("yMax");
            int zMax = cpt.func_74762_e("zMax");
            return new Box(xMin, yMin, zMin, xMax, yMax, zMax);
        }
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    public static IBox getPointBox(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            int x = cpt.func_74762_e("x");
            int y = cpt.func_74762_e("y");
            int z = cpt.func_74762_e("z");
            return new Box(x, y, z, x, y, z);
        }
        return null;
    }

    @Override
    public ForgeDirection getPointSide(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            return ForgeDirection.values()[cpt.func_74771_c("side")];
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public BlockIndex getPoint(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            return new BlockIndex(cpt.func_74762_e("x"), cpt.func_74762_e("y"), cpt.func_74762_e("z"));
        }
        return null;
    }

    @Override
    public IZone getZone(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 3) {
            ZonePlan plan = new ZonePlan();
            plan.readFromNBT(cpt);
            return plan;
        }
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 1) {
            return this.getBox(item);
        }
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            return ItemMapLocation.getPointBox(item);
        }
        return null;
    }

    @Override
    public List<BlockIndex> getPath(ItemStack item) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 2) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            NBTTagList pathNBT = cpt.func_150295_c("path", 10);
            for (int i = 0; i < pathNBT.func_74745_c(); ++i) {
                indexList.add(new BlockIndex(pathNBT.func_150305_b(i)));
            }
            return indexList;
        }
        if (cpt.func_74764_b("kind") && cpt.func_74771_c("kind") == 0) {
            ArrayList<BlockIndex> indexList = new ArrayList<BlockIndex>();
            indexList.add(new BlockIndex(cpt.func_74762_e("x"), cpt.func_74762_e("y"), cpt.func_74762_e("z")));
            return indexList;
        }
        return null;
    }

    public static void setZone(ItemStack item, ZonePlan plan) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.func_74774_a("kind", (byte)3);
        plan.writeToNBT(cpt);
    }

    @Override
    public String getName(ItemStack item) {
        return NBTUtils.getItemData(item).func_74779_i("name");
    }

    @Override
    public boolean setName(ItemStack item, String name) {
        NBTTagCompound cpt = NBTUtils.getItemData(item);
        cpt.func_74778_a("name", name);
        return true;
    }

    @Override
    public IMapLocation.MapLocationType getType(ItemStack stack) {
        NBTTagCompound cpt = NBTUtils.getItemData(stack);
        return IMapLocation.MapLocationType.values()[cpt.func_74771_c("kind")];
    }
}

