/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.worldgen.WorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenSwampGum
extends WorldGenTree {
    public WorldGenSwampGum(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        float leafSpawn = this.height + 2;
        float weakerBottm = this.randBetween(0.5f, 0.6f) * (float)this.height;
        float bottom = this.randBetween(0.4f, 0.5f) * (float)this.height;
        float width = (float)this.height * this.randBetween(0.15f, 0.2f);
        if (width > 7.0f) {
            width = 7.0f;
        }
        float f = leafSpawn;
        leafSpawn = f - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f, 0.0f), 0.4f * width, 1, this.leaf, false);
        float f2 = leafSpawn;
        leafSpawn = f2 - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f2, 0.0f), 0.7f * width, 1, this.leaf, false);
        this.bushiness = 0.3f;
        while (leafSpawn > weakerBottm) {
            float f3 = leafSpawn;
            leafSpawn = f3 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f3, 0.0f), this.randBetween(0.9f, 1.0f) * width, 1, this.leaf, false);
        }
        this.bushiness = 0.6f;
        while (leafSpawn > bottom) {
            float f4 = leafSpawn;
            leafSpawn = f4 - 1.0f;
            this.generateCylinder(new WorldGenTree.Vector(0.0f, f4, 0.0f), this.randBetween(0.8f, 0.9f) * width, 1, this.leaf, false);
        }
        float f5 = leafSpawn;
        leafSpawn = f5 - 1.0f;
        this.generateCylinder(new WorldGenTree.Vector(0.0f, f5, 0.0f), 0.5f * width, 1, this.leaf, false);
        for (int i = 0; i < 5; ++i) {
            float f6 = leafSpawn;
            leafSpawn = f6 - 1.0f;
            this.generateSphere(new WorldGenTree.Vector(this.randBetween(-1, 1), f6, this.randBetween(-1, 1)), this.randBetween(1, 2), this.leaf, false);
        }
    }

    @Override
    public void preGenerate() {
        this.height = this.determineHeight(14, 3);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }
}

