/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenerator;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.plugins.PluginArboriculture;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class DefaultTreeGenerator
implements ITreeGenerator {
    private final ExtraTreeSpecies extraTreeSpecies;

    public DefaultTreeGenerator(ExtraTreeSpecies extraTreeSpecies) {
        this.extraTreeSpecies = extraTreeSpecies;
    }

    public void setLogBlock(ITreeGenome genome, World world, int x, int y, int z, ForgeDirection direction) {
        if (this.extraTreeSpecies.wood != null) {
            this.extraTreeSpecies.wood.placeBlock(world, x, y, z);
        }
    }

    public void setLeaves(ITreeGenome genome, World world, GameProfile owner, int x, int y, int z, boolean decorative) {
        boolean placed = world.func_147465_d(x, y, z, (Block)PluginArboriculture.blocks.leaves, 0, 3);
        if (!placed) {
            return;
        }
        Block block = world.func_147439_a(x, y, z);
        if (PluginArboriculture.blocks.leaves != block) {
            world.func_147468_f(x, y, z);
            return;
        }
        TileLeaves tileLeaves = BlockForestryLeaves.getLeafTile((IBlockAccess)world, (int)x, (int)y, (int)z);
        if (tileLeaves == null) {
            world.func_147468_f(x, y, z);
            return;
        }
        tileLeaves.setOwner(owner);
        if (decorative) {
            tileLeaves.setDecorative();
        }
        tileLeaves.setTree((ITree)new Tree(genome));
        world.func_147471_g(x, y, z);
    }

    public void setLogBlock(World world, int x, int y, int z, ForgeDirection direction) {
        this.extraTreeSpecies.wood.placeBlock(world, x, y, z);
    }

    public void setLeaves(World world, GameProfile player, int x, int y, int z, boolean arg5) {
    }

    public WorldGenerator getWorldGenerator(ITreeGenData tree) {
        return this.extraTreeSpecies.getGenerator(tree);
    }
}

