/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.craftgui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.craftgui.minecraft.CustomSlot;
import binnie.core.craftgui.minecraft.IWindowAffectsShiftClick;
import binnie.core.craftgui.minecraft.InventoryType;
import binnie.core.craftgui.minecraft.ListMap;
import binnie.core.craftgui.minecraft.Window;
import binnie.core.craftgui.minecraft.WindowInventory;
import binnie.core.craftgui.minecraft.control.ControlSlot;
import binnie.core.craftgui.minecraft.control.EnumHighlighting;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.machines.power.TankInfo;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.network.packet.MessageContainerUpdate;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ContainerCraftGUI
extends Container {
    public static final String ACTION_TYPE = "type";
    public static final String ACTION_BATCH = "batch";
    public static final String SLOT_REG = "slot-reg";
    public static final String TANK_CLICK = "tank-click";
    public static final String TANK_UPDATE = "tank-update-";
    public static final String POWER_UPDATE = "power-update";
    public static final String PROCESS_UPDATE = "process-update";
    public static final String ERROR_UPDATE = "error-update";
    public static final String MOUSE_OVER_SLOT = "mouse-over-slot";
    public static final String SHIFT_CLICK_INFO = "shift-click-info";
    public static final String ERROR_TYPE = "type";
    public static final byte CANNOT_WORK = 0;
    public static final byte CANNOT_PROGRESS = 1;
    public static final String SLOT_TYPE = "t";
    public static final String SLOT_INDEX = "i";
    public static final String SLOT_NUMBER = "n";
    public static final String ACTIONS = "actions";
    private static final String USERNAME = "username";
    private static final String SLOT_ID = "id";
    private static final String SLOT = "slot";
    private static final String SLOTS = "slots";
    private static final String TANK = "tank";
    private static final String ORIGIN = "origin";
    private static final String NAME = "name";
    private final Window window;
    private final Map<String, NBTTagCompound> syncedNBT = new HashMap<String, NBTTagCompound>();
    private final Map<String, NBTTagCompound> sentNBT = new HashMap<String, NBTTagCompound>();
    private final Map<Integer, TankInfo> syncedTanks = new HashMap<Integer, TankInfo>();
    private PowerInfo syncedPower = new PowerInfo();
    private ProcessInfo syncedProcess = new ProcessInfo();
    private int errorType = 0;
    private ErrorState error = null;
    private int mousedOverSlotNumber = -1;

    public ContainerCraftGUI(Window window) {
        this.window = window;
        if (!window.isServer()) {
            return;
        }
        this.field_75153_a = new ListMap();
        this.field_75151_b = new ListMap();
        IInventory entityInventory = window.getInventory();
        IMachine machine = Machine.getMachine(entityInventory);
        if (machine == null) {
            return;
        }
        GameProfile user = machine.getOwner();
        if (user == null) {
            return;
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a(USERNAME, user.getName());
        this.sendNBTToClient(USERNAME, nbt);
    }

    protected Slot func_75146_a(Slot slot) {
        return super.func_75146_a(slot);
    }

    private Side getSide() {
        return this.window.isServer() ? Side.SERVER : Side.CLIENT;
    }

    public Slot func_75139_a(int index) {
        return index < 0 || index >= this.field_75151_b.size() ? null : (Slot)this.field_75151_b.get(index);
    }

    public void func_75141_a(int index, ItemStack stack) {
        Slot slot = this.func_75139_a(index);
        if (slot != null) {
            slot.func_75215_d(stack);
        }
    }

    public void func_75131_a(ItemStack[] par1ArrayOfItemStack) {
        for (int i = 0; i < par1ArrayOfItemStack.length; ++i) {
            Slot slot = this.func_75139_a(i);
            if (slot == null) continue;
            slot.func_75215_d(par1ArrayOfItemStack[i]);
        }
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        WindowInventory windowInventory = this.window.getWindowInventory();
        InventoryPlayer playerInventory = player.field_71071_by;
        for (int i = 0; i < windowInventory.func_70302_i_(); ++i) {
            ItemStack newStack;
            ItemStack stack;
            if (!windowInventory.dispenseOnClose(i) || (stack = windowInventory.func_70301_a(i)) == null || (newStack = new TransferRequest(stack, (IInventory)playerInventory).transfer(true)) == null) continue;
            player.func_71019_a(newStack, false);
        }
    }

    public ItemStack func_75144_a(int slotNum, int mouseButton, int modifier, EntityPlayer player) {
        CustomSlot customSlot;
        Slot slot = this.func_75139_a(slotNum);
        if (slot instanceof CustomSlot && (customSlot = (CustomSlot)slot).handleClick()) {
            customSlot.onSlotClick(this, mouseButton, modifier, player);
            return player.field_71071_by.func_70445_o();
        }
        return super.func_75144_a(slotNum, mouseButton, modifier, player);
    }

    public void sendNBTToClient(String key, NBTTagCompound nbt) {
        this.syncedNBT.put(key, nbt);
    }

    public boolean func_75145_c(EntityPlayer player) {
        IInventory entityInventory;
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            if (!this.field_75149_d.contains(playerMP)) {
                this.field_75149_d.add(playerMP);
            }
            this.sentNBT.clear();
        }
        return (entityInventory = this.window.getInventory()) == null || entityInventory.func_70300_a(player);
    }

    public ItemStack func_82846_b(EntityPlayer player, int slotID) {
        this.shiftClick(player, slotID);
        return null;
    }

    private void shiftClick(EntityPlayer player, int index) {
        TransferRequest request = this.getShiftClickRequest(player, index);
        if (request == null) {
            return;
        }
        ItemStack stack = request.transfer(true);
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(index);
        shiftClickedSlot.func_75215_d(stack);
        shiftClickedSlot.func_75218_e();
    }

    private TransferRequest getShiftClickRequest(EntityPlayer player, int index) {
        if (index < 0) {
            return null;
        }
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(index);
        ItemStack itemstack = null;
        if (shiftClickedSlot.func_75216_d()) {
            itemstack = shiftClickedSlot.func_75211_c().func_77946_l();
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        IInventory entityInventory = this.window.getInventory();
        WindowInventory windowInventory = this.window.getWindowInventory();
        WindowInventory fromPlayer = entityInventory == null ? windowInventory : entityInventory;
        int[] target = new int[36];
        for (int i = 0; i < target.length; ++i) {
            target[i] = i;
        }
        TransferRequest request = shiftClickedSlot.field_75224_c == playerInventory ? new TransferRequest(itemstack, fromPlayer).setOrigin(shiftClickedSlot.field_75224_c) : new TransferRequest(itemstack, (IInventory)playerInventory).setOrigin(shiftClickedSlot.field_75224_c).setTargetSlots(target);
        Window window = this.window;
        if (window instanceof IWindowAffectsShiftClick) {
            IWindowAffectsShiftClick iWindowAffectsShiftClick = (IWindowAffectsShiftClick)((Object)window);
            iWindowAffectsShiftClick.alterRequest(request);
        }
        return request;
    }

    public ItemStack tankClick(EntityPlayer player, int slotID) {
        if (player.field_71071_by.func_70445_o() == null) {
            return null;
        }
        ItemStack heldItem = player.field_71071_by.func_70445_o().func_77946_l();
        IInventory entityInventory = this.window.getInventory();
        heldItem = new TransferRequest(heldItem, entityInventory).setOrigin((IInventory)player.field_71071_by).setTargetSlots(new int[0]).setTargetTanks(new int[]{slotID}).transfer(true);
        player.field_71071_by.func_70437_b(heldItem);
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP entityPlayerMP = (EntityPlayerMP)player;
            entityPlayerMP.func_71113_k();
        }
        return heldItem;
    }

    public void handleNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        String actionType = action.func_74779_i("type");
        if (actionType.equals(ACTION_BATCH)) {
            NBTTagList actionsBatch = action.func_150295_c(ACTIONS, 10);
            for (int i = 0; i < actionsBatch.func_74745_c(); ++i) {
                this.handleNBT(side, player, actionsBatch.func_150305_b(i));
            }
        }
        if (side == Side.SERVER) {
            switch (actionType) {
                case "tank-click": {
                    this.tankClick(player, action.func_74771_c(SLOT_ID));
                    break;
                }
                case "slot-reg": {
                    byte slotType = action.func_74771_c(SLOT_TYPE);
                    short slotIndex = action.func_74765_d(SLOT_INDEX);
                    short slotNumber = action.func_74765_d(SLOT_NUMBER);
                    this.createSlot(InventoryType.values()[slotType % 4], slotIndex, slotNumber);
                    for (ICrafting crafterObject : this.field_75149_d) {
                        crafterObject.func_71110_a((Container)this, this.func_75138_a());
                    }
                    break;
                }
            }
        }
        switch (actionType) {
            case "power-update": {
                this.onPowerUpdate(action);
                break;
            }
            case "process-update": {
                this.onProcessUpdate(action);
                break;
            }
            case "error-update": {
                this.onErrorUpdate(action);
                break;
            }
            case "mouse-over-slot": {
                this.onMouseOverSlot(player, action);
                break;
            }
            case "shift-click-info": {
                this.onReceiveShiftClickHighlights(action);
                break;
            }
            default: {
                if (!actionType.contains(TANK_UPDATE)) break;
                this.onTankUpdate(action);
            }
        }
    }

    public void func_75142_b() {
        INetwork.SendGuiNBT machineSync;
        super.func_75142_b();
        IInventory entityInventory = this.window.getInventory();
        ITankMachine tanks = Machine.getInterface(ITankMachine.class, entityInventory);
        IPoweredMachine powered = Machine.getInterface(IPoweredMachine.class, entityInventory);
        IErrorStateSource error = Machine.getInterface(IErrorStateSource.class, entityInventory);
        IProcess process = Machine.getInterface(IProcess.class, entityInventory);
        if (this.window.isServer() && tanks != null) {
            TankInfo[] tankInfos = tanks.getTankInfos();
            for (int i = 0; i < tankInfos.length; ++i) {
                TankInfo tank = tankInfos[i];
                if (this.getTankInfo(i).equals(tank)) continue;
                this.syncedNBT.put(TANK_UPDATE + i, this.createTankNBT(i, tank));
                this.syncedTanks.put(i, tank);
            }
        }
        if (this.window.isServer()) {
            if (powered != null) {
                this.syncedNBT.put(POWER_UPDATE, this.createPowerNBT(powered.getPowerInfo()));
            }
            if (process != null) {
                this.syncedNBT.put(PROCESS_UPDATE, this.createProcessNBT(process.getInfo()));
            }
            if (error != null) {
                this.syncedNBT.put(ERROR_UPDATE, this.createErrorNBT(error));
            }
        }
        if ((machineSync = Machine.getInterface(INetwork.SendGuiNBT.class, entityInventory)) != null) {
            machineSync.sendGuiNBT(this.syncedNBT);
        }
        HashMap<String, NBTTagCompound> sentThisTime = new HashMap<String, NBTTagCompound>();
        NBTTagList actions = new NBTTagList();
        for (Map.Entry<String, NBTTagCompound> entry : this.syncedNBT.entrySet()) {
            String actionType = entry.getKey();
            NBTTagCompound action = entry.getValue();
            NBTTagCompound actionPrev = this.sentNBT.get(actionType);
            action.func_74778_a("type", actionType);
            if (action.equals((Object)actionPrev)) continue;
            actions.func_74742_a((NBTBase)action);
            sentThisTime.put(actionType, action);
        }
        NBTTagCompound actionsBatch = new NBTTagCompound();
        actionsBatch.func_74778_a("type", ACTION_BATCH);
        actionsBatch.func_74782_a(ACTIONS, (NBTBase)actions);
        for (ICrafting crafter : this.field_75149_d) {
            if (!(crafter instanceof EntityPlayerMP)) continue;
            EntityPlayerMP playerMP = (EntityPlayerMP)crafter;
            MessageContainerUpdate packet = new MessageContainerUpdate(actionsBatch);
            BinnieCore.proxy.sendToPlayer(packet, (EntityPlayer)playerMP);
        }
        this.sentNBT.putAll(sentThisTime);
        this.syncedNBT.clear();
    }

    private NBTTagCompound createErrorNBT(IErrorStateSource error) {
        NBTTagCompound nbt = new NBTTagCompound();
        ErrorState state = null;
        if (error.canWork() != null) {
            nbt.func_74774_a("type", (byte)0);
            state = error.canWork();
        } else if (error.canProgress() != null) {
            nbt.func_74774_a("type", (byte)1);
            state = error.canProgress();
        }
        if (state != null) {
            state.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound createPowerNBT(PowerInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createProcessNBT(ProcessInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createTankNBT(int tank, TankInfo tankInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        tankInfo.writeToNBT(nbt);
        nbt.func_74774_a(TANK, (byte)tank);
        return nbt;
    }

    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c(TANK);
        TankInfo tank = new TankInfo();
        tank.readFromNBT(nbt);
        this.syncedTanks.put(Integer.valueOf(tankID), tank);
    }

    public void onProcessUpdate(NBTTagCompound nbt) {
        this.syncedProcess = new ProcessInfo();
        this.syncedProcess.readFromNBT(nbt);
    }

    public void onPowerUpdate(NBTTagCompound nbt) {
        this.syncedPower = new PowerInfo();
        this.syncedPower.readFromNBT(nbt);
    }

    public PowerInfo getPowerInfo() {
        return this.syncedPower;
    }

    public ProcessInfo getProcessInfo() {
        return this.syncedProcess;
    }

    public TankInfo getTankInfo(int tank) {
        return this.syncedTanks.containsKey(tank) ? this.syncedTanks.get(tank) : new TankInfo();
    }

    public void onErrorUpdate(NBTTagCompound nbt) {
        this.errorType = nbt.func_74771_c("type");
        if (nbt.func_74764_b(NAME)) {
            this.error = new ErrorState("", "");
            this.error.readFromNBT(nbt);
        } else {
            this.error = null;
        }
    }

    public ErrorState getErrorState() {
        return this.error;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public CustomSlot[] getCustomSlots() {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof CustomSlot)) continue;
            slots.add((CustomSlot)((Object)object));
        }
        return slots.toArray(new CustomSlot[0]);
    }

    public void setMouseOverSlot(Slot slot) {
        if (slot.field_75222_d == this.mousedOverSlotNumber) {
            return;
        }
        this.mousedOverSlotNumber = slot.field_75222_d;
        ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74777_a(SLOT, (short)slot.field_75222_d);
        this.window.sendClientAction(MOUSE_OVER_SLOT, nbt);
    }

    private void onMouseOverSlot(EntityPlayer player, NBTTagCompound data) {
        short slotNumber = data.func_74765_d(SLOT);
        TransferRequest request = this.getShiftClickRequest(player, slotNumber);
        if (request == null) {
            return;
        }
        request.transfer(false);
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (TransferRequest.TransferSlot transferSlot : request.getInsertedSlots()) {
            CustomSlot slot = this.getSlot(transferSlot.inventory, transferSlot.id);
            if (slot == null) continue;
            slots.add(slot.field_75222_d);
        }
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        nbt.func_74783_a(SLOTS, array);
        nbt.func_74777_a(ORIGIN, slotNumber);
        this.syncedNBT.put(SHIFT_CLICK_INFO, nbt);
    }

    private void onReceiveShiftClickHighlights(NBTTagCompound data) {
        ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
        for (int slotIndex : data.func_74759_k(SLOTS)) {
            ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).add(slotIndex);
        }
    }

    private CustomSlot getSlot(IInventory inventory, int id) {
        for (Object o : this.field_75151_b) {
            CustomSlot slot = (CustomSlot)((Object)o);
            if (slot.field_75224_c != inventory || slot.getSlotIndex() != id) continue;
            return slot;
        }
        return null;
    }

    public void receiveNBT(Side side, EntityPlayer player, NBTTagCompound action) {
        String actionType = action.func_74779_i("type");
        this.handleNBT(side, player, action);
        this.window.receiveGuiNBT(this.getSide(), player, actionType, action);
        INetwork.ReceiveGuiNBT machine = Machine.getInterface(INetwork.ReceiveGuiNBT.class, this.window.getInventory());
        if (machine == null) {
            return;
        }
        machine.receiveGuiNBT(this.getSide(), player, actionType, action);
    }

    public Slot getOrCreateSlot(InventoryType inventoryType, int slotIndex) {
        IInventory inventory = this.getInventory(inventoryType);
        CustomSlot slot = this.getSlot(inventory, slotIndex);
        if (slot == null) {
            slot = new CustomSlot(inventory, slotIndex);
            this.func_75146_a(slot);
        }
        return slot;
    }

    protected IInventory getInventory(InventoryType type) {
        IInventory iInventory;
        switch (type) {
            case Machine: {
                iInventory = this.window.getInventory();
                break;
            }
            case Player: {
                iInventory = this.window.getPlayer().field_71071_by;
                break;
            }
            case Window: {
                iInventory = this.window.getWindowInventory();
                break;
            }
            default: {
                iInventory = null;
            }
        }
        return iInventory;
    }

    private void createSlot(InventoryType type, int index, int slotNumber) {
        if (this.field_75151_b.get(slotNumber) != null) {
            return;
        }
        IInventory inventory = this.getInventory(type);
        CustomSlot slot = new CustomSlot(inventory, index);
        slot.field_75222_d = slotNumber;
        this.field_75151_b.add(slotNumber, slot);
        this.field_75153_a.add(slotNumber, null);
    }
}

