/*
 * Decompiled with CFR 0.152.
 */
package binnie.botany.flower;

import binnie.Binnie;
import binnie.botany.Botany;
import binnie.botany.api.EnumFlowerStage;
import binnie.botany.api.EnumSoilType;
import binnie.botany.api.IAlleleFlowerSpecies;
import binnie.botany.api.IFlower;
import binnie.botany.api.IFlowerColor;
import binnie.botany.api.IFlowerGenome;
import binnie.botany.api.IFlowerType;
import binnie.botany.core.BotanyCore;
import binnie.botany.gardening.BlockPlant;
import binnie.botany.gardening.Gardening;
import binnie.botany.genetics.EnumFlowerColor;
import binnie.botany.genetics.EnumFlowerType;
import binnie.botany.genetics.Flower;
import binnie.botany.network.MessageFlowerUpdate;
import binnie.core.BinnieCore;
import com.mojang.authlib.GameProfile;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.lepidopterology.IButterfly;
import forestry.api.lepidopterology.IButterflyNursery;
import forestry.lepidopterology.entities.EntityButterfly;
import forestry.plugins.PluginLepidopterology;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.EnumPlantType;

public class TileEntityFlower
extends TileEntity
implements IPollinatable,
IButterflyNursery {
    protected IFlower flower = null;
    protected GameProfile owner;
    protected int section = 0;
    protected RenderInfo renderInfo = null;
    protected IButterfly caterpillar;
    protected int matureTime = 0;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        this.flower = new Flower(nbttagcompound);
        this.section = nbttagcompound.func_74771_c("section");
        if (this.flower.getAge() == 0) {
            this.flower.setFlowered(false);
        }
        this.owner = NBTUtil.func_152459_a((NBTTagCompound)nbttagcompound.func_74775_l("owner"));
        if (nbttagcompound.func_74764_b("CATER") && BinnieCore.isLepidopteryActive()) {
            this.matureTime = nbttagcompound.func_74762_e("caterTime");
            this.caterpillar = Binnie.Genetics.getButterflyRoot().getMember(nbttagcompound.func_74775_l("cater"));
        }
        super.func_145839_a(nbttagcompound);
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        if (this.flower != null) {
            this.flower.writeToNBT(nbttagcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
        if (this.caterpillar != null) {
            nbttagcompound.func_74768_a("caterTime", this.matureTime);
            NBTTagCompound subcompound = new NBTTagCompound();
            this.caterpillar.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("cater", (NBTBase)subcompound);
        }
        nbttagcompound.func_74774_a("section", (byte)this.getSection());
        super.func_145841_b(nbttagcompound);
    }

    public void create(ItemStack stack, GameProfile owner) {
        this.create(BotanyCore.getFlowerRoot().getMember(stack), owner);
    }

    public void create(IFlower stack, GameProfile owner) {
        this.flower = stack;
        if (this.flower.getAge() == 0) {
            this.flower.setFlowered(false);
        }
        this.updateRender(true);
        this.owner = owner;
    }

    public EnumSet<EnumPlantType> getPlantType() {
        return EnumSet.of(EnumPlantType.Plains);
    }

    public IIndividual getPollen() {
        return this.getFlower();
    }

    public boolean canMateWith(IIndividual individual) {
        return this.isBreeding() && individual instanceof IFlower && this.getFlower() != null && this.getFlower().getMate() == null && this.getFlower().hasFlowered() && !this.getFlower().isGeneticEqual(individual);
    }

    public void mateWith(IIndividual individual) {
        IAlleleFlowerSpecies primary2;
        if (this.getFlower() == null || !(individual instanceof IFlower)) {
            return;
        }
        IAlleleFlowerSpecies primary = (IAlleleFlowerSpecies)individual.getGenome().getPrimary();
        if (primary == (primary2 = this.getFlower().getGenome().getPrimary()) || this.field_145850_b.field_73012_v.nextInt(4) == 0) {
            this.getFlower().mate((IFlower)individual);
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public IFlower getFlower() {
        if (this.getSection() <= 0) {
            return this.flower;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.getSection(), this.field_145849_e);
        if (tile instanceof TileEntityFlower) {
            return ((TileEntityFlower)tile).getFlower();
        }
        return null;
    }

    public boolean isBreeding() {
        Block roots = this.func_145831_w().func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e);
        return Gardening.isSoil(roots);
    }

    public void randomUpdate(Random rand) {
        IFlowerGenome mate;
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) != Botany.flower) {
            this.func_145843_s();
            return;
        }
        if (this.getSection() > 0 || this.flower == null) {
            return;
        }
        if (this.flower.getGenome() == null) {
            this.func_145843_s();
            return;
        }
        if (!this.isBreeding()) {
            return;
        }
        float light = this.field_145850_b.func_72957_l(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (light < 6.0f) {
            for (int dx = -2; dx <= 2; ++dx) {
                for (int dy = -2; dy <= 2; ++dy) {
                    light -= this.field_145850_b.func_72937_j(this.field_145851_c, this.field_145848_d, this.field_145849_e) ? 0.0f : 0.5f;
                }
            }
        }
        boolean canTolerate = Gardening.canTolerate(this.getFlower(), this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        EnumSoilType soil = Gardening.getSoilType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (rand.nextFloat() < this.getFlower().getGenome().getAgeChance()) {
            if (this.flower.getAge() < 1) {
                if (canTolerate && light > 6.0f) {
                    this.doFlowerAge();
                }
            } else {
                this.doFlowerAge();
            }
        }
        if (canTolerate && this.flower.getAge() > 1 && !this.flower.isWilted() && light > 6.0f) {
            this.flower.setFlowered(true);
        }
        if (!canTolerate && this.flower.isWilted() && rand.nextInt(2 + Math.max(this.flower.getAge(), 2)) == 0) {
            this.kill();
            return;
        }
        if (light < 2.0f && this.flower.isWilted()) {
            this.kill();
            return;
        }
        this.flower.setWilted(!canTolerate || light < 1.0f);
        float chanceDispersal = 0.8f;
        chanceDispersal += 0.2f * (float)this.flower.getGenome().getFertility();
        chanceDispersal *= 1.0f + (float)soil.ordinal() * 0.5f;
        float chancePollinate = 1.0f;
        chancePollinate += 0.25f * (float)this.flower.getGenome().getFertility();
        float chanceSelfPollinate = 0.2f * (chancePollinate *= 1.0f + (float)soil.ordinal() * 0.5f);
        if (this.field_145850_b.field_73012_v.nextFloat() < chanceDispersal && this.flower.hasFlowered() && !this.flower.isWilted() && (mate = this.flower.getMate()) != null) {
            boolean dispersed = false;
            for (int a = 0; a < 5 && !dispersed; ++a) {
                IFlower offspring;
                int dx2 = 0;
                int dz = 0;
                while (dx2 == 0 && dz == 0) {
                    dx2 = rand.nextInt(3) - 1;
                    dz = rand.nextInt(3) - 1;
                }
                Block b = this.func_145831_w().func_147439_a(this.field_145851_c + dx2, this.field_145848_d, this.field_145849_e + dz);
                Block b2 = this.func_145831_w().func_147439_a(this.field_145851_c + dx2, this.field_145848_d - 1, this.field_145849_e + dz);
                if (b != Blocks.field_150350_a || !Gardening.isSoil(b2) || (offspring = this.flower.getOffspring(this.func_145831_w())) == null) continue;
                Gardening.plant(this.func_145831_w(), this.field_145851_c + dx2, this.field_145848_d, this.field_145849_e + dz, offspring, this.getOwner());
                this.flower.removeMate();
                dispersed = true;
            }
        }
        if (this.field_145850_b.field_73012_v.nextFloat() < chancePollinate && this.flower.hasFlowered() && !this.flower.isWilted()) {
            for (int a2 = 0; a2 < 4; ++a2) {
                int dx3 = 0;
                int dz2 = 0;
                while (dx3 == 0 && dz2 == 0) {
                    dx3 = rand.nextInt(5) - 2;
                    dz2 = rand.nextInt(5) - 2;
                }
                TileEntity tile = this.func_145831_w().func_147438_o(this.field_145851_c + dx3, this.field_145848_d, this.field_145849_e + dz2);
                if (!(tile instanceof IPollinatable) || !((IPollinatable)tile).canMateWith((IIndividual)this.getFlower())) continue;
                ((IPollinatable)tile).mateWith((IIndividual)this.getFlower());
            }
        }
        if (this.field_145850_b.field_73012_v.nextFloat() < chanceSelfPollinate && this.flower.hasFlowered() && this.flower.getMate() == null) {
            this.mateWith(this.getFlower());
        }
        this.spawnButterflies();
        this.matureCaterpillar();
        this.checkIfDead(false);
        this.updateRender(true);
    }

    private void doFlowerAge() {
        this.getFlower().age();
        if (this.getFlower().getAge() != 1) {
            return;
        }
        Gardening.onGrowFromSeed(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.getOwner() != null && this.getFlower() != null) {
            BotanyCore.getFlowerRoot().getBreedingTracker(this.func_145831_w(), this.getOwner()).registerBirth(this.getFlower());
        }
    }

    public Packet func_145844_m() {
        if (this.renderInfo == null && this.getFlower() != null && this.getFlower().getGenome() != null) {
            this.renderInfo = new RenderInfo(this.getFlower(), this);
        }
        return this.renderInfo != null ? Botany.instance.getNetworkWrapper().getPacketFrom((IMessage)new MessageFlowerUpdate(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.renderInfo).getMessage()) : null;
    }

    public void updateRender(boolean update) {
        TileEntity above;
        RenderInfo newInfo;
        if (update && this.getFlower() != null && this.getFlower().getGenome() != null && !(newInfo = new RenderInfo(this.getFlower(), this)).equals(this.renderInfo)) {
            this.setRender(newInfo);
        }
        if ((above = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) instanceof TileEntityFlower) {
            ((TileEntityFlower)above).updateRender(true);
        }
    }

    public int getSection() {
        return this.section;
    }

    public void setSection(int i) {
        this.section = i;
        if (BinnieCore.proxy.isSimulating(this.field_145850_b)) {
            this.updateRender(true);
        }
    }

    public ItemStack getItemStack() {
        if (this.flower == null) {
            return null;
        }
        int stage = this.flower.getAge() == 0 ? EnumFlowerStage.SEED.ordinal() : EnumFlowerStage.FLOWER.ordinal();
        return Binnie.Genetics.getFlowerRoot().getMemberStack(this.getFlower(), stage);
    }

    private TileEntityFlower getRoot() {
        if (this.getSection() == 0) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d - this.getSection(), this.field_145849_e);
        return tile instanceof TileEntityFlower ? (TileEntityFlower)tile : null;
    }

    public void onShear() {
        if (this.getRoot() != null) {
            this.getRoot().onShear();
        }
        if (this.getFlower() == null || this.getFlower().getAge() <= 1) {
            return;
        }
        Random rand = new Random();
        IFlower cutting = (IFlower)this.getFlower().copy();
        cutting.setAge(0);
        ItemStack cuttingStack = BotanyCore.getFlowerRoot().getMemberStack(cutting, EnumFlowerStage.SEED.ordinal());
        float f = 0.7f;
        double d = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d2 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        double d3 = (double)(rand.nextFloat() * f) + (double)(1.0f - f) * 0.5;
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + d, (double)this.field_145848_d + d2, (double)this.field_145849_e + d3, cuttingStack);
        entityitem.field_145804_b = 10;
        this.field_145850_b.func_72838_d((Entity)entityitem);
        int maxAge = this.getFlower().getMaxAge();
        for (int i = 0; i < maxAge; ++i) {
            if (!rand.nextBoolean()) continue;
            this.getFlower().age();
            if (!this.checkIfDead(true)) continue;
            return;
        }
    }

    public boolean checkIfDead(boolean wasCut) {
        if (this.getSection() != 0) {
            return this.getRoot().checkIfDead(wasCut);
        }
        EnumSoilType soil = Gardening.getSoilType(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int maxAge = (int)((float)this.flower.getMaxAge() * (1.0f + (float)soil.ordinal() * 0.25f));
        if (this.flower.getAge() <= maxAge) {
            return false;
        }
        if (!wasCut && this.flower.getMate() != null) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            IFlower offspring = this.flower.getOffspring(this.func_145831_w());
            TileEntity above = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            if (above instanceof TileEntityFlower) {
                this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            }
            Gardening.plant(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, offspring, this.getOwner());
        } else {
            this.kill();
        }
        return true;
    }

    public void kill() {
        if (this.flower.getAge() > 0) {
            this.field_145850_b.func_147465_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Botany.plant, BlockPlant.Type.DeadFlower.ordinal(), 2);
        } else {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        int i = 1;
        while (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) instanceof TileEntityFlower) {
            this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
            ++i;
        }
    }

    public boolean onBonemeal() {
        if (this.getFlower() == null || !this.isBreeding() || this.getFlower().isWilted()) {
            return false;
        }
        this.doFlowerAge();
        if (this.getFlower().getAge() > 1 && !this.getFlower().hasFlowered()) {
            this.getFlower().setFlowered(true);
        }
        this.checkIfDead(false);
        this.updateRender(true);
        return true;
    }

    public GameProfile getOwner() {
        return this.owner;
    }

    public void setOwner(GameProfile ownerName) {
        this.owner = ownerName;
    }

    public void spawnButterflies() {
        if (!BinnieCore.isLepidopteryActive()) {
            return;
        }
        int x = this.field_145851_c;
        int y = this.field_145848_d;
        int z = this.field_145849_e;
        World world = this.field_145850_b;
        if (this.getCaterpillar() != null) {
            return;
        }
        if (world.field_73012_v.nextFloat() >= this.getFlower().getGenome().getSappiness()) {
            return;
        }
        if (this.field_145850_b.field_73012_v.nextFloat() >= 0.2f) {
            return;
        }
        IButterfly spawn = (IButterfly)Binnie.Genetics.getButterflyRoot().getIndividualTemplates().get(this.field_145850_b.field_73012_v.nextInt(Binnie.Genetics.getButterflyRoot().getIndividualTemplates().size()));
        if (this.field_145850_b.field_73012_v.nextFloat() >= spawn.getGenome().getPrimary().getRarity() * 0.5f) {
            return;
        }
        if (this.field_145850_b.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
            return;
        }
        if (!spawn.canSpawn(this.field_145850_b, (double)x, (double)y, (double)z)) {
            return;
        }
        if (world.func_147437_c(x, y + 1, z)) {
            this.attemptButterflySpawn(world, spawn, x, y + 1, z);
        } else if (world.func_147437_c(x - 1, y, z)) {
            this.attemptButterflySpawn(world, spawn, x - 1, y, z);
        } else if (world.func_147437_c(x + 1, y, z)) {
            this.attemptButterflySpawn(world, spawn, x + 1, y, z);
        } else if (world.func_147437_c(x, y, z - 1)) {
            this.attemptButterflySpawn(world, spawn, x, y, z - 1);
        } else if (world.func_147437_c(x, y, z + 1)) {
            this.attemptButterflySpawn(world, spawn, x, y, z + 1);
        }
    }

    private void attemptButterflySpawn(World world, IButterfly butterfly, double x, double y, double z) {
        if (BinnieCore.isLepidopteryActive()) {
            Binnie.Genetics.getButterflyRoot().spawnButterflyInWorld(world, butterfly.copy(), x, y + (double)0.1f, z);
        }
    }

    public World getWorld() {
        return this.func_145831_w();
    }

    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue((float)this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76750_F);
    }

    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue((float)this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76751_G);
    }

    public IButterfly getCaterpillar() {
        return this.caterpillar;
    }

    public void setCaterpillar(IButterfly butterfly) {
        this.caterpillar = butterfly;
        this.matureTime = 0;
    }

    public IIndividual getNanny() {
        return this.getFlower();
    }

    public boolean canNurse(IButterfly butterfly) {
        return this.getFlower() != null && !this.getFlower().isWilted() && this.getFlower().getAge() > 1;
    }

    private void matureCaterpillar() {
        if (this.getCaterpillar() == null) {
            return;
        }
        ++this.matureTime;
        if (this.matureTime >= this.caterpillar.getGenome().getLifespan() / (this.caterpillar.getGenome().getFertility() * 2) && this.caterpillar.canTakeFlight(this.field_145850_b, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e)) {
            if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d + 1, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c - 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c + 1, this.field_145848_d, this.field_145849_e);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e - 1);
            } else if (this.field_145850_b.func_147437_c(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1)) {
                this.attemptButterflySpawn(this.field_145850_b, this.caterpillar, this.field_145851_c, this.field_145848_d, this.field_145849_e + 1);
            }
            this.setCaterpillar(null);
        }
    }

    public void setRender(RenderInfo render) {
        this.renderInfo = render;
        this.section = this.renderInfo.section;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public int getAge() {
        return this.renderInfo == null ? 1 : (int)this.renderInfo.age;
    }

    public int getRenderSection() {
        return this.renderInfo == null ? 1 : (int)this.renderInfo.section;
    }

    public boolean isWilted() {
        return this.renderInfo != null && this.renderInfo.wilted;
    }

    public boolean isFlowered() {
        return this.renderInfo == null || this.renderInfo.flowered;
    }

    public int getPrimaryColor() {
        return this.renderInfo == null ? EnumFlowerColor.RED.getColor(false) : this.renderInfo.primary.getColor(this.isWilted());
    }

    public int getSecondaryColor() {
        return this.renderInfo == null ? EnumFlowerColor.RED.getColor(false) : this.renderInfo.secondary.getColor(this.isWilted());
    }

    public int getStemColour() {
        return this.renderInfo == null ? EnumFlowerColor.GREEN.getColor(false) : this.renderInfo.stem.getColor(this.isWilted());
    }

    public IFlowerType getType() {
        return this.renderInfo == null ? EnumFlowerType.POPPY : this.renderInfo.type;
    }

    public BiomeGenBase getBiome() {
        return this.getWorld().func_72807_a(this.field_145851_c, this.field_145849_e);
    }

    public ChunkCoordinates getCoordinates() {
        return new ChunkCoordinates(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public boolean isPollinated() {
        return this.isBreeding();
    }

    public static class RenderInfo {
        public IFlowerColor primary;
        public IFlowerColor secondary;
        public IFlowerColor stem;
        public IFlowerType type;
        public byte age;
        public boolean wilted;
        public boolean flowered;
        public byte section;

        public RenderInfo() {
        }

        public RenderInfo(IFlower flower, TileEntityFlower tile) {
            this.section = (byte)tile.getSection();
            this.primary = flower.getGenome().getPrimaryColor();
            this.secondary = flower.getGenome().getSecondaryColor();
            this.stem = flower.getGenome().getStemColor();
            this.age = (byte)flower.getAge();
            this.wilted = flower.isWilted();
            this.flowered = flower.hasFlowered();
            this.type = flower.getGenome().getType();
        }

        public boolean equals(Object obj) {
            if (obj instanceof RenderInfo) {
                RenderInfo o = (RenderInfo)obj;
                return o.age == this.age && o.wilted == this.wilted && o.flowered == this.flowered && o.primary == this.primary && o.secondary == this.secondary && o.stem == this.stem && o.type == this.type;
            }
            return super.equals(obj);
        }
    }
}

