/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.tml.data.chest;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dmillerw.tml.TooMuchLoot;
import dmillerw.tml.data.LootGroupXML;
import dmillerw.tml.data.LootLoadingMode;
import dmillerw.tml.data.XMLDataBridge;
import dmillerw.tml.data.chest.ChestLootCategory;
import dmillerw.tml.data.chest.ChestLootItem;
import dmillerw.tml.helper.LogHelper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class ChestLootLoader {
    public static FilenameFilter FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File file, String s) {
            return s.endsWith(".xml");
        }
    };

    public static HashMap<String, ChestGenHooks> copyLootTable(Map<String, ChestGenHooks> lootTable) {
        HashMap newLootTable = Maps.newHashMap();
        try {
            for (String key : lootTable.keySet()) {
                ChestGenHooks old = lootTable.get(key);
                ArrayList copiedList = Lists.newArrayList();
                for (WeightedRandomChestContent chestContent : (List)TooMuchLoot.contents.get(old)) {
                    copiedList.add(new WeightedRandomChestContent(chestContent.field_76297_b.func_77946_l(), chestContent.field_76295_d, chestContent.field_76296_e, chestContent.field_76292_a));
                }
                newLootTable.put(key, new ChestGenHooks(key, copiedList.toArray(new WeightedRandomChestContent[copiedList.size()]), old.getMin(), old.getMax()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return newLootTable;
    }

    public static void restoreCachedLootTable() {
        try {
            TooMuchLoot.chestInfo.set(ChestGenHooks.class, ChestLootLoader.copyLootTable((Map)TooMuchLoot.chestInfo.get(ChestGenHooks.class)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void generateFiles(File generationDir, String ... categories) {
        if (!generationDir.exists()) {
            generationDir.mkdirs();
        }
        if (categories == null || categories.length == 0) {
            categories = TooMuchLoot.chestGenCategories;
        }
        for (String key : categories) {
            try {
                String sanitizedKey = key.replaceAll("[^a-zA-Z0-9\\._]+", "_");
                File file = new File(generationDir, sanitizedKey + ".xml");
                if (file.exists()) {
                    file.delete();
                }
                ChestLootCategory lootCategory = ChestLootCategory.fromChestGenHooks(key);
                lootCategory.loading_mode = LootLoadingMode.OVERRIDE;
                for (ChestLootItem lootItem : lootCategory.loot) {
                    if (lootItem.nbt != null && (lootItem.nbt == null || !lootItem.nbt.func_82582_d())) continue;
                    lootItem.nbt = null;
                }
                LootGroupXML tXMLObject = XMLDataBridge.parseToXMLObject(lootCategory);
                try {
                    JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroupXML.class});
                    Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
                    jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
                    jaxMarsh.marshal((Object)tXMLObject, (OutputStream)new FileOutputStream(file, false));
                }
                catch (Exception e) {
                    LogHelper.warn(String.format("Error while creating lootfile %s", e.getMessage()), false);
                    e.printStackTrace();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void loadFiles(File scanDir) {
        HashMultimap toAdd = HashMultimap.create();
        HashMultimap toRemove = HashMultimap.create();
        HashMap tempMap = Maps.newHashMap();
        for (File file : scanDir.listFiles(FILTER)) {
            LogHelper.logParse(file.getName());
            try {
                JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{LootGroupXML.class});
                Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
                LootGroupXML tXMLObject = null;
                tXMLObject = (LootGroupXML)jaxUnmarsh.unmarshal(file);
                ChestLootCategory lootCategory = XMLDataBridge.parseToChestLootCat(tXMLObject);
                for (ChestLootItem chestLootItem : lootCategory.loot) {
                    chestLootItem.checkCountValues();
                }
                if (lootCategory.loading_mode == LootLoadingMode.OVERRIDE) {
                    if (!tempMap.containsKey(lootCategory.category)) {
                        LogHelper.logOverride(lootCategory.category);
                        tempMap.put(lootCategory.category, lootCategory.toChestGenHooks());
                        continue;
                    }
                    LogHelper.logOverrideError(lootCategory.category, file.getName());
                    continue;
                }
                if (lootCategory.loading_mode == LootLoadingMode.ADD) {
                    for (ChestLootItem lootItem : lootCategory.loot) {
                        toAdd.put((Object)lootCategory.category, (Object)lootItem.toChestContent());
                    }
                    continue;
                }
                if (lootCategory.loading_mode != LootLoadingMode.REMOVE) continue;
                for (ChestLootItem lootItem : lootCategory.loot) {
                    toRemove.put((Object)lootCategory.category, (Object)lootItem.toItemStack());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            if (!tempMap.isEmpty()) {
                ((HashMap)TooMuchLoot.chestInfo.get(ChestGenHooks.class)).putAll(tempMap);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (Map.Entry entry : toAdd.entries()) {
            LogHelper.logAddition((String)entry.getKey(), ((WeightedRandomChestContent)entry.getValue()).field_76297_b.func_82833_r());
            ChestGenHooks.getInfo((String)((String)entry.getKey())).addItem((WeightedRandomChestContent)entry.getValue());
        }
        for (Map.Entry entry : toRemove.entries()) {
            LogHelper.logRemoval((String)entry.getKey(), ((ItemStack)entry.getValue()).func_82833_r());
            ChestGenHooks.getInfo((String)((String)entry.getKey())).removeItem((ItemStack)entry.getValue());
        }
    }
}

