/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.util.Util;
import com.gtnewhorizons.navigator.mixins.late.journeymap.FullscreenAccessor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import journeymap.client.render.map.GridRenderer;
import net.minecraft.client.settings.KeyBinding;

public final class NavigatorApi {
    public static final double CHUNK_WIDTH = 16.0;
    public static final KeyBinding ACTION_KEY = new KeyBinding("navigator.key.action", 211, "Navigator");
    public static final List<LayerManager> layerManagers = new ArrayList<LayerManager>();

    public static void registerLayerManager(LayerManager layerManager) {
        layerManagers.add(layerManager);
    }

    public static List<LayerRenderer> getActiveRenderersFor(SupportedMods mod) {
        return layerManagers.stream().filter(LayerManager::isLayerActive).map(layerManager -> layerManager.getLayerRenderer(mod)).collect(Collectors.toList());
    }

    public static List<LayerRenderer> getActiveRenderersByPriority(SupportedMods mod) {
        List<LayerRenderer> list = NavigatorApi.getActiveRenderersFor(mod);
        list.sort(Comparator.comparingInt(LayerRenderer::getRenderPriority));
        return list;
    }

    public static List<LayerManager> getEnabledLayers(SupportedMods mod) {
        return layerManagers.stream().filter(layerManager -> layerManager.isEnabled(mod)).collect(Collectors.toList());
    }

    public static List<ButtonManager> getEnabledButtons(SupportedMods mod) {
        return layerManagers.stream().filter(layerManager -> layerManager.isEnabled(mod)).map(LayerManager::getButtonManager).distinct().collect(Collectors.toList());
    }

    public static List<ButtonManager> getDistinctButtons() {
        return NavigatorApi.getDistinctButtons(null);
    }

    public static List<ButtonManager> getDistinctButtons(ButtonManager toExclude) {
        return layerManagers.stream().map(LayerManager::getButtonManager).distinct().filter(buttonManager -> !buttonManager.equals(toExclude)).collect(Collectors.toList());
    }

    public static List<InteractableLayerManager> getInteractableLayers() {
        return layerManagers.stream().filter(layerManager -> layerManager instanceof InteractableLayerManager).map(layerManager -> (InteractableLayerManager)layerManager).collect(Collectors.toList());
    }

    public void openJourneyMapAt(@Nullable LayerManager layer, int blockX, int blockZ, int zoom) {
        if (!Util.isJourneyMapInstalled()) {
            return;
        }
        GridRenderer gridRenderer = FullscreenAccessor.getGridRenderer();
        if (gridRenderer == null) {
            return;
        }
        if (layer != null) {
            layer.activateLayer();
        }
        if (zoom == -1) {
            zoom = gridRenderer.getZoom();
        }
        gridRenderer.center(gridRenderer.getMapType(), (double)blockX, (double)blockZ, zoom);
    }

    public void openJourneyMapAt(@Nullable LayerManager layer, int blockX, int blockZ) {
        this.openJourneyMapAt(layer, blockX, blockZ, -1);
    }
}

