/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.plugins.gears;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import mantle.pulsar.pulse.Handler;
import mantle.pulsar.pulse.Pulse;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import tconstruct.TConstruct;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.crafting.FluidType;
import tconstruct.library.crafting.Smeltery;
import tconstruct.plugins.gears.GearCast;
import tconstruct.smeltery.TinkerSmeltery;
import tconstruct.util.config.PHConstruct;

@Pulse(id="Tinkers Gears", description="Adds a gear cast if other mods provide gears", pulsesRequired="Tinkers' Smeltery")
public class TinkerGears {
    public static Item gearCast;

    @Handler
    public void preInit(FMLPreInitializationEvent event) {
        TConstruct.logger.info("Gear module active. Adding gear cast.");
        gearCast = new GearCast();
        GameRegistry.registerItem((Item)gearCast, (String)"gearCast");
    }

    @Handler
    public void postInit(FMLPostInitializationEvent event) {
        ItemStack cast = new ItemStack(gearCast);
        FluidStack aluCastLiquid = new FluidStack(TinkerSmeltery.moltenAlubrassFluid, 144);
        FluidStack goldCastLiquid = null;
        if (!PHConstruct.removeGoldCastRecipes) {
            goldCastLiquid = new FluidStack(TinkerSmeltery.moltenGoldFluid, 288);
        }
        if (!PHConstruct.disableAllRecipes) {
            for (String oreName : OreDictionary.getOreNames()) {
                String material;
                Fluid fluid;
                if (!oreName.startsWith("gear")) continue;
                ArrayList gears = OreDictionary.getOres((String)oreName);
                if (!oreName.equals("gearWood")) {
                    for (ItemStack g : gears) {
                        TConstructRegistry.getTableCasting().addCastingRecipe(cast, aluCastLiquid, g, false, 50);
                        if (PHConstruct.removeGoldCastRecipes) continue;
                        TConstructRegistry.getTableCasting().addCastingRecipe(cast, goldCastLiquid, g, false, 50);
                    }
                }
                if ((fluid = FluidRegistry.getFluid((String)(material = oreName.substring(4)))) == null) {
                    fluid = FluidRegistry.getFluid((String)material.toLowerCase());
                }
                if (fluid == null) {
                    fluid = FluidRegistry.getFluid((String)(material.toLowerCase() + ".molten"));
                }
                if (fluid == null) continue;
                ItemStack gear = (ItemStack)gears.get(0);
                FluidStack liquid = new FluidStack(fluid.getID(), 576);
                TConstructRegistry.getTableCasting().addCastingRecipe(gear, liquid, cast, 55);
                FluidType ft = FluidType.getFluidType(fluid);
                if (ft != null) {
                    Smeltery.addMelting(ft, gear, 100, 576);
                    continue;
                }
                Smeltery.addMelting(gear, TinkerSmeltery.glueBlock, 0, 100, liquid);
            }
        }
    }
}

