/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizon.structurelib.structure;

import com.gtnewhorizon.structurelib.StructureLib;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.alignment.constructable.ChannelDataAccessor;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.alignment.enumerable.ExtendedFacing;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.IStructureWalker;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.structure.SurvivalBuildStructureWalker;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public interface IStructureDefinition<T> {
    public IStructureElement<T>[] getStructureFor(String var1);

    public boolean isContainedInStructure(String var1, int var2, int var3, int var4);

    default public boolean check(T object, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean forceCheckAllBlocks) {
        return IStructureDefinition.iterate(object, null, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, forceCheckAllBlocks);
    }

    default public boolean hints(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, true, null);
    }

    default public boolean build(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, false, null);
    }

    default public boolean buildOrHints(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly) {
        return IStructureDefinition.iterate(object, trigger, this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, hintsOnly, null);
    }

    @Deprecated
    default public int survivalBuild(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int elementBudget, IItemSource source, EntityPlayerMP actor, boolean check) {
        EntityPlayer realActor;
        if (actor == null) {
            realActor = ISurvivalConstructable.__get_player();
            if (realActor == null) {
                throw new IllegalArgumentException();
            }
        } else {
            realActor = actor;
        }
        return this.survivalBuild(object, trigger, piece, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, elementBudget, ISurvivalBuildEnvironment.create(source, realActor), check);
    }

    default public int survivalBuild(T object, ItemStack trigger, String piece, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, int elementBudget, ISurvivalBuildEnvironment env, boolean check) {
        SurvivalBuildStructureWalker<T> walker = new SurvivalBuildStructureWalker<T>(object, trigger, elementBudget, env, this, piece, extendedFacing, new int[]{basePositionA, basePositionB, basePositionC}, check);
        StructureUtility.iterateV2(this.getStructureFor(piece), world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, walker, "survivalBuild");
        return walker.getBuilt();
    }

    public static <T> boolean iterate(T object, ItemStack trigger, IStructureElement<T>[] elements, World world, ExtendedFacing extendedFacing, int basePositionX, int basePositionY, int basePositionZ, int basePositionA, int basePositionB, int basePositionC, boolean hintsOnly, Boolean checkBlocksIfNotNullForceCheckAllIfTrue) {
        if (!world.field_72995_K && hintsOnly) {
            return false;
        }
        if (checkBlocksIfNotNullForceCheckAllIfTrue != null) {
            boolean success = checkBlocksIfNotNullForceCheckAllIfTrue != false ? StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, (e, w, x, y, z, a, b, c) -> e.check(object, w, x, y, z), "check") : StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, IStructureWalker.skipBlockUnloaded((e, w, x, y, z, a, b, c) -> e.check(object, w, x, y, z)), "check force");
            if (StructureLibAPI.isDebugEnabled() && success) {
                StructureLib.LOGGER.info("Multi [" + basePositionX + ", " + basePositionY + ", " + basePositionZ + "] pass");
            }
            return success;
        }
        if (hintsOnly) {
            StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, IStructureWalker.ignoreBlockUnloaded((e, w, x, y, z, a, b, c) -> {
                e.spawnHint(object, world, x, y, z, trigger);
                if (ChannelDataAccessor.hasSubChannel(trigger, "show_error") && !e.couldBeValid(object, world, x, y, z, trigger)) {
                    StructureLibAPI.markHintParticleError(StructureLib.getCurrentPlayer(), world, x, y, z);
                }
                return true;
            }), "spawnHint");
        } else {
            StructureUtility.iterateV2(elements, world, extendedFacing, basePositionX, basePositionY, basePositionZ, basePositionA, basePositionB, basePositionC, IStructureWalker.ignoreBlockUnloaded((e, w, x, y, z, a, b, c) -> {
                e.placeBlock(object, world, x, y, z, trigger);
                return true;
            }), "placeBlock");
        }
        return true;
    }

    public static <T> StructureDefinition.Builder<T> builder() {
        return StructureDefinition.builder();
    }
}

