/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.config;

import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.client.RingsRenderInfo;
import de.katzenpapst.amunra.helper.AstronomyHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.planets.asteroids.AsteroidsModule;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

public class ARConfig {
    public int dimNeper = 20;
    public int dimMaahes = 21;
    public int dimAnubis = 22;
    public int dimHorus = 23;
    public int dimSeth = 24;
    public int dimMehen = 25;
    public int planetDefaultTier = 3;
    public boolean villageAdvancedMachines = false;
    public int maxNumMotherships = -1;
    public int mothershipMaxTier = 10;
    public int mothershipProviderID = -39;
    public int mothershipMaxTravelTime = 24000;
    public float mothershipSpeedFactor = 1.0f;
    public float mothershipFuelFactor = 1.0f;
    public int mothershipMass = 0;
    public Set<String> mothershipBodiesNoOrbit;
    public String validJetEngineFuel;
    public String validIonThrusterCoolant;
    public Set<String> bodiesNoRender;
    public Set<String> asteroidBeltBodies;
    public int mothershipNumStarLines = 400;
    public int numAsteroids = 600;
    public Map<String, Vector3> sunColorMap = new HashMap<String, Vector3>();
    public Map<String, RingsRenderInfo> ringMap = new HashMap<String, RingsRenderInfo>();
    public int schematicIdShuttle = 11;
    public int guiIdShuttle = 8;
    public float hydroponicsFactor = 1.0f;
    private final String[] defaultExtraSuns = new String[]{"tbn36b:0/0.1/1", "selpin:0/0.1/1", "tbn36a:1/0/0", "centaurib:1/0.7/0.8", "vega:0.8/0.8/1", "sirius:0.6/0.8/1", "siriusb:1/1/1", "dark:0.1/0.1/0.1", "kapteyn:0.70/0.1/0.1"};
    private final String[] defaultPlanetsWithRings = new String[]{"barnarda5:171:301:galaxyspace:textures/gui/celestialbodies/barnardaRings.png", "barnarda6:177:305:galaxyspace:textures/gui/celestialbodies/barnardaRings2.png", "appleapachia:8:20:extendedplanets:textures/gui/celestialbodies/appleapachiaRings.png"};
    private final String[] defaultAsteroidBelts = new String[]{"okblekbelt", "saturnrings"};
    public boolean generateOres = false;

    public void processConfig(Configuration config) {
        String[] ringData;
        String[] sunData;
        config.load();
        String[] emptySet = new String[]{};
        this.dimNeper = config.get("dimension_ids", "Neper", this.dimNeper).getInt();
        this.dimMaahes = config.get("dimension_ids", "Maahes", this.dimMaahes).getInt();
        this.dimAnubis = config.get("dimension_ids", "Anubis", this.dimAnubis).getInt();
        this.dimHorus = config.get("dimension_ids", "Horus", this.dimHorus).getInt();
        this.dimSeth = config.get("dimension_ids", "Seth", this.dimSeth).getInt();
        this.dimMehen = config.get("dimension_ids", "Mehen", this.dimMehen).getInt();
        this.villageAdvancedMachines = config.get("villages", "UseAdvancedMachines", false, "If true, robot villages will have advanced solar collectors, storage clusters and heavy wires").getBoolean();
        this.planetDefaultTier = config.getInt("default_tier", "general", this.planetDefaultTier, 0, 1000, "Default tier for AmunRa planets and moons");
        this.hydroponicsFactor = config.getFloat("hydroponicsFactor", "general", this.hydroponicsFactor, Float.MIN_VALUE, Float.MAX_VALUE, "Multiplier for the oxygen production of the hydroponics unit");
        this.generateOres = config.getBoolean("generateOres", "general", this.generateOres, "If ores should be generated on planets/moons");
        this.maxNumMotherships = config.getInt("numMothershipsPerPlayer", "motherships", this.maxNumMotherships, -1, 1000, "Maximal amount of motherships one single player can have. Set to -1 to remove the restriction.");
        this.mothershipProviderID = config.getInt("mothershipProviderID", "motherships", this.mothershipProviderID, Integer.MIN_VALUE, Integer.MAX_VALUE, "ID for the Mothership World Provider");
        this.mothershipMaxTier = config.getInt("maxMothershipTier", "motherships", this.mothershipMaxTier, 1, Integer.MAX_VALUE, "Maximal tier which can be reached from a mothership. Motherships will pretty much ignore the tier system otherwise.");
        this.mothershipMaxTravelTime = config.getInt("maxMothershipTravelTime", "motherships", this.mothershipMaxTravelTime, 1, Integer.MAX_VALUE, "Maximal travel time (in ticks) for a mothership. Destinations with a longer travel time are unreachable. 24000 = one Overworld day");
        this.mothershipSpeedFactor = config.getFloat("mothershipSpeedFactor", "motherships", this.mothershipSpeedFactor, Float.MIN_VALUE, Float.MAX_VALUE, "A factor to be multiplied onto the mothership speed. Higher values = faster motherships.");
        this.mothershipFuelFactor = config.getFloat("mothershipFuelFactor", "motherships", this.mothershipFuelFactor, Float.MIN_VALUE, Float.MAX_VALUE, "A factor to be multiplied onto the fuel usages of mothership engines. Higher values = higher fuel usage");
        this.mothershipMass = config.getInt("mothershipMass", "motherships", this.mothershipMass, 0, Integer.MAX_VALUE, "If greater than zero, overrides the mothership's mass. If zero, the mass will be calculated based on the blocks used to build the mothership.");
        this.mothershipBodiesNoOrbit = this.configGetStringHashSet(config, "bodiesNoOrbit", "motherships", emptySet, "Bodies which should not be orbitable by motherships");
        this.validJetEngineFuel = config.getString("validJetEngineFuel", "motherships", "fuel", "This fluid can be used by Jet Engines");
        this.validIonThrusterCoolant = config.getString("validIonThrusterCoolant", "motherships", "liquidnitrogen", "This fluid can be used by Ion Thrusters");
        this.mothershipNumStarLines = config.getInt("mothershipStarLines", "rendering", this.mothershipNumStarLines, 0, Integer.MAX_VALUE, "Number of speed lines to display while in transit. A lower number might improve performance, while a higher might look nicer.");
        this.numAsteroids = config.getInt("numAsteroids", "rendering", this.numAsteroids, 0, Integer.MAX_VALUE, "Approximate number of asteroids drawn in the sky when 'orbiting' an asteroid belt.");
        this.bodiesNoRender = this.configGetStringHashSet(config, "skyRenderExclude", "rendering", emptySet, "Names of bodies to exclude from rendering in the sky, for reasons other than being asteroid belts");
        this.asteroidBeltBodies = this.configGetStringHashSet(config, "asteroidBelts", "rendering", this.defaultAsteroidBelts, "Names of bodies to be considered asteroid belts. These values are automatically added to skyRenderExclude, so it is not necessary to add them to both.");
        for (String str : sunData = config.getStringList("additionalSuns", "rendering", this.defaultExtraSuns, "Additional bodies to render with a colored aura, or set the aura of a specific star. \nThe bodies in here will be considered stars on motherships as well. \nFormat: '<bodyName>:<r>/<g>/<b>' with the colors as floats between 0 and 1. \nExample: 'myPlanet:1/0.6/0.1'")) {
            String[] parts1 = str.split(":", 2);
            if (parts1.length < 2) {
                AmunRa.LOGGER.warn("'{}' is not a valid sun configuration", new Object[]{str});
                continue;
            }
            String body = parts1[0];
            String color = parts1[1];
            String[] parts2 = color.split("/", 3);
            if (parts2.length < 3) continue;
            Vector3 colorVec = new Vector3(Double.parseDouble(parts2[0]), Double.parseDouble(parts2[1]), Double.parseDouble(parts2[2]));
            this.sunColorMap.put(body, colorVec);
        }
        for (String str : ringData = config.getStringList("planetsWithRings", "rendering", this.defaultPlanetsWithRings, "Bodies to render with rings. \nThe format is: <bodyName>:<gapStart>:<gapEnd>:<Mod_Asset_Prefix>:<textureName>. \nThe 'gapStart' and 'gapEnd' is the number of pixels from the left or the top to the start of the gap for the planet and the end, respectively. \nExample: 'uranus:8:20:galacticraftcore:textures/gui/celestialbodies/uranusRings.png'")) {
            String[] parts1 = str.split(":", 5);
            if (parts1.length < 5) {
                AmunRa.LOGGER.warn("'{}' is not a valid ring configuration", new Object[]{str});
                continue;
            }
            String body = parts1[0];
            int gapStart = Integer.parseInt(parts1[1]);
            int gapEnd = Integer.parseInt(parts1[2]);
            String assetPrefix = parts1[3];
            String textureName = parts1[4];
            if (gapStart <= 0 || gapEnd <= 0 || gapEnd <= gapStart) {
                AmunRa.LOGGER.warn("'{}' is not a valid ring configuration", new Object[]{str});
                continue;
            }
            this.ringMap.put(body, new RingsRenderInfo(new ResourceLocation(assetPrefix, textureName), gapStart, gapEnd));
        }
        this.schematicIdShuttle = config.getInt("shuttleSchematicsId", "schematics", this.schematicIdShuttle, 6, Integer.MAX_VALUE, "ID of the Shuttle schematics, must be unique. 0-5 are used by Galacticraft already.");
        this.guiIdShuttle = config.getInt("shuttleGuiId", "schematics", this.guiIdShuttle, 8, Integer.MAX_VALUE, "ID of the Shuttle schematics GUI, must be unique. 0-7 are used by Galacticraft already.");
        config.save();
    }

    public NBTTagCompound getServerOverrideData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("maxNumMotherships", this.maxNumMotherships);
        NBTTagList bodiesNoList = new NBTTagList();
        for (String s : this.mothershipBodiesNoOrbit) {
            NBTTagString strTag = new NBTTagString(s);
            bodiesNoList.func_74742_a((NBTBase)strTag);
        }
        data.func_74782_a("msBodiesNoOrbit", (NBTBase)bodiesNoList);
        data.func_74768_a("msMaxTier", this.mothershipMaxTier);
        data.func_74768_a("msMaxTravelTime", this.mothershipMaxTravelTime);
        data.func_74776_a("msFuelFactor", this.mothershipFuelFactor);
        data.func_74776_a("msSpeedFactor", this.mothershipSpeedFactor);
        data.func_74768_a("planetDefaultTier", this.planetDefaultTier);
        return data;
    }

    public void setServerOverrideData(NBTTagCompound data) {
        this.maxNumMotherships = data.func_74762_e("maxNumMotherships");
        NBTTagList bodiesNoList = data.func_150295_c("msBodiesNoOrbit", 8);
        this.mothershipBodiesNoOrbit.clear();
        for (int i = 0; i < bodiesNoList.func_74745_c(); ++i) {
            String strData = bodiesNoList.func_150307_f(i);
            this.mothershipBodiesNoOrbit.add(strData);
        }
        this.mothershipMaxTier = data.func_74762_e("msMaxTier");
        this.mothershipMaxTravelTime = data.func_74762_e("msMaxTravelTime");
        this.mothershipFuelFactor = data.func_74760_g("msFuelFactor");
        this.mothershipSpeedFactor = data.func_74760_g("msSpeedFactor");
        this.planetDefaultTier = data.func_74762_e("planetDefaultTier");
    }

    public void setStaticConfigValues() {
        this.asteroidBeltBodies.add(AmunRa.instance.asteroidBeltMehen.getName());
        this.asteroidBeltBodies.add(AmunRa.instance.moonBaalRings.getName());
        this.asteroidBeltBodies.add(AsteroidsModule.planetAsteroids.getName());
        this.bodiesNoRender.addAll(this.asteroidBeltBodies);
        this.sunColorMap.put(AmunRa.instance.starAmun.getName(), new Vector3(0.0, 0.2, 0.7));
        if (!this.ringMap.containsKey("uranus")) {
            this.ringMap.put("uranus", new RingsRenderInfo(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/uranusRings.png"), 8, 20));
        }
        if (!this.ringMap.containsKey("saturn")) {
            this.ringMap.put("saturn", new RingsRenderInfo(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/celestialbodies/saturnRings.png"), 9, 21));
        }
    }

    public boolean isSun(CelestialBody body) {
        return this.sunColorMap.containsKey(body.getName());
    }

    public boolean isAsteroidBelt(CelestialBody body) {
        return this.asteroidBeltBodies.contains(body.getName());
    }

    private HashSet<String> configGetStringHashSet(Configuration config, String name, String category, String[] defaultValues, String comment) {
        String[] data = config.getStringList(name, category, defaultValues, comment);
        HashSet<String> result = new HashSet<String>();
        Collections.addAll(result, data);
        return result;
    }

    public void verifyMothershipProviderId() {
        CelestialBody body = GalaxyRegistry.getCelestialBodyFromDimensionID((int)this.mothershipProviderID);
        if (body != null) {
            String bodyName = AstronomyHelper.getDebugBodyName(body);
            throw new RuntimeException("Please change \"mothershipProviderID\" in the config file. " + this.mothershipProviderID + " is already in use by " + bodyName);
        }
    }
}

