/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import de.katzenpapst.amunra.GuiHandler;
import de.katzenpapst.amunra.block.ARBlocks;
import de.katzenpapst.amunra.command.CommandMothershipForceArrive;
import de.katzenpapst.amunra.command.CommandMothershipInfo;
import de.katzenpapst.amunra.command.CommandMoveMothership;
import de.katzenpapst.amunra.command.CommandShuttleTeleport;
import de.katzenpapst.amunra.config.ARConfig;
import de.katzenpapst.amunra.crafting.RecipeHelper;
import de.katzenpapst.amunra.entity.EntityCryoArrow;
import de.katzenpapst.amunra.entity.EntityLaserArrow;
import de.katzenpapst.amunra.entity.EntityOsirisBossFireball;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttle;
import de.katzenpapst.amunra.entity.spaceship.EntityShuttleFake;
import de.katzenpapst.amunra.event.CraftingHandler;
import de.katzenpapst.amunra.event.EventHandlerAR;
import de.katzenpapst.amunra.event.FurnaceHandler;
import de.katzenpapst.amunra.helper.InteroperabilityHelper;
import de.katzenpapst.amunra.item.ARItems;
import de.katzenpapst.amunra.mob.RobotVillagerProfession;
import de.katzenpapst.amunra.mob.entity.EntityARVillager;
import de.katzenpapst.amunra.mob.entity.EntityAlienBug;
import de.katzenpapst.amunra.mob.entity.EntityMummyBoss;
import de.katzenpapst.amunra.mob.entity.EntityPorcodon;
import de.katzenpapst.amunra.mob.entity.EntityRobotVillager;
import de.katzenpapst.amunra.mob.entity.EntitySentry;
import de.katzenpapst.amunra.mothership.MothershipWorldProvider;
import de.katzenpapst.amunra.network.ARChannelHandler;
import de.katzenpapst.amunra.network.packet.ConnectionPacketAR;
import de.katzenpapst.amunra.proxy.ARSidedProxy;
import de.katzenpapst.amunra.tick.ConnectionEvents;
import de.katzenpapst.amunra.tick.TickHandlerServer;
import de.katzenpapst.amunra.tile.TileEntityARChest;
import de.katzenpapst.amunra.tile.TileEntityARChestLarge;
import de.katzenpapst.amunra.tile.TileEntityBlockScale;
import de.katzenpapst.amunra.tile.TileEntityBossDungeonSpawner;
import de.katzenpapst.amunra.tile.TileEntityGravitation;
import de.katzenpapst.amunra.tile.TileEntityHydroponics;
import de.katzenpapst.amunra.tile.TileEntityIsotopeGenerator;
import de.katzenpapst.amunra.tile.TileEntityMothershipController;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBooster;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineBoosterIon;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineIon;
import de.katzenpapst.amunra.tile.TileEntityMothershipEngineJet;
import de.katzenpapst.amunra.tile.TileEntityMothershipSettings;
import de.katzenpapst.amunra.tile.TileEntityShuttleDock;
import de.katzenpapst.amunra.tile.TileEntityShuttleDockFake;
import de.katzenpapst.amunra.world.anubis.AnubisWorldProvider;
import de.katzenpapst.amunra.world.horus.HorusWorldProvider;
import de.katzenpapst.amunra.world.maahes.MaahesWorldProvider;
import de.katzenpapst.amunra.world.mehen.MehenWorldProvider;
import de.katzenpapst.amunra.world.neper.NeperWorldProvider;
import de.katzenpapst.amunra.world.seth.SethWorldProvider;
import java.util.ArrayList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Moon;
import micdoodle8.mods.galacticraft.api.galaxies.Planet;
import micdoodle8.mods.galacticraft.api.galaxies.SolarSystem;
import micdoodle8.mods.galacticraft.api.galaxies.Star;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeMoon;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeOverworld;
import micdoodle8.mods.galacticraft.core.dimension.TeleportTypeSpaceStation;
import micdoodle8.mods.galacticraft.core.items.GCItems;
import micdoodle8.mods.galacticraft.core.util.CreativeTabGC;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.TeleportTypeAsteroids;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.command.ICommand;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="GalacticraftAmunRa", version="0.8.2", dependencies="required-after:GalacticraftCore@[3.0.61-GTNH,);required-after:GalacticraftMars;after:dreamcraft;after:IronChest;after:AdvancedSolarPanel;after:Hodgepodge@[2.2.19,);", name="Amun-Ra")
public class AmunRa {
    public static final String MODID = "GalacticraftAmunRa";
    public static final String MODNAME = "Amun-Ra";
    public static final String VERSION = "0.8.2";
    public static ARChannelHandler packetPipeline;
    @Mod.Instance(value="GalacticraftAmunRa")
    public static AmunRa instance;
    public static final String ASSETPREFIX = "amunra";
    public static final String TEXTUREPREFIX = "amunra:";
    public Star starRa = null;
    public Planet starAmun = null;
    public SolarSystem systemAmunRa = null;
    public Planet planetOsiris = null;
    public Planet planetHorus = null;
    public Planet planetBaal = null;
    public Planet planetAnubis = null;
    public Planet asteroidBeltMehen = null;
    public Planet planetSekhmet = null;
    public Moon moonBaalRings = null;
    public Moon moonKhonsu;
    public Moon moonNeper;
    public Moon moonIah;
    public Moon moonBastet;
    public Moon moonMaahes;
    public Moon moonThoth;
    public Moon moonSeth;
    public Moon moonKebe;
    public static CreativeTabs arTab;
    private int nextID = 0;
    public static int chestRenderId;
    public static int msBoosterRendererId;
    public static int multiOreRendererId;
    public static int dummyRendererId;
    public static final ARConfig config;
    protected ArrayList<ResourceLocation> possibleMothershipTextures = new ArrayList();
    protected ArrayList<ResourceLocation> possibleAsteroidTextures = new ArrayList();
    public static boolean isNHCoreLoaded;
    public static boolean isIronChestsLoaded;
    public static boolean isIronTanksLoaded;
    public static boolean isASPLoaded;
    @SidedProxy(clientSide="de.katzenpapst.amunra.proxy.ClientProxy", serverSide="de.katzenpapst.amunra.proxy.ServerProxy")
    public static ARSidedProxy proxy;
    public static final Logger LOGGER;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        isNHCoreLoaded = Loader.isModLoaded((String)"dreamcraft");
        isIronChestsLoaded = Loader.isModLoaded((String)"IronChest");
        isIronTanksLoaded = Loader.isModLoaded((String)"irontank");
        isASPLoaded = Loader.isModLoaded((String)"AdvancedSolarPanel");
        Configuration configFile = new Configuration(event.getSuggestedConfigurationFile());
        config.processConfig(configFile);
        ARBlocks.initBlocks();
        ARItems.initItems();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerAR());
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        GameRegistry.registerFuelHandler((IFuelHandler)new FurnaceHandler());
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/0.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/1.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/2.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/3.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/4.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/5.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/6.png"));
        this.possibleMothershipTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/mothership_icons/7.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/0.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/1.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/2.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/3.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/4.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/5.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/6.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/7.png"));
        this.possibleAsteroidTextures.add(new ResourceLocation(ASSETPREFIX, "textures/gui/asteroid_icons/8.png"));
        ConnectionPacketAR.bus = NetworkRegistry.INSTANCE.newEventDrivenChannel("amunra$connection");
        ConnectionPacketAR.bus.register((Object)new ConnectionPacketAR());
        FMLCommonHandler.instance().bus().register((Object)new ConnectionEvents());
        proxy.preInit(event);
    }

    public List<ResourceLocation> getPossibleMothershipTextures() {
        return (List)this.possibleMothershipTextures.clone();
    }

    public List<ResourceLocation> getPossibleAsteroidTextures() {
        return (List)this.possibleAsteroidTextures.clone();
    }

    public void addPossibleMothershipTexture(ResourceLocation loc) {
        this.possibleMothershipTextures.add(loc);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        arTab = new CreativeTabGC(CreativeTabs.getNextID(), "AmunRaTab", (Item)ARItems.shuttleItem, 0);
        packetPipeline = ARChannelHandler.init();
        this.initCelestialBodies();
        this.initCreatures();
        this.registerTileEntities();
        this.initOtherEntities();
        RecipeHelper.initRecipes();
        proxy.init(event);
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandShuttleTeleport());
        event.registerServerCommand((ICommand)new CommandMoveMothership());
        event.registerServerCommand((ICommand)new CommandMothershipInfo());
        event.registerServerCommand((ICommand)new CommandMothershipForceArrive());
    }

    @Mod.EventHandler
    public void serverInit(FMLServerStartedEvent event) {
        TickHandlerServer.restart();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        FMLCommonHandler.instance().bus().register((Object)new TickHandlerServer());
        TileEntityMothershipEngineJet.jetFuel = FluidRegistry.getFluid((String)AmunRa.config.validJetEngineFuel);
        TileEntityMothershipEngineIon.coolant = FluidRegistry.getFluid((String)AmunRa.config.validIonThrusterCoolant);
        this.doCompatibilityChecks();
        InteroperabilityHelper.initCompatibility();
    }

    private void doCompatibilityChecks() {
        RecipeHelper.verifyNasaWorkbenchCrafting();
        config.verifyMothershipProviderId();
    }

    public int nextInternalID() {
        ++this.nextID;
        return this.nextID - 1;
    }

    public void registerCreature(Class<? extends Entity> entityClass, String entityName, int eggBgColor, int eggFgColor) {
        int newID = EntityRegistry.findGlobalUniqueEntityId();
        EntityRegistry.registerGlobalEntityID(entityClass, (String)entityName, (int)newID, (int)eggBgColor, (int)eggFgColor);
        EntityRegistry.registerModEntity(entityClass, (String)entityName, (int)this.nextInternalID(), (Object)instance, (int)80, (int)3, (boolean)true);
    }

    public void registerNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        EntityRegistry.registerModEntity(var0, (String)var1, (int)this.nextInternalID(), (Object)instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityIsotopeGenerator.class, (String)"AmunRa Atomic Battery");
        GameRegistry.registerTileEntity(TileEntityMothershipController.class, (String)"AmunRa Mothership Controller");
        GameRegistry.registerTileEntity(TileEntityMothershipEngineJet.class, (String)"AmunRa Mothership Engine");
        GameRegistry.registerTileEntity(TileEntityMothershipSettings.class, (String)"AmunRa Mothership Settings");
        GameRegistry.registerTileEntity(TileEntityMothershipEngineBooster.class, (String)"AmunRa Mothership Engine Booster");
        GameRegistry.registerTileEntity(TileEntityMothershipEngineIon.class, (String)"AmunRa Mothership Ion Engine");
        GameRegistry.registerTileEntity(TileEntityMothershipEngineBoosterIon.class, (String)"AmunRa Mothership Ion Engine Booster");
        GameRegistry.registerTileEntity(TileEntityBlockScale.class, (String)"AmunRa Block Scale");
        GameRegistry.registerTileEntity(TileEntityShuttleDock.class, (String)"AmunRa Shuttle Dock");
        GameRegistry.registerTileEntity(TileEntityShuttleDockFake.class, (String)"AmunRa Shuttle Dock Fake");
        GameRegistry.registerTileEntity(TileEntityHydroponics.class, (String)"AmunRa Hydroponics");
        GameRegistry.registerTileEntity(TileEntityGravitation.class, (String)"AmunRa Gravity Engine");
        GameRegistry.registerTileEntity(TileEntityBossDungeonSpawner.class, (String)"AmunRa Dungeon Spawner Osiris");
        GameRegistry.registerTileEntity(TileEntityARChest.class, (String)"AmunRa Chest");
        GameRegistry.registerTileEntity(TileEntityARChestLarge.class, (String)"AmunRa Chest Large");
    }

    protected void initCreatures() {
        this.registerCreature(EntityPorcodon.class, "porcodon", 0xFF9D9D, 5227601);
        this.registerCreature(EntityARVillager.class, "alienVillagerAR", 0x292233, 10718774);
        this.registerCreature(EntityRobotVillager.class, "robotVillager", 0x626260, 0x141514);
        this.registerCreature(EntitySentry.class, "sentryRobot", 0x626260, 0x141514);
        this.registerCreature(EntityAlienBug.class, "alienBug", 4202526, 3222571);
        this.registerCreature(EntityMummyBoss.class, "osirisBoss", 4202526, 0xFFFF0B);
        this.registerTrading();
    }

    protected void initOtherEntities() {
        this.registerNonMobEntity(EntityLaserArrow.class, "laserArrow", 150, 5, true);
        this.registerNonMobEntity(EntityCryoArrow.class, "cryoArrow", 150, 5, true);
        this.registerNonMobEntity(EntityShuttle.class, "Shuttle", 150, 1, false);
        this.registerNonMobEntity(EntityShuttleFake.class, "ShuttleFake", 150, 5, false);
        this.registerNonMobEntity(EntityOsirisBossFireball.class, "cryoArrow", 150, 5, true);
    }

    protected void registerTrading() {
        RobotVillagerProfession.addProfession(new RobotVillagerProfession(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/blocks/electricFurnace.png"), "furnace").addRecipe(Items.field_151082_bd, 4, Items.field_151083_be).addRecipe(new ItemStack(Items.field_151036_c, 1), new ItemStack(Items.field_151166_bC, 6), new ItemStack(Items.field_151042_j, 3)).addRecipe(new ItemStack(Items.field_151139_aw, 1), new ItemStack(Items.field_151166_bC, 12), new ItemStack(Items.field_151042_j, 6)).addRecipe(new ItemStack(Items.field_151019_K, 1), new ItemStack(Items.field_151166_bC, 4), new ItemStack(Items.field_151042_j, 2)).addRecipe(new ItemStack(Items.field_151035_b, 1), new ItemStack(Items.field_151166_bC, 6), new ItemStack(Items.field_151042_j, 3)).addRecipe(new ItemStack(Items.field_151037_a, 1), new ItemStack(Items.field_151166_bC, 2), new ItemStack(Items.field_151042_j, 1)));
        ItemStack emptyCan = new ItemStack(GCItems.oilCanister, 1, GCItems.oilCanister.func_77612_l());
        RobotVillagerProfession.addProfession(new RobotVillagerProfession(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/blocks/machine_compressor_1.png"), "compressor").addRecipe(emptyCan, new ItemStack(Items.field_151166_bC, 24), new ItemStack(AsteroidsItems.canisterLOX, 1, 1)).addRecipe(emptyCan, new ItemStack(Items.field_151166_bC, 4), new ItemStack(AsteroidsItems.canisterLN2, 1, 1)).addRecipe(new ItemStack(Items.field_151166_bC, 2), emptyCan).addRecipe(new ItemStack(GCItems.oxTankLight, 1, GCItems.oxTankLight.func_77612_l()), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.oxTankLight, 1)).addRecipe(new ItemStack(GCItems.oxTankMedium, 1, GCItems.oxTankMedium.func_77612_l()), new ItemStack(Items.field_151166_bC, 8), new ItemStack(GCItems.oxTankMedium, 1)).addRecipe(new ItemStack(GCItems.oxTankHeavy, 1, GCItems.oxTankHeavy.func_77612_l()), new ItemStack(Items.field_151166_bC, 16), new ItemStack(GCItems.oxTankHeavy, 1)));
        RobotVillagerProfession.addProfession(new RobotVillagerProfession(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/blocks/refinery_front.png"), "refinery").addRecipe(new ItemStack(GCItems.oilCanister, 1, 1), new ItemStack(Items.field_151166_bC, 16), new ItemStack(GCItems.fuelCanister, 1, 1)).addRecipe(emptyCan, new ItemStack(Items.field_151166_bC, 26), new ItemStack(GCItems.fuelCanister, 1, 1)));
        RobotVillagerProfession.addProfession(new RobotVillagerProfession(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/blocks/electric_compressor.png"), "ingotcompressor").addRecipe(new ItemStack(Items.field_151042_j, 2), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.basicItem, 1, 11)).addRecipe(new ItemStack(GCItems.basicItem, 2, 5), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.basicItem, 1, 8)).addRecipe(new ItemStack(GCItems.basicItem, 2, 4), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.basicItem, 1, 7)).addRecipe(new ItemStack(GCItems.basicItem, 2, 3), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.basicItem, 1, 6)));
        RobotVillagerProfession.addProfession(new RobotVillagerProfession(new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/blocks/circuit_fabricator.png"), "circuitfabricator").addRecipe(new ItemStack(Items.field_151100_aR, 1, 4), new ItemStack(Items.field_151166_bC, 4), new ItemStack(GCItems.basicItem, 9, 12)).addRecipe(new ItemStack(Blocks.field_150429_aA), new ItemStack(Items.field_151166_bC, 6), new ItemStack(GCItems.basicItem, 3, 13)).addRecipe(new ItemStack(Items.field_151107_aW), new ItemStack(Items.field_151166_bC, 8), new ItemStack(GCItems.basicItem, 2, 14)).addRecipe(new ItemStack(Items.field_151079_bi), new ItemStack(Items.field_151166_bC, 10), ARItems.baseItem.getItemStack("waferEnder", 1)));
    }

    protected void initCelestialBodies() {
        this.systemAmunRa = new SolarSystem("systemAmunRa", "milkyWay");
        this.starRa = new Star("starRa");
        this.systemAmunRa.setMainStar(this.starRa).setMapPosition(new Vector3(3.0, -1.5, 0.0));
        GalaxyRegistry.registerSolarSystem((SolarSystem)this.systemAmunRa);
        this.starRa.setBodyIcon(new ResourceLocation(ASSETPREFIX, "textures/gui/celestialbodies/sun-red2.png"));
        this.starRa.setParentSolarSystem(this.systemAmunRa);
        this.starAmun = this.createPlanet("starAmun", "sun-blue.png", 0.3141592653589793, 0.7, 0.9);
        this.starAmun.setRelativeSize(3.0f);
        this.starAmun.setParentSolarSystem(this.systemAmunRa);
        GalaxyRegistry.registerPlanet((Planet)this.starAmun);
        this.planetOsiris = this.createPlanet("osiris", "planet-mercury.png", 2.5132741228718345, 0.34, 0.4);
        this.planetOsiris.setParentSolarSystem(this.systemAmunRa);
        this.planetOsiris.setRelativeSize(0.8f);
        GalaxyRegistry.registerPlanet((Planet)this.planetOsiris);
        this.planetHorus = this.createPlanet("horus", "planet-horus.png", 4.084070449666731, 0.55, 0.458);
        this.planetHorus.setRelativeSize(1.05f);
        this.planetHorus.setParentSolarSystem(this.systemAmunRa);
        this.planetHorus.setDimensionInfo(AmunRa.config.dimHorus, HorusWorldProvider.class);
        GalacticraftRegistry.registerTeleportType(HorusWorldProvider.class, (ITeleportType)new TeleportTypeMoon());
        this.planetHorus.setTierRequired(AmunRa.config.planetDefaultTier);
        GalaxyRegistry.registerPlanet((Planet)this.planetHorus);
        this.planetBaal = this.createPlanet("baal", "planet-gas03.png", 5.969026041820607, 1.2, 1.4);
        this.planetBaal.setParentSolarSystem(this.systemAmunRa);
        this.planetBaal.setRelativeSize(2.2f);
        GalaxyRegistry.registerPlanet((Planet)this.planetBaal);
        this.moonBaalRings = this.createMoon("baalRings", "micromoon.png", 1.58, 9.0, 100.0);
        this.moonBaalRings.setParentPlanet(this.planetBaal);
        GalaxyRegistry.registerMoon((Moon)this.moonBaalRings);
        this.moonKhonsu = this.createMoon("khonsu", "moon.png", 5.969026041820607, 12.45, 110.0);
        this.moonKhonsu.setParentPlanet(this.planetBaal);
        this.moonKhonsu.setRelativeSize(0.45f);
        GalaxyRegistry.registerMoon((Moon)this.moonKhonsu);
        this.moonNeper = this.createMoon("neper", "planet-life-o2.png", 1.58, 14.9, 140.0);
        this.moonNeper.atmosphere.add(IAtmosphericGas.NITROGEN);
        this.moonNeper.atmosphere.add(IAtmosphericGas.OXYGEN);
        this.moonNeper.atmosphere.add(IAtmosphericGas.ARGON);
        this.moonNeper.atmosphere.add(IAtmosphericGas.HELIUM);
        this.moonNeper.setDimensionInfo(AmunRa.config.dimNeper, NeperWorldProvider.class);
        this.moonNeper.setParentPlanet(this.planetBaal);
        this.moonNeper.setTierRequired(AmunRa.config.planetDefaultTier);
        this.moonNeper.setRelativeSize(0.89f);
        GalacticraftRegistry.registerTeleportType(NeperWorldProvider.class, (ITeleportType)new TeleportTypeOverworld());
        GalaxyRegistry.registerMoon((Moon)this.moonNeper);
        this.moonIah = this.createMoon("iah", "moon.png", 3.1, 18.5, 162.0);
        this.moonIah.setParentPlanet(this.planetBaal);
        this.moonIah.setRelativeSize(0.21f);
        GalaxyRegistry.registerMoon((Moon)this.moonIah);
        this.asteroidBeltMehen = this.createPlanet("asteroidBeltMehen", "micromoon.png", 0.5969026041820606, 1.4, 1.6);
        this.asteroidBeltMehen.setParentSolarSystem(this.systemAmunRa);
        this.asteroidBeltMehen.setDimensionInfo(AmunRa.config.dimMehen, MehenWorldProvider.class);
        this.asteroidBeltMehen.setTierRequired(AmunRa.config.planetDefaultTier);
        GalacticraftRegistry.registerTeleportType(MehenWorldProvider.class, (ITeleportType)new TeleportTypeAsteroids());
        GalaxyRegistry.registerPlanet((Planet)this.asteroidBeltMehen);
        this.planetSekhmet = this.createPlanet("sekhmet", "planet-gas02.png", 1.8849555921538759, 1.6, 1.8);
        this.planetSekhmet.setParentSolarSystem(this.systemAmunRa);
        this.planetSekhmet.setRelativeSize(2.42f);
        GalaxyRegistry.registerPlanet((Planet)this.planetSekhmet);
        this.moonBastet = this.createMoon("bast", "moon.png", 3.1, 9.8, 122.0);
        this.moonBastet.setParentPlanet(this.planetSekhmet);
        this.moonBastet.setRelativeSize(0.758f);
        GalaxyRegistry.registerMoon((Moon)this.moonBastet);
        this.moonMaahes = this.createMoon("maahes", "planet-life-ch4.png", 4.514, 11.4, 136.0);
        this.moonMaahes.setRelativeSize(0.912f);
        this.moonMaahes.setParentPlanet(this.planetSekhmet);
        this.moonMaahes.atmosphere.add(IAtmosphericGas.CO2);
        this.moonMaahes.atmosphere.add(IAtmosphericGas.METHANE);
        this.moonMaahes.atmosphere.add(IAtmosphericGas.HYDROGEN);
        this.moonMaahes.atmosphere.add(IAtmosphericGas.ARGON);
        this.moonMaahes.setDimensionInfo(AmunRa.config.dimMaahes, MaahesWorldProvider.class);
        this.moonMaahes.setTierRequired(AmunRa.config.planetDefaultTier);
        GalacticraftRegistry.registerTeleportType(MaahesWorldProvider.class, (ITeleportType)new TeleportTypeOverworld());
        GalaxyRegistry.registerMoon((Moon)this.moonMaahes);
        this.moonThoth = this.createMoon("thoth", "moon.png", 1.9, 15.5, 145.0);
        this.moonThoth.setRelativeSize(0.68f);
        this.moonThoth.setParentPlanet(this.planetSekhmet);
        GalaxyRegistry.registerMoon((Moon)this.moonThoth);
        this.moonSeth = this.createMoon("seth", "planet-ice2.png", 6.0, 17.98, 198.0);
        this.moonSeth.setRelativeSize(0.457f);
        this.moonSeth.setParentPlanet(this.planetSekhmet);
        this.moonSeth.setDimensionInfo(AmunRa.config.dimSeth, SethWorldProvider.class);
        this.moonSeth.setTierRequired(AmunRa.config.planetDefaultTier);
        GalacticraftRegistry.registerTeleportType(SethWorldProvider.class, (ITeleportType)new TeleportTypeMoon());
        GalaxyRegistry.registerMoon((Moon)this.moonSeth);
        this.planetAnubis = this.createPlanet("anubis", "moon.png", 1.1309733552923256, 1.9, 2.2);
        this.planetAnubis.setParentSolarSystem(this.systemAmunRa);
        this.planetAnubis.setDimensionInfo(AmunRa.config.dimAnubis, AnubisWorldProvider.class);
        this.planetAnubis.setRelativeSize(0.65f);
        GalacticraftRegistry.registerTeleportType(AnubisWorldProvider.class, (ITeleportType)new TeleportTypeMoon());
        this.planetAnubis.setTierRequired(AmunRa.config.planetDefaultTier);
        GalaxyRegistry.registerPlanet((Planet)this.planetAnubis);
        this.moonKebe = this.createMoon("kebe", "moon.png", 5.1, 19.0, 253.0);
        this.moonKebe.setRelativeSize(0.32f);
        this.moonKebe.setParentPlanet(this.planetAnubis);
        GalaxyRegistry.registerMoon((Moon)this.moonKebe);
        boolean flag = DimensionManager.registerProviderType((int)AmunRa.config.mothershipProviderID, MothershipWorldProvider.class, (boolean)false);
        if (!flag) {
            throw new RuntimeException("Could not register provider mothership provider ID. Please change I:mothershipProviderID in the config.");
        }
        GalacticraftRegistry.registerTeleportType(MothershipWorldProvider.class, (ITeleportType)new TeleportTypeSpaceStation());
        config.setStaticConfigValues();
    }

    protected Planet createPlanet(String name, String texture, double phaseShift, double distance, double orbitTime) {
        Planet pl = new Planet(name);
        this.setCelestialBodyStuff((CelestialBody)pl, texture, phaseShift, distance, orbitTime);
        return pl;
    }

    protected Moon createMoon(String name, String texture, double phaseShift, double distance, double orbitTime) {
        Moon pl = new Moon(name);
        this.setCelestialBodyStuff((CelestialBody)pl, texture, phaseShift, distance, orbitTime);
        return pl;
    }

    protected void setCelestialBodyStuff(CelestialBody body, String texture, double phaseShift, double distance, double orbitTime) {
        body.setBodyIcon(new ResourceLocation(ASSETPREFIX, "textures/gui/celestialbodies/" + texture)).setPhaseShift((float)phaseShift).setRelativeDistanceFromCenter(new CelestialBody.ScalableDistance((float)distance, (float)distance)).setRelativeOrbitTime((float)orbitTime);
    }

    public static boolean isDevEnvironment() {
        return (Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment");
    }

    static {
        config = new ARConfig();
        LOGGER = LogManager.getLogger((String)MODNAME);
    }
}

