/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.thaumcraft.research.frontend.integration.table.gui.component;

import elan.tweaks.common.gui.component.UIContext;
import elan.tweaks.common.gui.component.dragndrop.DragAndDropUIComponent;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.thaumcraft.research.frontend.domain.ports.provided.AspectPalletPort;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import thaumcraft.api.aspects.Aspect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u0011\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lelan/tweaks/thaumcraft/research/frontend/integration/table/gui/component/AspectDragAndDropUIComponent;", "Lelan/tweaks/common/gui/component/dragndrop/DragAndDropUIComponent;", "pallet", "Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectPalletPort;", "<init>", "(Lelan/tweaks/thaumcraft/research/frontend/domain/ports/provided/AspectPalletPort;)V", "draggable", "Lthaumcraft/api/aspects/Aspect;", "onAttemptDrag", "", "", "uiMousePosition", "Lelan/tweaks/common/gui/dto/VectorXY;", "context", "Lelan/tweaks/common/gui/component/UIContext;", "onDropping", "onDragClick", "onDragging", "ThaumcraftResearchTweaks"})
public final class AspectDragAndDropUIComponent
implements DragAndDropUIComponent {
    @NotNull
    private final AspectPalletPort pallet;
    @Nullable
    private Aspect draggable;

    public AspectDragAndDropUIComponent(@NotNull AspectPalletPort pallet) {
        Intrinsics.checkNotNullParameter((Object)pallet, (String)"pallet");
        this.pallet = pallet;
    }

    @Override
    public void onAttemptDrag(@NotNull Object draggable, @NotNull VectorXY uiMousePosition, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)draggable, (String)"draggable");
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (this.draggable != null || !(draggable instanceof Aspect)) {
            return;
        }
        this.draggable = (Aspect)draggable;
    }

    @Override
    @Nullable
    public Object onDropping(@NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Aspect aspect = this.draggable;
        if (aspect == null) {
            return null;
        }
        Aspect droppedAspect = aspect;
        this.draggable = null;
        return droppedAspect;
    }

    @Override
    @Nullable
    public Object onDragClick(@NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.draggable;
    }

    @Override
    public void onDragging(@NotNull VectorXY uiMousePosition, @NotNull UIContext context) {
        Intrinsics.checkNotNullParameter((Object)uiMousePosition, (String)"uiMousePosition");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Aspect aspect = this.draggable;
        if (aspect == null) {
            return;
        }
        Aspect draggedAspect = aspect;
        if (this.pallet.isDrainedOf(draggedAspect)) {
            this.draggable = null;
            return;
        }
        context.drawOrb(uiMousePosition, draggedAspect.getColor());
    }

    @Override
    public void onAttemptDrag(@NotNull List<? extends Object> draggables, @NotNull VectorXY uiMousePosition, @NotNull UIContext context) {
        DragAndDropUIComponent.DefaultImpls.onAttemptDrag(this, draggables, uiMousePosition, context);
    }
}

