/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.layout.grid;

import elan.tweaks.common.gui.dto.Rectangle;
import elan.tweaks.common.gui.dto.Vector2D;
import elan.tweaks.common.gui.dto.VectorXY;
import elan.tweaks.common.gui.layout.grid.GridLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B+\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002J\u0018\u0010\u0015\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0013\u001a\u00020\u0014H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u001a\u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00028\u00000\u00190\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0006H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lelan/tweaks/common/gui/layout/grid/GridLayoutDynamicListAdapter;", "ElementT", "Lelan/tweaks/common/gui/layout/grid/GridLayout;", "bounds", "Lelan/tweaks/common/gui/dto/Rectangle;", "cellSize", "", "provideElements", "Lkotlin/Function0;", "", "<init>", "(Lelan/tweaks/common/gui/dto/Rectangle;ILkotlin/jvm/functions/Function0;)V", "elements", "getElements", "()Ljava/util/List;", "dimensions", "Lelan/tweaks/common/gui/dto/Vector2D;", "contains", "", "uiPoint", "Lelan/tweaks/common/gui/dto/VectorXY;", "get", "(Lelan/tweaks/common/gui/dto/VectorXY;)Ljava/lang/Object;", "deduceIndex", "asOriginList", "Lkotlin/Pair;", "toCellOrigin", "index", "ThaumcraftResearchTweaks"})
@SourceDebugExtension(value={"SMAP\nGridLayoutDynamicListAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GridLayoutDynamicListAdapter.kt\nelan/tweaks/common/gui/layout/grid/GridLayoutDynamicListAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,48:1\n1567#2:49\n1598#2,4:50\n*S KotlinDebug\n*F\n+ 1 GridLayoutDynamicListAdapter.kt\nelan/tweaks/common/gui/layout/grid/GridLayoutDynamicListAdapter\n*L\n42#1:49\n42#1:50,4\n*E\n"})
public final class GridLayoutDynamicListAdapter<ElementT>
implements GridLayout<ElementT> {
    @NotNull
    private final Rectangle bounds;
    private final int cellSize;
    @NotNull
    private final Function0<List<ElementT>> provideElements;
    @NotNull
    private final Vector2D dimensions;

    public GridLayoutDynamicListAdapter(@NotNull Rectangle bounds, int cellSize, @NotNull Function0<? extends List<? extends ElementT>> provideElements) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(provideElements, (String)"provideElements");
        this.bounds = bounds;
        this.cellSize = cellSize;
        this.provideElements = provideElements;
        this.dimensions = new Vector2D(this.bounds.getScale().getWidth() / this.cellSize, this.bounds.getScale().getHeight() / this.cellSize);
    }

    private final List<ElementT> getElements() {
        return (List)this.provideElements.invoke();
    }

    @Override
    public boolean contains(@NotNull VectorXY uiPoint) {
        Intrinsics.checkNotNullParameter((Object)uiPoint, (String)"uiPoint");
        return this.bounds.contains(uiPoint);
    }

    @Override
    @Nullable
    public ElementT get(@NotNull VectorXY uiPoint) {
        Intrinsics.checkNotNullParameter((Object)uiPoint, (String)"uiPoint");
        if (!this.bounds.contains(uiPoint)) {
            return null;
        }
        int elementIndex = this.deduceIndex(uiPoint);
        return (0 <= elementIndex ? elementIndex < ((Collection)this.getElements()).size() : false) ? (ElementT)this.getElements().get(elementIndex) : null;
    }

    private final int deduceIndex(VectorXY uiPoint) {
        VectorXY point = uiPoint.minus(this.bounds.getOrigin());
        int columnIndex = RangesKt.coerceAtMost((int)(point.getX() / this.cellSize), (int)(this.dimensions.getX() - 1));
        int rowIndex = RangesKt.coerceAtMost((int)(point.getY() / this.cellSize), (int)(this.dimensions.getY() - 1));
        return columnIndex + rowIndex * this.dimensions.getX();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Pair<Vector2D, ElementT>> asOriginList() {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = this.getElements();
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void element;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(TuplesKt.to((Object)this.toCellOrigin((int)index), (Object)element));
        }
        return (List)destination$iv$iv;
    }

    private final Vector2D toCellOrigin(int index) {
        return new Vector2D(index % this.dimensions.getX() * this.cellSize, index / this.dimensions.getX() * this.cellSize).plus(this.bounds.getOrigin());
    }
}

