/*
 * Decompiled with CFR 0.152.
 */
package elan.tweaks.common.gui.dto;

import elan.tweaks.common.gui.dto.Scale;
import elan.tweaks.common.gui.dto.VectorXY;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0003H\u0086\u0002J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00112\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\u00038BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\r\u0010\t\u00a8\u0006\u001e"}, d2={"Lelan/tweaks/common/gui/dto/Rectangle;", "", "origin", "Lelan/tweaks/common/gui/dto/VectorXY;", "scale", "Lelan/tweaks/common/gui/dto/Scale;", "<init>", "(Lelan/tweaks/common/gui/dto/VectorXY;Lelan/tweaks/common/gui/dto/Scale;)V", "getOrigin", "()Lelan/tweaks/common/gui/dto/VectorXY;", "getScale", "()Lelan/tweaks/common/gui/dto/Scale;", "originScaled", "getOriginScaled", "originScaled$delegate", "Lkotlin/Lazy;", "contains", "", "point", "plus", "offset", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "ThaumcraftResearchTweaks"})
public final class Rectangle {
    @NotNull
    private final VectorXY origin;
    @NotNull
    private final Scale scale;
    @NotNull
    private final Lazy originScaled$delegate;

    public Rectangle(@NotNull VectorXY origin, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        this.origin = origin;
        this.scale = scale;
        this.originScaled$delegate = LazyKt.lazy(() -> Rectangle.originScaled_delegate$lambda$0(this));
    }

    @NotNull
    public final VectorXY getOrigin() {
        return this.origin;
    }

    @NotNull
    public final Scale getScale() {
        return this.scale;
    }

    private final VectorXY getOriginScaled() {
        Lazy lazy = this.originScaled$delegate;
        return (VectorXY)lazy.getValue();
    }

    public final boolean contains(@NotNull VectorXY point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.origin.compareTo(point) < 0 && point.compareTo(this.getOriginScaled()) < 0;
    }

    @NotNull
    public final Rectangle plus(@NotNull VectorXY offset) {
        Intrinsics.checkNotNullParameter((Object)offset, (String)"offset");
        return new Rectangle(this.origin.plus(offset), this.scale);
    }

    @NotNull
    public final VectorXY component1() {
        return this.origin;
    }

    @NotNull
    public final Scale component2() {
        return this.scale;
    }

    @NotNull
    public final Rectangle copy(@NotNull VectorXY origin, @NotNull Scale scale) {
        Intrinsics.checkNotNullParameter((Object)origin, (String)"origin");
        Intrinsics.checkNotNullParameter((Object)scale, (String)"scale");
        return new Rectangle(origin, scale);
    }

    public static /* synthetic */ Rectangle copy$default(Rectangle rectangle, VectorXY vectorXY, Scale scale, int n, Object object) {
        if ((n & 1) != 0) {
            vectorXY = rectangle.origin;
        }
        if ((n & 2) != 0) {
            scale = rectangle.scale;
        }
        return rectangle.copy(vectorXY, scale);
    }

    @NotNull
    public String toString() {
        return "Rectangle(origin=" + this.origin + ", scale=" + this.scale + ')';
    }

    public int hashCode() {
        int result = this.origin.hashCode();
        result = result * 31 + this.scale.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rectangle)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)other;
        if (!Intrinsics.areEqual((Object)this.origin, (Object)rectangle.origin)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.scale, (Object)rectangle.scale);
    }

    private static final VectorXY originScaled_delegate$lambda$0(Rectangle this$0) {
        return this$0.origin.plus(this$0.scale);
    }
}

