/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture.common.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gcewing.architecture.common.network.ChannelInput;
import gcewing.architecture.common.network.ChannelOutput;
import gcewing.architecture.common.network.ClientMessageHandler;
import gcewing.architecture.common.network.DataHandler;
import gcewing.architecture.common.network.DataPacket;
import gcewing.architecture.common.network.HandlerMap;
import gcewing.architecture.common.network.ServerMessageHandler;
import io.netty.channel.ChannelHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.player.EntityPlayer;

public class DataChannel {
    public final String name;
    public final List handlers = new ArrayList();
    protected final EnumMap<Side, FMLEmbeddedChannel> pipes;

    public DataChannel(String name, Object ... handlers) {
        this.name = name;
        DataHandler handler = new DataHandler(this);
        this.pipes = NetworkRegistry.INSTANCE.newChannel(name, new ChannelHandler[]{handler});
        this.handlers.add(this);
        this.handlers.addAll(Arrays.asList(handlers));
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target) {
        return this.openTarget(message, fromSide, target, null);
    }

    protected ChannelOutput openTarget(String message, Side fromSide, FMLOutboundHandler.OutboundTarget target, Object arg) {
        DataPacket out = new DataPacket(this, fromSide, target, arg);
        out.writeUTF(message);
        return out;
    }

    public ChannelOutput openServer(String message) {
        return this.openTarget(message, Side.CLIENT, FMLOutboundHandler.OutboundTarget.TOSERVER);
    }

    public ChannelOutput openPlayer(EntityPlayer player, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.PLAYER, player);
    }

    public ChannelOutput openAllPlayers(String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALL);
    }

    public ChannelOutput openAllAround(NetworkRegistry.TargetPoint point, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, point);
    }

    public ChannelOutput openDimension(int dimensionId, String message) {
        return this.openTarget(message, Side.SERVER, FMLOutboundHandler.OutboundTarget.DIMENSION, dimensionId);
    }

    public ChannelOutput openServerContainer(String message) {
        ChannelOutput out = this.openServer(".container.");
        out.writeUTF(message);
        return out;
    }

    public ChannelOutput openClientContainer(EntityPlayer player, String message) {
        ChannelOutput out = this.openPlayer(player, ".container.");
        out.writeUTF(message);
        return out;
    }

    @ServerMessageHandler(value=".container.")
    public void onServerContainerMessage(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        DataChannel.doServerDispatch(player.field_71070_bA, message, player, data);
    }

    @SideOnly(value=Side.CLIENT)
    @ClientMessageHandler(value=".container.")
    public void onClientContainerMessage(ChannelInput data) {
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        String message = data.readUTF();
        DataChannel.doClientDispatch(player.field_71070_bA, message, data);
    }

    protected void onReceiveFromClient(EntityPlayer player, ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!DataChannel.serverDispatch(h, message, player, data)) continue;
            return;
        }
    }

    public static void doServerDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        DataChannel.serverDispatch(handler, message, player, data);
    }

    public static boolean serverDispatch(Object handler, String message, EntityPlayer player, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.SERVER.get(handler, message)) != null) {
            try {
                meth.invoke(handler, player, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling server-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }

    protected void onReceiveFromServer(ChannelInput data) {
        String message = data.readUTF();
        for (Object h : this.handlers) {
            if (!DataChannel.clientDispatch(h, message, data)) continue;
            return;
        }
    }

    public static void doClientDispatch(Object handler, String message, ChannelInput data) {
        DataChannel.clientDispatch(handler, message, data);
    }

    public static boolean clientDispatch(Object handler, String message, ChannelInput data) {
        Method meth;
        if (handler != null && (meth = HandlerMap.CLIENT.get(handler, message)) != null) {
            try {
                meth.invoke(handler, data);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Exception while calling client-side handler %s.%s for message %s", handler.getClass().getName(), meth.getName(), message), e);
            }
            return true;
        }
        return false;
    }
}

