/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.lib;

import com.google.common.collect.PeekingIterator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.NotImplementedException;

public class PeekableIterator<E>
implements PeekingIterator<E> {
    @Nonnull
    private final Iterator<E> wrappedIterator;
    private boolean peeking = false;
    private E peekedValue = null;

    public PeekableIterator(Iterator<E> wrappedIterator) {
        this.wrappedIterator = wrappedIterator;
    }

    public E peek() {
        if (this.peeking) {
            return this.peekedValue;
        }
        this.peekedValue = this.wrappedIterator.next();
        this.peeking = true;
        return this.peekedValue;
    }

    public boolean hasNext() {
        return this.peeking || this.wrappedIterator.hasNext();
    }

    public E next() {
        if (this.peeking) {
            E result = this.peekedValue;
            this.peekedValue = null;
            this.peeking = false;
            return result;
        }
        return this.wrappedIterator.next();
    }

    public void remove() {
        throw new NotImplementedException("Not worth implementing right now");
    }
}

