/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.common.commands.arguments;

import dev.rndmorris.salisarcana.SalisArcana;
import dev.rndmorris.salisarcana.common.commands.CommandErrors;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.FlagArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.NamedArg;
import dev.rndmorris.salisarcana.common.commands.arguments.annotations.PositionalArg;
import dev.rndmorris.salisarcana.common.commands.arguments.handlers.IArgumentHandler;
import dev.rndmorris.salisarcana.lib.ClassComparator;
import dev.rndmorris.salisarcana.lib.PeekableIterator;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;

public class ArgumentProcessor<TArguments> {
    private final Map<Class<? extends IArgumentHandler>, IArgumentHandler> argumentHandlers = new TreeMap<Class<? extends IArgumentHandler>, IArgumentHandler>(new ClassComparator());
    private final Class<TArguments> argumentsClass;
    private final Supplier<TArguments> initializer;
    private final Map<Integer, ArgEntry> positionalArgs = new TreeMap<Integer, ArgEntry>();
    private final Map<String, ArgEntry> flagArgs = new TreeMap<String, ArgEntry>();
    private final Map<String, ArgEntry> namedArgs = new TreeMap<String, ArgEntry>();
    public final List<String> descriptionLangKeys = new ArrayList<String>();

    public ArgumentProcessor(Class<TArguments> argumentsClass, Supplier<TArguments> initializer, IArgumentHandler[] argumentHandlers) {
        this.argumentsClass = argumentsClass;
        this.initializer = initializer;
        for (IArgumentHandler handler : argumentHandlers) {
            this.argumentHandlers.put(handler.getClass(), handler);
        }
        this.buildArgumentMaps();
    }

    public TArguments process(ICommandSender sender, String[] args) {
        TreeSet<String> excludedNames = new TreeSet<String>(String::compareToIgnoreCase);
        TArguments arguments = this.initializer.get();
        PeekableIterator<String> $args = new PeekableIterator<String>(Arrays.stream(args).iterator());
        int index = 0;
        while ($args.hasNext()) {
            String current = null;
            ArgEntry entry = null;
            if (this.positionalArgs.containsKey(index)) {
                entry = this.positionalArgs.get(index);
            } else {
                current = (String)$args.next();
                if (this.flagArgs.containsKey(current)) {
                    entry = this.flagArgs.get(current);
                } else if (this.namedArgs.containsKey(current)) {
                    entry = this.namedArgs.get(current);
                }
            }
            if (entry != null && (entry.argType == ArgType.FLAG || entry.argType == ArgType.NAMED)) {
                if (excludedNames.contains(current)) {
                    entry = null;
                } else {
                    if (!entry.isList) {
                        excludedNames.add(current);
                    }
                    excludedNames.addAll(entry.excludes);
                }
            }
            if (entry == null) {
                throw new CommandException("salisarcana:error.unexpected_value", new Object[]{current});
            }
            if (entry.argType == ArgType.NAMED && !$args.hasNext()) {
                CommandErrors.invalidSyntax();
            }
            Object value = entry.handler.parse(sender, $args);
            entry.fieldSetter.accept(arguments, value);
            ++index;
        }
        return arguments;
    }

    public List<String> getAutocompletionSuggestions(ICommandSender sender, String[] args) {
        TreeSet<String> excludedNames = new TreeSet<String>();
        PeekableIterator<String> $args = new PeekableIterator<String>(Arrays.stream(args).iterator());
        int index = 0;
        while ($args.hasNext()) {
            String current = null;
            ArgEntry entry = null;
            if (this.positionalArgs.containsKey(index)) {
                entry = this.positionalArgs.get(index);
            } else {
                current = (String)$args.next();
                if (this.flagArgs.containsKey(current)) {
                    entry = this.flagArgs.get(current);
                } else if (this.namedArgs.containsKey(current)) {
                    entry = this.namedArgs.get(current);
                }
            }
            if (entry != null && (entry.argType == ArgType.FLAG || entry.argType == ArgType.NAMED)) {
                if (excludedNames.contains(current)) {
                    entry = null;
                } else {
                    if (!entry.isList) {
                        excludedNames.add(current);
                    }
                    excludedNames.addAll(entry.excludes);
                }
            }
            if (entry == null || !$args.hasNext()) {
                Stream<String> availableFlags = this.flagArgs.keySet().stream().filter(k -> !excludedNames.contains(k));
                Stream<String> availableNames = this.namedArgs.keySet().stream().filter(k -> !excludedNames.contains(k));
                return Stream.concat(availableFlags, availableNames).collect(Collectors.toList());
            }
            List<String> result = entry.handler.getAutocompleteOptions(sender, $args);
            if (result != null) {
                return result;
            }
            ++index;
        }
        return Collections.emptyList();
    }

    private void buildArgumentMaps() {
        for (Field field : this.argumentsClass.getFields()) {
            Class<?> expectedOutput;
            field.setAccessible(true);
            ArgEntry entry = new ArgEntry();
            if (!this.evaluatePositionalArg(field, entry) && !this.evaluateFlagArg(field, entry) && !this.evaluateNamedArg(field, entry)) continue;
            Class<?> fieldType = field.getType();
            Class<?> outputType = entry.handler.getOutputType();
            if (fieldType.isInterface()) {
                throw new RuntimeException(String.format("Argument field \"%s\" on %s must be a concrete type, not an interface.", field.getName(), this.argumentsClass.getName()));
            }
            entry.isList = List.class.isAssignableFrom(fieldType);
            boolean outputIsList = List.class.isAssignableFrom(outputType);
            if (!entry.isList && outputIsList) {
                throw new RuntimeException(String.format("Handler output (%s) is not assignable to target field %s (%s) on %s.", outputType, field.getName(), field.getType(), this.argumentsClass.getName()));
            }
            if (!outputIsList && !(expectedOutput = this.getExpectedOutputClass(field, entry, fieldType)).isAssignableFrom(entry.handler.getOutputType())) {
                throw new RuntimeException(String.format("Handler output (%s) is not assignable to target field %s (%s) on %s", entry.handler.getOutputType(), field.getName(), expectedOutput, this.argumentsClass.getName()));
            }
            entry.fieldSetter = entry.isList ? (arguments, val) -> {
                try {
                    ArrayList<Object> list;
                    Object fieldObj = field.get(arguments);
                    if (fieldObj == null) {
                        list = new ArrayList<Object>();
                        field.set(arguments, list);
                    } else {
                        list = (ArrayList<Object>)fieldObj;
                    }
                    if (val instanceof List) {
                        List listVal = (List)val;
                        list.addAll(listVal);
                    } else {
                        list.add(val);
                    }
                }
                catch (IllegalAccessException e) {
                    SalisArcana.LOG.error((Object)e);
                }
            } : (arguments, val) -> {
                try {
                    field.set(arguments, val);
                }
                catch (IllegalAccessException e) {
                    SalisArcana.LOG.error((Object)e);
                }
            };
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Class<?> getExpectedOutputClass(Field field, ArgEntry entry, Class<?> fieldType) {
        ParameterizedType parameterizedType;
        if (!entry.isList) return fieldType;
        Type type = field.getGenericType();
        if (!(type instanceof ParameterizedType) || !((type = (parameterizedType = (ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class)) throw new RuntimeException(String.format("Could not get generic type from field \"%s\" on %s.", field.getName(), this.argumentsClass.getName()));
        Class typeInList = (Class)type;
        return typeInList;
    }

    private boolean evaluatePositionalArg(Field field, ArgEntry entry) {
        PositionalArg posArg = field.getAnnotation(PositionalArg.class);
        if (posArg == null) {
            return false;
        }
        this.positionalArgs.put(posArg.index(), entry);
        entry.handler = this.argumentHandlers.get(posArg.handler());
        if (entry.handler == null) {
            SalisArcana.LOG.error(String.format("No parser found for positional argument at index %d", posArg.index()));
            throw new RuntimeException();
        }
        if (!posArg.descLangKey().isEmpty()) {
            this.descriptionLangKeys.add(posArg.descLangKey());
        }
        entry.argType = ArgType.POS;
        return true;
    }

    private boolean evaluateFlagArg(Field field, ArgEntry entry) {
        FlagArg flagArg = field.getAnnotation(FlagArg.class);
        if (flagArg == null) {
            return false;
        }
        this.flagArgs.put(flagArg.name(), entry);
        entry.handler = this.argumentHandlers.get(flagArg.handler());
        if (entry.handler == null) {
            SalisArcana.LOG.error(String.format("No parser found for named argument at %s", flagArg.name()));
            throw new RuntimeException();
        }
        if (!flagArg.descLangKey().isEmpty()) {
            this.descriptionLangKeys.add(flagArg.descLangKey());
        }
        entry.excludes = Arrays.stream(flagArg.excludes()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        entry.argType = ArgType.FLAG;
        return true;
    }

    private boolean evaluateNamedArg(Field field, ArgEntry entry) {
        NamedArg namedArg = field.getAnnotation(NamedArg.class);
        if (namedArg == null) {
            return false;
        }
        this.namedArgs.put(namedArg.name(), entry);
        entry.handler = this.argumentHandlers.get(namedArg.handler());
        if (entry.handler == null) {
            SalisArcana.LOG.error(String.format("No parser found for named argument at %s", namedArg.name()));
            throw new RuntimeException();
        }
        if (!namedArg.descLangKey().isEmpty()) {
            this.descriptionLangKeys.add(namedArg.descLangKey());
        }
        entry.excludes = Arrays.stream(namedArg.excludes()).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        entry.argType = ArgType.NAMED;
        return true;
    }

    private static class ArgEntry {
        public IArgumentHandler handler;
        public BiConsumer<Object, Object> fieldSetter;
        public boolean isList;
        public List<String> excludes = Collections.emptyList();
        public ArgType argType;

        private ArgEntry() {
        }
    }

    private static enum ArgType {
        POS,
        FLAG,
        NAMED;

    }
}

