/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.utils;

import gcewing.sg.blocks.base.BaseBlock;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.utils.BaseUtils;
import gcewing.sg.utils.EnumWorldBlockLayer;
import gcewing.sg.utils.blockstates.MetaBlockState;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.joml.Vector3i;
import org.joml.Vector3ic;

public class BaseBlockUtils {
    public static boolean blockIsGettingExternallyPowered(World world, Vector3i pos) {
        for (EnumFacing side : BaseUtils.facings) {
            if (!BaseBlockUtils.isPoweringSide(world, new Vector3i(side.func_82601_c(), side.func_96559_d(), side.func_82599_e()).add((Vector3ic)pos), side)) continue;
            return true;
        }
        return false;
    }

    static boolean isPoweringSide(World world, Vector3i pos, EnumFacing side) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        if (block.func_149709_b((IBlockAccess)world, pos.x, pos.y, pos.z, side.ordinal()) > 0) {
            return true;
        }
        if (block.shouldCheckWeakPower((IBlockAccess)world, pos.x, pos.y, pos.z, side.ordinal())) {
            for (EnumFacing side2 : BaseUtils.facings) {
                if (side2 == BaseUtils.oppositeFacing(side)) continue;
                Vector3i pos2 = new Vector3i(side2.func_82601_c(), side2.func_96559_d(), side2.func_82599_e()).add((Vector3ic)pos);
                Block block2 = world.func_147439_a(pos2.x, pos2.y, pos2.z);
                if (block2.func_149748_c((IBlockAccess)world, pos2.x, pos2.y, pos2.z, side2.ordinal()) <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public static IBlockState getBlockStateFromItemStack(ItemStack stack) {
        Block block = Block.func_149634_a((Item)stack.func_77973_b());
        int meta = 0;
        if (stack.func_77973_b().func_77614_k()) {
            meta = stack.func_77973_b().func_77647_b(stack.func_77960_j());
        }
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static IBlockState getBlockStateFromMeta(Block block, int meta) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static int getMetaFromBlockState(IBlockState state) {
        if (state instanceof MetaBlockState) {
            return ((MetaBlockState)state).meta;
        }
        return ((BaseBlock)state.getBlock()).getMetaFromState(state);
    }

    public static Block getWorldBlock(IBlockAccess world, Vector3i pos) {
        return world.func_147439_a(pos.x, pos.y, pos.z);
    }

    public static IBlockState getWorldBlockState(IBlockAccess world, Vector3i pos) {
        Block block = world.func_147439_a(pos.x, pos.y, pos.z);
        int meta = world.func_72805_g(pos.x, pos.y, pos.z);
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static IBlockState getWorldBlockState(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        int meta = world.func_72805_g(x, y, z);
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).getStateFromMeta(meta);
        }
        return new MetaBlockState(block, meta);
    }

    public static void markWorldBlockForUpdate(World world, Vector3i pos) {
        world.func_147471_g(pos.x, pos.y, pos.z);
    }

    public static void notifyWorldNeighborsOfStateChange(World world, Vector3i pos, Block block) {
        world.func_147459_d(pos.x, pos.y, pos.z, block);
    }

    public static TileEntity getWorldTileEntity(IBlockAccess world, Vector3i pos) {
        return world.func_147438_o(pos.x, pos.y, pos.z);
    }

    public static World getTileEntityWorld(TileEntity te) {
        return te.func_145831_w();
    }

    public static Vector3i getTileEntityPos(TileEntity te) {
        return new Vector3i(te.field_145851_c, te.field_145848_d, te.field_145849_e);
    }

    public static boolean blockCanRenderInLayer(Block block, EnumWorldBlockLayer layer) {
        if (block instanceof BaseBlock) {
            return ((BaseBlock)block).canRenderInLayer(layer);
        }
        switch (layer) {
            case SOLID: {
                return block.canRenderInPass(0);
            }
            case TRANSLUCENT: {
                return block.canRenderInPass(1);
            }
        }
        return false;
    }
}

