/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.compat.cc;

import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import gcewing.sg.compat.cc.CCCall;
import gcewing.sg.compat.cc.CCMethod;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class CCMethodQueue {
    public static CCMethodQueue instance;
    Queue<CCCall> items = new ConcurrentLinkedQueue<CCCall>();

    public static void init() {
        instance = new CCMethodQueue();
    }

    public static void onServerTick() {
        if (instance != null) {
            instance.tick();
        }
    }

    public Object[] invoke(IComputerAccess cpu, ILuaContext ctx, Object target, CCMethod method, Object[] args) throws LuaException, InterruptedException {
        CCCall item = new CCCall(cpu, ctx, target, method, args);
        this.items.add(item);
        item.lock.acquire();
        if (item.exception == null) {
            return item.result;
        }
        throw item.exception;
    }

    void tick() {
        int n = this.items.size();
        while (n-- > 0) {
            CCCall item = this.items.poll();
            if (item == null) {
                return;
            }
            try {
                item.result = item.method.invoke(item.cpu, item.ctx, item.target, item.args);
            }
            catch (LuaException e) {
                item.exception = e;
            }
            catch (Exception e) {
                item.exception = new LuaException(e.getMessage());
            }
            item.lock.release();
        }
    }
}

