/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.utils;

import com.google.auto.value.AutoValue;
import com.recursive_pineapple.matter_manipulator.common.utils.AutoValue_ItemId;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

@AutoValue
public abstract class ItemId {
    public static ItemId create(NBTTagCompound tag) {
        return new AutoValue_ItemId(Item.func_150899_d((int)tag.func_74765_d("item")), tag.func_74765_d("meta"), tag.func_150297_b("tag", 10) ? tag.func_74775_l("tag") : null, tag.func_150297_b("stackSize", 3) ? Integer.valueOf(tag.func_74762_e("stackSize")) : null);
    }

    public static ItemId create(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_ItemId(itemStack.func_77973_b(), Items.field_151008_G.getDamage(itemStack), nbt, null);
    }

    public static ItemId createWithStackSize(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_ItemId(itemStack.func_77973_b(), Items.field_151008_G.getDamage(itemStack), nbt, itemStack.field_77994_a);
    }

    public static ItemId create(Item item, int metaData, @Nullable NBTTagCompound nbt) {
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_ItemId(item, metaData, nbt, null);
    }

    public static ItemId create(Item item, int metaData, @Nullable NBTTagCompound nbt, @Nullable Integer stackSize) {
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_ItemId(item, metaData, nbt, stackSize);
    }

    public static ItemId createAsWildcard(ItemStack itemStack) {
        return new AutoValue_ItemId(itemStack.func_77973_b(), Short.MAX_VALUE, null, null);
    }

    public static ItemId createAsWildcardWithNBT(ItemStack itemStack) {
        NBTTagCompound nbt = itemStack.func_77978_p();
        if (nbt != null) {
            nbt = (NBTTagCompound)nbt.func_74737_b();
        }
        return new AutoValue_ItemId(itemStack.func_77973_b(), Short.MAX_VALUE, nbt, null);
    }

    public static ItemId createWithoutNBT(ItemStack itemStack) {
        return new AutoValue_ItemId(itemStack.func_77973_b(), Items.field_151008_G.getDamage(itemStack), null, null);
    }

    public static ItemId createNoCopy(ItemStack itemStack) {
        return new AutoValue_ItemId(itemStack.func_77973_b(), Items.field_151008_G.getDamage(itemStack), itemStack.func_77978_p(), null);
    }

    public static ItemId createNoCopyWithStackSize(ItemStack itemStack) {
        return new AutoValue_ItemId(itemStack.func_77973_b(), Items.field_151008_G.getDamage(itemStack), itemStack.func_77978_p(), itemStack.field_77994_a);
    }

    public static ItemId createNoCopy(Item item, int metaData, @Nullable NBTTagCompound nbt) {
        return new AutoValue_ItemId(item, metaData, nbt, null);
    }

    protected abstract Item item();

    protected abstract int metaData();

    @Nullable
    protected abstract NBTTagCompound nbt();

    @Nullable
    protected abstract Integer stackSize();

    public NBTTagCompound writeToNBT() {
        Integer s;
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74777_a("item", (short)Item.func_150891_b((Item)this.item()));
        tag.func_74777_a("meta", (short)this.metaData());
        if (this.nbt() != null) {
            tag.func_74782_a("tag", (NBTBase)this.nbt());
        }
        if ((s = this.stackSize()) != null) {
            tag.func_74768_a("stackSize", s.intValue());
        }
        return tag;
    }

    @Nonnull
    public ItemStack getItemStack() {
        ItemStack itemStack = new ItemStack(this.item(), 1, this.metaData());
        NBTTagCompound nbt = this.nbt();
        itemStack.func_77982_d(nbt == null ? null : (NBTTagCompound)nbt.func_74737_b());
        return itemStack;
    }

    @Nonnull
    public ItemStack getItemStack(int stackSize) {
        ItemStack itemStack = new ItemStack(this.item(), stackSize, this.metaData());
        NBTTagCompound nbt = this.nbt();
        itemStack.func_77982_d(nbt == null ? null : (NBTTagCompound)nbt.func_74737_b());
        return itemStack;
    }

    public boolean isSameAs(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.item() != stack.func_77973_b()) {
            return false;
        }
        if (this.metaData() != Items.field_151008_G.getDamage(stack)) {
            return false;
        }
        return Objects.equals(this.nbt(), stack.func_77978_p());
    }
}

