/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.uplink;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.implementations.IPowerChannelState;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.crafting.ICraftingGrid;
import appeng.api.networking.crafting.ICraftingJob;
import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingMedium;
import appeng.api.networking.crafting.ICraftingPatternDetails;
import appeng.api.networking.crafting.ICraftingProvider;
import appeng.api.networking.crafting.ICraftingProviderHelper;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.events.MENetworkCraftingPatternChange;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.MachineSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.helpers.PatternHelper;
import appeng.me.GridAccessException;
import appeng.me.helpers.AENetworkProxy;
import appeng.me.helpers.IGridProxyable;
import appeng.util.Platform;
import appeng.util.item.AEItemStack;
import com.google.common.collect.ImmutableSet;
import com.recursive_pineapple.matter_manipulator.common.items.MMItemList;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import gregtech.GTMod;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;

public class MTEMMUplinkMEHatch
extends MTEHatch
implements IGridProxyable,
IPowerChannelState,
ICraftingProvider,
ICraftingRequester {
    protected BaseActionSource requestSource = null;
    protected AENetworkProxy gridProxy = null;
    protected boolean additionalConnection = false;
    private final List<ManipulatorRequest> manualRequests = new ArrayList<ManipulatorRequest>();
    private final List<ManipulatorRequest> autoRequests = new ArrayList<ManipulatorRequest>();
    private List<ItemStack> pendingCraft;

    public MTEMMUplinkMEHatch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 8, 0, new String[]{"Quantum Uplink ME connector hatch.", "Change ME connection behavior by right-clicking with wire cutter.", "Clear all stored plans and cancel all jobs by right-clicking with a screw driver."}, new ITexture[0]);
    }

    public MTEMMUplinkMEHatch(MTEMMUplinkMEHatch prototype) {
        super(prototype.mName, (int)prototype.mTier, 0, prototype.mDescriptionArray, prototype.mTextures);
    }

    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEMMUplinkMEHatch(this);
    }

    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_INPUT_FLUID_HATCH_ACTIVE)};
    }

    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of((IIconContainer)Textures.BlockIcons.OVERLAY_ME_INPUT_FLUID_HATCH)};
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return this.isOutputFacing(forgeDirection) ? AECableType.SMART : AECableType.NONE;
    }

    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTimer) {
        super.onPostTick(aBaseMetaTileEntity, aTimer);
        if (this.getBaseMetaTileEntity().isServerSide() && aTimer % 20L == 0L) {
            boolean isActive = this.isActive();
            this.getBaseMetaTileEntity().setActive(isActive);
            if (isActive && !this.autoRequests.isEmpty()) {
                this.pollRequests();
            }
            this.pushPendingCraft();
        }
    }

    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        super.onFirstTick(aBaseMetaTileEntity);
        this.getProxy().onReady();
    }

    private void pollRequests() {
        Iterator<ManipulatorRequest> iter = this.autoRequests.iterator();
        while (iter.hasNext()) {
            ManipulatorRequest request = iter.next();
            if (request.poll()) continue;
            EntityPlayer player = MMUtils.getPlayerById(request.requester);
            if (player != null) {
                MMUtils.sendErrorToPlayer(player, StatCollector.func_74837_a((String)"mm.info.error.craft_failed", (Object[])new Object[]{request.requestName}));
            }
            iter.remove();
            this.onRequestsChanged();
        }
    }

    private void updateValidGridProxySides() {
        if (this.additionalConnection) {
            this.getProxy().setValidSides(EnumSet.complementOf(EnumSet.of(ForgeDirection.UNKNOWN)));
        } else {
            this.getProxy().setValidSides(EnumSet.of(this.getBaseMetaTileEntity().getFrontFacing()));
        }
    }

    public boolean onWireCutterRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        this.additionalConnection = !this.additionalConnection;
        this.updateValidGridProxySides();
        aPlayer.func_146105_b((IChatComponent)new ChatComponentTranslation("GT5U.hatch.additionalConnection." + this.additionalConnection, new Object[0]));
        return true;
    }

    public void onFacingChange() {
        this.updateValidGridProxySides();
    }

    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    public AENetworkProxy getProxy() {
        if (this.gridProxy == null && this.getBaseMetaTileEntity() instanceof IGridProxyable) {
            this.gridProxy = new AENetworkProxy((IGridProxyable)this, "proxy", MMItemList.UplinkHatch.get(1), true);
            this.gridProxy.setFlags(new GridFlags[]{GridFlags.REQUIRE_CHANNEL});
            this.updateValidGridProxySides();
            if (this.getBaseMetaTileEntity().getWorld() != null) {
                this.gridProxy.setOwner(this.getBaseMetaTileEntity().getWorld().func_72924_a(this.getBaseMetaTileEntity().getOwnerName()));
            }
        }
        return this.gridProxy;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.getProxy().getNode();
    }

    public IGridNode getActionableNode() {
        return this.getProxy().getNode();
    }

    public void securityBreak() {
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this.getBaseMetaTileEntity().getWorld(), this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
    }

    public ImmutableSet<ICraftingLink> getRequestedJobs() {
        ImmutableSet.Builder jobs = ImmutableSet.builder();
        for (ManipulatorRequest request : this.autoRequests) {
            if (request.link == null) continue;
            jobs.add((Object)request.link);
        }
        return jobs.build();
    }

    public IAEItemStack injectCraftedItems(ICraftingLink link, IAEItemStack items, Actionable mode) {
        return items;
    }

    public void jobStateChange(ICraftingLink link) {
    }

    public IGrid getGrid() {
        try {
            return this.getProxy().getGrid();
        }
        catch (GridAccessException e) {
            return null;
        }
    }

    public IStorageGrid getStorageGrid() {
        IGrid grid = this.getGrid();
        if (grid == null) {
            return null;
        }
        return (IStorageGrid)grid.getCache(IStorageGrid.class);
    }

    public ICraftingGrid getCraftingGrid() {
        IGrid grid = this.getGrid();
        if (grid == null) {
            return null;
        }
        return (ICraftingGrid)grid.getCache(ICraftingGrid.class);
    }

    public BaseActionSource getRequestSource() {
        if (this.requestSource == null) {
            this.requestSource = new MachineSource((IActionHost)this);
        }
        return this.requestSource;
    }

    public boolean isPowered() {
        return this.getProxy() != null && this.getProxy().isPowered();
    }

    public boolean isActive() {
        return this.getProxy() != null && this.getProxy().isActive();
    }

    public void saveRequests(NBTTagCompound tag) {
        NBTTagList auto = new NBTTagList();
        for (ManipulatorRequest request : this.autoRequests) {
            auto.func_74742_a((NBTBase)request.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("auto", (NBTBase)auto);
        NBTTagList manual = new NBTTagList();
        for (ManipulatorRequest request : this.manualRequests) {
            manual.func_74742_a((NBTBase)request.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("manual", (NBTBase)manual);
    }

    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74757_a("additionalConnection", this.additionalConnection);
        if (this.pendingCraft != null) {
            NBTTagList pendingItems = new NBTTagList();
            for (ItemStack stack : this.pendingCraft) {
                pendingItems.func_74742_a((NBTBase)stack.func_77955_b(new NBTTagCompound()));
            }
            aNBT.func_74782_a("items", (NBTBase)pendingItems);
        }
        this.saveRequests(aNBT);
        this.getProxy().writeToNBT(aNBT);
    }

    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.additionalConnection = aNBT.func_74767_n("additionalConnection");
        if (aNBT.func_74764_b("items")) {
            List pendingItems = ((NBTTagList)aNBT.func_74781_a((String)"items")).field_74747_a;
            this.pendingCraft = new LinkedList<ItemStack>();
            for (NBTTagCompound item : pendingItems) {
                this.pendingCraft.add(ItemStack.func_77949_a((NBTTagCompound)item));
            }
        }
        this.autoRequests.clear();
        this.manualRequests.clear();
        List auto = ((NBTTagList)aNBT.func_74781_a((String)"auto")).field_74747_a;
        for (NBTTagCompound request : auto) {
            this.autoRequests.add(ManipulatorRequest.readFromNBT(this, request));
        }
        List manual = ((NBTTagList)aNBT.func_74781_a((String)"manual")).field_74747_a;
        for (NBTTagCompound request : manual) {
            this.manualRequests.add(ManipulatorRequest.readFromNBT(this, request));
        }
        this.autoRequests.remove(null);
        this.manualRequests.remove(null);
        this.getProxy().readFromNBT(aNBT);
        this.onRequestsChanged();
    }

    private void pushPendingCraft() {
        if (this.pendingCraft == null) {
            return;
        }
        IStorageGrid grid = this.getStorageGrid();
        if (grid == null) {
            return;
        }
        IMEMonitor itemInventory = grid.getItemInventory();
        if (itemInventory == null) {
            return;
        }
        Iterator<ItemStack> iter = this.pendingCraft.iterator();
        while (iter.hasNext()) {
            ItemStack current = iter.next();
            IAEItemStack result = (IAEItemStack)itemInventory.injectItems((IAEStack)AEItemStack.create((ItemStack)current), Actionable.MODULATE, this.getRequestSource());
            if (result != null) {
                current.field_77994_a = (int)result.getStackSize();
                continue;
            }
            iter.remove();
        }
        if (this.pendingCraft.isEmpty()) {
            this.pendingCraft = null;
        }
    }

    public boolean pushPattern(ICraftingPatternDetails patternDetails, InventoryCrafting table) {
        this.pushPendingCraft();
        if (this.isBusy()) {
            return false;
        }
        this.pendingCraft = new LinkedList<ItemStack>(MMUtils.streamInventory((IInventory)table).filter(i -> i != null).collect(Collectors.toList()));
        PatternHelper pattern = (PatternHelper)patternDetails;
        IAEItemStack hologram = pattern.getCondensedOutputs()[0];
        Iterator<ManipulatorRequest> iter = this.autoRequests.iterator();
        while (iter.hasNext()) {
            ManipulatorRequest request = iter.next();
            if (!hologram.isSameType(request.hologram)) continue;
            if (request.link != null) {
                request.link.cancel();
                EntityPlayer player = MMUtils.getPlayerById(request.requester);
                if (player != null) {
                    MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.craft_finished", (Object[])new Object[]{request.requestName}));
                }
            }
            iter.remove();
        }
        this.onRequestsChanged();
        this.pushPendingCraft();
        return true;
    }

    public boolean isBusy() {
        return this.pendingCraft != null;
    }

    public void provideCrafting(ICraftingProviderHelper craftingTracker) {
        PatternHelper pattern;
        for (ManipulatorRequest request : this.manualRequests) {
            try {
                pattern = new PatternHelper(request.getPattern(), this.getBaseMetaTileEntity().getWorld());
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern);
            }
            catch (IllegalStateException e) {
                GTMod.GT_FML_LOGGER.error("Could not load matter manipulator plan", (Throwable)e);
            }
        }
        for (ManipulatorRequest request : this.autoRequests) {
            try {
                pattern = new PatternHelper(request.getPattern(), this.getBaseMetaTileEntity().getWorld());
                craftingTracker.addCraftingOption((ICraftingMedium)this, (ICraftingPatternDetails)pattern);
            }
            catch (IllegalStateException e) {
                GTMod.GT_FML_LOGGER.error("Could not load matter manipulator plan", (Throwable)e);
            }
        }
    }

    public void addRequest(EntityPlayer requester, String requestName, List<IAEItemStack> requiredItems, boolean autocraft) {
        ManipulatorRequest request = new ManipulatorRequest(requester.func_146103_bH().getId(), requestName, requiredItems);
        if (autocraft) {
            this.autoRequests.add(request);
        } else {
            this.manualRequests.add(request);
        }
        this.onRequestsChanged();
    }

    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        for (ManipulatorRequest req : this.autoRequests) {
            if (req.link != null) {
                req.link.cancel();
            }
            if (req.job == null) continue;
            req.job.cancel(false);
        }
        this.autoRequests.clear();
        this.manualRequests.clear();
        this.onRequestsChanged();
        MMUtils.sendInfoToPlayer(aPlayer, StatCollector.func_74838_a((String)"mm.info.cleared_all_plans_and_pending_jobs"));
    }

    public void clearManualPlans(EntityPlayer player) {
        this.manualRequests.removeIf(request -> request.requester.equals(player.func_146103_bH().getId()));
        this.onRequestsChanged();
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.cleared_your_manual_plans"));
    }

    public void cancelAutoPlans(EntityPlayer player) {
        Iterator<ManipulatorRequest> iter = this.autoRequests.iterator();
        while (iter.hasNext()) {
            ManipulatorRequest req = iter.next();
            if (!req.requester.equals(player.func_146103_bH().getId())) continue;
            if (req.link != null) {
                req.link.cancel();
            }
            if (req.job != null) {
                req.job.cancel(false);
            }
            iter.remove();
        }
        this.onRequestsChanged();
        MMUtils.sendInfoToPlayer(player, StatCollector.func_74838_a((String)"mm.info.cleared_your_plans_and_craft"));
    }

    private void onRequestsChanged() {
        try {
            this.getProxy().getGrid().postEvent((MENetworkEvent)new MENetworkCraftingPatternChange((ICraftingProvider)this, this.getProxy().getNode()));
        }
        catch (GridAccessException gridAccessException) {
            // empty catch block
        }
    }

    public boolean hasAnyRequests() {
        return !this.autoRequests.isEmpty() || !this.manualRequests.isEmpty();
    }

    private class ManipulatorRequest {
        public final UUID requester;
        public final String requestName;
        public final List<IAEItemStack> requiredItems;
        public final ItemStack hologram;
        public Future<ICraftingJob> job;
        public ICraftingLink link;
        private static int counter;

        public ManipulatorRequest(UUID requester, String requestName, List<IAEItemStack> requiredItems) {
            this.requester = requester;
            this.requestName = requestName;
            this.requiredItems = requiredItems;
            this.hologram = MMItemList.Hologram.get(1);
            this.hologram.func_151001_c(EnumChatFormatting.RESET + requestName);
            this.hologram.func_77978_p().func_74768_a("discriminator", counter++);
        }

        private ManipulatorRequest(UUID requester, String requestName, List<IAEItemStack> requiredItems, ICraftingLink link) {
            this.requester = requester;
            this.requestName = requestName;
            this.requiredItems = requiredItems;
            this.link = link;
            this.hologram = MMItemList.Hologram.get(1);
            this.hologram.func_151001_c(EnumChatFormatting.RESET + requestName);
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            tag.func_74772_a("r1", this.requester.getMostSignificantBits());
            tag.func_74772_a("r2", this.requester.getLeastSignificantBits());
            tag.func_74778_a("rn", this.requestName);
            if (this.link != null) {
                NBTTagCompound linkTag = new NBTTagCompound();
                this.link.writeToNBT(linkTag);
                tag.func_74782_a("link", (NBTBase)linkTag);
            }
            NBTTagList items = new NBTTagList();
            for (IAEItemStack item : this.requiredItems) {
                NBTTagCompound itemTag = new NBTTagCompound();
                item.writeToNBT(itemTag);
                items.func_74742_a((NBTBase)itemTag);
            }
            tag.func_74782_a("items", (NBTBase)items);
            return tag;
        }

        public static ManipulatorRequest readFromNBT(MTEMMUplinkMEHatch hatch, NBTTagCompound tag) {
            UUID requester = new UUID(tag.func_74763_f("r1"), tag.func_74763_f("r2"));
            String requestName = tag.func_74779_i("rn");
            ICraftingLink link = null;
            if (tag.func_74764_b("link")) {
                link = AEApi.instance().storage().loadCraftingLink(tag.func_74775_l("link"), (ICraftingRequester)hatch);
            }
            ArrayList<IAEItemStack> requiredItems = new ArrayList<IAEItemStack>();
            List items = ((NBTTagList)tag.func_74781_a((String)"items")).field_74747_a;
            for (NBTTagCompound item : items) {
                requiredItems.add(AEItemStack.loadItemStackFromNBT((NBTTagCompound)item));
            }
            requiredItems.remove(null);
            if (requiredItems.isEmpty()) {
                return null;
            }
            MTEMMUplinkMEHatch mTEMMUplinkMEHatch = hatch;
            Objects.requireNonNull(mTEMMUplinkMEHatch);
            return mTEMMUplinkMEHatch.new ManipulatorRequest(requester, requestName, requiredItems, link);
        }

        boolean poll() {
            ICraftingGrid cg;
            if (!MTEMMUplinkMEHatch.this.isActive()) {
                return true;
            }
            try {
                cg = MTEMMUplinkMEHatch.this.getProxy().getCrafting();
            }
            catch (GridAccessException e) {
                return true;
            }
            if (this.link != null) {
                return !this.link.isCanceled();
            }
            if (this.job == null) {
                this.job = cg.beginCraftingJob(MTEMMUplinkMEHatch.this.getBaseMetaTileEntity().getWorld(), MTEMMUplinkMEHatch.this.getGrid(), MTEMMUplinkMEHatch.this.getRequestSource(), (IAEItemStack)AEItemStack.create((ItemStack)this.hologram), null);
            }
            if (this.job == null) {
                return false;
            }
            try {
                ICraftingJob job = null;
                if (this.job.isDone()) {
                    job = this.job.get();
                }
                if (job != null) {
                    this.link = cg.submitJob(job, (ICraftingRequester)MTEMMUplinkMEHatch.this, null, false, MTEMMUplinkMEHatch.this.getRequestSource());
                    if (this.link == null) {
                        return false;
                    }
                    EntityPlayer player = MMUtils.getPlayerById(this.requester);
                    if (player != null) {
                        MMUtils.sendInfoToPlayer(player, StatCollector.func_74837_a((String)"mm.info.submitted_job", (Object[])new Object[]{this.requestName}));
                    }
                }
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
            return true;
        }

        public ItemStack getPattern() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74757_a("crafting", false);
            tag.func_74757_a("substitute", false);
            tag.func_74757_a("beSubstitute", false);
            EntityPlayer player = MMUtils.getPlayerById(this.requester);
            tag.func_74778_a("author", player != null ? player.func_146103_bH().getName() : this.requester.toString());
            NBTTagList out = new NBTTagList();
            out.func_74742_a((NBTBase)Platform.writeItemStackToNBT((ItemStack)this.hologram, (NBTTagCompound)new NBTTagCompound()));
            tag.func_74782_a("out", (NBTBase)out);
            NBTTagList in = new NBTTagList();
            for (IAEItemStack stack : this.requiredItems) {
                in.func_74742_a((NBTBase)Platform.writeItemStackToNBT((ItemStack)stack.getItemStack(), (NBTTagCompound)new NBTTagCompound()));
            }
            tag.func_74782_a("in", (NBTBase)in);
            ItemStack pattern = (ItemStack)AEApi.instance().definitions().items().encodedPattern().maybeStack(1).get();
            pattern.func_77982_d(tag);
            return pattern;
        }
    }
}

