/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.persist;

import com.google.common.reflect.TypeToken;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.data.WeightedSpecList;
import it.unimi.dsi.fastutil.objects.ObjectIntMutablePair;
import java.lang.reflect.Type;

public class WeightedListJsonAdapter
implements JsonSerializer<WeightedSpecList>,
JsonDeserializer<WeightedSpecList> {
    private static final Type BLOCK_SPEC = new TypeToken<BlockSpec>(){}.getType();

    public WeightedSpecList deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (!(json instanceof JsonArray)) {
            return new WeightedSpecList(new BlockSpec[0]);
        }
        JsonArray array = (JsonArray)json;
        WeightedSpecList list = new WeightedSpecList(new BlockSpec[0]);
        for (JsonElement x : array) {
            JsonPrimitive weight;
            JsonObject obj;
            JsonElement jsonElement;
            if (!(x instanceof JsonObject) || !((jsonElement = (obj = (JsonObject)x).get("s")) instanceof JsonObject)) continue;
            JsonObject spec = (JsonObject)jsonElement;
            JsonElement jsonElement2 = obj.get("w");
            if (!(jsonElement2 instanceof JsonPrimitive) || !(weight = (JsonPrimitive)jsonElement2).isNumber()) continue;
            list.specs.add((ObjectIntMutablePair<BlockSpec>)ObjectIntMutablePair.of((Object)((BlockSpec)context.deserialize((JsonElement)spec, BLOCK_SPEC)), (int)weight.getAsInt()));
        }
        return list;
    }

    public JsonElement serialize(WeightedSpecList src, Type typeOfSrc, JsonSerializationContext context) {
        BlockSpec spec;
        if (src.specs.size() == 1 && ((spec = (BlockSpec)src.specs.get(0).left()) == null || spec.isAir())) {
            return JsonNull.INSTANCE;
        }
        JsonArray array = new JsonArray();
        for (ObjectIntMutablePair<BlockSpec> p : src.specs) {
            JsonObject pair = new JsonObject();
            pair.add("s", context.serialize(p.left()));
            pair.addProperty("w", (Number)p.rightInt());
            array.add((JsonElement)pair);
        }
        return array;
    }
}

