/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import com.gtnewhorizon.gtnhlib.util.AboveHotbarHUD;
import com.gtnewhorizon.gtnhlib.util.CoordinatePacker;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.recursive_pineapple.matter_manipulator.GlobalMMConfig;
import com.recursive_pineapple.matter_manipulator.MMMod;
import com.recursive_pineapple.matter_manipulator.client.rendering.BoxRenderer;
import com.recursive_pineapple.matter_manipulator.common.building.BlockSpec;
import com.recursive_pineapple.matter_manipulator.common.building.PendingBlock;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.Location;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMConfig;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.RenderHints;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import it.unimi.dsi.fastutil.longs.LongCollection;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongList;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3i;
import org.lwjgl.opengl.GL11;

@EventBusSubscriber(side={Side.CLIENT})
public class MMRenderer {
    private static long lastAnalysisMS = 0L;
    private static MMConfig lastAnalyzedConfig = null;
    private static Location lastPlayerPosition = null;
    private static List<PendingBlock> analysisCache = null;
    private static ItemMatterManipulator lastDrawer = null;
    private static boolean wasValid = false;
    private static final long ANALYSIS_INTERVAL_MS = 10000L;
    private static long lastExceptionPrint = 0L;
    private static boolean needsHintDraw = false;
    private static boolean needsAnalysis = false;
    private static LongList errors;
    private static LongList warnings;
    private static long statusExpiration;
    private static boolean wasInUse;
    private static final short[] WHITE;
    private static final short[] WARNING;
    private static final short[] ERROR;
    private static final int RULER_LENGTH = 128;

    private MMRenderer() {
    }

    public static void init() {
    }

    public static void markNeedsRedraw() {
        needsHintDraw = true;
    }

    public static void markNeedsReanalysis() {
        needsAnalysis = true;
    }

    public static void setStatusHints(LongList errors, LongList warnings) {
        needsHintDraw = true;
        MMRenderer.errors = errors;
        MMRenderer.warnings = warnings;
        statusExpiration = GlobalMMConfig.RenderingConfig.statusExpiration <= 0 ? 0L : System.currentTimeMillis() + (long)(GlobalMMConfig.RenderingConfig.statusExpiration * 1000);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void renderSelection(RenderWorldLastEvent event) {
        block2: {
            try {
                MMRenderer.renderSelectionImpl(event);
            }
            catch (Throwable t) {
                MMMod.LOG.error("Could not render matter manipulator preview", t);
                long now = System.currentTimeMillis();
                if (now - lastExceptionPrint <= 10000L) break block2;
                Minecraft.func_71410_x().field_71439_g.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Could not render preview due to a crash. Check the logs for more info. Building will not work - items may be voided if you try."));
                lastExceptionPrint = now;
            }
        }
    }

    private static void renderSelectionImpl(RenderWorldLastEvent event) {
        Item item;
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        ItemStack held = player.func_70694_bm();
        if (held != null && (item = held.func_77973_b()) instanceof ItemMatterManipulator) {
            ItemMatterManipulator manipulator = (ItemMatterManipulator)item;
            MMState state = ItemMatterManipulator.getState(held);
            switch (state.config.placeMode) {
                case GEOMETRY: 
                case EXCHANGING: 
                case CABLES: {
                    MMRenderer.renderGeom(event, (EntityPlayer)player, state, manipulator);
                    break;
                }
                case COPYING: 
                case MOVING: {
                    MMRenderer.renderRegions(event, (EntityPlayer)player, state, manipulator);
                }
            }
        } else if (lastDrawer != null) {
            lastDrawer = null;
            MMRenderer.clear((EntityPlayer)player);
        }
    }

    private static void clear(EntityPlayer player) {
        lastAnalysisMS = 0L;
        lastAnalyzedConfig = null;
        lastPlayerPosition = null;
        analysisCache = null;
        needsHintDraw = false;
        needsAnalysis = false;
        RenderHints.reset();
        AboveHotbarHUD.renderTextAboveHotbar((String)"", (int)0, (boolean)false, (boolean)false);
    }

    @SubscribeEvent
    public static void checkPlayerStoppedBuilding(TickEvent.PlayerTickEvent event) {
        if (event.side != Side.CLIENT) {
            return;
        }
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.type != TickEvent.Type.PLAYER) {
            return;
        }
        ItemStack inUse = event.player.func_71011_bu();
        if (inUse != null) {
            if (inUse.func_77973_b() instanceof ItemMatterManipulator) {
                wasInUse = true;
            }
            return;
        }
        if (wasInUse) {
            MMRenderer.markNeedsReanalysis();
            wasInUse = false;
        }
    }

    private static void renderGeom(RenderWorldLastEvent event, EntityPlayer player, MMState state, ItemMatterManipulator manipulator) {
        boolean isValid;
        Vector3i lookingAt = MMUtils.getLookingAtLocation(player);
        Location coordA = state.config.getCoordA(player.field_70170_p, lookingAt);
        Location coordB = state.config.getCoordB(player.field_70170_p, lookingAt);
        Location coordC = state.config.getCoordC(player.field_70170_p, lookingAt);
        state.config.coordA = coordA;
        state.config.coordB = coordB;
        state.config.coordC = coordC;
        boolean isAValid = coordA != null && coordA.isInWorld(player.field_70170_p);
        boolean isBValid = coordB != null && coordB.isInWorld(player.field_70170_p);
        boolean isCValid = coordC != null && coordC.isInWorld(player.field_70170_p);
        boolean bl = isValid = isAValid && isBValid;
        if (state.config.placeMode == MMState.PlaceMode.GEOMETRY && state.config.shape == MMState.Shape.CYLINDER) {
            isValid &= isCValid;
            if (isAValid && isBValid) {
                Objects.requireNonNull(coordA);
                Objects.requireNonNull(coordB);
                Vector3i b2 = MMState.pinToPlanes(coordA.toVec(), coordB.toVec());
                coordB.x = b2.x;
                coordB.y = b2.y;
                coordB.z = b2.z;
                if (isCValid) {
                    Objects.requireNonNull(coordC);
                    Vector3i height = MMState.pinToLine(coordA.toVec(), b2, coordC.toVec());
                    coordC.x = height.x;
                    coordC.y = height.y;
                    coordC.z = height.z;
                }
            }
        }
        if (!isValid && wasValid) {
            MMRenderer.clear(player);
            wasValid = false;
            return;
        }
        wasValid = isValid;
        if (isAValid && isBValid && state.config.placeMode == MMState.PlaceMode.CABLES) {
            Objects.requireNonNull(coordA);
            Objects.requireNonNull(coordB);
            Vector3i b2 = MMState.pinToAxes(coordA.toVec(), coordB.toVec());
            coordB.x = b2.x;
            coordB.y = b2.y;
            coordB.z = b2.z;
        }
        if (isAValid && state.config.coordAOffset != null) {
            GL11.glColor4f((float)0.15f, (float)0.6f, (float)0.75f, (float)0.75f);
            MMRenderer.drawRulers(player, coordA, false, event.partialTicks);
        }
        if (isBValid && state.config.coordBOffset != null) {
            GL11.glColor4f((float)0.15f, (float)0.6f, (float)0.75f, (float)0.75f);
            MMRenderer.drawRulers(player, coordB, false, event.partialTicks);
        }
        if (isCValid && state.config.coordCOffset != null) {
            GL11.glColor4f((float)0.15f, (float)0.6f, (float)0.75f, (float)0.75f);
            MMRenderer.drawRulers(player, coordC, false, event.partialTicks);
        }
        if (isAValid && isBValid) {
            Objects.requireNonNull(coordA);
            Objects.requireNonNull(coordB);
            Location playerLocation = new Location(player.func_130014_f_(), MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
            Vector3i vA = coordA.toVec();
            Vector3i vB = coordB.toVec();
            Vector3i vC = null;
            MMConfig.VoxelAABB aabb = new MMConfig.VoxelAABB(vA, vB);
            if ((state.config.placeMode != MMState.PlaceMode.GEOMETRY || state.config.shape.requiresC()) && isCValid) {
                Objects.requireNonNull(coordC);
                vC = coordC.toVec();
                aabb.union(vC);
            }
            BoxRenderer.INSTANCE.start(event.partialTicks);
            BoxRenderer.INSTANCE.drawAround(aabb.toBoundingBox(), new Vector3f(0.15f, 0.6f, 0.75f));
            BoxRenderer.INSTANCE.finish();
            long now = System.currentTimeMillis();
            if (statusExpiration > 0L && now > statusExpiration) {
                errors = null;
                warnings = null;
                statusExpiration = 0L;
                needsHintDraw = true;
            }
            needsAnalysis = needsAnalysis || now - lastAnalysisMS >= 10000L || lastDrawer != manipulator || !Objects.equals(lastAnalyzedConfig, state.config);
            boolean bl2 = needsHintDraw = needsHintDraw || needsAnalysis || lastPlayerPosition.distanceTo(playerLocation) > 2.0 && manipulator.tier.maxRange != -1;
            if (needsAnalysis) {
                lastAnalysisMS = now;
                lastAnalyzedConfig = state.config;
                analysisCache = state.getPendingBlocks(manipulator.tier, player.func_130014_f_());
                analysisCache.removeIf(Objects::isNull);
                analysisCache.sort(Comparator.comparingInt(b -> b.renderOrder));
                needsAnalysis = false;
                AboveHotbarHUD.renderTextAboveHotbar((String)aabb.describe(), (int)200, (boolean)false, (boolean)false);
            }
            if (needsHintDraw) {
                lastPlayerPosition = playerLocation;
                lastDrawer = manipulator;
                needsHintDraw = false;
                MMRenderer.drawHints(event, state, player, playerLocation, manipulator.tier.maxRange);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void renderRegions(RenderWorldLastEvent event, EntityPlayer player, MMState state, ItemMatterManipulator manipulator) {
        boolean isValid;
        Location sourceA = state.config.coordA;
        Location sourceB = state.config.coordB;
        Location paste = state.config.coordC;
        Vector3i lookingAt = MMUtils.getLookingAtLocation(player);
        if (state.config.action != null) {
            switch (state.config.action) {
                case MARK_COPY_A: 
                case MARK_CUT_A: {
                    sourceA = new Location(player.field_70170_p, lookingAt);
                    GL11.glColor4f((float)0.15f, (float)0.6f, (float)0.75f, (float)0.75f);
                    MMRenderer.drawRulers(player, sourceA, false, event.partialTicks);
                    break;
                }
                case MARK_COPY_B: 
                case MARK_CUT_B: {
                    sourceB = new Location(player.field_70170_p, lookingAt);
                    GL11.glColor4f((float)0.15f, (float)0.6f, (float)0.75f, (float)0.75f);
                    MMRenderer.drawRulers(player, sourceB, false, event.partialTicks);
                    break;
                }
                case MARK_PASTE: {
                    paste = new Location(player.field_70170_p, lookingAt);
                    GL11.glColor4f((float)0.75f, (float)0.5f, (float)0.15f, (float)0.75f);
                    MMRenderer.drawRulers(player, paste, false, event.partialTicks);
                    break;
                }
                case MARK_ARRAY: {
                    GL11.glColor4f((float)0.4f, (float)0.75f, (float)0.15f, (float)0.75f);
                    MMRenderer.drawRulers(player, new Location(player.field_70170_p, lookingAt), false, event.partialTicks);
                    if (paste == null || !paste.isInWorld(player.field_70170_p)) break;
                    state.config.arraySpan = state.config.getArrayMult(player.field_70170_p, sourceA, sourceB, paste, lookingAt);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        state.config.coordA = sourceA;
        state.config.coordB = sourceB;
        state.config.coordC = paste;
        boolean isSourceAValid = sourceA != null && sourceA.isInWorld(player.field_70170_p);
        boolean isSourceBValid = sourceB != null && sourceB.isInWorld(player.field_70170_p);
        boolean isPasteValid = paste != null && paste.isInWorld(player.field_70170_p);
        boolean bl = isValid = isSourceAValid && isSourceBValid && isPasteValid;
        if (!isValid && wasValid) {
            MMRenderer.clear(player);
            wasValid = false;
            return;
        }
        wasValid = isValid;
        MMConfig.VoxelAABB copyDeltas = null;
        BoxRenderer.INSTANCE.start(event.partialTicks);
        try {
            if (isSourceAValid && isSourceBValid) {
                Objects.requireNonNull(sourceA);
                Objects.requireNonNull(sourceB);
                copyDeltas = new MMConfig.VoxelAABB(sourceA.toVec(), sourceB.toVec());
                BoxRenderer.INSTANCE.drawAround(copyDeltas.toBoundingBox(), new Vector3f(0.15f, 0.6f, 0.75f));
            }
            MMConfig.VoxelAABB pasteDeltas = null;
            if (isPasteValid) {
                Objects.requireNonNull(paste);
                pasteDeltas = state.config.getPasteVisualDeltas(player.field_70170_p, true);
                if (pasteDeltas == null) {
                    pasteDeltas = new MMConfig.VoxelAABB(paste.toVec(), paste.toVec());
                }
                BoxRenderer.INSTANCE.drawAround(pasteDeltas.toBoundingBox(), new Vector3f(0.75f, 0.5f, 0.15f));
                Location playerLocation = new Location(player.func_130014_f_(), MathHelper.func_76128_c((double)player.field_70165_t), MathHelper.func_76128_c((double)player.field_70163_u), MathHelper.func_76128_c((double)player.field_70161_v));
                long now = System.currentTimeMillis();
                needsAnalysis = needsAnalysis || now - lastAnalysisMS >= 10000L || lastDrawer != manipulator || !Objects.equals(lastAnalyzedConfig, state.config);
                boolean bl2 = needsHintDraw = needsHintDraw || needsAnalysis || lastPlayerPosition.distanceTo(playerLocation) > 2.0 && manipulator.tier.maxRange != -1;
                if (needsAnalysis) {
                    lastAnalysisMS = now;
                    lastAnalyzedConfig = state.config;
                    analysisCache = state.getPendingBlocks(manipulator.tier, player.func_130014_f_());
                    analysisCache.removeIf(Objects::isNull);
                    analysisCache.sort(Comparator.comparingInt(b -> b.renderOrder));
                    needsAnalysis = false;
                }
                if (needsHintDraw) {
                    lastPlayerPosition = playerLocation;
                    lastDrawer = manipulator;
                    needsHintDraw = false;
                    MMRenderer.drawHints(event, state, player, playerLocation, manipulator.tier.maxRange);
                }
            }
            if (pasteDeltas != null) {
                String array = "";
                Vector3i span = state.config.arraySpan;
                if (span != null) {
                    array = String.format(" stX=%d stY=%d stZ=%d", span.x >= 0 ? span.x + 1 : span.x, span.y >= 0 ? span.y + 1 : span.y, span.z >= 0 ? span.z + 1 : span.z);
                }
                AboveHotbarHUD.renderTextAboveHotbar((String)(pasteDeltas.describe() + array), (int)200, (boolean)false, (boolean)false);
            } else if (copyDeltas != null) {
                AboveHotbarHUD.renderTextAboveHotbar((String)copyDeltas.describe(), (int)200, (boolean)false, (boolean)false);
            }
        }
        finally {
            BoxRenderer.INSTANCE.finish();
        }
    }

    private static void drawHints(RenderWorldLastEvent event, MMState state, EntityPlayer player, Location playerLocation, int maxRange) {
        int y;
        LongIterator longIterator;
        int buildable = maxRange * maxRange;
        int i = 0;
        BlockSpec pooled = new BlockSpec();
        LongOpenHashSet errors = MMRenderer.errors == null ? null : new LongOpenHashSet((LongCollection)MMRenderer.errors);
        LongOpenHashSet warnings = MMRenderer.warnings == null ? null : new LongOpenHashSet((LongCollection)MMRenderer.warnings);
        World world = player.field_70170_p;
        RenderHints.reset();
        RenderHints.setDrawOnTop(GlobalMMConfig.RenderingConfig.hintsOnTop || state.config.placeMode == MMState.PlaceMode.EXCHANGING);
        for (PendingBlock pendingBlock : analysisCache) {
            Block block;
            int dist2;
            if (!pendingBlock.isInWorld(world) || maxRange != -1 && (dist2 = pendingBlock.distanceTo2(playerLocation)) > buildable || pendingBlock.spec.isAir() && world.func_147437_c(pendingBlock.x, pendingBlock.y, pendingBlock.z) || (block = pendingBlock.getBlock()) == null) continue;
            BlockSpec.fromBlock(pooled, world, pendingBlock.x, pendingBlock.y, pendingBlock.z);
            if (pooled.isEquivalent(pendingBlock.spec)) continue;
            if (++i > GlobalMMConfig.RenderingConfig.maxHints) break;
            long packed = CoordinatePacker.pack((int)pendingBlock.x, (int)pendingBlock.y, (int)pendingBlock.z);
            short[] tint = WHITE;
            if (warnings != null && warnings.remove(packed)) {
                tint = WARNING;
            }
            if (errors != null && errors.remove(packed)) {
                tint = ERROR;
            }
            if (pendingBlock.spec.isAir()) {
                RenderHints.addHint(pendingBlock.x, pendingBlock.y, pendingBlock.z, StructureLibAPI.getBlockHint(), 15, tint);
                continue;
            }
            RenderHints.addHint(pendingBlock.x, pendingBlock.y, pendingBlock.z, block, pendingBlock.spec.getBlockMeta(), tint);
        }
        if (warnings != null) {
            longIterator = warnings.iterator();
            while (longIterator.hasNext()) {
                long packed = (Long)longIterator.next();
                int x = CoordinatePacker.unpackX((long)packed);
                y = CoordinatePacker.unpackY((long)packed);
                int z = CoordinatePacker.unpackZ((long)packed);
                RenderHints.addHint(x, y, z, StructureLibAPI.getBlockHint(), 13, WARNING);
            }
        }
        if (errors != null) {
            longIterator = errors.iterator();
            while (longIterator.hasNext()) {
                long packed = (Long)longIterator.next();
                int x = CoordinatePacker.unpackX((long)packed);
                y = CoordinatePacker.unpackY((long)packed);
                int z = CoordinatePacker.unpackZ((long)packed);
                RenderHints.addHint(x, y, z, StructureLibAPI.getBlockHint(), 13, ERROR);
            }
        }
    }

    private static Vector3d getVecForDir(ForgeDirection dir) {
        return new Vector3d((double)dir.offsetX, (double)dir.offsetY, (double)dir.offsetZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void drawRulers(EntityPlayer player, Location l, boolean fromSurface, float partialTickTime) {
        GL11.glEnable((int)3042);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glLineWidth((float)2.0f);
        GL11.glDisable((int)3553);
        GL11.glDepthMask((boolean)false);
        GL11.glPointSize((float)4.0f);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glPushMatrix();
        double d0 = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTickTime;
        double d1 = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTickTime;
        double d2 = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTickTime;
        GL11.glTranslated((double)((double)l.x - d0 + 0.5), (double)((double)l.y - d1 + 0.5), (double)((double)l.z - d2 + 0.5));
        Tessellator tessellator = Tessellator.field_78398_a;
        try {
            tessellator.func_78371_b(1);
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                Vector3d delta = MMRenderer.getVecForDir(dir);
                if (fromSurface) {
                    tessellator.func_78377_a(delta.x * 0.5, delta.y * 0.5, delta.z * 0.5);
                } else {
                    tessellator.func_78377_a(0.0, 0.0, 0.0);
                }
                tessellator.func_78377_a(delta.x * 128.0, delta.y * 128.0, delta.z * 128.0);
            }
        }
        finally {
            try {
                tessellator.func_78381_a();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)3553);
            GL11.glDisable((int)3042);
        }
    }

    static {
        statusExpiration = 0L;
        wasInUse = false;
        WHITE = new short[]{229, 242, 255, 255};
        WARNING = new short[]{255, 170, 0, 255};
        ERROR = new short[]{255, 85, 85, 255};
    }
}

