/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.items.manipulator;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import org.joml.Vector3i;

public class Location {
    public int worldId;
    public int x;
    public int y;
    public int z;

    public Location() {
    }

    public Location(int worldId, int x, int y, int z) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Location(@Nonnull World world, int x, int y, int z) {
        this(world.field_73011_w.field_76574_g, x, y, z);
    }

    public Location(@Nonnull World world, Vector3i v) {
        this(world, v.x, v.y, v.z);
    }

    public String toString() {
        return String.format("X=%,d Y=%,d Z=%,d", this.x, this.y, this.z);
    }

    public Vector3i toVec() {
        return new Vector3i(this.x, this.y, this.z);
    }

    public boolean isInWorld(@Nonnull World world) {
        return world.field_73011_w.field_76574_g == this.worldId;
    }

    public int distanceTo2(Location other) {
        int dx = this.x - other.x;
        int dy = this.y - other.y;
        int dz = this.z - other.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double distanceTo(Location other) {
        return Math.sqrt(this.distanceTo2(other));
    }

    public World getWorld() {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return this.getWorldClient();
        }
        return DimensionManager.getWorld((int)this.worldId);
    }

    @SideOnly(value=Side.CLIENT)
    private World getWorldClient() {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        return world.field_73011_w.field_76574_g == this.worldId ? world : null;
    }

    public Location offset(ForgeDirection dir) {
        this.x += dir.offsetX;
        this.y += dir.offsetY;
        this.z += dir.offsetZ;
        return this;
    }

    public Location offset(int dx, int dy, int dz) {
        this.x += dx;
        this.y += dy;
        this.z += dz;
        return this;
    }

    public Location clone() {
        return new Location(this.worldId, this.x, this.y, this.z);
    }

    public static boolean areCompatible(Location a, Location b) {
        if (a == null || b == null) {
            return false;
        }
        return a.worldId == b.worldId;
    }

    public static boolean areCompatible(Location a, Location b, Location c) {
        if (a == null || b == null || c == null) {
            return false;
        }
        if (a.worldId != b.worldId) {
            return false;
        }
        return a.worldId == c.worldId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.worldId;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.worldId != other.worldId) {
            return false;
        }
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }
}

