/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.compat;

import com.recursive_pineapple.matter_manipulator.common.compat.BlockProperty;
import com.recursive_pineapple.matter_manipulator.common.compat.Orientation;
import net.minecraft.world.World;

public interface OrientationBlockProperty
extends BlockProperty<Orientation> {
    @Override
    default public Orientation parse(String text) throws Exception {
        for (Orientation o : Orientation.values()) {
            if (!o.name().equalsIgnoreCase(text)) continue;
            return o;
        }
        throw new Exception("illegal orientation: '" + text + "'");
    }

    @Override
    default public String stringify(Orientation value) {
        return value.name().toLowerCase();
    }

    public static OrientationBlockProperty orientation(final int mask, final O2M o2m, final M2O m2o) {
        return new OrientationBlockProperty(){

            @Override
            public String getName() {
                return "orientation";
            }

            @Override
            public Orientation getValue(World world, int x, int y, int z) {
                return m2o.getDir(world.func_72805_g(x, y, z) & mask);
            }

            @Override
            public void setValue(World world, int x, int y, int z, Orientation value) {
                int meta = 0;
                if (mask != -1) {
                    meta = world.func_72805_g(x, y, z) & ~mask;
                }
                world.func_72921_c(x, y, z, o2m.getMeta(value) | meta, 2);
            }
        };
    }

    public static interface M2O {
        public Orientation getDir(int var1);
    }

    public static interface O2M {
        public int getMeta(Orientation var1);
    }
}

