/*
 * Decompiled with CFR 0.152.
 */
package com.recursive_pineapple.matter_manipulator.common.building;

import appeng.api.config.Actionable;
import appeng.api.config.FuzzyMode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.gtnhlib.util.map.ItemStackMap;
import com.recursive_pineapple.matter_manipulator.asm.Optional;
import com.recursive_pineapple.matter_manipulator.common.building.IPseudoInventory;
import com.recursive_pineapple.matter_manipulator.common.entities.EntityItemLarge;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.ItemMatterManipulator;
import com.recursive_pineapple.matter_manipulator.common.items.manipulator.MMState;
import com.recursive_pineapple.matter_manipulator.common.uplink.IUplinkMulti;
import com.recursive_pineapple.matter_manipulator.common.uplink.UplinkStatus;
import com.recursive_pineapple.matter_manipulator.common.utils.BigFluidStack;
import com.recursive_pineapple.matter_manipulator.common.utils.BigItemStack;
import com.recursive_pineapple.matter_manipulator.common.utils.FluidId;
import com.recursive_pineapple.matter_manipulator.common.utils.ItemId;
import com.recursive_pineapple.matter_manipulator.common.utils.MMUtils;
import com.recursive_pineapple.matter_manipulator.common.utils.Mods;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.booleans.BooleanObjectImmutablePair;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class MMInventory
implements IPseudoInventory {
    public EntityPlayer player;
    public MMState state;
    public ItemMatterManipulator.ManipulatorTier tier;
    public final Object2LongOpenHashMap<ItemId> pendingItems = new Object2LongOpenHashMap();
    public final Object2LongOpenHashMap<FluidId> pendingFluids = new Object2LongOpenHashMap();
    private boolean printedUplinkWarning = false;
    private final HashSet<IStorageGrid> visitedGrids = new HashSet();

    public MMInventory(EntityPlayer player, MMState state, ItemMatterManipulator.ManipulatorTier tier) {
        this.player = player;
        this.state = state;
        this.tier = tier;
    }

    @Override
    public BooleanObjectImmutablePair<List<BigItemStack>> tryConsumeItems(List<BigItemStack> items, int flags) {
        if ((flags & 8) == 0 && this.player.field_71075_bZ.field_75098_d) {
            return BooleanObjectImmutablePair.of((boolean)true, items);
        }
        this.visitedGrids.clear();
        List<BigItemStack> simulated = MMUtils.mapToList(items, BigItemStack::copy);
        ArrayList<BigItemStack> extracted = new ArrayList<BigItemStack>();
        this.consumeItemsFromPending(simulated, extracted, flags | 1);
        this.consumeItemsFromPlayer(simulated, extracted, flags | 1);
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_AE) && Mods.AppliedEnergistics2.isModLoaded()) {
            this.consumeItemsFromAE(simulated, extracted, flags | 1);
        }
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_UPLINK) && Mods.GregTech.isModLoaded()) {
            this.consumeItemsFromUplink(simulated, extracted, flags | 1);
        }
        if ((flags & 4) == 0 && simulated.stream().anyMatch(s -> s.getStackSize() > 0L)) {
            return BooleanObjectImmutablePair.of((boolean)false, null);
        }
        if ((flags & 1) != 0) {
            return BooleanObjectImmutablePair.of((boolean)true, MMInventory.merge(extracted));
        }
        this.visitedGrids.clear();
        simulated = MMUtils.mapToList(items, BigItemStack::copy);
        extracted.clear();
        this.consumeItemsFromPending(simulated, extracted, flags);
        this.consumeItemsFromPlayer(simulated, extracted, flags);
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_AE) && Mods.AppliedEnergistics2.isModLoaded()) {
            this.consumeItemsFromAE(simulated, extracted, flags);
        }
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_UPLINK) && Mods.GregTech.isModLoaded()) {
            this.consumeItemsFromUplink(simulated, extracted, flags);
        }
        return BooleanObjectImmutablePair.of((boolean)true, MMInventory.merge(extracted));
    }

    private static ArrayList<BigItemStack> merge(List<BigItemStack> unmerged) {
        ItemStackMap out = new ItemStackMap(true);
        for (BigItemStack ex : unmerged) {
            ItemStack stack = ex.getItemStack();
            BigItemStack merged = (BigItemStack)out.get((Object)stack);
            if (merged == null) {
                merged = ex.copy().setStackSize(0L);
                out.put(stack, (Object)merged);
            }
            merged.incStackSize(ex.getStackSize());
        }
        return new ArrayList<BigItemStack>(out.values());
    }

    @Override
    public void givePlayerItems(List<BigItemStack> items) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BigItemStack item : items) {
            if (item == null || item.getItem() == null) continue;
            this.pendingItems.addTo((Object)item.getId(), item.stackSize);
        }
    }

    @Override
    public void givePlayerFluids(List<BigFluidStack> fluids) {
        if (this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        for (BigFluidStack fluid : fluids) {
            if (fluid == null) continue;
            this.pendingFluids.addTo((Object)fluid.getId(), fluid.amount);
        }
    }

    protected void actuallyGivePlayerStuff() {
        Object stack;
        if (this.player.field_71075_bZ.field_75098_d) {
            this.pendingItems.clear();
            this.pendingFluids.clear();
            return;
        }
        boolean hasME = false;
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_AE) && Mods.AppliedEnergistics2.isModLoaded()) {
            if (this.state.encKey != null && !this.state.hasMEConnection()) {
                this.state.connectToMESystem();
            }
            hasME = this.state.hasMEConnection() && this.state.canInteractWithAE(this.player);
        }
        boolean hasUplink = false;
        if (this.state.hasCap(ItemMatterManipulator.CONNECTS_TO_UPLINK) && Mods.GregTech.isModLoaded()) {
            if (this.state.uplinkAddress != null && !this.state.hasUplinkConnection()) {
                this.state.connectToUplink();
            }
            hasUplink = this.state.hasUplinkConnection();
        }
        for (Object2LongMap.Entry entry : this.pendingItems.object2LongEntrySet()) {
            stack = BigItemStack.create((ItemId)entry.getKey(), entry.getLongValue());
            if (hasME) {
                this.injectItemsIntoAE((BigItemStack)stack);
                if (((BigItemStack)stack).getStackSize() == 0L) continue;
            }
            if (hasUplink) {
                this.injectItemsIntoUplink((BigItemStack)stack);
                if (((BigItemStack)stack).getStackSize() == 0L) continue;
            }
            this.injectItemsIntoInventory((BigItemStack)stack);
            if (((BigItemStack)stack).getStackSize() == 0L) continue;
            this.injectItemsIntoWorld((BigItemStack)stack);
        }
        this.pendingItems.clear();
        for (Object2LongMap.Entry entry : this.pendingFluids.object2LongEntrySet()) {
            stack = BigFluidStack.create((FluidId)entry.getKey(), entry.getLongValue());
            if (hasME) {
                this.injectFluidsIntoAE((BigFluidStack)stack);
                if (((BigFluidStack)stack).getStackSize() == 0L) continue;
            }
            if (hasUplink) {
                this.injectFluidsIntoUplink((BigFluidStack)stack);
                if (((BigFluidStack)stack).getStackSize() == 0L) continue;
            }
            this.injectFluidsIntoIdealCell((BigFluidStack)stack);
            if (((BigFluidStack)stack).getStackSize() == 0L) continue;
            this.injectFluidsIntoCells((BigFluidStack)stack);
            if (((BigFluidStack)stack).getStackSize() == 0L || ((BigFluidStack)stack).amount <= 0L || this.player.field_71075_bZ.field_75098_d) continue;
            MMUtils.sendWarningToPlayer(this.player, StatCollector.func_74838_a((String)"mm.info.warning.not_find_container_for_fluid"));
            MMUtils.sendWarningToPlayer(this.player, String.format("  %sL of %s", MMUtils.formatNumbers(((BigFluidStack)stack).amount), ((BigFluidStack)stack).getFluidStack().getLocalizedName()));
        }
        this.pendingFluids.clear();
    }

    private void injectItemsIntoUplink(BigItemStack stack) {
        UplinkStatus status = this.state.uplink.tryGivePlayerItems(Arrays.asList(stack));
        if (status != UplinkStatus.OK && !this.printedUplinkWarning) {
            this.printedUplinkWarning = true;
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74837_a((String)"mm.info.error.could_not_push_items_to_uplink", (Object[])new Object[]{status.toString()}));
        }
    }

    @Optional(value={"appliedenergistics2"})
    private void injectItemsIntoAE(BigItemStack stack) {
        IAEItemStack result = (IAEItemStack)this.state.storageGrid.getItemInventory().injectItems((IAEStack)stack.getAEItemStack(), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, (IActionHost)this.state.securityTerminal));
        stack.setStackSize(result != null ? result.getStackSize() : 0L);
    }

    private void injectItemsIntoInventory(BigItemStack stack) {
        while (stack.stackSize > 0L) {
            ItemStack smallStack = stack.remove(stack.getItemStack().func_77976_d());
            int toInsert = smallStack.field_77994_a;
            this.player.field_71071_by.func_70441_a(smallStack);
            stack.stackSize += (long)smallStack.field_77994_a;
            if (smallStack.field_77994_a != toInsert) continue;
            break;
        }
    }

    private void injectItemsIntoWorld(BigItemStack stack) {
        AxisAlignedBB aabb = AxisAlignedBB.func_72330_a((double)(this.player.field_70165_t - 2.5), (double)(this.player.field_70163_u - 1.0), (double)(this.player.field_70165_t - 2.5), (double)(this.player.field_70163_u + 2.5), (double)((double)this.player.func_70047_e() + 1.0), (double)(this.player.field_70161_v + 2.5));
        for (ItemStack smallStack : stack.toStacks()) {
            List onGround = this.player.field_70170_p.func_72872_a(EntityItemLarge.class, aabb);
            for (EntityItemLarge e : onGround) {
                if (smallStack.field_77994_a <= 0) break;
                ItemStack droppedStack = e.func_92059_d();
                if (!MMUtils.areStacksBasicallyEqual(droppedStack, smallStack)) continue;
                int toAdd = (int)(Math.min(Integer.MAX_VALUE, (long)droppedStack.field_77994_a + (long)smallStack.field_77994_a) - (long)droppedStack.field_77994_a);
                droppedStack = droppedStack.func_77946_l();
                droppedStack.field_77994_a += toAdd;
                smallStack.field_77994_a -= toAdd;
                e.func_92058_a(droppedStack);
            }
            if (smallStack.field_77994_a <= 0) continue;
            this.player.field_70170_p.func_72838_d((Entity)new EntityItemLarge(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, smallStack));
        }
    }

    @Optional(value={"appliedenergistics2"})
    private void injectFluidsIntoAE(BigFluidStack stack) {
        IAEFluidStack result = (IAEFluidStack)this.state.storageGrid.getFluidInventory().injectItems((IAEStack)stack.getAEFluidStack(), Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, (IActionHost)this.state.securityTerminal));
        stack.setStackSize(result != null ? result.getStackSize() : 0L);
    }

    private void injectFluidsIntoUplink(BigFluidStack stack) {
        UplinkStatus status = this.state.uplink.tryGivePlayerFluids(Arrays.asList(stack));
        if (status != UplinkStatus.OK && !this.printedUplinkWarning) {
            this.printedUplinkWarning = true;
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74837_a((String)"mm.info.error.could_not_push_fluids_to_uplink", (Object[])new Object[]{status.toString()}));
        }
    }

    private void injectFluidsIntoIdealCell(BigFluidStack stack) {
        FluidStack fluid = stack.getFluidStack();
        ItemStack idealCell = MMUtils.streamInventory((IInventory)this.player.field_71071_by).sorted(Comparator.comparingInt(x -> {
            int n;
            Item patt13712$temp;
            if (x != null && (patt13712$temp = x.func_77973_b()) instanceof IFluidContainerItem) {
                IFluidContainerItem container = (IFluidContainerItem)patt13712$temp;
                n = container.getCapacity(x);
            } else {
                n = 0;
            }
            return n;
        })).filter(x -> {
            IFluidContainerItem container;
            Item patt13884$temp;
            return x != null && (patt13884$temp = x.func_77973_b()) instanceof IFluidContainerItem && (container = (IFluidContainerItem)patt13884$temp).fill(x, fluid, false) == fluid.amount;
        }).findFirst().orElse(null);
        if (idealCell != null) {
            stack.amount -= (long)((IFluidContainerItem)idealCell.func_77973_b()).fill(idealCell, fluid, true);
        }
    }

    private void injectFluidsIntoCells(BigFluidStack stack) {
        FluidStack fluid = stack.getFluidStack();
        List validCells = MMUtils.streamInventory((IInventory)this.player.field_71071_by).filter(x -> {
            IFluidContainerItem container;
            Item patt14541$temp;
            return x != null && (patt14541$temp = x.func_77973_b()) instanceof IFluidContainerItem && (container = (IFluidContainerItem)patt14541$temp).fill(x, fluid, false) > 0;
        }).collect(Collectors.toList());
        for (ItemStack cell : validCells) {
            FluidStack fluid2 = stack.getFluidStack();
            stack.amount -= (long)((IFluidContainerItem)cell.func_77973_b()).fill(cell, fluid2, true);
            if (stack.amount > 0L) continue;
            return;
        }
    }

    private void consumeItemsFromPending(List<BigItemStack> requestedItems, List<BigItemStack> extractedItems, int flags) {
        boolean simulate = (flags & 1) != 0;
        boolean fuzzy = (flags & 2) != 0;
        for (BigItemStack req : requestedItems) {
            if (req.getStackSize() == 0L) continue;
            if (!fuzzy) {
                ItemId id = req.getId();
                long amtInPending = this.pendingItems.getLong((Object)id);
                if (amtInPending == 0L) continue;
                long toRemove = Math.min(amtInPending, req.getStackSize());
                extractedItems.add(req.copy().setStackSize(toRemove));
                amtInPending -= toRemove;
                req.decStackSize(toRemove);
                if (simulate) continue;
                if (amtInPending == 0L) {
                    this.pendingItems.removeLong((Object)id);
                    continue;
                }
                this.pendingItems.put((Object)id, amtInPending);
                continue;
            }
            ObjectIterator iter = this.pendingItems.object2LongEntrySet().iterator();
            while (iter.hasNext()) {
                ItemStack stack;
                Object2LongMap.Entry e = (Object2LongMap.Entry)iter.next();
                if (e.getLongValue() == 0L || (stack = ((ItemId)e.getKey()).getItemStack()).func_77973_b() != req.getItem() || stack.func_77981_g() && Items.field_151008_G.getDamage(stack) != req.getItemDamage()) continue;
                long amtInPending = e.getLongValue();
                long toRemove = Math.min(amtInPending, req.getStackSize());
                extractedItems.add(req.copy().setStackSize(toRemove));
                amtInPending -= toRemove;
                req.decStackSize(toRemove);
                if (simulate) continue;
                if (amtInPending == 0L) {
                    iter.remove();
                    continue;
                }
                e.setValue(amtInPending);
            }
        }
    }

    private void consumeItemsFromPlayer(List<BigItemStack> requestedItems, List<BigItemStack> extractedItems, int flags) {
        boolean simulate = (flags & 1) != 0;
        boolean fuzzy = (flags & 2) != 0;
        ItemStack[] inv = this.player.field_71071_by.field_70462_a;
        block0: for (BigItemStack req : requestedItems) {
            if (req.getStackSize() == 0L) continue;
            for (int i = 0; i < inv.length; ++i) {
                ItemStack slot = inv[i];
                if (req.getStackSize() == 0L) continue block0;
                if (slot == null || slot.func_77973_b() == null || slot.field_77994_a == 0 || req.getItem() != slot.func_77973_b()) continue;
                ItemStack reqStack = req.getItemStack();
                if (!fuzzy ? !MMUtils.areStacksBasicallyEqual(reqStack, slot) : reqStack.func_77981_g() && req.meta != Items.field_151008_G.getDamage(slot)) continue;
                if (slot.field_77994_a == 111) {
                    extractedItems.add(BigItemStack.create(slot).setStackSize(req.getStackSize()));
                    req.setStackSize(0L);
                    continue;
                }
                int toRemove = Math.min(slot.field_77994_a, reqStack.field_77994_a);
                req.decStackSize(toRemove);
                extractedItems.add(BigItemStack.create(slot).setStackSize(toRemove));
                if (simulate) continue;
                slot.field_77994_a -= toRemove;
                if (slot.field_77994_a == 0) {
                    inv[i] = null;
                }
                this.player.field_71071_by.func_70296_d();
            }
        }
    }

    @Optional(value={"appliedenergistics2"})
    private void consumeItemsFromAE(List<BigItemStack> requestedItems, List<BigItemStack> extractedItems, int flags) {
        boolean fuzzy;
        boolean simulate = (flags & 1) != 0;
        boolean bl = fuzzy = (flags & 2) != 0;
        if (this.state.encKey == null) {
            return;
        }
        if (!this.state.hasMEConnection() && !this.state.connectToMESystem()) {
            return;
        }
        if (!this.state.canInteractWithAE(this.player)) {
            return;
        }
        if (!this.visitedGrids.add(this.state.storageGrid)) {
            return;
        }
        block0: for (BigItemStack req : requestedItems) {
            if (req.getStackSize() == 0L) continue;
            IAEItemStack aeReq = req.getAEItemStack();
            ImmutableList matches = fuzzy ? ImmutableList.copyOf((Collection)this.state.itemStorage.getStorageList().findFuzzy((IAEStack)aeReq, FuzzyMode.IGNORE_ALL)) : Arrays.asList((IAEItemStack)this.state.itemStorage.getStorageList().findPrecise((IAEStack)aeReq));
            for (IAEItemStack match : matches) {
                if (req.getStackSize() == 0L) continue block0;
                if (match == null) continue;
                IAEItemStack result = (IAEItemStack)this.state.itemStorage.extractItems((IAEStack)(match = (IAEItemStack)match.copy().setStackSize(req.getStackSize())), simulate ? Actionable.SIMULATE : Actionable.MODULATE, (BaseActionSource)new PlayerSource(this.player, (IActionHost)this.state.securityTerminal));
                if (result == null) continue;
                extractedItems.add(BigItemStack.create(result));
                req.decStackSize(result.getStackSize());
            }
        }
    }

    @Optional(value={"gregtech_nh"})
    private void consumeItemsFromUplink(List<BigItemStack> requestedItems, List<BigItemStack> extractedItems, int flags) {
        boolean fuzzy;
        boolean simulate = (flags & 1) != 0;
        boolean bl = fuzzy = (flags & 2) != 0;
        if (this.state.uplinkAddress == null) {
            return;
        }
        this.state.connectToUplink();
        if (!this.state.hasUplinkConnection()) {
            return;
        }
        IUplinkMulti uplink = this.state.uplink;
        if (!this.visitedGrids.add(uplink.getStorageGrid())) {
            return;
        }
        Pair<UplinkStatus, List<BigItemStack>> result = uplink.tryConsumeItems(requestedItems, simulate, fuzzy);
        if (result.left() != UplinkStatus.OK && !this.printedUplinkWarning) {
            this.printedUplinkWarning = true;
            MMUtils.sendErrorToPlayer(this.player, StatCollector.func_74837_a((String)"mm.info.error.could_not_request_items_from_uplink", (Object[])new Object[]{((UplinkStatus)((Object)result.left())).toString()}));
        }
        if (result.right() != null) {
            extractedItems.addAll((Collection)result.right());
        }
    }

    protected void resetWarnings() {
        this.printedUplinkWarning = false;
    }
}

