/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import com.gtnewhorizon.structurelib.util.Vec3Impl;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.SoundResource;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.check.SimpleCheckRecipeResult;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.shutdown.ShutDownReason;
import gregtech.common.WirelessComputationPacket;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;
import tectech.mechanics.dataTransport.QuantumDataPacket;
import tectech.thing.casing.TTCasingsContainer;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataInput;
import tectech.thing.metaTileEntity.hatch.MTEHatchDataOutput;
import tectech.thing.metaTileEntity.hatch.MTEHatchRack;
import tectech.thing.metaTileEntity.hatch.MTEHatchWirelessComputationOutput;
import tectech.thing.metaTileEntity.multi.base.INameFunction;
import tectech.thing.metaTileEntity.multi.base.IStatusFunction;
import tectech.thing.metaTileEntity.multi.base.LedStatus;
import tectech.thing.metaTileEntity.multi.base.Parameters;
import tectech.thing.metaTileEntity.multi.base.TTMultiblockBase;
import tectech.thing.metaTileEntity.multi.base.render.TTRenderedExtendedFacingTexture;

public class MTEQuantumComputer
extends TTMultiblockBase
implements ISurvivalConstructable {
    private final ArrayList<MTEHatchRack> eRacks = new ArrayList();
    private final ArrayList<MTEHatchWirelessComputationOutput> eWirelessComputationOutputs = new ArrayList();
    private static Textures.BlockIcons.CustomIcon ScreenOFF;
    private static Textures.BlockIcons.CustomIcon ScreenON;
    private static final String[] description;
    private static final IStructureDefinition<MTEQuantumComputer> STRUCTURE_DEFINITION;
    protected Parameters.Group.ParameterIn overclock;
    protected Parameters.Group.ParameterIn overvolt;
    protected Parameters.Group.ParameterOut maxCurrentTemp;
    protected Parameters.Group.ParameterOut availableData;
    private boolean wirelessModeEnabled = false;
    private static final INameFunction<MTEQuantumComputer> OC_NAME;
    private static final INameFunction<MTEQuantumComputer> OV_NAME;
    private static final INameFunction<MTEQuantumComputer> MAX_TEMP_NAME;
    private static final INameFunction<MTEQuantumComputer> COMPUTE_NAME;
    private static final IStatusFunction<MTEQuantumComputer> OC_STATUS;
    private static final IStatusFunction<MTEQuantumComputer> OV_STATUS;
    private static final IStatusFunction<MTEQuantumComputer> MAX_TEMP_STATUS;
    private static final IStatusFunction<MTEQuantumComputer> COMPUTE_STATUS;

    public MTEQuantumComputer(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    public MTEQuantumComputer(String aName) {
        super(aName);
        this.eCertainMode = (byte)5;
        this.eCertainStatus = (byte)-128;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.quantumComputerFakeRecipes;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEQuantumComputer(this.mName);
    }

    @Override
    protected void parametersInstantiation_EM() {
        Parameters.Group hatch_0 = this.parametrization.getGroup(0);
        this.overclock = hatch_0.makeInParameter(0, 1.0, OC_NAME, OC_STATUS);
        this.overvolt = hatch_0.makeInParameter(1, 1.0, OV_NAME, OV_STATUS);
        this.maxCurrentTemp = hatch_0.makeOutParameter(0, 0.0, MAX_TEMP_NAME, MAX_TEMP_STATUS);
        this.availableData = hatch_0.makeOutParameter(1, 0.0, COMPUTE_NAME, COMPUTE_STATUS);
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity iGregTechTileEntity, ItemStack itemStack) {
        int offset;
        for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
        this.eRacks.clear();
        if (!this.structureCheck_EM("front", 1, 2, 0)) {
            return false;
        }
        if (!this.structureCheck_EM("cap", 1, 2, -1)) {
            return false;
        }
        int totalLen = 4;
        for (offset = -2; offset > -16 && this.structureCheck_EM("slice", 1, 2, offset); offset = (int)((byte)(offset - 1))) {
            totalLen = (byte)(totalLen + 1);
        }
        if (totalLen > 17) {
            return false;
        }
        if (!this.structureCheck_EM("cap", 1, 2, offset = (int)((byte)(offset + 1)))) {
            return false;
        }
        if (!this.structureCheck_EM("back", 1, 2, offset = (int)((byte)(offset - 1)))) {
            return false;
        }
        this.eCertainMode = (byte)Math.min(totalLen / 3, 5);
        for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
            rack.getBaseMetaTileEntity().setActive(iGregTechTileEntity.isActive());
        }
        return this.eUncertainHatches.size() == 1;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74780_a("computation", this.availableData.get());
        aNBT.func_74757_a("wirelessModeEnabled", this.wirelessModeEnabled);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        if (this.availableData != null) {
            this.availableData.set(aNBT.func_74769_h("computation"));
            this.eAvailableData = (long)this.availableData.get();
        }
        if (aNBT.func_74764_b("wirelessModeEnabled")) {
            this.wirelessModeEnabled = aNBT.func_74767_n("wirelessModeEnabled");
            if (this.wirelessModeEnabled) {
                WirelessComputationPacket.enableWirelessNetWork(this.getBaseMetaTileEntity());
            }
        } else {
            this.wirelessModeEnabled = false;
        }
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && this.mMachine && !aBaseMetaTileEntity.isActive() && aTick % 20L == 12L) {
            double maxTemp = 0.0;
            for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
                if (!((double)rack.heat > maxTemp)) continue;
                maxTemp = rack.heat;
            }
            this.maxCurrentTemp.set(maxTemp);
        }
    }

    @Override
    @NotNull
    protected CheckRecipeResult checkProcessing_EM() {
        this.parametrization.setToDefaults(false, true);
        this.eAvailableData = 0L;
        double maxTemp = 0.0;
        double overClockRatio = this.overclock.get();
        double overVoltageRatio = this.overvolt.get();
        if (Double.isNaN(overClockRatio) || Double.isNaN(overVoltageRatio)) {
            return SimpleCheckRecipeResult.ofFailure("no_computing");
        }
        if (this.overclock.getStatus((boolean)true).isOk && this.overvolt.getStatus((boolean)true).isOk) {
            float eut = Math.max((float)GTValues.V[6], (float)GTValues.V[7] * (float)overClockRatio * (float)overVoltageRatio);
            if (!(eut < 2.1474836E9f)) {
                this.mEUt = -((int)GTValues.V[7]);
                return CheckRecipeResultRegistry.POWER_OVERFLOW;
            }
            this.mEUt = -((int)eut);
            int thingsActive = 0;
            for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
                int rackComputation;
                if ((double)rack.heat > maxTemp) {
                    maxTemp = rack.heat;
                }
                if ((rackComputation = rack.tickComponents((float)overClockRatio, (float)overVoltageRatio)) > 0) {
                    this.eAvailableData += (long)rackComputation;
                    thingsActive = (short)(thingsActive + 4);
                }
                rack.getBaseMetaTileEntity().setActive(true);
            }
            for (MTEHatchDataInput di : this.eInputData) {
                if (di.q == null) continue;
                thingsActive = (short)(thingsActive + 1);
            }
            if (thingsActive > 0 && this.eCertainStatus == 0) {
                thingsActive = (short)(thingsActive + this.eOutputData.size());
                this.eAmpereFlow = 1 + (thingsActive >> 2);
                this.mMaxProgresstime = 20;
                this.mEfficiencyIncrease = 10000;
                this.maxCurrentTemp.set(maxTemp);
                this.availableData.set(this.eAvailableData);
                return SimpleCheckRecipeResult.ofSuccess("computing");
            }
            this.eAvailableData = 0L;
            this.mEUt = -((int)GTValues.V[7]);
            this.eAmpereFlow = 1L;
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 10000;
            this.maxCurrentTemp.set(maxTemp);
            this.availableData.set(this.eAvailableData);
            return SimpleCheckRecipeResult.ofSuccess("no_computing");
        }
        return SimpleCheckRecipeResult.ofFailure("no_computing");
    }

    @Override
    public void outputAfterRecipe_EM() {
        if (!this.eOutputData.isEmpty()) {
            Vec3Impl pos = new Vec3Impl(this.getBaseMetaTileEntity().getXCoord(), (int)this.getBaseMetaTileEntity().getYCoord(), this.getBaseMetaTileEntity().getZCoord());
            int eHatchData = 0;
            for (MTEHatchDataInput hatch : this.eInputData) {
                if (hatch.q == null || ((QuantumDataPacket)hatch.q).contains(pos)) continue;
                eHatchData = (int)((long)eHatchData + (Long)((QuantumDataPacket)hatch.q).getContent());
            }
            QuantumDataPacket pack = new QuantumDataPacket((this.eAvailableData + (long)eHatchData) / (long)this.eOutputData.size()).unifyTraceWith(pos);
            if (pack == null) {
                return;
            }
            for (MTEHatchDataOutput o : this.eOutputData) {
                o.providePacket(pack);
            }
        }
    }

    @Override
    public MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.machinetype")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.0")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.1")).addInfo(StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.desc.2")).addTecTechHatchInfo().beginVariableStructureBlock(2, 2, 4, 4, 5, 16, false).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.certain.tier.07.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), 1).addOtherStructurePart(StatCollector.func_74838_a((String)"tt.keyword.Structure.DataConnector"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), 1).addOtherStructurePart(StatCollector.func_74838_a((String)"gt.blockmachines.hatch.rack.tier.08.name"), StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyAdvComputerCasingExceptOuter"), 2).addEnergyHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), 1).addMaintenanceHatch(StatCollector.func_74838_a((String)"tt.keyword.Structure.AnyComputerCasingFirstOrLastSlice"), 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ, ItemStack aTool) {
        if (this.getBaseMetaTileEntity().isServerSide()) {
            boolean bl = this.wirelessModeEnabled = !this.wirelessModeEnabled;
            if (this.wirelessModeEnabled) {
                GTUtility.sendChatToPlayer(aPlayer, "Wireless mode enabled");
                WirelessComputationPacket.enableWirelessNetWork(this.getBaseMetaTileEntity());
            } else {
                GTUtility.sendChatToPlayer(aPlayer, "Wireless mode disabled");
                WirelessComputationPacket.disableWirelessNetWork(this.getBaseMetaTileEntity());
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        ScreenOFF = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER");
        ScreenON = new Textures.BlockIcons.CustomIcon("iconsets/EM_COMPUTER_ACTIVE");
        super.registerIcons(aBlockIconRegister);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3], new TTRenderedExtendedFacingTexture(aActive ? ScreenON : ScreenOFF)};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[8][3]};
    }

    @Override
    protected SoundResource getActivitySoundLoop() {
        return SoundResource.TECTECH_MACHINES_FX_HIGH_FREQ;
    }

    @Override
    public void onRemoval() {
        super.onRemoval();
        for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void extraExplosions_EM() {
        for (MetaTileEntity metaTileEntity : this.eRacks) {
            metaTileEntity.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
        }
    }

    @Override
    protected long getAvailableData_EM() {
        return this.eAvailableData;
    }

    @Override
    public void stopMachine(@Nonnull ShutDownReason reason) {
        super.stopMachine(reason);
        this.eAvailableData = 0L;
        for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    @Override
    protected void afterRecipeCheckFailed() {
        super.afterRecipeCheckFailed();
        for (MTEHatchRack rack : GTUtility.validMTEList(this.eRacks)) {
            rack.getBaseMetaTileEntity().setActive(false);
        }
    }

    public final boolean addRackToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchRack) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eRacks.add((MTEHatchRack)aMetaTileEntity);
        }
        return false;
    }

    public final boolean addWirelessDataOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchWirelessComputationOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.eWirelessComputationOutputs.add((MTEHatchWirelessComputationOutput)aMetaTileEntity) && this.eOutputData.add((MTEHatchWirelessComputationOutput)aMetaTileEntity);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM("front", 1, 2, 0, stackSize, hintsOnly);
        this.structureBuild_EM("cap", 1, 2, -1, stackSize, hintsOnly);
        int offset = -2;
        for (int rackSlices = Math.min(stackSize.field_77994_a, 12); rackSlices > 0; --rackSlices) {
            int n = offset;
            offset = (byte)(offset - 1);
            this.structureBuild_EM("slice", 1, 2, n, stackSize, hintsOnly);
        }
        int n = offset;
        offset = (byte)(offset - 1);
        this.structureBuild_EM("cap", 1, 2, n, stackSize, hintsOnly);
        this.structureBuild_EM("back", 1, 2, offset, stackSize, hintsOnly);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, IItemSource source, EntityPlayerMP actor) {
        if (this.mMachine) {
            return -1;
        }
        int built = this.survivalBuildPiece("front", stackSize, 1, 2, 0, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        built = this.survivalBuildPiece("cap", stackSize, 1, 2, -1, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        int offset = -2;
        for (int rackSlices = Math.min(stackSize.field_77994_a, 12); rackSlices > 0; --rackSlices) {
            int n = offset;
            offset = (byte)(offset - 1);
            built = this.survivalBuildPiece("slice", stackSize, 1, 2, n, elementBudget, source, actor, false, true);
            if (built < 0) continue;
            return built;
        }
        int n = offset;
        offset = (byte)(offset - 1);
        built = this.survivalBuildPiece("cap", stackSize, 1, 2, n, elementBudget, source, actor, false, true);
        if (built >= 0) {
            return built;
        }
        return this.survivalBuildPiece("back", stackSize, 1, 2, offset, elementBudget, source, actor, false, true);
    }

    public IStructureDefinition<MTEQuantumComputer> getStructure_EM() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return description;
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> data = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        if (this.wirelessModeEnabled) {
            WirelessComputationPacket wirelessComputationPacket = WirelessComputationPacket.getPacketByUserId(this.getBaseMetaTileEntity().getOwnerUuid());
            data.add(StatCollector.func_74838_a((String)"tt.infodata.qc.wireless_mode.enabled"));
            data.add(StatCollector.func_74837_a((String)"tt.infodata.qc.total_wireless_computation", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + wirelessComputationPacket.getAvailableComputationStored()}));
        } else {
            data.add(StatCollector.func_74838_a((String)"tt.infodata.qc.wireless_mode.disabled"));
        }
        return data.toArray(new String[0]);
    }

    static {
        description = new String[]{EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"tt.keyphrase.Hint_Details") + ":", StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.0"), StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.hint.1")};
        STRUCTURE_DEFINITION = IStructureDefinition.builder().addShape("front", StructureUtility.transpose((String[][])new String[][]{{" AA"}, {" AA"}, {" ~A"}, {" AA"}})).addShape("cap", StructureUtility.transpose((String[][])new String[][]{{"-CB"}, {" DD"}, {" DD"}, {"-CB"}})).addShape("slice", StructureUtility.transpose((String[][])new String[][]{{"-CB"}, {" ED"}, {" ED"}, {"-CB"}})).addShape("back", StructureUtility.transpose((String[][])new String[][]{{" AA"}, {" AA"}, {" AA"}, {" AA"}})).addElement('B', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1)).addElement('C', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)2)).addElement('D', StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)3)).addElement('A', GTStructureUtility.buildHatchAdder(MTEQuantumComputer.class).atLeast(HatchElement.Energy.or(TTMultiblockBase.HatchElement.EnergyMulti), HatchElement.Maintenance, TTMultiblockBase.HatchElement.Uncertainty, TTMultiblockBase.HatchElement.InputData, TTMultiblockBase.HatchElement.OutputData, WirelessComputationHatchElement.INSTANCE).casingIndex(1025).dot(1).buildAndChain(StructureUtility.ofBlock((Block)TTCasingsContainer.sBlockCasingsTT, (int)1))).addElement('E', RackHatchElement.INSTANCE.newAnyOrCasing(1027, 2, TTCasingsContainer.sBlockCasingsTT, 3)).build();
        OC_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.0");
        OV_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgi.1");
        MAX_TEMP_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.0");
        COMPUTE_NAME = (base, p) -> StatCollector.func_74838_a((String)"gt.blockmachines.multimachine.em.computer.cfgo.1");
        OC_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.0, 1.0, 3.0, 5.0, new double[0]);
        OV_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.0, 1.0, 3.0, 5.0, new double[0]);
        MAX_TEMP_STATUS = (base, p) -> LedStatus.fromLimitsInclusiveOuterBoundary(p.get(), 0.0, 2000.0, 8000.0, 10000.0, new double[0]);
        COMPUTE_STATUS = (base, p) -> {
            if (base.eAvailableData < 0L) {
                return LedStatus.STATUS_TOO_LOW;
            }
            if (base.eAvailableData == 0L) {
                return LedStatus.STATUS_NEUTRAL;
            }
            return LedStatus.STATUS_OK;
        };
    }

    private static enum WirelessComputationHatchElement implements IHatchElement<MTEQuantumComputer>
    {
        INSTANCE;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchWirelessComputationOutput.class);
        }

        @Override
        public IGTHatchAdder<? super MTEQuantumComputer> adder() {
            return MTEQuantumComputer::addWirelessDataOutputToMachineList;
        }

        @Override
        public long count(MTEQuantumComputer gtMetaTileEntityEmComputer) {
            return gtMetaTileEntityEmComputer.eWirelessComputationOutputs.size();
        }
    }

    private static enum RackHatchElement implements IHatchElement<MTEQuantumComputer>
    {
        INSTANCE;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchRack.class);
        }

        @Override
        public IGTHatchAdder<? super MTEQuantumComputer> adder() {
            return MTEQuantumComputer::addRackToMachineList;
        }

        @Override
        public long count(MTEQuantumComputer t) {
            return t.eRacks.size();
        }
    }
}

