/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.render.TextureFactory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.loader.ConfigHandler;
import tectech.util.CommonValues;
import tectech.util.TTUtility;

public class MTEHatchCapacitor
extends MTEHatch
implements IAddUIWidgets {
    private static Textures.BlockIcons.CustomIcon TM_H;
    private static Textures.BlockIcons.CustomIcon TM_H_ACTIVE;
    private static final Map<String, CapacitorComponent> componentBinds;

    public MTEHatchCapacitor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 16, new String[]{CommonValues.THETA_MOVEMENT, StatCollector.func_74838_a((String)"gt.blockmachines.hatch.capacitor.desc.0"), EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"gt.blockmachines.hatch.capacitor.desc.1")}, new ITexture[0]);
    }

    public MTEHatchCapacitor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 16, aDescription, aTextures);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        TM_H_ACTIVE = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_CAPS_ACTIVE");
        TM_H = new Textures.BlockIcons.CustomIcon("iconsets/TM_TESLA_CAPS");
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TM_H_ACTIVE)};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        return new ITexture[]{aBaseTexture, TextureFactory.of(TM_H)};
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchCapacitor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return true;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return side == aBaseMetaTileEntity.getFrontFacing();
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public int func_70302_i_() {
        return this.getBaseMetaTileEntity().isActive() ? 0 : this.mInventory.length;
    }

    public long[] getCapacitors() {
        long tier = -1L;
        long tCurrent = 0L;
        long tEnergyMax = 0L;
        for (ItemStack stack : this.mInventory) {
            CapacitorComponent cap;
            if (stack == null || stack.field_77994_a != 1 || (cap = componentBinds.get(TTUtility.getUniqueIdentifier(stack))) == null || cap.tier <= tier) continue;
            tier = cap.tier;
        }
        if (tier >= 0L) {
            for (int i = 0; i < this.mInventory.length; ++i) {
                CapacitorComponent cap;
                if (this.mInventory[i] == null || this.mInventory[i].field_77994_a != 1 || (cap = componentBinds.get(TTUtility.getUniqueIdentifier(this.mInventory[i]))) == null) continue;
                if (cap.tier < tier) {
                    if (!this.getBaseMetaTileEntity().isActive()) continue;
                    this.mInventory[i] = null;
                    this.getBaseMetaTileEntity().setOnFire();
                    continue;
                }
                tCurrent += cap.current;
                tEnergyMax += cap.energyMax;
            }
        }
        return new long[]{tier, tCurrent, tEnergyMax};
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)4).startFromSlot(0).endAtSlot(15).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

            public int func_75219_a() {
                return 1;
            }

            public boolean isEnabled() {
                return !MTEHatchCapacitor.this.getBaseMetaTileEntity().isActive();
            }
        }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot()}).build().setPos(52, 7));
    }

    public static void run() {
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.0", 0L, 1L, GTValues.V[1] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.1", 1L, 1L, GTValues.V[2] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.2", 2L, 1L, GTValues.V[3] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.3", 3L, 1L, GTValues.V[4] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.4", 4L, 1L, GTValues.V[5] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.5", 5L, 1L, GTValues.V[6] * 512L);
        new CapacitorComponent("tectech:item.tm.teslaCoilCapacitor.6", 6L, 1L, GTValues.V[7] * 512L);
    }

    static {
        componentBinds = new HashMap<String, CapacitorComponent>();
    }

    public static class CapacitorComponent
    implements Comparable<CapacitorComponent> {
        private final String unlocalizedName;
        private final long tier;
        private final long current;
        private final long energyMax;

        CapacitorComponent(ItemStack is, long tier, long current, long energyMax) {
            this(TTUtility.getUniqueIdentifier(is), tier, current, energyMax);
        }

        CapacitorComponent(String is, long tier, long current, long energyMax) {
            this.unlocalizedName = is;
            this.tier = tier;
            this.current = current;
            this.energyMax = energyMax;
            componentBinds.put(this.unlocalizedName, this);
            if (ConfigHandler.debug.DEBUG_MODE) {
                TecTech.LOGGER.info((Object)("Tesla Capacitor registered: " + this.unlocalizedName));
            }
        }

        @Override
        public int compareTo(CapacitorComponent o) {
            return this.unlocalizedName.compareTo(o.unlocalizedName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof CapacitorComponent) {
                return this.compareTo((CapacitorComponent)obj) == 0;
            }
            return false;
        }
    }
}

