/*
 * Decompiled with CFR 0.152.
 */
package tectech.mechanics.spark;

import com.gtnewhorizon.structurelib.util.Vec3Impl;
import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.util.Objects;

public class ThaumSpark
implements Serializable {
    private static final long serialVersionUID = -7037856938316679566L;
    public int x;
    public int y;
    public int z;
    public int wID;
    public byte xR;
    public byte yR;
    public byte zR;

    public ThaumSpark(int x, int y, int z, byte xR, byte yR, byte zR, int wID) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.xR = xR;
        this.yR = yR;
        this.zR = zR;
        this.wID = wID;
    }

    public ThaumSpark(ByteBuf buf) {
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.xR = buf.readByte();
        this.yR = buf.readByte();
        this.zR = buf.readByte();
        this.wID = buf.readInt();
    }

    public ThaumSpark(Vec3Impl origin, Vec3Impl target, int wID) {
        this.x = origin.get0();
        this.y = origin.get1();
        this.z = origin.get2();
        Vec3Impl offset = target.sub(origin);
        this.xR = (byte)offset.get0();
        this.yR = (byte)offset.get1();
        this.zR = (byte)offset.get2();
        this.wID = wID;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ThaumSpark that = (ThaumSpark)o;
        return this.x == that.x && this.y == that.y && this.z == that.z && this.wID == that.wID && this.xR == that.xR && this.yR == that.yR && this.zR == that.zR;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z, this.wID, this.xR, this.yR, this.zR);
    }

    public void writeToBuf(ByteBuf buf) {
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeByte((int)this.xR);
        buf.writeByte((int)this.yR);
        buf.writeByte((int)this.zR);
        buf.writeInt(this.wID);
    }
}

