/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.tile.multi.elevator;

import com.google.common.collect.ImmutableList;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.ICustomBlockSetting;
import com.gtnewhorizon.structurelib.structure.IItemSource;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ITierConverter;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.util.IGTHatchAdder;
import gregtech.common.misc.spaceprojects.SpaceProjectManager;
import gregtech.common.misc.spaceprojects.interfaces.ISpaceProject;
import gtnhintergalactic.tile.multi.elevator.TileEntitySpaceElevator;
import gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;

public class ElevatorUtil {
    private static final int[] AVAILABLE_MODULE_SLOTS = new int[]{6, 12, 15, 18, 24};

    public static boolean isProjectAvailable(UUID machineOwner, String neededProject, String neededLocation) {
        if (neededProject != null && !neededProject.isEmpty()) {
            if (neededLocation != null && !neededLocation.isEmpty()) {
                ISpaceProject project = SpaceProjectManager.getTeamProject(machineOwner, SpaceProjectManager.getLocation(neededLocation), neededProject);
                return project != null && project.isFinished();
            }
            ArrayList<ISpaceProject> projects = new ArrayList<ISpaceProject>(SpaceProjectManager.getTeamSpaceProjects(machineOwner));
            for (ISpaceProject project : projects) {
                if (project == null || !project.isFinished() || neededLocation == null || !neededLocation.equals(project.getProjectLocation().getName())) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static int getModuleSlotsUnlocked(int motorTier) {
        if (motorTier < 1 || motorTier > AVAILABLE_MODULE_SLOTS.length) {
            return 0;
        }
        return AVAILABLE_MODULE_SLOTS[motorTier - 1];
    }

    public static int getPlanetaryTravelTier(int motorTier) {
        if (motorTier >= 3) {
            return 9;
        }
        return 8;
    }

    public static <T> IStructureElement<T> ofBlockAdder(final IBlockAdder<T> iBlockAdder, final Block defaultBlock, final int defaultMeta) {
        if (iBlockAdder == null || defaultBlock == null) {
            throw new IllegalArgumentException();
        }
        if (defaultBlock instanceof ICustomBlockSetting) {
            return new IStructureElement<T>(){

                public boolean check(T t, World world, int x, int y, int z) {
                    Block worldBlock = world.func_147439_a(x, y, z);
                    return iBlockAdder.apply(t, worldBlock, worldBlock.func_149643_k(world, x, y, z), world, x, y, z);
                }

                public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                    ((ICustomBlockSetting)defaultBlock).setBlock(world, x, y, z, defaultMeta);
                    return true;
                }

                public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                    StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)defaultBlock, (int)defaultMeta);
                    return true;
                }

                public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                    return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
                }

                public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                    if (this.check(t, world, x, y, z)) {
                        return IStructureElement.PlaceResult.SKIP;
                    }
                    return StructureUtility.survivalPlaceBlock((Block)defaultBlock, (int)defaultMeta, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
                }
            };
        }
        return new IStructureElement<T>(){

            public boolean check(T t, World world, int x, int y, int z) {
                Block worldBlock = world.func_147439_a(x, y, z);
                return iBlockAdder.apply(t, worldBlock, worldBlock.func_149643_k(world, x, y, z), world, x, y, z);
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                world.func_147465_d(x, y, z, defaultBlock, defaultMeta, 2);
                return true;
            }

            public boolean spawnHint(T t, World world, int x, int y, int z, ItemStack trigger) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)defaultBlock, (int)defaultMeta);
                return true;
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, IItemSource s, EntityPlayerMP actor, Consumer<IChatComponent> chatter) {
                return this.survivalPlaceBlock(t, world, x, y, z, trigger, AutoPlaceEnvironment.fromLegacy((IItemSource)s, (EntityPlayer)actor, chatter));
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                if (this.check(t, world, x, y, z)) {
                    return IStructureElement.PlaceResult.SKIP;
                }
                return StructureUtility.survivalPlaceBlock((Block)defaultBlock, (int)defaultMeta, (World)world, (int)x, (int)y, (int)z, (IItemSource)env.getSource(), (EntityPlayer)env.getActor(), (Consumer)env.getChatter());
            }
        };
    }

    public static List<Pair<Block, Integer>> getMotorTiers() {
        return ImmutableList.of((Object)Pair.of((Object)GregTechAPI.sBlockCasingsSEMotor, (Object)0), (Object)Pair.of((Object)GregTechAPI.sBlockCasingsSEMotor, (Object)1), (Object)Pair.of((Object)GregTechAPI.sBlockCasingsSEMotor, (Object)2), (Object)Pair.of((Object)GregTechAPI.sBlockCasingsSEMotor, (Object)3), (Object)Pair.of((Object)GregTechAPI.sBlockCasingsSEMotor, (Object)4));
    }

    public static ITierConverter<Integer> motorTierConverter() {
        return (block, meta) -> {
            if (block == null) {
                return -1;
            }
            if (block == GregTechAPI.sBlockCasingsSEMotor) {
                return meta + 1;
            }
            return -1;
        };
    }

    public static interface IBlockAdder<T> {
        public boolean apply(T var1, Block var2, int var3, World var4, int var5, int var6, int var7);
    }

    public static enum ProjectModuleElement implements IHatchElement<TileEntitySpaceElevator>
    {
        ProjectModule(TileEntitySpaceElevator::addProjectModuleToMachineList, new Class[]{TileEntityModuleBase.class}){

            @Override
            public long count(TileEntitySpaceElevator tileEntity) {
                return tileEntity.mProjectModuleHatches.size();
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<TileEntitySpaceElevator> adder;

        @SafeVarargs
        private ProjectModuleElement(IGTHatchAdder<TileEntitySpaceElevator> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super TileEntitySpaceElevator> adder() {
            return this.adder;
        }
    }
}

