/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines;

import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.items.MetaGeneratedTool;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.recipe.maps.FuelBackend;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TurbineStatCalculator;
import gregtech.api.util.shutdown.ShutDownReasonRegistry;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.xmod.gregtech.api.metatileentity.implementations.MTEHatchTurbine;
import gtPlusPlus.xmod.gregtech.common.tileentities.machines.multi.production.turbines.MTELargerTurbineBase;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTELargerTurbinePlasma
extends MTELargerTurbineBase {
    public MTELargerTurbinePlasma(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTELargerTurbinePlasma(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTELargerTurbinePlasma(this.mName);
    }

    @Override
    public int getCasingMeta() {
        return 4;
    }

    @Override
    public int getCasingTextureIndex() {
        return 60;
    }

    @Override
    protected boolean requiresOutputHatch() {
        return true;
    }

    @Override
    public int getFuelValue(FluidStack aLiquid) {
        if (aLiquid == null) {
            return 0;
        }
        GTRecipe tFuel = this.getRecipeMap().getBackend().findFuel(aLiquid);
        if (tFuel != null) {
            return tFuel.mSpecialValue;
        }
        return 0;
    }

    public RecipeMap<FuelBackend> getRecipeMap() {
        return RecipeMaps.plasmaFuels;
    }

    @Override
    public int getRecipeCatalystPriority() {
        return -20;
    }

    @Override
    protected boolean filtersFluid() {
        return false;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing() {
        try {
            ArrayList<MTEHatchTurbine> aEmptyTurbineRotorHatches = this.getEmptyTurbineAssemblies();
            if (!aEmptyTurbineRotorHatches.isEmpty()) {
                block2: for (MTEHatchTurbine aHatch : aEmptyTurbineRotorHatches) {
                    ArrayList<ItemStack> aTurbines = this.getAllBufferedTurbines();
                    for (ItemStack aTurbineItem : aTurbines) {
                        if (aTurbineItem == null || !aHatch.insertTurbine(aTurbineItem.func_77946_l())) continue;
                        this.depleteTurbineFromStock(aTurbineItem);
                        continue block2;
                    }
                }
            }
            if (!this.getEmptyTurbineAssemblies().isEmpty() || !this.areAllTurbinesTheSame()) {
                this.stopMachine(ShutDownReasonRegistry.NO_TURBINE);
                return CheckRecipeResultRegistry.NO_TURBINE_FOUND;
            }
            ItemStack turbineItem = ((MTEHatchTurbine)this.mTurbineRotorHatches.get(0)).getTurbine();
            TurbineStatCalculator turbine = new TurbineStatCalculator((MetaGeneratedTool)turbineItem.func_77973_b(), turbineItem);
            ArrayList<FluidStack> tFluids = this.getStoredFluids();
            if (!tFluids.isEmpty()) {
                if (this.baseEff == 0 || this.optFlow == 0L || this.counter >= 512 || this.getBaseMetaTileEntity().hasWorkJustBeenEnabled() || this.getBaseMetaTileEntity().hasInventoryBeenModified()) {
                    this.counter = 0;
                    float aTotalBaseEff = 0.0f;
                    float aTotalOptimalFlow = 0.0f;
                    ItemStack aStack = this.getFullTurbineAssemblies().get(0).getTurbine();
                    aTotalBaseEff += turbine.getPlasmaEfficiency() * 10000.0f;
                    aTotalOptimalFlow += turbine.getOptimalPlasmaFlow();
                    double aEUPerTurbine = turbine.getOptimalPlasmaEUt();
                    if ((aTotalOptimalFlow *= (float)this.getSpeedMultiplier()) < 0.0f) {
                        aTotalOptimalFlow = 100.0f;
                    }
                    this.flowMultipliers[0] = MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mSteamMultiplier;
                    this.flowMultipliers[1] = MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mGasMultiplier;
                    this.flowMultipliers[2] = MetaGeneratedTool.getPrimaryMaterial((ItemStack)aStack).mPlasmaMultiplier;
                    this.baseEff = MathUtils.roundToClosestInt(aTotalBaseEff);
                    this.optFlow = MathUtils.roundToClosestInt(aTotalOptimalFlow);
                    this.euPerTurbine = MathUtils.roundToClosestInt(aEUPerTurbine);
                    if (this.optFlow <= 0L || this.baseEff <= 0) {
                        this.stopMachine(ShutDownReasonRegistry.NONE);
                        return CheckRecipeResultRegistry.NO_FUEL_FOUND;
                    }
                } else {
                    ++this.counter;
                }
            }
            long newPower = this.fluidIntoPower(tFluids, turbine);
            int fuelValue = 0;
            if (!tFluids.isEmpty()) {
                fuelValue = this.getFuelValue(new FluidStack(tFluids.get(0), 0));
            }
            float magicValue = (float)fuelValue * 0.005f * ((float)fuelValue * 0.005f);
            float efficiencyLoss = Math.min(1.0f, magicValue / (float)this.euPerTurbine);
            newPower = (long)((float)newPower * efficiencyLoss);
            long difference = newPower - this.lEUt;
            int maxChangeAllowed = Math.max(200, GTUtility.safeInt(Math.abs(difference) / 5L));
            if (Math.abs(difference) > (long)maxChangeAllowed) {
                int change = maxChangeAllowed * (difference > 0L ? 1 : -1);
                this.lEUt += (long)change;
            } else {
                this.lEUt = newPower;
            }
            if (this.lEUt <= 0L) {
                this.lEUt = 0L;
                this.mEfficiency = 0;
                return CheckRecipeResultRegistry.NO_FUEL_FOUND;
            }
            this.mMaxProgresstime = 20;
            this.mEfficiencyIncrease = 200;
            this.enableAllTurbineHatches();
            return CheckRecipeResultRegistry.GENERATING;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return CheckRecipeResultRegistry.NO_FUEL_FOUND;
        }
    }

    @Override
    long fluidIntoPower(ArrayList<FluidStack> aFluids, TurbineStatCalculator turbine) {
        if (!aFluids.isEmpty()) {
            int tEU = 0;
            int actualOptimalFlow = 0;
            FluidStack firstFuelType = new FluidStack(aFluids.get(0), 0);
            int fuelValue = this.getFuelValue(firstFuelType);
            if (fuelValue <= 0) {
                return 0L;
            }
            actualOptimalFlow = GTUtility.safeInt((long)((double)((float)this.getSpeedMultiplier() * (this.isLooseMode() ? turbine.getOptimalLoosePlasmaFlow() : turbine.getOptimalPlasmaFlow()) * 20.0f) / (double)fuelValue));
            this.realOptFlow = actualOptimalFlow;
            int remainingFlow = GTUtility.safeInt((long)((float)actualOptimalFlow * 1.25f));
            int flow = 0;
            int totalFlow = 0;
            this.storedFluid = 0;
            for (FluidStack aFluid : aFluids) {
                if (!aFluid.isFluidEqual(firstFuelType)) continue;
                flow = Math.min(aFluid.amount, remainingFlow);
                this.depleteInput(new FluidStack(aFluid, flow));
                this.storedFluid += aFluid.amount;
                remainingFlow -= flow;
                totalFlow += flow;
            }
            String fn = FluidRegistry.getFluidName((FluidStack)firstFuelType);
            String[] nameSegments = fn.split("\\.", 2);
            if (nameSegments.length == 2) {
                String outputName = nameSegments[1];
                FluidStack output = FluidRegistry.getFluidStack((String)outputName, (int)totalFlow);
                if (output == null) {
                    output = FluidRegistry.getFluidStack((String)("molten." + outputName), (int)totalFlow);
                }
                if (output != null) {
                    this.addOutput(output);
                }
            }
            if (totalFlow <= 0) {
                return 0L;
            }
            tEU = GTUtility.safeInt((long)((double)fuelValue / 20.0 * (double)totalFlow));
            if (totalFlow != actualOptimalFlow) {
                double efficiency = 1.0 - (double)Math.abs((float)(totalFlow - actualOptimalFlow) / (float)actualOptimalFlow);
                tEU = (int)((double)tEU * efficiency);
            }
            tEU = GTUtility.safeInt((long)((this.isLooseMode() ? turbine.getLoosePlasmaEfficiency() : turbine.getPlasmaEfficiency()) * (float)tEU));
            return tEU;
        }
        return 0L;
    }

    @Override
    public String getMachineType() {
        return "Large Plasma Turbine, XLPT";
    }

    @Override
    protected String getTurbineType() {
        return "Plasma";
    }

    @Override
    protected String getCasingName() {
        return "Reinforced Plasma Turbine Casing";
    }

    @Override
    protected boolean isDenseSteam() {
        return false;
    }
}

