/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.tileentities.base;

import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.IDescribable;
import gregtech.api.interfaces.tileentity.IBasicEnergyContainer;
import gregtech.api.interfaces.tileentity.IEnergyConnected;
import gregtech.api.interfaces.tileentity.IGregTechDeviceInformation;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IHasInventory;
import gregtech.api.interfaces.tileentity.IRedstoneTileEntity;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.data.GTBlockEventTracker;
import gregtech.common.pollution.Pollution;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.api.objects.minecraft.BTF_Inventory;
import ic2.api.Direction;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityBase
extends TileEntity
implements IRedstoneTileEntity,
IHasInventory,
IBasicEnergyContainer,
IGregTechDeviceInformation,
IDescribable {
    private String customName;
    public String mOwnerName = "null";
    public String mOwnerUUID = "null";
    private boolean mIsOwnerOP = false;
    public final BTF_Inventory mInventory;
    protected TileEntityBase mMetaTileEntity;
    protected long mStoredEnergy = 0L;
    protected int mAverageEUInputIndex = 0;
    protected int mAverageEUOutputIndex = 0;
    protected boolean mReleaseEnergy = false;
    protected int[] mAverageEUInput = new int[11];
    protected int[] mAverageEUOutput = new int[11];
    private final boolean[] mActiveEUInputs = new boolean[]{false, false, false, false, false, false};
    private final boolean[] mActiveEUOutputs = new boolean[]{false, false, false, false, false, false};
    private final byte[] mSidedRedstone = new byte[]{0, 0, 0, 0, 0, 0};
    private final int[] mTimeStatistics = new int[GregTechAPI.TICKS_FOR_LAG_AVERAGING];
    private boolean mHasEnoughEnergy = true;
    protected boolean mRunningThroughTick = false;
    protected boolean mInputDisabled = false;
    protected boolean mOutputDisabled = false;
    private final boolean mMuffler = false;
    private final boolean mLockUpgrade = false;
    private final boolean mActive = false;
    private boolean mRedstone = false;
    private final boolean mWorkUpdate = false;
    private boolean mInventoryChanged = false;
    private final boolean mWorks = true;
    private final boolean mNeedsUpdate = true;
    private final boolean mNeedsBlockUpdate = true;
    private boolean mSendClientData = false;
    private final boolean oRedstone = false;
    private final boolean mEnergyStateReady = false;
    private final byte mColor = 0;
    private final byte oColor = 0;
    private byte mStrongRedstone = 0;
    private final byte oRedstoneData = (byte)63;
    private final byte oTextureData = 0;
    private final byte oUpdateData = 0;
    private final byte oTexturePage = 0;
    private final byte oLightValueClient = (byte)-1;
    private final byte oLightValue = (byte)-1;
    private byte mLightValue = 0;
    private final byte mOtherUpgrades = 0;
    private final byte mFacing = 0;
    private final byte oFacing = 0;
    private final byte mWorkData = 0;
    private final int mDisplayErrorCode = 0;
    private final int oX = 0;
    private final int oY = 0;
    private final int oZ = 0;
    private final int mTimeStatisticsIndex = 0;
    private final int mLagWarningCount = 0;
    private final short mID = 0;
    protected long mTickTimer = 0L;
    private final long oOutput = 0L;
    private long mAcceptedAmperes = Long.MAX_VALUE;
    private final TileEntity[] mBufferedTileEntities = new TileEntity[6];
    public boolean ignoreUnloadedChunks = true;
    public boolean isDead = false;
    private boolean firstTicked = false;

    public TileEntityBase(int aCapacity) {
        this.mInventory = new BTF_Inventory(aCapacity, this);
    }

    public NBTTagCompound getTag(NBTTagCompound nbt, String tag) {
        if (!nbt.func_74764_b(tag)) {
            nbt.func_74782_a(tag, (NBTBase)new NBTTagCompound());
        }
        return nbt.func_74775_l(tag);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        if (this.func_145818_k_()) {
            nbt.func_74778_a("CustomName", this.getCustomName());
        }
        nbt.func_74757_a("mIsOwnerOP", this.mIsOwnerOP);
        nbt.func_74778_a("mOwnerName", this.mOwnerName);
        nbt.func_74778_a("mOwnerUUID", this.mOwnerUUID);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        if (nbt.func_150297_b("CustomName", 8)) {
            this.setCustomName(nbt.func_74779_i("CustomName"));
        }
        this.mIsOwnerOP = nbt.func_74767_n("mIsOwnerOP");
        this.mOwnerName = nbt.func_74779_i("mOwnerName");
        this.mOwnerUUID = nbt.func_74779_i("mOwnerUUID");
    }

    public void func_145845_h() {
        long aTick = System.currentTimeMillis();
        this.isDead = false;
        if (!this.firstTicked) {
            this.onFirstTick();
        }
        try {
            if (this.isServerSide()) {
                this.onPreTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's pre-tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's tick stage.");
            t.printStackTrace();
        }
        try {
            if (this.isServerSide()) {
                this.onPostTick(aTick);
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's post-tick stage.");
            t.printStackTrace();
        }
    }

    public boolean onPreTick(long aTick) {
        return true;
    }

    public boolean onTick(long aTick) {
        try {
            if (this.isServerSide()) {
                this.processRecipe();
            }
        }
        catch (Throwable t) {
            Logger.ERROR("Tile Entity Encountered an error in it's processing of a recipe stage.");
            t.printStackTrace();
        }
        return true;
    }

    public boolean onPostTick(long aTick) {
        return true;
    }

    public boolean processRecipe() {
        return true;
    }

    public String getOwner() {
        if (this.mOwnerName == null) {
            return "null";
        }
        return this.mOwnerName;
    }

    public UUID getOwnerUUID() {
        return UUID.fromString(this.mOwnerUUID);
    }

    public boolean isOwnerOP() {
        return this.mIsOwnerOP;
    }

    public void setOwnerInformation(String mName, String mUUID, boolean mOP) {
        if (this.isServerSide() && (this.mOwnerName == null || this.mOwnerUUID == null || this.mOwnerName.equals("null") || this.mOwnerUUID.equals("null"))) {
            this.mOwnerName = mName;
            this.mOwnerUUID = mUUID;
            this.mIsOwnerOP = mOP;
        }
    }

    @Override
    public boolean isServerSide() {
        if (this.func_145830_o()) {
            return !this.func_145831_w().field_72995_K;
        }
        return false;
    }

    @Override
    public final boolean isClientSide() {
        return this.field_145850_b.field_72995_K;
    }

    public String getCustomName() {
        return this.customName;
    }

    public void setCustomName(String customName) {
        this.customName = customName;
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.tileentity.name";
    }

    public boolean func_145818_k_() {
        return this.customName != null && !this.customName.isEmpty();
    }

    public int func_70302_i_() {
        return this.mInventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int aIndex) {
        return this.mInventory.func_70301_a(aIndex);
    }

    public ItemStack func_70298_a(int aIndex, int aAmount) {
        if (this.canAccessData()) {
            this.mInventoryChanged = true;
            return this.mInventory.func_70298_a(aIndex, aAmount);
        }
        return null;
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        return this.mInventory.func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        this.mInventory.func_70299_a(p_70299_1_, p_70299_2_);
    }

    public int func_70297_j_() {
        return this.mInventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        return this.mInventory.func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
        this.mInventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.mInventory.func_70305_f();
    }

    public boolean func_94041_b(int aIndex, ItemStack aStack) {
        return this.canAccessData() && this.mInventory.func_94041_b(aIndex, aStack);
    }

    public int[] func_94128_d(int ordinalSide) {
        if (this.canAccessData()) {
            return this.mInventory.func_94128_d(ordinalSide);
        }
        return GTValues.emptyIntArray;
    }

    public boolean func_102007_a(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mInputDisabled) && this.mInventory.func_102007_a(aIndex, aStack, ordinalSide);
    }

    public boolean func_102008_b(int aIndex, ItemStack aStack, int ordinalSide) {
        return this.canAccessData() && (this.mRunningThroughTick || !this.mOutputDisabled) && this.mInventory.func_102008_b(aIndex, aStack, ordinalSide);
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return this.canAccessData() && this.mInventory.isValidSlot(aIndex);
    }

    public void issueClientUpdate() {
        this.mSendClientData = true;
    }

    protected final boolean canAccessData() {
        return !this.isDead() && !this.func_145837_r();
    }

    @Override
    public void issueBlockUpdate() {
        super.func_70296_d();
    }

    @Override
    public long getTimer() {
        return this.mTickTimer;
    }

    @Override
    public long getOutputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesOut() : 0L;
    }

    @Override
    public long getOutputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput() ? this.mMetaTileEntity.maxEUOutput() : 0L;
    }

    @Override
    public long getInputAmperage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxAmperesIn() : 0L;
    }

    @Override
    public long getInputVoltage() {
        return this.canAccessData() && this.mMetaTileEntity.isElectric() ? this.mMetaTileEntity.maxEUInput() : Integer.MAX_VALUE;
    }

    @Override
    public boolean decreaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooLessEnergy) {
        return this.canAccessData() && (this.mHasEnoughEnergy = this.decreaseStoredEU(aEnergy, aIgnoreTooLessEnergy));
    }

    @Override
    public boolean increaseStoredEnergyUnits(long aEnergy, boolean aIgnoreTooMuchEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.getStoredEU() >= this.getEUCapacity() && !aIgnoreTooMuchEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() + aEnergy);
        return true;
    }

    @Override
    public boolean inputEnergyFrom(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN || (!this.isServerSide() ? this.isEnergyInputSide(side) : side != ForgeDirection.UNKNOWN && this.mActiveEUInputs[side.ordinal()] && !this.mReleaseEnergy);
    }

    @Override
    public boolean outputsEnergyTo(ForgeDirection side) {
        return side == ForgeDirection.UNKNOWN || (!this.isServerSide() ? this.isEnergyOutputSide(side) : side != ForgeDirection.UNKNOWN && this.mActiveEUOutputs[side.ordinal()] || this.mReleaseEnergy);
    }

    private boolean isEnergyInputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return false;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetInput()) {
                return this.mMetaTileEntity.isInputFacing(side);
            }
        }
        return false;
    }

    private boolean isEnergyOutputSide(ForgeDirection side) {
        if (side != ForgeDirection.UNKNOWN) {
            if (this.func_145837_r() || this.mReleaseEnergy) {
                return this.mReleaseEnergy;
            }
            if (this.canAccessData() && this.mMetaTileEntity.isElectric() && this.mMetaTileEntity.isEnetOutput()) {
                return this.mMetaTileEntity.isOutputFacing(side);
            }
        }
        return false;
    }

    public boolean isOutputFacing(ForgeDirection side) {
        return false;
    }

    public boolean isInputFacing(ForgeDirection side) {
        return false;
    }

    private void clearNullMarkersFromTileEntityBuffer() {
        for (int i = 0; i < this.mBufferedTileEntities.length; ++i) {
            if (this.mBufferedTileEntities[i] != this) continue;
            this.mBufferedTileEntities[i] = null;
        }
    }

    protected final void clearTileEntityBuffer() {
        Arrays.fill(this.mBufferedTileEntities, null);
    }

    @Override
    public final World getWorld() {
        return this.field_145850_b;
    }

    @Override
    public final int getXCoord() {
        return this.field_145851_c;
    }

    @Override
    public final short getYCoord() {
        return (short)this.field_145848_d;
    }

    @Override
    public final int getZCoord() {
        return this.field_145849_e;
    }

    @Override
    public final int getOffsetX(ForgeDirection side, int aMultiplier) {
        return this.field_145851_c + side.offsetX * aMultiplier;
    }

    @Override
    public final short getOffsetY(ForgeDirection side, int aMultiplier) {
        return (short)(this.field_145848_d + side.offsetY * aMultiplier);
    }

    @Override
    public final int getOffsetZ(ForgeDirection side, int aMultiplier) {
        return this.field_145849_e + side.offsetZ * aMultiplier;
    }

    @Override
    public final int getRandomNumber(int aRange) {
        return this.field_145850_b.field_73012_v.nextInt(aRange);
    }

    @Override
    public final BiomeGenBase getBiome(int aX, int aZ) {
        return this.field_145850_b.func_72807_a(aX, aZ);
    }

    @Override
    public final BiomeGenBase getBiome() {
        return this.getBiome(this.field_145851_c, this.field_145849_e);
    }

    @Override
    public final Block getBlockOffset(int aX, int aY, int aZ) {
        return this.getBlock(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final Block getBlockAtSide(ForgeDirection side) {
        return this.getBlockAtSideAndDistance(side, 1);
    }

    @Override
    public final Block getBlockAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getBlock(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final int getMetaIDOffset(int aX, int aY, int aZ) {
        return this.getMetaID(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final int getMetaIDAtSide(ForgeDirection side) {
        return this.getMetaIDAtSideAndDistance(side, 1);
    }

    @Override
    public final int getMetaIDAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getMetaID(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final byte getLightLevelOffset(int aX, int aY, int aZ) {
        return this.getLightLevel(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final byte getLightLevelAtSide(ForgeDirection side) {
        return this.getLightLevelAtSideAndDistance(side, 1);
    }

    @Override
    public final byte getLightLevelAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getLightLevel(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final boolean getOpacityOffset(int aX, int aY, int aZ) {
        return this.getOpacity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getOpacityAtSide(ForgeDirection side) {
        return this.getOpacityAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getOpacityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getOpacity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final boolean getSkyOffset(int aX, int aY, int aZ) {
        return this.getSky(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getSkyAtSide(ForgeDirection side) {
        return this.getSkyAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getSkyAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getSky(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final boolean getAirOffset(int aX, int aY, int aZ) {
        return this.getAir(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final boolean getAirAtSide(ForgeDirection side) {
        return this.getAirAtSideAndDistance(side, 1);
    }

    @Override
    public final boolean getAirAtSideAndDistance(ForgeDirection side, int aDistance) {
        return this.getAir(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final TileEntity getTileEntityOffset(int aX, int aY, int aZ) {
        return this.getTileEntity(this.field_145851_c + aX, this.field_145848_d + aY, this.field_145849_e + aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        return aDistance == 1 ? this.getTileEntityAtSide(side) : this.getTileEntity(this.getOffsetX(side, aDistance), this.getOffsetY(side, aDistance), this.getOffsetZ(side, aDistance));
    }

    @Override
    public final IInventory getIInventory(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    @Override
    public final IInventory getIInventoryOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    @Override
    public final IInventory getIInventoryAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    @Override
    public final IInventory getIInventoryAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IInventory ? (IInventory)tTileEntity : null;
    }

    @Override
    public final IFluidHandler getITankContainer(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IFluidHandler getITankContainerOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IFluidHandler getITankContainerAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IFluidHandler ? (IFluidHandler)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntity(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntity(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityOffset(int aX, int aY, int aZ) {
        TileEntity tTileEntity = this.getTileEntityOffset(aX, aY, aZ);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSide(ForgeDirection side) {
        TileEntity tTileEntity = this.getTileEntityAtSide(side);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final IGregTechTileEntity getIGregTechTileEntityAtSideAndDistance(ForgeDirection side, int aDistance) {
        TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(side, aDistance);
        return tTileEntity instanceof IGregTechTileEntity ? (IGregTechTileEntity)tTileEntity : null;
    }

    @Override
    public final Block getBlock(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? Blocks.field_150350_a : this.field_145850_b.func_147439_a(aX, aY, aZ);
    }

    @Override
    public final int getMetaID(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? 0 : this.field_145850_b.func_72805_g(aX, aY, aZ);
    }

    @Override
    public final byte getLightLevel(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? (byte)0 : (byte)(this.field_145850_b.func_72801_o(aX, aY, aZ) * 15.0f);
    }

    @Override
    public final boolean getSky(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) || this.field_145850_b.func_72937_j(aX, aY, aZ);
    }

    @Override
    public final boolean getOpacity(int aX, int aY, int aZ) {
        return (!this.ignoreUnloadedChunks || !this.crossedChunkBorder(aX, aZ) || this.field_145850_b.func_72899_e(aX, aY, aZ)) && GTUtility.isOpaqueBlock(this.field_145850_b, aX, aY, aZ);
    }

    @Override
    public final boolean getAir(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) || GTUtility.isBlockAir(this.field_145850_b, aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntity(int aX, int aY, int aZ) {
        return this.ignoreUnloadedChunks && this.crossedChunkBorder(aX, aZ) && !this.field_145850_b.func_72899_e(aX, aY, aZ) ? null : this.field_145850_b.func_147438_o(aX, aY, aZ);
    }

    @Override
    public final TileEntity getTileEntityAtSide(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        if (side != ForgeDirection.UNKNOWN && this.mBufferedTileEntities[ordinalSide] != this) {
            int tX = this.getOffsetX(side, 1);
            short tY = this.getOffsetY(side, 1);
            int tZ = this.getOffsetZ(side, 1);
            if (this.crossedChunkBorder(tX, tZ)) {
                this.mBufferedTileEntities[ordinalSide] = null;
                if (this.ignoreUnloadedChunks && !this.field_145850_b.func_72899_e(tX, (int)tY, tZ)) {
                    return null;
                }
            }
            if (this.mBufferedTileEntities[ordinalSide] == null) {
                this.mBufferedTileEntities[ordinalSide] = this.field_145850_b.func_147438_o(tX, (int)tY, tZ);
                if (this.mBufferedTileEntities[ordinalSide] == null) {
                    this.mBufferedTileEntities[ordinalSide] = this;
                    return null;
                }
                return this.mBufferedTileEntities[ordinalSide];
            }
            if (this.mBufferedTileEntities[ordinalSide].func_145837_r()) {
                this.mBufferedTileEntities[ordinalSide] = null;
                return this.getTileEntityAtSide(side);
            }
            return this.mBufferedTileEntities[ordinalSide].field_145851_c == tX && this.mBufferedTileEntities[ordinalSide].field_145848_d == tY && this.mBufferedTileEntities[ordinalSide].field_145849_e == tZ ? this.mBufferedTileEntities[ordinalSide] : null;
        }
        return null;
    }

    @Override
    public boolean isDead() {
        return this.isDead || this.isInvalidTileEntity();
    }

    public void func_145829_t() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145829_t();
    }

    public void func_145843_s() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.func_145843_s();
    }

    public void onChunkUnload() {
        this.clearNullMarkersFromTileEntityBuffer();
        super.onChunkUnload();
        this.isDead = true;
    }

    public final void onAdjacentBlockChange(int aX, int aY, int aZ) {
        this.clearNullMarkersFromTileEntityBuffer();
    }

    @Override
    public final void sendBlockEvent(byte aID, byte aValue) {
        GTBlockEventTracker.enqueue(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, aID, aValue);
    }

    private boolean crossedChunkBorder(int aX, int aZ) {
        return aX >> 4 != this.field_145851_c >> 4 || aZ >> 4 != this.field_145849_e >> 4;
    }

    public final void setOnFire() {
        GTUtility.setCoordsOnFire(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    public final void setToFire() {
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150480_ab);
    }

    @Override
    public byte getInputRedstoneSignal(ForgeDirection side) {
        return (byte)(this.field_145850_b.func_72878_l(this.getOffsetX(side, 1), (int)this.getOffsetY(side, 1), this.getOffsetZ(side, 1), side.ordinal()) & 0xF);
    }

    @Override
    public byte getOutputRedstoneSignal(ForgeDirection side) {
        return this.getGeneralRS(side);
    }

    public boolean allowGeneralRedstoneOutput() {
        return false;
    }

    @Override
    public byte getGeneralRS(ForgeDirection side) {
        return this.allowGeneralRedstoneOutput() ? this.mSidedRedstone[side.ordinal()] : (byte)0;
    }

    @Override
    public void setOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        aStrength = (byte)Math.min(Math.max(0, aStrength), 15);
        if (side != ForgeDirection.UNKNOWN && this.mSidedRedstone[side.ordinal()] != aStrength) {
            this.mSidedRedstone[side.ordinal()] = aStrength;
            this.issueBlockUpdate();
        }
    }

    @Override
    public boolean hasInventoryBeenModified() {
        return this.mInventoryChanged;
    }

    @Override
    public void setGenericRedstoneOutput(boolean aOnOff) {
        this.mRedstone = aOnOff;
    }

    @Override
    public void setLightValue(byte aLightValue) {
        this.mLightValue = (byte)(aLightValue & 0xF);
    }

    @Override
    public long getAverageElectricInput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUInput.length; ++i) {
            if (i == this.mAverageEUInputIndex) continue;
            rEU += this.mAverageEUInput[i];
        }
        return rEU / (this.mAverageEUInput.length - 1);
    }

    @Override
    public long getAverageElectricOutput() {
        int rEU = 0;
        for (int i = 0; i < this.mAverageEUOutput.length; ++i) {
            if (i == this.mAverageEUOutputIndex) continue;
            rEU += this.mAverageEUOutput[i];
        }
        return rEU / (this.mAverageEUOutput.length - 1);
    }

    public String getOwnerName() {
        if (GTUtility.isStringInvalid(this.mOwnerName)) {
            return "Player";
        }
        return this.mOwnerName;
    }

    public String setOwnerName(String aName) {
        if (GTUtility.isStringInvalid(aName)) {
            this.mOwnerName = "Player";
            return "Player";
        }
        this.mOwnerName = aName;
        return this.mOwnerName;
    }

    @Override
    public byte getComparatorValue(ForgeDirection side) {
        return this.canAccessData() ? this.mMetaTileEntity.getComparatorValue(side) : (byte)0;
    }

    @Override
    public byte getStrongOutputRedstoneSignal(ForgeDirection side) {
        int ordinalSide = side.ordinal();
        return side != ForgeDirection.UNKNOWN && (this.mStrongRedstone & 1 << ordinalSide) != 0 ? (byte)(this.mSidedRedstone[ordinalSide] & 0xF) : (byte)0;
    }

    @Override
    public void setStrongOutputRedstoneSignal(ForgeDirection side, byte aStrength) {
        this.mStrongRedstone = (byte)(this.mStrongRedstone | 1 << side.ordinal());
        this.setOutputRedstoneSignal(side, aStrength);
    }

    @Override
    public void setRedstoneOutputStrength(ForgeDirection side, boolean isStrong) {
        this.mStrongRedstone = isStrong ? (byte)(this.mStrongRedstone | (byte)side.flag) : (byte)(this.mStrongRedstone & ~((byte)side.flag));
        this.setOutputRedstoneSignal(side, this.mSidedRedstone[side.ordinal()]);
    }

    @Override
    public boolean getRedstoneOutputStrength(ForgeDirection side) {
        return (this.mStrongRedstone & side.flag) != 0;
    }

    @Override
    public long injectEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.inputEnergyFrom(side) && aAmperage > 0L && aVoltage > 0L && this.getStoredEU() < this.getEUCapacity() && this.mMetaTileEntity.maxAmperesIn() > this.mAcceptedAmperes)) {
            return 0L;
        }
        if (aVoltage > this.getInputVoltage()) {
            this.doExplosion(aVoltage);
            return 0L;
        }
        if (this.increaseStoredEnergyUnits(aVoltage * (aAmperage = Math.min(aAmperage, Math.min(this.mMetaTileEntity.maxAmperesIn() - this.mAcceptedAmperes, 1L + (this.getEUCapacity() - this.getStoredEU()) / aVoltage))), true)) {
            int n = this.mAverageEUInputIndex;
            this.mAverageEUInput[n] = (int)((long)this.mAverageEUInput[n] + aVoltage * aAmperage);
            this.mAcceptedAmperes += aAmperage;
            return aAmperage;
        }
        return 0L;
    }

    @Override
    public boolean drainEnergyUnits(ForgeDirection side, long aVoltage, long aAmperage) {
        if (!(this.canAccessData() && this.mMetaTileEntity.isElectric() && this.outputsEnergyTo(side) && this.getStoredEU() - aVoltage * aAmperage >= this.mMetaTileEntity.getMinimumStoredEU())) {
            return false;
        }
        if (this.decreaseStoredEU(aVoltage * aAmperage, false)) {
            int n = this.mAverageEUOutputIndex;
            this.mAverageEUOutput[n] = (int)((long)this.mAverageEUOutput[n] + aVoltage * aAmperage);
            return true;
        }
        return false;
    }

    public double getOutputEnergyUnitsPerTick() {
        return 0.0;
    }

    public boolean isTeleporterCompatible(ForgeDirection side) {
        return false;
    }

    public double demandedEnergyUnits() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0.0;
        }
        return this.getEUCapacity() - this.getStoredEU();
    }

    public double injectEnergyUnits(ForgeDirection aDirection, double aAmount) {
        return this.injectEnergyUnits(aDirection, (int)aAmount, 1L) > 0L ? 0.0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aEmitter, ForgeDirection aDirection) {
        return this.inputEnergyFrom(aDirection);
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, ForgeDirection aDirection) {
        return this.outputsEnergyTo(aDirection);
    }

    public double getOfferedEnergy() {
        return this.canAccessData() && this.getStoredEU() - this.mMetaTileEntity.getMinimumStoredEU() >= 0L ? (double)Math.max(0L, 0L) : 0.0;
    }

    public void drawEnergy(double amount) {
        int n = this.mAverageEUOutputIndex;
        this.mAverageEUOutput[n] = (int)((double)this.mAverageEUOutput[n] + amount);
        this.decreaseStoredEU((int)amount, true);
    }

    public int injectEnergy(ForgeDirection aForgeDirection, int aAmount) {
        return this.injectEnergyUnits(aForgeDirection, aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public int addEnergy(int aEnergy) {
        if (!this.canAccessData()) {
            return 0;
        }
        if (aEnergy > 0) {
            this.increaseStoredEnergyUnits(aEnergy, true);
        } else {
            this.decreaseStoredEU(-aEnergy, true);
        }
        return (int)Math.min(Integer.MAX_VALUE, this.mMetaTileEntity.getEUVar());
    }

    public boolean isAddedToEnergyNet() {
        return false;
    }

    public int demandsEnergy() {
        if (this.mReleaseEnergy || !this.canAccessData() || !this.mMetaTileEntity.isEnetInput()) {
            return 0;
        }
        return this.getCapacity() - this.getStored();
    }

    public int getCapacity() {
        return (int)Math.min(Integer.MAX_VALUE, this.getEUCapacity());
    }

    public int getStored() {
        return (int)Math.min(Integer.MAX_VALUE, Math.min(this.getStoredEU(), (long)this.getCapacity()));
    }

    public void setStored(int aEU) {
        if (this.canAccessData()) {
            this.setStoredEU(aEU);
        }
    }

    public int getMaxSafeInput() {
        return (int)Math.min(Integer.MAX_VALUE, this.getInputVoltage());
    }

    public int getMaxEnergyOutput() {
        if (this.mReleaseEnergy) {
            return Integer.MAX_VALUE;
        }
        return this.getOutput();
    }

    public int getOutput() {
        return (int)Math.min(Integer.MAX_VALUE, 0L);
    }

    public int injectEnergy(Direction aDirection, int aAmount) {
        return this.injectEnergyUnits(aDirection.toForgeDirection(), aAmount, 1L) > 0L ? 0 : aAmount;
    }

    public boolean acceptsEnergyFrom(TileEntity aReceiver, Direction aDirection) {
        return this.inputEnergyFrom(aDirection.toForgeDirection());
    }

    public boolean emitsEnergyTo(TileEntity aReceiver, Direction aDirection) {
        return this.outputsEnergyTo(aDirection.toForgeDirection());
    }

    @Override
    public boolean isInvalidTileEntity() {
        return this.func_145837_r();
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack) {
        if (GTUtility.isStackInvalid(aStack)) {
            return true;
        }
        if (aIndex < 0 || aIndex >= this.func_70302_i_()) {
            return false;
        }
        ItemStack tStack = this.func_70301_a(aIndex);
        if (GTUtility.isStackInvalid(tStack)) {
            this.func_70299_a(aIndex, aStack);
            return true;
        }
        if (GTUtility.areStacksEqual(tStack, aStack = GTOreDictUnificator.get(aStack)) && tStack.field_77994_a + aStack.field_77994_a <= Math.min(aStack.func_77976_d(), this.func_70297_j_())) {
            tStack.field_77994_a += aStack.field_77994_a;
            return true;
        }
        return false;
    }

    @Override
    public boolean addStackToSlot(int aIndex, ItemStack aStack, int aAmount) {
        return this.addStackToSlot(aIndex, GTUtility.copyAmount(aAmount, aStack));
    }

    public void func_70296_d() {
        super.func_70296_d();
        this.mInventoryChanged = true;
    }

    public boolean isElectric() {
        return true;
    }

    public boolean isEnetOutput() {
        return false;
    }

    public boolean isEnetInput() {
        return false;
    }

    public long maxEUStore() {
        return 0L;
    }

    public long maxEUInput() {
        return 0L;
    }

    public long maxEUOutput() {
        return 0L;
    }

    public long maxAmperesOut() {
        return 1L;
    }

    public long maxAmperesIn() {
        return 1L;
    }

    public void doEnergyExplosion() {
        if (this.getUniversalEnergyCapacity() > 0L && this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 5L) {
            this.doExplosion(this.oOutput * (long)(this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() ? 4 : (this.getUniversalEnergyStored() >= this.getUniversalEnergyCapacity() / 2L ? 2 : 1)));
            GTMod arg9999 = GTMod.GT;
            GTMod.achievements.issueAchievement(this.func_145831_w().func_72924_a(this.mOwnerName), "electricproblems");
        }
    }

    public void doExplosion(long aAmount) {
        if (this.canAccessData()) {
            if (GregTechAPI.sMachineWireFire && this.mMetaTileEntity.isElectric()) {
                try {
                    this.mReleaseEnergy = true;
                    IEnergyConnected.Util.emitEnergyToNetwork(GTValues.V[5], Math.max(1L, this.getStoredEU() / GTValues.V[5]), this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.mReleaseEnergy = false;
            this.onExplosion();
            Pollution.addPollution(this, 100000);
            this.mMetaTileEntity.doExplosion(aAmount);
        }
    }

    public void onExplosion() {
    }

    @Override
    public String[] getDescription() {
        return this.canAccessData() ? this.mMetaTileEntity.getDescription() : GTValues.emptyStringArray;
    }

    @Override
    public boolean isGivingInformation() {
        return true;
    }

    public long getEUVar() {
        return this.mStoredEnergy;
    }

    public void setEUVar(long aEnergy) {
        this.mStoredEnergy = aEnergy;
    }

    @Override
    public long getStoredEU() {
        return this.canAccessData() ? Math.min(this.mMetaTileEntity.getEUVar(), this.getEUCapacity()) : 0L;
    }

    @Override
    public long getEUCapacity() {
        return this.canAccessData() ? this.mMetaTileEntity.maxEUStore() : 0L;
    }

    public long getMinimumStoredEU() {
        return 512L;
    }

    public boolean setStoredEU(long aEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (aEnergy < 0L) {
            aEnergy = 0L;
        }
        this.mMetaTileEntity.setEUVar(aEnergy);
        return true;
    }

    public boolean decreaseStoredEU(long aEnergy, boolean aIgnoreTooLessEnergy) {
        if (!this.canAccessData()) {
            return false;
        }
        if (this.mMetaTileEntity.getEUVar() - aEnergy < 0L && !aIgnoreTooLessEnergy) {
            return false;
        }
        this.setStoredEU(this.mMetaTileEntity.getEUVar() - aEnergy);
        if (this.mMetaTileEntity.getEUVar() < 0L) {
            this.setStoredEU(0L);
            return false;
        }
        return true;
    }

    public boolean energyStateReady() {
        return false;
    }

    public boolean onFirstTick() {
        if (!this.firstTicked) {
            this.firstTicked = true;
            if (this.mInventory != null) {
                this.mInventory.purgeNulls();
                return true;
            }
        }
        return false;
    }

    public boolean inputEnergyFrom(byte arg0, boolean arg1) {
        return false;
    }

    public boolean outputsEnergyTo(byte arg0, boolean arg1) {
        return false;
    }

    @Override
    public byte getColorization() {
        return 0;
    }

    @Override
    public byte setColorization(byte arg0) {
        return 0;
    }

    @Override
    public byte getStrongestRedstone() {
        return 0;
    }

    @Override
    public boolean getRedstone() {
        return false;
    }

    @Override
    public boolean getRedstone(ForgeDirection side) {
        return false;
    }

    @Override
    public boolean isUniversalEnergyStored(long arg0) {
        return false;
    }

    @Override
    public long getUniversalEnergyStored() {
        return 0L;
    }

    @Override
    public long getUniversalEnergyCapacity() {
        return 0L;
    }
}

