/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.tool.misc;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.enums.SubTag;
import gregtech.api.enums.TCAspects;
import gregtech.api.interfaces.IItemBehaviour;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicTank;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.item.ModItems;
import gtPlusPlus.core.util.minecraft.FluidUtils;
import gtPlusPlus.core.util.minecraft.NBTUtils;
import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.api.item.ISpecialElectricItem;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class ItemGregtechPump
extends Item
implements ISpecialElectricItem,
IElectricItemManager,
IFluidContainerItem {
    private final HashMap<Short, ArrayList<IItemBehaviour<ItemGregtechPump>>> mItemBehaviors = new HashMap();
    public final short mOffset;
    public final short mItemAmount;
    public final BitSet mEnabledItems;
    public final BitSet mVisibleItems;
    private String unlocalizedName;
    private final HashMap<Integer, IIcon> mIconMap = new LinkedHashMap<Integer, IIcon>();
    private final HashMap<Integer, EnumRarity> rarity = new LinkedHashMap<Integer, EnumRarity>();
    public final HashMap<Short, Long[]> mElectricStats = new LinkedHashMap<Short, Long[]>();

    public boolean func_77648_a(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, int a4, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (aStack == null || aPlayer == null || aWorld == null || aWorld.field_72995_K) {
            return false;
        }
        return this.tryDrainTile(aStack, aWorld, aPlayer, aX, aY, aZ);
    }

    public void registerPumpType(int aID, String aPumpName, int aEuMax, int aTier) {
        EnumRarity enumRarity;
        long l = aEuMax;
        short s = (short)aTier;
        switch (aTier) {
            case 0: {
                enumRarity = EnumRarity.common;
                break;
            }
            case 1: {
                enumRarity = EnumRarity.uncommon;
                break;
            }
            case 2: {
                enumRarity = EnumRarity.rare;
                break;
            }
            default: {
                enumRarity = EnumRarity.epic;
            }
        }
        ModItems.toolGregtechPump.registerItem(aID, aPumpName, l, s, enumRarity);
    }

    public ItemGregtechPump() {
        this("MU-metatool.01", AddToCreativeTab.tabTools, 1000, 31766);
    }

    public ItemGregtechPump(String unlocalizedName, CreativeTabs creativeTab, short aOffset, short aItemAmount) {
        this.mEnabledItems = new BitSet(aItemAmount);
        this.mVisibleItems = new BitSet(aItemAmount);
        this.mOffset = (short)Math.min(32766, aOffset);
        this.mItemAmount = (short)Math.min(aItemAmount, 32766 - this.mOffset);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b(unlocalizedName);
        this.func_77637_a(creativeTab);
        this.func_77625_d(1);
        if (GameRegistry.findItem((String)Mods.GTPlusPlus.ID, (String)unlocalizedName) == null) {
            GameRegistry.registerItem((Item)this, (String)unlocalizedName);
        }
    }

    public void registerItem(int id, String localizedName, long euStorage, short tier, EnumRarity regRarity) {
        this.addItem(id, localizedName, EnumChatFormatting.GRAY + "Can be used to remove fluids from GT machine input & output slots", new Object[0]);
        if (euStorage > 0L && tier > 0) {
            this.setElectricStats(this.mOffset + id, euStorage, GTValues.V[tier], tier, -3L, true);
        }
        this.rarity.put(id, regRarity);
    }

    @SideOnly(value=Side.CLIENT)
    public EnumRarity func_77613_e(ItemStack par1ItemStack) {
        int h = this.getCorrectMetaForItemstack(par1ItemStack);
        if (this.rarity.get(h) != null) {
            return this.rarity.get(h);
        }
        return EnumRarity.common;
    }

    public void func_77624_a(ItemStack aStack, EntityPlayer aPlayer, List aList, boolean aF3_H) {
        ArrayList<IItemBehaviour<ItemGregtechPump>> tList;
        int aOffsetMeta = this.getCorrectMetaForItemstack(aStack);
        aList.add(GTLanguageManager.getTranslation("gtplusplus." + this.func_77667_c(aStack) + "." + aOffsetMeta + ".tooltip"));
        FluidStack f = this.getFluid(aStack);
        aList.add(StatCollector.func_74838_a((String)"item.itemGregtechPump.tooltip.0"));
        aList.add(StatCollector.func_74838_a((String)"item.itemGregtechPump.tooltip.1"));
        aList.add(EnumChatFormatting.DARK_GRAY + StatCollector.func_74838_a((String)"item.itemGregtechPump.tooltip.2"));
        aList.add(EnumChatFormatting.BLUE + (f != null ? f.getLocalizedName() : StatCollector.func_74838_a((String)"item.itemGregtechPump.tooltip.3")));
        aList.add(EnumChatFormatting.BLUE + (f != null ? "" + GTUtility.formatNumbers(f.amount) : "0") + "L / " + GTUtility.formatNumbers(this.getCapacity(aStack)) + "L");
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats != null) {
            if (tStats[3] > 0L) {
                aList.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"item.itemBaseEuItem.tooltip.1", (Object[])new Object[]{GTUtility.formatNumbers(tStats[3]), tStats[2] >= 0L ? tStats[2] : 0L}) + EnumChatFormatting.GRAY);
            } else {
                long tCharge = this.getRealCharge(aStack);
                if (tStats[3] == -2L && tCharge <= 0L) {
                    aList.add(EnumChatFormatting.AQUA + StatCollector.func_74838_a((String)"item.itemBaseEuItem.tooltip.2") + EnumChatFormatting.GRAY);
                } else {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = GTUtility.formatNumbers(tCharge);
                    objectArray[1] = GTUtility.formatNumbers(Math.abs(tStats[0]));
                    objectArray[2] = GTUtility.formatNumbers(GTValues.V[(int)(tStats[2] >= 0L ? (tStats[2] < (long)GTValues.V.length ? tStats[2] : (long)(GTValues.V.length - 1)) : 1L)]);
                    aList.add(EnumChatFormatting.AQUA + StatCollector.func_74837_a((String)"item.itemBaseEuItem.tooltip.3", (Object[])objectArray) + EnumChatFormatting.GRAY);
                }
            }
        }
        if ((tList = this.mItemBehaviors.get((short)this.getDamage(aStack))) != null) {
            for (IItemBehaviour<ItemGregtechPump> tBehavior : tList) {
                aList = tBehavior.getAdditionalToolTips(this, aList, aStack);
            }
        }
    }

    public final Item getChargedItem(ItemStack itemStack) {
        return this;
    }

    public final Item getEmptyItem(ItemStack itemStack) {
        return this;
    }

    public final double getMaxCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.abs(tStats[0]);
    }

    public final double getTransferLimit(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0.0;
        }
        return Math.max(tStats[1], tStats[3]);
    }

    public final int getTier(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        return (int)(tStats == null ? Integer.MAX_VALUE : tStats[2]);
    }

    public final double charge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aSimulate) {
        long tNewCharge;
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier || tStats[3] != -1L && tStats[3] != -3L && (tStats[3] >= 0L || aCharge != 2.147483647E9) || aStack.field_77994_a != 1) {
            return 0.0;
        }
        long tChargeBefore = this.getRealCharge(aStack);
        long l = aCharge == 2.147483647E9 ? Long.MAX_VALUE : (tNewCharge = Math.min(Math.abs(tStats[0]), tChargeBefore + (aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge))));
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tNewCharge - tChargeBefore;
    }

    public final double discharge(ItemStack aStack, double aCharge, int aTier, boolean aIgnoreTransferLimit, boolean aBatteryAlike, boolean aSimulate) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[2] > (long)aTier) {
            return 0.0;
        }
        if (aBatteryAlike && !this.canProvideEnergy(aStack)) {
            return 0.0;
        }
        if (tStats[3] > 0L) {
            if (aCharge < (double)tStats[3].longValue() || aStack.field_77994_a < 1) {
                return 0.0;
            }
            if (!aSimulate) {
                --aStack.field_77994_a;
            }
            return tStats[3].longValue();
        }
        long tChargeBefore = this.getRealCharge(aStack);
        long tNewCharge = Math.max(0L, tChargeBefore - (aIgnoreTransferLimit ? (long)aCharge : Math.min(tStats[1], (long)aCharge)));
        if (!aSimulate) {
            this.setCharge(aStack, tNewCharge);
        }
        return tChargeBefore - tNewCharge;
    }

    public final double getCharge(ItemStack aStack) {
        return this.getRealCharge(aStack);
    }

    public final boolean canUse(ItemStack aStack, double aAmount) {
        return (double)this.getRealCharge(aStack) >= aAmount;
    }

    public final boolean use(ItemStack aStack, double aAmount, EntityLivingBase aPlayer) {
        this.chargeFromArmor(aStack, aPlayer);
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).field_71075_bZ.field_75098_d) {
            return true;
        }
        double tTransfer = this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, true);
        if (tTransfer == aAmount) {
            this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
            this.chargeFromArmor(aStack, aPlayer);
            return true;
        }
        this.discharge(aStack, aAmount, Integer.MAX_VALUE, true, false, false);
        this.chargeFromArmor(aStack, aPlayer);
        return false;
    }

    public final boolean canProvideEnergy(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return false;
        }
        return tStats[3] > 0L || aStack.field_77994_a == 1 && (tStats[3] == -2L || tStats[3] == -3L);
    }

    public final void chargeFromArmor(ItemStack aStack, EntityLivingBase aPlayer) {
        if (aPlayer == null || aPlayer.field_70170_p.field_72995_K) {
            return;
        }
        for (int i = 1; i < 5; ++i) {
            Container tContainer;
            double tCharge;
            IElectricItem tArmorItem;
            ItemStack tArmor = aPlayer.func_71124_b(i);
            if (!GTModHandler.isElectricItem(tArmor) || !(tArmorItem = (IElectricItem)tArmor.func_77973_b()).canProvideEnergy(tArmor) || tArmorItem.getTier(tArmor) < this.getTier(aStack) || !((tCharge = ElectricItem.manager.discharge(tArmor, this.charge(aStack, 2.147483646E9, Integer.MAX_VALUE, true, true), Integer.MAX_VALUE, true, true, false)) > 0.0)) continue;
            this.charge(aStack, tCharge, Integer.MAX_VALUE, true, false);
            if (!(aPlayer instanceof EntityPlayer) || (tContainer = ((EntityPlayer)aPlayer).field_71070_bA) == null) continue;
            tContainer.func_75142_b();
        }
    }

    public final long getRealCharge(ItemStack aStack) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null) {
            return 0L;
        }
        if (tStats[3] > 0L) {
            return (int)tStats[3].longValue();
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        return tNBT == null ? 0L : tNBT.func_74763_f("GT.ItemCharge");
    }

    public final boolean setCharge(ItemStack aStack, long aCharge) {
        Long[] tStats = this.getElectricStats(aStack);
        if (tStats == null || tStats[3] > 0L) {
            return false;
        }
        NBTTagCompound tNBT = aStack.func_77978_p();
        if (tNBT == null) {
            tNBT = new NBTTagCompound();
        }
        tNBT.func_82580_o("GT.ItemCharge");
        aCharge = Math.min(tStats[0] < 0L ? Math.abs(tStats[0] / 2L) : aCharge, Math.abs(tStats[0]));
        if (aCharge > 0L) {
            aStack.func_77964_b((int)this.getChargedMetaData(aStack));
            tNBT.func_74772_a("GT.ItemCharge", aCharge);
        } else {
            aStack.func_77964_b((int)this.getEmptyMetaData(aStack));
        }
        if (tNBT.func_82582_d()) {
            aStack.func_77982_d(null);
        } else {
            aStack.func_77982_d(tNBT);
        }
        this.isItemStackUsable(aStack);
        return true;
    }

    public short getChargedMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public short getEmptyMetaData(ItemStack aStack) {
        return (short)aStack.func_77960_j();
    }

    public boolean isItemStackUsable(ItemStack aStack) {
        ArrayList<IItemBehaviour<ItemGregtechPump>> tList = this.mItemBehaviors.get((short)this.getDamage(aStack));
        if (tList != null) {
            for (IItemBehaviour<ItemGregtechPump> tBehavior : tList) {
                if (tBehavior.isItemStackUsable(this, aStack)) continue;
                return false;
            }
        }
        return true;
    }

    public final String getToolTip(ItemStack aStack) {
        return null;
    }

    public final IElectricItemManager getManager(ItemStack aStack) {
        return this;
    }

    public final ItemGregtechPump setElectricStats(int aMetaValue, long aMaxCharge, long aTransferLimit, long aTier, long aSpecialData, boolean aUseAnimations) {
        if (aMetaValue < 0) {
            return this;
        }
        if (aMaxCharge == 0L) {
            this.mElectricStats.remove((short)aMetaValue);
        } else {
            this.mElectricStats.put((short)aMetaValue, new Long[]{aMaxCharge, Math.max(0L, aTransferLimit), Math.max(-1L, aTier), aSpecialData});
        }
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item var1, CreativeTabs aCreativeTab, List aList) {
        int j = this.mEnabledItems.length();
        for (int i = 0; i < j; ++i) {
            ItemStack tStack;
            if (!this.mVisibleItems.get(i) && (!GTValues.D1 || !this.mEnabledItems.get(i))) continue;
            Long[] tStats = this.mElectricStats.get((short)(this.mOffset + i));
            if (tStats != null && tStats[3] < 0L) {
                tStack = new ItemStack((Item)this, 1, this.mOffset + i);
                this.setCharge(tStack, Math.abs(tStats[0]));
                this.isItemStackUsable(tStack);
                aList.add(tStack);
            }
            if (tStats != null && tStats[3] == -2L) continue;
            tStack = new ItemStack((Item)this, 1, this.mOffset + i);
            this.isItemStackUsable(tStack);
            aList.add(tStack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public final void func_94581_a(IIconRegister aIconRegister) {
        short j = (short)this.mEnabledItems.length();
        for (short i = 0; i < j; i = (short)(i + 1)) {
            if (!this.mEnabledItems.get(i)) continue;
            this.mIconMap.put(Integer.valueOf(i), aIconRegister.func_94245_a(Mods.GTPlusPlus.ID + ":" + this.func_77658_a() + "/" + i));
        }
    }

    public final IIcon func_77617_a(int aMetaData) {
        if (aMetaData < 0) {
            return null;
        }
        if (aMetaData < this.mOffset) {
            return this.mIconMap.get(0);
        }
        int newMeta = aMetaData - this.mOffset;
        newMeta = Math.max(0, Math.min(4, newMeta));
        return this.mIconMap.get(newMeta);
    }

    public Item func_77655_b(String p_77655_1_) {
        this.unlocalizedName = p_77655_1_;
        super.func_77655_b(p_77655_1_);
        return this;
    }

    public String func_77658_a() {
        return this.unlocalizedName;
    }

    public final Long[] getElectricStats(ItemStack aStack) {
        return this.mElectricStats.get((short)aStack.func_77960_j());
    }

    public boolean isBookEnchantable(ItemStack aStack, ItemStack aBook) {
        return false;
    }

    public final ItemGregtechPump addItemBehavior(int aMetaValue, IItemBehaviour<ItemGregtechPump> aBehavior) {
        if (aMetaValue < 0 || aMetaValue >= 32766 || aBehavior == null) {
            return this;
        }
        ArrayList tList = this.mItemBehaviors.computeIfAbsent((short)aMetaValue, k -> new ArrayList(1));
        tList.add(aBehavior);
        return this;
    }

    public final ItemStack addItem(int aID, String aEnglish, String aToolTip, Object ... aRandomData) {
        if (aToolTip == null) {
            aToolTip = "";
        }
        if (aID >= 0 && aID < this.mItemAmount) {
            ItemStack rStack = new ItemStack((Item)this, 1, this.mOffset + aID);
            GTModHandler.registerBoxableItemToToolBox(rStack);
            this.mEnabledItems.set(aID);
            this.mVisibleItems.set(aID);
            GTLanguageManager.addStringLocalization("gtplusplus." + this.func_77667_c(rStack) + "." + aID + ".name", aEnglish);
            GTLanguageManager.addStringLocalization("gtplusplus." + this.func_77667_c(rStack) + "." + aID + ".tooltip", aToolTip);
            ArrayList<TCAspects.TC_AspectStack> tAspects = new ArrayList<TCAspects.TC_AspectStack>();
            for (Object tRandomData : aRandomData) {
                if (!(tRandomData instanceof SubTag)) continue;
                if (tRandomData == SubTag.INVISIBLE) {
                    this.mVisibleItems.set(aID, false);
                    continue;
                }
                if (tRandomData != SubTag.NO_UNIFICATION) continue;
                GTOreDictUnificator.addToBlacklist(rStack);
            }
            for (Object tRandomData : aRandomData) {
                if (tRandomData == null) continue;
                boolean tUseOreDict = true;
                if (tRandomData instanceof IItemBehaviour) {
                    this.addItemBehavior(this.mOffset + aID, (IItemBehaviour)tRandomData);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof IItemContainer) {
                    ((IItemContainer)tRandomData).set(rStack);
                    tUseOreDict = false;
                }
                if (tRandomData instanceof SubTag) continue;
                if (tRandomData instanceof TCAspects.TC_AspectStack) {
                    ((TCAspects.TC_AspectStack)tRandomData).addToAspectList(tAspects);
                    continue;
                }
                if (tRandomData instanceof ItemData) {
                    if (GTUtility.isStringValid(tRandomData)) {
                        GTOreDictUnificator.registerOre(tRandomData, rStack);
                        continue;
                    }
                    GTOreDictUnificator.addItemData(rStack, (ItemData)tRandomData);
                    continue;
                }
                if (!tUseOreDict) continue;
                GTOreDictUnificator.registerOre(tRandomData, rStack);
            }
            if (GregTechAPI.sThaumcraftCompat != null) {
                GregTechAPI.sThaumcraftCompat.registerThaumcraftAspectsToItem(rStack, tAspects, false);
            }
            return rStack;
        }
        return null;
    }

    public String func_77653_i(ItemStack aStack) {
        int keyValue = this.getCorrectMetaForItemstack(aStack);
        keyValue = GTUtility.clamp(keyValue, 0, 4);
        return GTLanguageManager.getTranslation("gtplusplus." + this.func_77667_c(aStack) + "." + keyValue + ".name");
    }

    public void emptyStoredFluid(ItemStack aStack) {
        if (aStack.func_77942_o()) {
            NBTTagCompound t = aStack.func_77978_p();
            if (t.func_74764_b("mInit")) {
                t.func_82580_o("mInit");
            }
            if (t.func_74764_b("mFluid")) {
                t.func_82580_o("mFluid");
            }
            if (t.func_74764_b("mFluidAmount")) {
                t.func_82580_o("mFluidAmount");
            }
        }
    }

    public void storeFluid(ItemStack aStack, FluidStack aFluid) {
        if (aFluid != null) {
            String fluidname = aFluid.getFluid().getName();
            int amount = aFluid.amount;
            if (fluidname != null && !fluidname.isEmpty() && amount > 0) {
                NBTUtils.setString(aStack, "mFluid", fluidname);
                NBTUtils.setInteger(aStack, "mFluidAmount", amount);
            }
        }
    }

    public FluidStack getFluid(ItemStack container) {
        if (!container.func_77942_o() || !container.func_77978_p().func_74764_b("mInit")) {
            this.initNBT(container);
        }
        if (container.func_77978_p().func_74764_b("mInit") && container.func_77978_p().func_74767_n("mInit")) {
            Integer amount = 0;
            String fluidname = NBTUtils.getString(container, "mFluid");
            amount = NBTUtils.getInteger(container, "mFluidAmount");
            if (fluidname != null && amount > 0) {
                return FluidUtils.getFluidStack(fluidname, (int)amount);
            }
            return null;
        }
        return null;
    }

    public int getCapacity(ItemStack container) {
        if (!container.func_77942_o() || !container.func_77978_p().func_74764_b("mInit")) {
            this.initNBT(container);
        }
        if (container.func_77978_p().func_74764_b("mInit") && container.func_77978_p().func_74767_n("mInit")) {
            return container.func_77978_p().func_74762_e("mCapacity");
        }
        int aMeta = this.getCorrectMetaForItemstack(container);
        return 2000 * (int)GTUtility.powInt(4.0, aMeta);
    }

    public int fill(ItemStack container, FluidStack resource) {
        return this.fill(container, resource, true);
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        if (!doFill || resource == null) {
            return 0;
        }
        if (!container.func_77942_o() || !container.func_77978_p().func_74764_b("mInit")) {
            this.initNBT(container);
        }
        if (container.func_77978_p().func_74764_b("mInit") && container.func_77978_p().func_74767_n("mInit")) {
            int aStoredAmount = 0;
            int aCapacity = this.getCapacity(container);
            FluidStack aStoredFluid = this.getFluid(container);
            if (aStoredFluid != null) {
                String aStored = aStoredFluid.getFluid().getName();
                aStoredAmount = aStoredFluid.amount;
                if (aStoredAmount == aCapacity) {
                    return 0;
                }
            }
            if (aStoredFluid == null) {
                Logger.INFO("Pump is empty, filling with tank fluids.");
                int amountToConsume = Math.min(resource.amount, aCapacity);
                FluidStack toConsume = FluidUtils.getFluidStack(resource, amountToConsume);
                if (toConsume != null && amountToConsume > 0) {
                    this.storeFluid(container, toConsume);
                    return amountToConsume;
                }
            } else {
                Logger.INFO("Pump is Partially full, filling with tank fluids.");
                if (aStoredFluid.isFluidEqual(resource)) {
                    Logger.INFO("Found matching fluids.");
                    int aSpaceLeft = aCapacity - aStoredAmount;
                    Logger.INFO("Capacity: " + aCapacity + " | Stored: " + aStoredAmount + " | Space left: " + aSpaceLeft);
                    int amountToConsume = 0;
                    if (resource.amount >= aSpaceLeft) {
                        amountToConsume = aSpaceLeft;
                        Logger.INFO("More or equal fluid amount to pump container space.");
                    } else {
                        amountToConsume = resource.amount;
                        Logger.INFO("Less fluid than container space");
                    }
                    Logger.INFO("Amount to consume: " + amountToConsume);
                    FluidStack toConsume = FluidUtils.getFluidStack(resource, aStoredAmount + amountToConsume);
                    if (toConsume != null && amountToConsume > 0) {
                        Logger.INFO("Storing Fluid");
                        this.storeFluid(container, toConsume);
                        return amountToConsume;
                    }
                    Logger.INFO("Not storing fluid");
                } else {
                    Logger.INFO("Fluids did not match.");
                }
            }
        }
        return 0;
    }

    public FluidStack drain(ItemStack container, int drainAmt) {
        return this.drain(container, drainAmt, true);
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        if (!doDrain || maxDrain == 0) {
            return null;
        }
        if (!container.func_77942_o() || !container.func_77978_p().func_74764_b("mInit")) {
            this.initNBT(container);
        }
        if (container.func_77978_p().func_74764_b("mInit") && container.func_77978_p().func_74767_n("mInit")) {
            FluidStack aStoredFluid = this.getFluid(container);
            if (aStoredFluid == null) {
                return null;
            }
            int aStoredAmount = aStoredFluid.amount;
            if (maxDrain >= aStoredAmount) {
                this.emptyStoredFluid(container);
                return aStoredFluid;
            }
            int amountRemaining = aStoredAmount - maxDrain;
            FluidStack newAmount = FluidUtils.getFluidStack(aStoredFluid, amountRemaining);
            FluidStack drained = FluidUtils.getFluidStack(aStoredFluid, maxDrain);
            this.storeFluid(container, newAmount);
            return drained;
        }
        return null;
    }

    public void initNBT(ItemStack aStack) {
        NBTTagCompound aNewNBT = !aStack.func_77942_o() ? new NBTTagCompound() : aStack.func_77978_p();
        if (!aNewNBT.func_74764_b("mInit")) {
            int aMeta = this.getCorrectMetaForItemstack(aStack);
            aNewNBT.func_74768_a("mMeta", aMeta);
            aNewNBT.func_74757_a("mInit", true);
            aNewNBT.func_74778_a("mFluid", "@@@@@");
            aNewNBT.func_74768_a("mFluidAmount", 0);
            if (!aNewNBT.func_74764_b("capacityInit")) {
                int aCapacity = 2000 * (int)GTUtility.powInt(4.0, aMeta);
                aNewNBT.func_74768_a("mCapacity", aCapacity);
                aNewNBT.func_74757_a("capacityInit", true);
            }
            aStack.func_77982_d(aNewNBT);
        }
    }

    public boolean tryDrainTile(ItemStack aStack, World aWorld, EntityPlayer aPlayer, int aX, int aY, int aZ) {
        try {
            if (aWorld.field_72995_K || aStack == null) {
                return false;
            }
            int aTier = aStack.func_77960_j() - 1000;
            int removal = 0;
            if (aTier != 0) {
                removal = 8 * (int)GTUtility.powInt(4.0, aTier);
            }
            if (!this.canUse(aStack, removal) && aTier > 0 && aTier < 4) {
                GTUtility.sendChatToPlayer(aPlayer, "Not enough power.");
                Logger.INFO("No Power");
                return false;
            }
            Block aBlock = aWorld.func_147439_a(aX, aY, aZ);
            if (aBlock == null) {
                return false;
            }
            TileEntity tTileEntity = aWorld.func_147438_o(aX, aY, aZ);
            if (tTileEntity == null) {
                return false;
            }
            double aCharge = this.getCharge(aStack);
            boolean didDrain = false;
            if (aTier > 0 && aCharge > 0.0) {
                if (this.discharge(aStack, removal, aTier, true, true, false) > 0.0) {
                    didDrain = true;
                }
            } else {
                boolean bl = didDrain = aTier == 0 || aTier == 4;
            }
            if (didDrain && tTileEntity instanceof IGregTechTileEntity) {
                return this.drainTankGT(tTileEntity, aStack, aWorld, aPlayer);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public boolean drainTankGT(TileEntity tTileEntity, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (tTileEntity == null) {
            return false;
        }
        if (tTileEntity instanceof IGregTechTileEntity) {
            Logger.INFO("Right Clicking on GT Tile - drainTankGT.");
            if (((IGregTechTileEntity)tTileEntity).getTimer() < 50L) {
                Logger.INFO("Returning False - Behaviour Class. Timer < 50");
                return false;
            }
            if (!aWorld.field_72995_K && !((IGregTechTileEntity)tTileEntity).func_70300_a(aPlayer)) {
                Logger.INFO("Returning True - drainTankGT. NotUsable()");
                return true;
            }
            if (this.getFluid(aStack) == null || this.getFluid(aStack) != null && this.getFluid((ItemStack)aStack).amount < this.getCapacity(aStack)) {
                Logger.INFO("Trying to find Stored Fluid - drainTankGT.");
                FluidStack aStored = this.getStoredFluidOfGTMachine((IGregTechTileEntity)tTileEntity);
                if (aStored != null) {
                    int mAmountInserted = this.fill(aStack, aStored);
                    if (mAmountInserted > 0) {
                        FluidStack newStackRemainingInTank = mAmountInserted == aStored.amount ? null : FluidUtils.getFluidStack(aStored, aStored.amount - mAmountInserted);
                        boolean b = this.setStoredFluidOfGTMachine((IGregTechTileEntity)tTileEntity, newStackRemainingInTank);
                        Logger.INFO("Cleared Tank? " + b + " | mAmountInserted: " + mAmountInserted);
                        Logger.INFO("Returning " + b + " - drainTankGT.");
                        if (b) {
                            GTUtility.sendChatToPlayer(aPlayer, "Drained " + mAmountInserted + "L of " + aStored.getLocalizedName() + ".");
                        } else {
                            this.drain(aStack, mAmountInserted);
                        }
                        return b;
                    }
                } else {
                    Logger.INFO("Found no valid Fluidstack - drainTankGT.");
                }
            } else {
                Logger.INFO("Pump is full.");
            }
        }
        Logger.INFO("Could not drain GT tank.");
        return false;
    }

    public FluidStack getStoredFluidOfGTMachine(IGregTechTileEntity aTileEntity) {
        if (aTileEntity == null) {
            return null;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null || aMetaTileEntity instanceof MTEHatchMultiInput) {
            return null;
        }
        if (aMetaTileEntity instanceof MTEBasicTank) {
            Logger.INFO("Tile Was Instanceof BasicTank.");
            return this.getStoredFluidOfGTMachine((MTEBasicTank)aMetaTileEntity);
        }
        return null;
    }

    public FluidStack getStoredFluidOfGTMachine(MTEBasicTank aTileEntity) {
        FluidStack f = aTileEntity.mFluid;
        Logger.INFO("Returning Fluid stack from tile. Found: " + (f != null ? f.getLocalizedName() + " - " + f.amount + "L" : "Nothing"));
        return f;
    }

    public boolean setStoredFluidOfGTMachine(IGregTechTileEntity aTileEntity, FluidStack aSetFluid) {
        Logger.INFO("Trying to clear Tile's tank. - Behaviour Class. [1]");
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEBasicTank) {
            Logger.INFO("Trying to clear Tile's tank. - Behaviour Class. [2]");
            return this.setStoredFluidOfGTMachine((MTEBasicTank)aMetaTileEntity, aSetFluid);
        }
        return false;
    }

    public boolean setStoredFluidOfGTMachine(MTEBasicTank aTileEntity, FluidStack aSetFluid) {
        try {
            aTileEntity.mFluid = aSetFluid;
            Logger.INFO("Trying to set Tile's tank. - Behaviour Class. [3] success.");
            return true;
        }
        catch (Throwable t) {
            Logger.INFO("Trying to clear Tile's tank. FAILED - Behaviour Class. [x]");
            return false;
        }
    }

    public int getCorrectMetaForItemstack(ItemStack aStack) {
        if (aStack == null) {
            return 0;
        }
        if (aStack.func_77960_j() < this.mOffset) {
            return 0;
        }
        int newMeta = aStack.func_77960_j() - this.mOffset;
        newMeta = Math.max(0, Math.min(4, newMeta));
        return newMeta;
    }
}

