/*
 * Decompiled with CFR 0.152.
 */
package gtPlusPlus.core.item.general;

import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Mods;
import gregtech.api.util.GTUtility;
import gtPlusPlus.api.objects.Logger;
import gtPlusPlus.core.creative.AddToCreativeTab;
import gtPlusPlus.core.interfaces.IItemBlueprint;
import gtPlusPlus.core.util.math.MathUtils;
import gtPlusPlus.core.util.minecraft.ItemUtils;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemBlueprint
extends Item
implements IItemBlueprint {
    public ItemBlueprint(String unlocalizedName) {
        this.func_77655_b(unlocalizedName);
        this.func_111206_d(Mods.GTPlusPlus.ID + ":" + unlocalizedName);
        this.func_77625_d(1);
        this.func_77637_a(AddToCreativeTab.tabMachines);
        GameRegistry.registerItem((Item)this, (String)unlocalizedName);
    }

    public void func_77624_a(ItemStack itemStack, EntityPlayer aPlayer, List list, boolean bool) {
        if (!itemStack.func_77942_o()) {
            this.createNBT(itemStack);
        }
        int id = -1;
        String name = "";
        boolean blueprint = false;
        if (itemStack.func_77942_o()) {
            id = (Integer)this.getNBT(itemStack, "mID");
            name = (String)this.getNBT(itemStack, "mName");
            blueprint = (Boolean)this.getNBT(itemStack, "mBlueprint");
        }
        if (itemStack.func_77942_o()) {
            if (id != -1) {
                list.add(EnumChatFormatting.GRAY + StatCollector.func_74837_a((String)StatCollector.func_74838_a((String)"item.itemBlueprint.tooltip.0"), (Object[])new Object[]{id}));
            }
            if (blueprint) {
                list.add(EnumChatFormatting.BLUE + StatCollector.func_74837_a((String)StatCollector.func_74838_a((String)"item.itemBlueprint.tooltip.1"), (Object[])new Object[]{name}));
            } else {
                list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"item.itemBlueprint.tooltip.2"));
            }
        } else {
            list.add(EnumChatFormatting.RED + StatCollector.func_74838_a((String)"item.itemBlueprint.tooltip.2"));
        }
        super.func_77624_a(itemStack, aPlayer, list, bool);
    }

    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer player) {
        this.createNBT(itemStack);
    }

    public ItemStack func_77659_a(ItemStack itemStack, World world, EntityPlayer par3Entity) {
        if (itemStack.func_77942_o()) {
            GTUtility.sendChatToPlayer(par3Entity, "This Blueprint holds NBT data. |" + this.getNBT(itemStack, "mID") + "|" + this.getNBT(itemStack, "mBlueprint") + "|" + this.getNBT(itemStack, "mName") + "|" + ItemUtils.getArrayStackNames(this.readItemsFromNBT(itemStack)));
        } else {
            this.createNBT(itemStack);
            GTUtility.sendChatToPlayer(par3Entity, "This is a placeholder. " + this.getNBT(itemStack, "mID"));
        }
        return super.func_77659_a(itemStack, world, par3Entity);
    }

    public ItemStack[] readItemsFromNBT(ItemStack itemStack) {
        ItemStack[] blueprint = new ItemStack[9];
        if (itemStack.func_77942_o()) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            NBTTagList list = nbt.func_150295_c("Inventory", 10);
            blueprint = new ItemStack[9];
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound data = list.func_150305_b(i);
                int slot = data.func_74762_e("Slot");
                if (slot < 0 || slot >= 9) continue;
                blueprint[slot] = ItemStack.func_77949_a((NBTTagCompound)data);
            }
            return blueprint;
        }
        return null;
    }

    public ItemStack writeItemsToNBT(ItemStack itemStack, ItemStack[] craftingGrid) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound nbt = itemStack.func_77978_p();
            NBTTagList list = new NBTTagList();
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = craftingGrid[i];
                if (stack == null) continue;
                NBTTagCompound data = new NBTTagCompound();
                stack.func_77955_b(data);
                data.func_74768_a("Slot", i);
                list.func_74742_a((NBTBase)data);
            }
            nbt.func_74782_a("Inventory", (NBTBase)list);
            itemStack.func_77982_d(nbt);
            return itemStack;
        }
        return null;
    }

    @Override
    public boolean isBlueprint(ItemStack stack) {
        return true;
    }

    @Override
    public boolean setBlueprint(ItemStack stack, IInventory craftingTable, ItemStack output) {
        boolean hasBP = false;
        ItemStack[] blueprint = new ItemStack[9];
        if (stack.func_77942_o()) {
            hasBP = (Boolean)this.getNBT(stack, "mBlueprint");
            blueprint = this.readItemsFromNBT(stack);
        }
        if (!hasBP) {
            try {
                for (int o = 0; o < craftingTable.func_70302_i_(); ++o) {
                    blueprint[o] = craftingTable.func_70301_a(o);
                    if (blueprint[0] == null) continue;
                    blueprint[0].field_77994_a = 0;
                }
                this.writeItemsToNBT(stack, blueprint);
                if (stack.func_77942_o()) {
                    if (stack.func_77978_p().func_74775_l("Items") != null) {
                        stack.field_77990_d.func_74757_a("mBlueprint", true);
                    }
                    hasBP = (Boolean)this.getNBT(stack, "mBlueprint");
                }
                if (output != null) {
                    this.setBlueprintName(stack, output.func_82833_r());
                    return true;
                }
                return false;
            }
            catch (Throwable t) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void setBlueprintName(ItemStack stack, String name) {
        stack.field_77990_d.func_74778_a("mName", name);
    }

    @Override
    public boolean hasBlueprint(ItemStack stack) {
        if (stack.func_77942_o()) {
            return (Boolean)this.getNBT(stack, "mBlueprint");
        }
        return false;
    }

    @Override
    public ItemStack[] getBlueprint(ItemStack stack) {
        ItemStack[] blueprint = new ItemStack[9];
        if (stack.func_77942_o()) {
            blueprint = this.readItemsFromNBT(stack);
        }
        try {
            ItemStack[] returnStack = new ItemStack[9];
            for (int o = 0; o < blueprint.length; ++o) {
                returnStack[o] = blueprint[o];
                if (returnStack[0] == null) continue;
                returnStack[0].field_77994_a = 1;
            }
            return returnStack;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean createNBT(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            if (!itemStack.field_77990_d.func_74767_n("mBlueprint") && !itemStack.field_77990_d.func_74779_i("mName").isEmpty()) {
                Logger.WARNING("No Blueprint and no name Set");
                return false;
            }
            if (itemStack.field_77990_d.func_74767_n("mBlueprint") && !itemStack.field_77990_d.func_74779_i("mName").isEmpty()) {
                Logger.WARNING("Has Blueprint but invalid name set");
                return false;
            }
            if (!itemStack.field_77990_d.func_74767_n("mBlueprint") && itemStack.field_77990_d.func_74779_i("mName").isEmpty()) {
                Logger.WARNING("Has no Blueprint, but strangely has a name");
                return false;
            }
            return false;
        }
        int bpID = MathUtils.randInt(0, 1000);
        boolean hasRecipe = false;
        String recipeName = "";
        Logger.WARNING("Creating a Blueprint, setting up it's NBT data. " + bpID);
        itemStack.field_77990_d = new NBTTagCompound();
        itemStack.field_77990_d.func_74768_a("mID", bpID);
        itemStack.field_77990_d.func_74757_a("mBlueprint", false);
        itemStack.field_77990_d.func_74778_a("mName", "");
        return true;
    }

    public Object getNBT(ItemStack itemStack, String tagNBT) {
        if (!itemStack.func_77942_o()) {
            return null;
        }
        Object o = null;
        switch (tagNBT) {
            case "mID": {
                o = itemStack.field_77990_d.func_74762_e(tagNBT);
                break;
            }
            case "mBlueprint": {
                o = itemStack.field_77990_d.func_74767_n(tagNBT);
                break;
            }
            case "mName": {
                o = itemStack.field_77990_d.func_74779_i(tagNBT);
                break;
            }
        }
        return o;
    }
}

