/*
 * Decompiled with CFR 0.152.
 */
package gregtech.nei.formatter;

import gregtech.GTMod;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MethodsReturnNonnullByDefault;
import gregtech.nei.RecipeDisplayInfo;
import gregtech.nei.formatter.INEISpecialInfoFormatter;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class DefaultSpecialValueFormatter
implements INEISpecialInfoFormatter {
    public static DefaultSpecialValueFormatter INSTANCE = new DefaultSpecialValueFormatter();

    @Override
    public List<String> format(RecipeDisplayInfo recipeInfo) {
        int specialValue = recipeInfo.recipe.mSpecialValue;
        if (specialValue == -100 && GTMod.proxy.mLowGravProcessing) {
            return Collections.singletonList(GTUtility.trans("159", "Needs Low Gravity"));
        }
        if (specialValue == -200 && GTMod.proxy.mEnableCleanroom) {
            return Collections.singletonList(GTUtility.trans("160", "Needs Cleanroom"));
        }
        if (specialValue == -201) {
            return Collections.singletonList(GTUtility.trans("206", "Scan for Assembly Line"));
        }
        if (specialValue == -300 && GTMod.proxy.mEnableCleanroom) {
            return Collections.singletonList(GTUtility.trans("160.1", "Needs Cleanroom & LowGrav"));
        }
        if (specialValue == -400) {
            return Collections.singletonList(GTUtility.trans("216", "Deprecated Recipe"));
        }
        return Collections.emptyList();
    }
}

