/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi.purification;

import bartworks.system.material.WerkstoffLoader;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Textures;
import gregtech.api.enums.TierEU;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchMultiInput;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.multi.purification.MTEHatchDegasifierControl;
import gregtech.common.tileentities.machines.multi.purification.MTEPurificationUnitBase;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEPurificationUnitDegasser
extends MTEPurificationUnitBase<MTEPurificationUnitDegasser>
implements ISurvivalConstructable {
    private static final int CASING_INDEX_MAIN = MTEPurificationUnitDegasser.getTextureIndex(GregTechAPI.sBlockCasings9, 11);
    private static final String STRUCTURE_PIECE_MAIN = "main";
    private static final String[][] structure = new String[][]{{"      AAAAA      ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "      AAAAA      "}, {"    AAAAAAAAA    ", "      AAAAA      ", "                 ", "           C     ", "         CC      ", "        C        ", "      CC         ", "     C           ", "                 ", "                 ", "                 ", "           C     ", "         CC      ", "        C        ", "      CC         ", "     C           ", "                 ", "                 ", "                 ", "           C     ", "         CC      ", "        C        ", "      CC         ", "    CCAA~AA      ", "    AAAAAAAAA    "}, {"  AAAAAAAAAAAAA  ", "   CAAAAAAAAA    ", "      BBBBB CC   ", "      BBBBB      ", "      BBBBB      ", "       BBB       ", "        B        ", "                 ", "    C            ", "                 ", "            C    ", "                 ", "                 ", "                 ", "                 ", "                 ", "    C            ", "                 ", "        B   C    ", "       BBB       ", "      BBBBB      ", "      BBBBB      ", "      BBBBB      ", "    AAAAAAAAA    ", "  AAAAAAAAAAAAA  "}, {"  AAAAAAAAAAAAA  ", "   AAAAAAAAAAAC  ", "  C BB     BB    ", "    BB     BB    ", "     B     B     ", "     BB   BB     ", "     BBB BBB     ", "      BBBBB      ", "       BBB       ", "   C         C   ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "       BBB       ", "   C  BBBBB  C   ", "     BBB BBB     ", "     BB   BB     ", "     B     B     ", "    BB     BB    ", "    BB     BB    ", "   AAAAAAAAAAA   ", "  AAAAAAAAAAAAA  "}, {" AAAAAAAAAAAAAAA ", "  AAAAAAAAAAAAA  ", "  CB         B   ", "   B         B   ", "    B       B    ", "    B       B    ", "    B       B    ", "    BB     BB    ", "     BB   BB  C  ", "      BBBBB      ", "  C    BBB       ", "                 ", "                 ", "                 ", "       BBB       ", "      BBBBB      ", "     BB   BB  C  ", "    BB     BB    ", "  C B       B    ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", "  AAAAAAAAAAAAAC ", " AAAAAAAAAAAAAAA "}, {" AAAAAAAAAAAAAAA ", "  AAAAAAAAAAAAA  ", "   B         B   ", " C B         B   ", "   B         B   ", "   B         B   ", "   B         B   ", "    B       B  C ", "    B       B    ", "     B     B     ", "      B   B      ", " C     BBB       ", "                 ", "       BBB       ", "      B   B      ", "     B     B   C ", "    B       B    ", "    B       B    ", "   B         B   ", " C B         B   ", "   B         B   ", "   B         B   ", "   B         B   ", "  AAAAAAAAAAAAAC ", " AAAAAAAAAAAAAAA "}, {"AAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAA ", "  B           B  ", "  B           B  ", " CB           B  ", "   B         B   ", "   B         B C ", "   B         B   ", "    B       B    ", "    B       B    ", "     B     B     ", "      BBBBB      ", " C     BBB       ", "      BBBBB      ", "     B     B   C ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", "   B         B   ", " CB           B  ", "  B           B  ", "  B           BC ", " AAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAA ", "  B           B  ", "  B           B  ", " CB           B  ", "  B           B  ", "   B         B C ", "   B         B   ", "   B         B   ", "    B       B    ", "    B       B    ", "     BB   BB     ", " C    BBBBB      ", "     BB   BB     ", "    B       B  C ", "    B       B    ", "   B         B   ", "   B         B   ", "   B         B   ", "  B           B  ", " CB           B  ", "  B           B  ", "  B           BC ", " AAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAA ", "  B           B  ", "  B           B  ", "  B           B  ", " CB           BC ", "  B           B  ", "   B         B   ", "   B         B   ", "    B       B    ", "    B       B    ", "     BB   BB     ", "      BBBBB      ", " C   BB   BB   C ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", "  B           B  ", "  B           B  ", "  B           B  ", " CB           BC ", "  B           B  ", " AAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAA ", "  B           B  ", "  B           B  ", "  B           BC ", "  B           B  ", " C B         B   ", "   B         B   ", "   B         B   ", "    B       B    ", "    B       B    ", "     BB   BB     ", "      BBBBB    C ", "     BB   BB     ", " C  B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", "   B         B   ", "  B           B  ", "  B           BC ", "  B           B  ", " CB           B  ", " AAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAA"}, {"AAAAAAAAAAAAAAAAA", " AAAAAAAAAAAAAAA ", "  B           B  ", "  B           B  ", "  B           BC ", "   B         B   ", " C B         B   ", "   B         B   ", "    B       B    ", "    B       B    ", "     B     B     ", "      BBBBB      ", "       BBB     C ", "      BBBBB      ", " C   B     B     ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", "   B         B   ", "  B           BC ", "  B           B  ", " CB           B  ", " AAAAAAAAAAAAAAA ", "AAAAAAAAAAAAAAAAA"}, {" AAAAAAAAAAAAAAA ", "  AAAAAAAAAAAAA  ", "   B         B   ", "   B         B C ", "   B         B   ", "   B         B   ", "   B         B   ", " C  B       B    ", "    B       B    ", "     B     B     ", "      B   B      ", "       BBB     C ", "                 ", "       BBB       ", "      B   B      ", " C   B     B     ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B C ", "   B         B   ", "   B         B   ", "   B         B   ", " CAAAAAAAAAAAAA  ", " AAAAAAAAAAAAAAA "}, {" AAAAAAAAAAAAAAA ", "  AAAAAAAAAAAAA  ", "   B         BC  ", "   B         B   ", "    B       B    ", "    B       B    ", "    B       B    ", "    BB     BB    ", "  C  BB   BB     ", "      BBBBB      ", "       BBB    C  ", "                 ", "                 ", "                 ", "       BBB       ", "      BBBBB      ", "  C  BB   BB     ", "    BB     BB    ", "    B       B C  ", "    B       B    ", "    B       B    ", "   B         B   ", "   B         B   ", " CAAAAAAAAAAAAA  ", " AAAAAAAAAAAAAAA "}, {"  AAAAAAAAAAAAA  ", "  CAAAAAAAAAAA   ", "    BB     BB C  ", "    BB     BB    ", "     B     B     ", "     BB   BB     ", "     BBB BBB     ", "      BBBBB      ", "       BBB       ", "   C         C   ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "       BBB       ", "   C  BBBBB  C   ", "     BBB BBB     ", "     BB   BB     ", "     B     B     ", "    BB     BB    ", "    BB     BB    ", "   AAAAAAAAAAA   ", "  AAAAAAAAAAAAA  "}, {"  AAAAAAAAAAAAA  ", "    AAAAAAAAAC   ", "   CC BBBBB      ", "      BBBBB      ", "      BBBBB      ", "       BBB       ", "        B        ", "                 ", "            C    ", "                 ", "    C            ", "                 ", "                 ", "                 ", "                 ", "                 ", "            C    ", "                 ", "    C   B        ", "       BBB       ", "      BBBBB      ", "      BBBBB      ", "      BBBBB      ", "    AAAAAAAAA    ", "  AAAAAAAAAAAAA  "}, {"    AAAAAAAAA    ", "      AAAAA      ", "                 ", "     C           ", "      CC         ", "        C        ", "         CC      ", "           C     ", "                 ", "                 ", "                 ", "     C           ", "      CC         ", "        C        ", "         CC      ", "           C     ", "                 ", "                 ", "                 ", "     C           ", "      CC         ", "        C        ", "         CC      ", "      AAAAACC    ", "    AAAAAAAAA    "}, {"      AAAAA      ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "                 ", "      AAAAA      "}};
    private int casingCount = 0;
    private static final int MIN_CASING = 780;
    private static final IStructureDefinition<MTEPurificationUnitDegasser> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("main", structure).addElement('A', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{StructureUtility.lazy(t -> GTStructureUtility.buildHatchAdder().atLeastList(Arrays.asList(HatchElement.InputHatch, HatchElement.OutputHatch, SpecialHatchElement.ControlHatch)).casingIndex(CASING_INDEX_MAIN).dot(1).cacheHint(() -> "Input Hatch, Output Hatch, Control Hatch").build()), StructureUtility.onElementPass(t -> ++t.casingCount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings9, (int)11))})).addElement('B', StructureUtility.ofBlock((Block)GregTechAPI.sBlockGlass1, (int)2)).addElement('C', GTStructureUtility.ofFrame(Materials.Bedrockium)).build();
    private static final int STRUCTURE_X_OFFSET = 8;
    private static final int STRUCTURE_Y_OFFSET = 23;
    private static final int STRUCTURE_Z_OFFSET = 1;
    private static final Supplier<FluidStack[]> INERT_GASES = () -> new FluidStack[]{Materials.Helium.getGas(10000L), WerkstoffLoader.Neon.getFluidOrGas(7500), WerkstoffLoader.Krypton.getFluidOrGas(5000), WerkstoffLoader.Xenon.getFluidOrGas(2500)};
    private static final long SUPERCON_FLUID_AMOUNT = 1440L;
    private static final Supplier<SuperconductorMaterial[]> SUPERCONDUCTOR_MATERIALS = () -> new SuperconductorMaterial[]{new SuperconductorMaterial(Materials.Longasssuperconductornameforuvwire.getMolten(1440L), 1.0f), new SuperconductorMaterial(Materials.Longasssuperconductornameforuhvwire.getMolten(1440L), 1.25f), new SuperconductorMaterial(Materials.SuperconductorUEVBase.getMolten(1440L), 1.5f), new SuperconductorMaterial(Materials.SuperconductorUIVBase.getMolten(1440L), 1.75f), new SuperconductorMaterial(Materials.SuperconductorUMVBase.getMolten(1440L), 2.0f)};
    private static final FluidStack CATALYST_FLUID = Materials.Neutronium.getMolten(4608L);
    private static final FluidStack COOLANT_FLUID = Materials.SuperCoolant.getFluid(10000L);
    private static final long CONSUME_INTERVAL = 20L;
    private ControlSignal controlSignal = new ControlSignal(0);
    private final HashMap<Fluid, FluidStack> insertedStuffThisCycle = new HashMap();
    private float outputMultiplier = 1.0f;
    private MTEHatchDegasifierControl controlHatch = null;

    public MTEPurificationUnitDegasser(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    protected MTEPurificationUnitDegasser(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPurificationUnitDegasser(this.mName);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean active, boolean redstoneLevel) {
        if (side == facing) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_LARGE_CHEMICAL_REACTOR_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.getCasingTextureForId(CASING_INDEX_MAIN)};
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_MAIN, stackSize, hintsOnly, 8, 23, 1);
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        return this.survivalBuildPiece(STRUCTURE_PIECE_MAIN, stackSize, 8, 23, 1, elementBudget, env, true);
    }

    @Override
    public IStructureDefinition<MTEPurificationUnitDegasser> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Purification Unit").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.BOLD + "Water Tier: " + EnumChatFormatting.WHITE + GTUtility.formatNumbers(this.getWaterTier()) + EnumChatFormatting.RESET).addInfo("Must be linked to a Purification Plant using a data stick to work").addSeparator().addInfo("At the start of the operation, the " + EnumChatFormatting.WHITE + "Degasser Control Hatch" + EnumChatFormatting.GRAY + " will output a redstone signal").addInfo("To succeed the recipe, you will need to successfully decode the instructions in the signal").addInfo("To decode the signal, interpret the signal strength as a 4-bit number from 0-15").addInfo("Denote the lowest bit as bit 1, and the highest as bit 4").addSeparator().addInfo(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD + "Bit 1: " + EnumChatFormatting.BLUE + EnumChatFormatting.BOLD + "Ozone Sparging by Inert Gas").addInfo("If this bit is on, you must insert an " + EnumChatFormatting.WHITE + "inert gas" + EnumChatFormatting.GRAY + " into the machine").addInfo("To determine which gas to insert, interpret bits " + EnumChatFormatting.WHITE + "2-3" + EnumChatFormatting.GRAY + " as a 2-bit number").addInfo(EnumChatFormatting.GRAY + "0: " + EnumChatFormatting.RED + "10000L " + EnumChatFormatting.WHITE + "Helium" + EnumChatFormatting.GRAY + " / 1: " + EnumChatFormatting.RED + "7500L " + EnumChatFormatting.WHITE + "Neon" + EnumChatFormatting.GRAY + " / 2: " + EnumChatFormatting.RED + "5000L " + EnumChatFormatting.WHITE + "Krypton" + EnumChatFormatting.GRAY + " / 3: " + EnumChatFormatting.RED + "2500L " + EnumChatFormatting.WHITE + "Xenon").addSeparator().addInfo(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD + "Bit 2: " + EnumChatFormatting.BLUE + EnumChatFormatting.BOLD + "Superconductive Deionization").addInfo("If this bit is on, you must insert " + EnumChatFormatting.RED + "1440L " + EnumChatFormatting.WHITE + "Molten Superconductor Base.").addInfo("Using higher tier superconductor provides bonus output").addInfo("Output multiplier: " + EnumChatFormatting.DARK_GREEN + "UV" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.WHITE + "1x" + EnumChatFormatting.GRAY + " / " + EnumChatFormatting.DARK_RED + "UHV" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.WHITE + "1.25x" + EnumChatFormatting.GRAY + " / " + EnumChatFormatting.DARK_PURPLE + "UEV" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.WHITE + "1.5x" + EnumChatFormatting.GRAY + " / " + EnumChatFormatting.DARK_BLUE + EnumChatFormatting.BOLD + "UIV" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.WHITE + "1.75x" + EnumChatFormatting.GRAY + " / " + EnumChatFormatting.RED + EnumChatFormatting.BOLD + "UMV" + EnumChatFormatting.GRAY + ": " + EnumChatFormatting.WHITE + "2x").addSeparator().addInfo(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD + "Bit 3: " + EnumChatFormatting.BLUE + EnumChatFormatting.BOLD + "Gravitationally-Generated Differential Vacuum Extraction").addInfo("If this bit is on, you must insert " + EnumChatFormatting.RED + "4608L " + EnumChatFormatting.WHITE + "Molten Neutronium").addSeparator().addInfo(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD + "Bit 4: " + EnumChatFormatting.BLUE + EnumChatFormatting.BOLD + "Seldonian Settlement Process").addInfo("If this bit is on," + EnumChatFormatting.RED + " DISREGARD " + EnumChatFormatting.GRAY + "all other bits and do not insert anything").addSeparator().addInfo(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.BOLD + "No bits: " + EnumChatFormatting.BLUE + EnumChatFormatting.BOLD + "Machine Overload").addInfo("In rare cases, the machine may overload and output no control signal at all").addInfo("To prevent machine damage, insert " + EnumChatFormatting.RED + "10000L " + EnumChatFormatting.WHITE + "Super Coolant.").addSeparator().addInfo("The recipe can only succeed if the entire signal is decoded correctly").addInfo("Inserting any fluid not requested by the signal will always void the recipe").addSeparator().addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "The penultimate stage of water purification, step seven, is an irregular series of complex").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "processes designed to remove any residual materials left by the decontaminants from the previous").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "steps such as any energetic ions, acids, clarifiers, or gasses. Depending on what the Degasser").addInfo(EnumChatFormatting.AQUA + "" + EnumChatFormatting.ITALIC + "detects in the water, it will request various materials to complete the processes listed above.").beginStructureBlock(17, 25, 17, false).addController("Front center").addCasingInfoRangeColored("Heat-Resistant Trinium Plated Casing", EnumChatFormatting.GRAY, 780, 803, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Omni-Purpose Infinity Fused Glass", EnumChatFormatting.GRAY, 622, EnumChatFormatting.GOLD, false).addCasingInfoExactlyColored("Bedrockium Frame Box", EnumChatFormatting.GRAY, 124, EnumChatFormatting.GOLD, false).addOutputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+, Any Trinium Casing", 1).addInputHatch(EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + "+, Any Trinium Casing", 1).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.degasser_control_hatch"), EnumChatFormatting.GOLD + "1" + EnumChatFormatting.GRAY + ", Any Trinium Casing", 1).toolTipFinisher(GTValues.AuthorNotAPenguin);
        return tt;
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.purificationDegasifierRecipes;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidFluid(FluidStack stack) {
        if (stack.isFluidEqual(CATALYST_FLUID)) return true;
        if (stack.isFluidEqual(COOLANT_FLUID)) return true;
        if (Arrays.stream(INERT_GASES.get()).anyMatch(arg_0 -> ((FluidStack)stack).isFluidEqual(arg_0))) return true;
        if (!Arrays.stream(SUPERCONDUCTOR_MATERIALS.get()).anyMatch(mat -> stack.isFluidEqual(mat.fluid))) return false;
        return true;
    }

    private boolean wasFluidInsertedExact(FluidStack toFind) {
        FluidStack candidate = this.insertedStuffThisCycle.get(toFind.getFluid());
        return candidate != null && candidate.amount == toFind.amount;
    }

    private ControlBitStatus isBit0Satisfied() {
        if (this.controlSignal.getBit(0)) {
            int gasToInsert = this.controlSignal.getControlBit12();
            FluidStack gasStack = INERT_GASES.get()[gasToInsert];
            if (this.wasFluidInsertedExact(gasStack)) {
                return new ControlBitStatus(gasStack, true);
            }
            return new ControlBitStatus(null, false);
        }
        return new ControlBitStatus(null, true);
    }

    private ControlBitStatus isBit1Satisfied() {
        if (this.controlSignal.getBit(1)) {
            Optional<SuperconductorMaterial> material = Arrays.stream(SUPERCONDUCTOR_MATERIALS.get()).filter(candidate -> this.wasFluidInsertedExact(candidate.fluid)).findFirst();
            if (material.isPresent()) {
                SuperconductorMaterial scMaterial = material.get();
                this.outputMultiplier = scMaterial.multiplier;
                return new ControlBitStatus(scMaterial.fluid, true);
            }
            return new ControlBitStatus(null, false);
        }
        return new ControlBitStatus(null, true);
    }

    private ControlBitStatus isBit2Satisfied() {
        if (this.controlSignal.getBit(2)) {
            if (this.wasFluidInsertedExact(CATALYST_FLUID)) {
                return new ControlBitStatus(CATALYST_FLUID, true);
            }
            return new ControlBitStatus(null, false);
        }
        return new ControlBitStatus(null, true);
    }

    private ControlBitStatus isBit3Satisfied() {
        if (this.controlSignal.getBit(3)) {
            if (this.insertedStuffThisCycle.isEmpty()) {
                return new ControlBitStatus(null, true);
            }
            return new ControlBitStatus(null, false);
        }
        return new ControlBitStatus(null, true);
    }

    private boolean areAllBitsSatisfied() {
        if (this.controlSignal.isZero()) {
            return this.wasFluidInsertedExact(COOLANT_FLUID);
        }
        ControlBitStatus bit0 = this.isBit0Satisfied();
        ControlBitStatus bit1 = this.isBit1Satisfied();
        ControlBitStatus bit2 = this.isBit2Satisfied();
        ControlBitStatus bit3 = this.isBit3Satisfied();
        if (this.controlSignal.getBit(3) && bit3.satisfied) {
            bit1 = bit2 = new ControlBitStatus(null, true);
            bit0 = bit2;
        }
        if (bit0.satisfied && bit1.satisfied && bit2.satisfied && bit3.satisfied) {
            for (FluidStack inserted : this.insertedStuffThisCycle.values()) {
                if (inserted == null || bit0.stack != null && inserted.isFluidEqual(bit0.stack) || bit1.stack != null && inserted.isFluidEqual(bit1.stack) || bit2.stack != null && inserted.isFluidEqual(bit2.stack) || bit3.stack != null && inserted.isFluidEqual(bit3.stack)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void startCycle(int cycleTime, int progressTime) {
        super.startCycle(cycleTime, progressTime);
        this.controlSignal.randomize();
        this.insertedStuffThisCycle.clear();
        this.outputMultiplier = 1.0f;
        this.controlHatch.updateOutputSignal(this.controlSignal.getSignal());
    }

    private static ArrayList<FluidStack> getDrainableFluidsFromHatch(MTEHatchInput hatch) {
        if (hatch instanceof MTEHatchMultiInput) {
            return new ArrayList<FluidStack>(Arrays.asList(((MTEHatchMultiInput)hatch).getStoredFluid()));
        }
        return new ArrayList<FluidStack>(Collections.singletonList(hatch.getFluid()));
    }

    @Override
    protected void runMachine(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.runMachine(aBaseMetaTileEntity, aTick);
        if (this.mMaxProgresstime > 0 && aTick % 20L == 0L) {
            for (MTEHatchInput hatch : this.mInputHatches) {
                ArrayList<FluidStack> drainableFluids = MTEPurificationUnitDegasser.getDrainableFluidsFromHatch(hatch);
                for (FluidStack fluid : drainableFluids) {
                    if (fluid == null || !MTEPurificationUnitDegasser.isValidFluid(fluid)) continue;
                    ForgeDirection front = hatch.getBaseMetaTileEntity().getFrontFacing();
                    FluidStack drainedFluid = hatch.drain(front, fluid, true);
                    this.insertedStuffThisCycle.merge(fluid.getFluid(), drainedFluid, (a, b) -> new FluidStack(a.getFluid(), a.amount + b.amount));
                }
            }
        }
    }

    @Override
    public void addRecipeOutputs() {
        super.addRecipeOutputs();
        if (this.outputMultiplier > 1.01f && this.mOutputFluids != null) {
            FluidStack waterOutput = this.mOutputFluids[0];
            FluidStack bonusOutput = new FluidStack(waterOutput.getFluid(), (int)((float)waterOutput.amount * (this.outputMultiplier - 1.0f)));
            this.addOutput(bonusOutput);
        }
    }

    @Override
    public float calculateFinalSuccessChance() {
        if (this.areAllBitsSatisfied()) {
            return 100.0f;
        }
        return 0.0f;
    }

    @Override
    public int getWaterTier() {
        return 7;
    }

    @Override
    public long getBasePowerUsage() {
        return TierEU.RECIPE_UHV;
    }

    public boolean addControlHatchToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity instanceof MTEHatchDegasifierControl && this.controlHatch == null) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.controlHatch = (MTEHatchDegasifierControl)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingCount = 0;
        this.controlHatch = null;
        if (!this.checkPiece(STRUCTURE_PIECE_MAIN, 8, 23, 1)) {
            return false;
        }
        if (this.casingCount < 780) {
            return false;
        }
        if (this.controlHatch == null || !this.controlHatch.isValid()) {
            return false;
        }
        return super.checkMachine(aBaseMetaTileEntity, aStack);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.controlSignal = new ControlSignal(aNBT.func_74771_c("controlSignal"));
        this.outputMultiplier = aNBT.func_74760_g("outputMultiplier");
        NBTTagCompound fluidMap = aNBT.func_74775_l("insertedFluidMap");
        for (String key : fluidMap.func_150296_c()) {
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)fluidMap.func_74775_l(key));
            if (fluid == null) continue;
            this.insertedStuffThisCycle.put(fluid.getFluid(), fluid);
        }
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        super.saveNBTData(aNBT);
        aNBT.func_74774_a("controlSignal", this.controlSignal.getSignal());
        aNBT.func_74776_a("outputMultiplier", this.outputMultiplier);
        NBTTagCompound fluidMap = new NBTTagCompound();
        for (FluidStack stack : this.insertedStuffThisCycle.values()) {
            NBTTagCompound compound = new NBTTagCompound();
            stack.writeToNBT(compound);
            fluidMap.func_74782_a(stack.getFluid().getName(), (NBTBase)compound);
        }
        aNBT.func_74782_a("insertedFluidMap", (NBTBase)fluidMap);
    }

    private static String generateInfoStringForBit(int i, ControlBitStatus status) {
        String statusText = status.satisfied ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.infodata.purification_unit_degasser.bit.ok") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.infodata.purification_unit_degasser.bit.not_ok");
        return StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_degasser.bit", (Object[])new Object[]{i + 1, statusText});
    }

    @Override
    public String[] getInfoData() {
        ArrayList<String> info = new ArrayList<String>(Arrays.asList(super.getInfoData()));
        info.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_degasser.control_signal", (Object[])new Object[]{EnumChatFormatting.YELLOW + this.controlSignal.toString()}));
        info.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_degasser.output_multiplier", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + this.outputMultiplier}));
        for (FluidStack stack : this.insertedStuffThisCycle.values()) {
            info.add(StatCollector.func_74837_a((String)"GT5U.infodata.purification_unit_degasser.fluid_inserted", (Object[])new Object[]{"" + EnumChatFormatting.YELLOW + stack.amount, stack.getLocalizedName()}));
        }
        info.add(MTEPurificationUnitDegasser.generateInfoStringForBit(0, this.controlSignal.getBit(3) && this.isBit3Satisfied().satisfied ? new ControlBitStatus(null, true) : this.isBit0Satisfied()));
        info.add(MTEPurificationUnitDegasser.generateInfoStringForBit(1, this.controlSignal.getBit(3) && this.isBit3Satisfied().satisfied ? new ControlBitStatus(null, true) : this.isBit1Satisfied()));
        info.add(MTEPurificationUnitDegasser.generateInfoStringForBit(2, this.controlSignal.getBit(3) && this.isBit3Satisfied().satisfied ? new ControlBitStatus(null, true) : this.isBit2Satisfied()));
        info.add(MTEPurificationUnitDegasser.generateInfoStringForBit(3, this.isBit3Satisfied()));
        return info.toArray(new String[0]);
    }

    private static class ControlSignal {
        private byte signal;

        public ControlSignal(byte sig) {
            this.signal = sig;
        }

        public void randomize() {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            this.signal = (byte)random.nextInt(0, 8);
            if (random.nextInt(0, 5) == 0) {
                this.signal = (byte)(this.signal + 8);
            }
        }

        public boolean getBit(int bit) {
            if (bit < 0 || bit > 3) {
                throw new IllegalArgumentException("Invalid bit index for degasser control signal");
            }
            return (this.signal >> bit & 1) == 1;
        }

        public byte getSignal() {
            return this.signal;
        }

        public int getControlBit12() {
            return this.signal >> 1 & 3;
        }

        public boolean isZero() {
            return this.signal == 0;
        }

        public String toString() {
            return Integer.toBinaryString(this.signal & 0xF);
        }
    }

    private static final class SuperconductorMaterial {
        public FluidStack fluid;
        public float multiplier;

        SuperconductorMaterial(FluidStack fluid, float multiplier) {
            this.fluid = fluid;
            this.multiplier = multiplier;
        }
    }

    private static class ControlBitStatus {
        public FluidStack stack;
        public boolean satisfied;

        public ControlBitStatus(FluidStack stack, boolean satisfied) {
            this.stack = stack;
            this.satisfied = satisfied;
        }
    }

    private static enum SpecialHatchElement implements IHatchElement<MTEPurificationUnitDegasser>
    {
        ControlHatch(MTEPurificationUnitDegasser::addControlHatchToMachineList, new Class[]{MTEHatchDegasifierControl.class}){

            @Override
            public long count(MTEPurificationUnitDegasser mte) {
                return mte.controlHatch == null ? 0L : 1L;
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEPurificationUnitDegasser> adder;

        @SafeVarargs
        private SpecialHatchElement(IGTHatchAdder<MTEPurificationUnitDegasser> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEPurificationUnitDegasser> adder() {
            return this.adder;
        }
    }
}

