/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.multi;

import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import gregtech.GTMod;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.enums.VoidingMode;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.IIconContainer;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEExtendedPowerMultiBlockBase;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchDataAccess;
import gregtech.api.metatileentity.implementations.MTEMultiBlockBase;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.RecipeMaps;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.AssemblyLineUtils;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.api.util.OverclockCalculator;
import gregtech.api.util.ParallelHelper;
import gregtech.api.util.VoidProtectionHelper;
import gregtech.common.misc.GTStructureChannels;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MTEAssemblyLine
extends MTEExtendedPowerMultiBlockBase<MTEAssemblyLine>
implements ISurvivalConstructable {
    public ArrayList<MTEHatchDataAccess> mDataAccessHatches = new ArrayList();
    private static final String STRUCTURE_PIECE_FIRST = "first";
    private static final String STRUCTURE_PIECE_LATER = "later";
    private static final String STRUCTURE_PIECE_LAST = "last";
    private static final IStructureDefinition<MTEAssemblyLine> STRUCTURE_DEFINITION = StructureDefinition.builder().addShape("first", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"~", "l", "G"}, {"g", "m", "g"}, {"b", "i", "b"}})).addShape("later", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"b", "I", "b"}})).addShape("last", StructureUtility.transpose((String[][])new String[][]{{" ", "e", " "}, {"d", "l", "d"}, {"g", "m", "g"}, {"o", "i", "b"}})).addElement('G', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings3, (int)10)).addElement('l', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)9)).addElement('m', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)5)).addElement('g', GTStructureUtility.chainAllGlasses()).addElement('e', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{HatchElement.Energy.newAny(16, 1, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH), StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0)})).addElement('d', GTStructureUtility.buildHatchAdder(MTEAssemblyLine.class).atLeast(DataHatchElement.DataAccess).dot(2).casingIndex(42).allowOnly(ForgeDirection.NORTH).buildAndChain(GregTechAPI.sBlockCasings3, 10)).addElement('b', GTStructureUtility.buildHatchAdder(MTEAssemblyLine.class).atLeast(HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(16).dot(3).allowOnly(ForgeDirection.DOWN).buildAndChain(new IStructureElement[]{StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)0), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 4)})).addElement('I', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{HatchElement.InputBus.newAny(16, 4, ForgeDirection.DOWN), GTStructureUtility.ofHatchAdder(MTEMultiBlockBase::addOutputToMachineList, 16, 3)})).addElement('i', HatchElement.InputBus.newAny(16, 4, ForgeDirection.DOWN)).addElement('o', HatchElement.OutputBus.newAny(16, 3, ForgeDirection.DOWN)).build();

    public MTEAssemblyLine(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional);
    }

    public MTEAssemblyLine(String aName) {
        super(aName);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEAssemblyLine(this.mName);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Assembly Line, Assline, AL").addInfo("Used to craft complex machine parts (LuV+)").addInfo("Items & Fluids are inserted in NEI order, one per slice").addInfo("Does not run Assembler recipes").addMaxTierSkips(1).beginVariableStructureBlock(5, 16, 4, 4, 3, 3, false).addStructureInfo("From Bottom to Top, Left to Right").addStructureInfo("Layer 1 - Solid Steel Machine Casing, Input Bus, Solid Steel Machine Casing").addStructureInfo("Layer 2 - Glass, Assembly Line Casing, Glass").addStructureInfo("Layer 3 - Grate Machine Casing, Assembler Machine Casing, Grate Machine Casing").addStructureInfo("Layer 4 - Empty, Solid Steel Machine Casing, Empty").addStructureInfo("Up to 16 repeating slices, each one allows for 1 more item in recipes").addController("Either Grate Machine Casing on the first slice").addEnergyHatch("Any layer 4 casing", 1).addMaintenanceHatch("Any layer 1 casing", 3).addInputBus("As specified on layer 1", 4).addInputHatch("Any layer 1 casing", 3).addOutputBus("Replaces Input Bus or Solid Steel Machine casing on layer 1 of last slice", 3).addOtherStructurePart(StatCollector.func_74838_a((String)"GT5U.tooltip.structure.data_access_hatch"), "Any Grate Machine Casing NOT on the first slice", 2).addSubChannelUsage(GTStructureChannels.BOROGLASS).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == facingDirection) {
            if (active) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16], TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE).extFacing().build(), TextureFactory.builder().addIcon((IIconContainer)Textures.BlockIcons.OVERLAY_FRONT_ASSEMBLY_LINE_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][16]};
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return RecipeMaps.assemblylineVisualRecipes;
    }

    @Override
    @Nonnull
    public CheckRecipeResult checkProcessing() {
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Start ALine recipe check");
        }
        CheckRecipeResult result = CheckRecipeResultRegistry.NO_DATA_STICKS;
        ArrayList<GTRecipe.RecipeAssemblyLine> availableRecipes = new ArrayList<GTRecipe.RecipeAssemblyLine>();
        if (AssemblyLineUtils.isItemDataStick(this.mInventory[1])) {
            availableRecipes.addAll(AssemblyLineUtils.findALRecipeFromDataStick(this.mInventory[1]));
        }
        for (MTEHatchDataAccess dataAccess : GTUtility.validMTEList(this.mDataAccessHatches)) {
            availableRecipes.addAll(dataAccess.getAssemblyLineRecipes());
        }
        if (availableRecipes.isEmpty()) {
            return result;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Stick accepted, " + availableRecipes.size() + " Data Sticks found");
        }
        int[] tStacks = GTValues.emptyIntArray;
        FluidStack[] tFluids = GTValues.emptyFluidStackArray;
        long averageVoltage = this.getAverageInputVoltage();
        int maxParallel = 1;
        long maxAmp = this.getMaxInputAmps();
        Map<GTUtility.ItemId, ItemStack> inputsFromME = this.getStoredInputsFromME();
        Map<Fluid, FluidStack> fluidsFromME = this.getStoredFluidsFromME();
        for (GTRecipe.RecipeAssemblyLine tRecipe : availableRecipes) {
            int[] itemConsumptions;
            int originalMaxParallel;
            if ((long)tRecipe.mEUt > averageVoltage * 4L) {
                result = CheckRecipeResultRegistry.insufficientPower(tRecipe.mEUt);
                continue;
            }
            if ((long)tRecipe.mEUt > maxAmp * averageVoltage) {
                result = CheckRecipeResultRegistry.insufficientPower(tRecipe.mEUt);
                continue;
            }
            if (this.mInputBusses.size() < tRecipe.mInputs.length || this.mInputHatches.size() < tRecipe.mFluidInputs.length) {
                if (GTValues.D1) {
                    GTMod.GT_FML_LOGGER.info("Not enough sources: Need ({}, {}), has ({}, {})", new Object[]{this.mInputBusses.size(), tRecipe.mInputs.length, this.mInputHatches.size(), tRecipe.mFluidInputs.length});
                }
                if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            maxParallel = originalMaxParallel = 1;
            OverclockCalculator calculator = new OverclockCalculator().setRecipeEUt(tRecipe.mEUt).setEUt(averageVoltage).setAmperage(maxAmp).setAmperageOC(this.mEnergyHatches.size() != 1).setDuration(tRecipe.mDuration).setParallel(originalMaxParallel);
            int maxParallelBeforeBatchMode = maxParallel = GTUtility.safeInt((long)((double)maxParallel * calculator.calculateMultiplierUnderOneTick()), 0);
            if (this.isBatchModeEnabled()) {
                maxParallel = GTUtility.safeInt((long)maxParallel * (long)this.getMaxBatchSize(), 0);
            }
            if (this.protectsExcessItem()) {
                VoidProtectionHelper voidProtectionHelper = new VoidProtectionHelper();
                voidProtectionHelper.setMachine(this).setItemOutputs(new ItemStack[]{tRecipe.mOutput}).setMaxParallel(maxParallel).build();
                maxParallel = Math.min(voidProtectionHelper.getMaxParallel(), maxParallel);
                if (voidProtectionHelper.isItemFull()) {
                    result = CheckRecipeResultRegistry.ITEM_OUTPUT_FULL;
                    continue;
                }
            }
            if ((itemConsumptions = GTRecipe.RecipeAssemblyLine.getItemConsumptionAmountArray(this.mInputBusses, tRecipe)) == null || itemConsumptions.length == 0) {
                if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            int currentParallel = maxParallel;
            if ((currentParallel = (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputItems(this.mInputBusses, currentParallel, itemConsumptions, inputsFromME)) <= 0) {
                if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                result = CheckRecipeResultRegistry.NO_RECIPE;
                continue;
            }
            tStacks = itemConsumptions;
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("All Items accepted");
            }
            if (tRecipe.mFluidInputs.length > 0) {
                if ((currentParallel = (int)GTRecipe.RecipeAssemblyLine.maxParallelCalculatedByInputFluids(this.mInputHatches, currentParallel, tRecipe.mFluidInputs, fluidsFromME)) <= 0) {
                    if (result != CheckRecipeResultRegistry.NO_DATA_STICKS) continue;
                    result = CheckRecipeResultRegistry.NO_RECIPE;
                    continue;
                }
                tFluids = tRecipe.mFluidInputs;
            }
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("All fluids accepted");
            }
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("Check overclock");
            }
            int currentParallelBeforeBatchMode = Math.min(currentParallel, maxParallelBeforeBatchMode);
            calculator.setCurrentParallel(currentParallelBeforeBatchMode).calculate();
            double batchMultiplierMax = 1.0;
            if (currentParallel > maxParallelBeforeBatchMode && calculator.getDuration() < this.getMaxBatchSize()) {
                batchMultiplierMax = (double)this.getMaxBatchSize() / (double)calculator.getDuration();
                batchMultiplierMax = Math.min(batchMultiplierMax, (double)currentParallel / (double)maxParallelBeforeBatchMode);
            }
            int finalParallel = (int)(batchMultiplierMax * (double)currentParallelBeforeBatchMode);
            this.lEUt = calculator.getConsumption();
            this.mMaxProgresstime = (int)((double)calculator.getDuration() * batchMultiplierMax);
            maxParallel = finalParallel;
            if (GTValues.D1) {
                GTMod.GT_FML_LOGGER.info("Find available recipe");
            }
            result = CheckRecipeResultRegistry.SUCCESSFUL;
            ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
            ParallelHelper.addItemsLong(outputs, tRecipe.mOutput, (long)tRecipe.mOutput.field_77994_a * (long)maxParallel);
            this.mOutputItems = outputs.toArray(new ItemStack[0]);
            break;
        }
        if (!result.wasSuccessful()) {
            return result;
        }
        if (tStacks.length == 0 || maxParallel <= 0) {
            return CheckRecipeResultRegistry.INTERNAL_ERROR;
        }
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("All checked start consuming inputs");
        }
        GTRecipe.RecipeAssemblyLine.consumeInputItems(this.mInputBusses, maxParallel, tStacks, inputsFromME);
        GTRecipe.RecipeAssemblyLine.consumeInputFluids(this.mInputHatches, maxParallel, tFluids, fluidsFromME);
        if (this.lEUt > 0L) {
            this.lEUt = -this.lEUt;
        }
        this.mEfficiency = 10000 - (this.getIdealStatus() - this.getRepairStatus()) * 1000;
        this.mEfficiencyIncrease = 10000;
        this.updateSlots();
        if (GTValues.D1) {
            GTMod.GT_FML_LOGGER.info("Recipe successful");
        }
        return result;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        for (MTEHatchDataAccess hatch_dataAccess : this.mDataAccessHatches) {
            hatch_dataAccess.setActive(true);
        }
        return super.onRunningTick(aStack);
    }

    @Override
    public IStructureDefinition<MTEAssemblyLine> getStructureDefinition() {
        return STRUCTURE_DEFINITION;
    }

    @Override
    public boolean checkMachine(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.mDataAccessHatches.clear();
        if (!this.checkPiece(STRUCTURE_PIECE_FIRST, 0, 1, 0)) {
            return false;
        }
        return this.checkMachine(true) || this.checkMachine(false);
    }

    private boolean checkMachine(boolean leftToRight) {
        for (int i = 1; i < 16; ++i) {
            if (!this.checkPiece(STRUCTURE_PIECE_LATER, leftToRight ? -i : i, 1, 0)) {
                return false;
            }
            if (this.mOutputBusses.isEmpty()) continue;
            return !this.mEnergyHatches.isEmpty() && this.mMaintenanceHatches.size() == 1 && this.mDataAccessHatches.size() <= 1;
        }
        return false;
    }

    public boolean addDataAccessToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchDataAccess) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            return this.mDataAccessHatches.add((MTEHatchDataAccess)aMetaTileEntity);
        }
        return false;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.buildPiece(STRUCTURE_PIECE_FIRST, stackSize, hintsOnly, 0, 1, 0);
        int tLength = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(stackSize, 5, 16);
        for (int i = 1; i < tLength; ++i) {
            this.buildPiece(STRUCTURE_PIECE_LATER, stackSize, hintsOnly, -i, 1, 0);
        }
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        int build = this.survivalBuildPiece(STRUCTURE_PIECE_FIRST, stackSize, 0, 1, 0, elementBudget, env, false, true);
        if (build >= 0) {
            return build;
        }
        int tLength = GTStructureChannels.STRUCTURE_LENGTH.getValueClamped(stackSize, 5, 16);
        for (int i = 1; i < tLength; ++i) {
            build = this.survivalBuildPiece(STRUCTURE_PIECE_LATER, stackSize, -i, 1, 0, elementBudget, env, false, true);
            if (build < 0) continue;
            return build;
        }
        return this.survivalBuildPiece(STRUCTURE_PIECE_LAST, stackSize, 1 - tLength, 1, 0, elementBudget, env, false, true);
    }

    @Override
    public boolean supportsVoidProtection() {
        return true;
    }

    @Override
    public Set<VoidingMode> getAllowedVoidingModes() {
        return VoidingMode.ITEM_ONLY_MODES;
    }

    @Override
    public boolean supportsBatchMode() {
        return true;
    }

    private static enum DataHatchElement implements IHatchElement<MTEAssemblyLine>
    {
        DataAccess;


        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return Collections.singletonList(MTEHatchDataAccess.class);
        }

        @Override
        public IGTHatchAdder<MTEAssemblyLine> adder() {
            return MTEAssemblyLine::addDataAccessToMachineList;
        }

        @Override
        public long count(MTEAssemblyLine t) {
            return t.mDataAccessHatches.size();
        }
    }
}

