/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.generators;

import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.forge.IItemHandlerModifiable;
import com.gtnewhorizons.modularui.api.math.Alignment;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.Widget;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.FakeSyncWidget;
import com.gtnewhorizons.modularui.common.widget.ProgressBar;
import com.gtnewhorizons.modularui.common.widget.SlotGroup;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTUtility;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MTESolarGenerator
extends MTETieredMachineBlock
implements IAddUIWidgets,
IAddGregtechLogo {
    protected long clientEU;
    private boolean valid = true;
    private boolean noRain = false;
    private boolean dayTime = false;
    private boolean seesSky = false;

    public MTESolarGenerator(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 4, new String[]{"Generates EU From Solar Power", "Does not generate power when raining", "Cleans itself automatically", "Does not explode in rain!"}, new ITexture[0]);
    }

    public MTESolarGenerator(String aName, int aTier, int aInvSlotCount, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aInvSlotCount, aDescription, aTextures);
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity baseMetaTileEntity, ForgeDirection sideDirection, ForgeDirection facingDirection, int colorIndex, boolean active, boolean redstoneLevel) {
        if (sideDirection == ForgeDirection.UP) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], TextureFactory.of(Textures.BlockIcons.OVERLAY_SOLAR_PANEL)};
        }
        if (sideDirection == facingDirection) {
            return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], Textures.BlockIcons.OVERLAYS_ENERGY_OUT[this.mTier + 1]};
        }
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1]};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTESolarGenerator(this.mName, this.mTier, this.mInventory.length, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
    }

    @Override
    public boolean willExplodeInRain() {
        return false;
    }

    @Override
    public int rechargerSlotCount() {
        return 4;
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, ForgeDirection side, float aX, float aY, float aZ) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        this.addGregTechLogo(builder);
        this.addConditionalImages(builder);
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(SlotGroup.ofItemHandler((IItemHandlerModifiable)this.inventoryHandler, (int)2).startFromSlot(0).endAtSlot(3).slotCreator(index -> new BaseSlot((IItemHandlerModifiable)this.inventoryHandler, (int)index){

            public int func_75219_a() {
                return 1;
            }
        }).background(new IDrawable[]{this.getGUITextureSet().getItemSlot(), GTUITextures.OVERLAY_SLOT_CHARGER}).build().setPos(100, 15))).widget(new ProgressBar().setProgress(() -> Float.valueOf((float)this.getBaseMetaTileEntity().getStoredEU() / (float)this.getBaseMetaTileEntity().getEUCapacity())).setDirection(ProgressBar.Direction.RIGHT).setTexture(GTUITextures.PROGRESSBAR_STORED_EU, 147).setPos(14, 74).setSize(147, 5))).widget(new TextWidget().setStringSupplier(() -> GTUtility.formatNumbers(this.clientEU) + "/" + GTUtility.formatNumbers(this.getBaseMetaTileEntity().getEUCapacity()) + " EU").setTextAlignment(Alignment.Center).setPos(14, 66).setSize(147, 5))).widget((Widget)new FakeSyncWidget.LongSyncer(() -> this.getBaseMetaTileEntity().getStoredEU(), val -> {
            this.clientEU = val;
        }));
    }

    public void addConditionalImages(ModularWindow.Builder builder) {
        ((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable(() -> this.dayTime ? GTUITextures.OVERLAY_BUTTON_CHECKMARK : GTUITextures.OVERLAY_BUTTON_CROSS).setPos(5, 10).setSize(16, 16))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.solarindicator1")).setPos(21, 15))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.dayTime, val -> {
            this.dayTime = val;
        }))).widget(new DrawableWidget().setDrawable(() -> this.noRain ? GTUITextures.OVERLAY_BUTTON_CHECKMARK : GTUITextures.OVERLAY_BUTTON_CROSS).setPos(5, 26).setSize(16, 16))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.solarindicator2")).setPos(21, 31))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.noRain, val -> {
            this.noRain = val;
        }))).widget(new DrawableWidget().setDrawable(() -> this.seesSky ? GTUITextures.OVERLAY_BUTTON_CHECKMARK : GTUITextures.OVERLAY_BUTTON_CROSS).setPos(5, 42).setSize(16, 16))).widget(new TextWidget(StatCollector.func_74838_a((String)"GT5U.machines.solarindicator3")).setPos(21, 47))).widget((Widget)new FakeSyncWidget.BooleanSyncer(() -> this.seesSky, val -> {
            this.seesSky = val;
        }));
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT).setSize(17, 17).setPos(154, 5));
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (aTick % 100L == 0L) {
                this.doWorldChecks(aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity);
            }
            if (aTick % 20L == 0L && this.valid) {
                aBaseMetaTileEntity.increaseStoredEnergyUnits(this.maxEUOutput() * 20L, false);
            }
        }
        super.onPostTick(aBaseMetaTileEntity, aTick);
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        this.doWorldChecks(aBaseMetaTileEntity.getWorld(), aBaseMetaTileEntity);
        super.onFirstTick(aBaseMetaTileEntity);
    }

    private void doWorldChecks(World world, IGregTechTileEntity aBaseMetaTileEntity) {
        this.noRain = !world.func_72896_J() || !(aBaseMetaTileEntity.getBiome().field_76751_G > 0.0f);
        this.dayTime = world.func_72935_r();
        this.seesSky = aBaseMetaTileEntity.getSkyAtSide(ForgeDirection.UP);
        this.valid = this.noRain && this.dayTime && this.seesSky;
    }

    @Override
    public void getWailaNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, int x, int y, int z) {
        IGregTechTileEntity aBase = this.getBaseMetaTileEntity();
        tag.func_74757_a("valid", this.valid);
        tag.func_74772_a("storedeu", aBase.getStoredEU());
        tag.func_74772_a("maxeu", aBase.getEUCapacity());
        super.getWailaNBTData(player, tile, tag, world, x, y, z);
    }

    @Override
    public void getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        NBTTagCompound tag = accessor.getNBTData();
        if (tag.func_74764_b("valid")) {
            currenttip.add(tag.func_74767_n("valid") ? EnumChatFormatting.GREEN + StatCollector.func_74838_a((String)"GT5U.waila.generating.on") : EnumChatFormatting.RED + StatCollector.func_74838_a((String)"GT5U.waila.generating.off"));
        }
        if (tag.func_74764_b("storedeu") && tag.func_74764_b("maxeu")) {
            currenttip.add(EnumChatFormatting.GREEN + GTUtility.formatNumbers(tag.func_74763_f("storedeu")) + EnumChatFormatting.GRAY + " / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(tag.func_74763_f("maxeu")) + EnumChatFormatting.GRAY + " EU");
        }
        super.getWailaBody(itemStack, currenttip, accessor, config);
    }

    @Override
    public long maxEUStore() {
        return GTValues.V[this.mTier] * 10000L;
    }

    @Override
    public long maxEUOutput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public boolean isEnetOutput() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection side) {
        return side != ForgeDirection.UP;
    }

    @Override
    public boolean isOutputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }
}

